/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.ServerRegisterStatus;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.SubscriptionStatus;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.service.impl.DatabaseSystemSettingService;
import com.penpower.worldcard.team.web.api.SystemController;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DatabaseSystemSettingService
implements SystemSettingService {
    private static final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    CompanyGlobalInfoService companyGlobalInfoService;

    public String getServerId(AccountInfo currentLoginUser) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SERVER_ID", currentLoginUser.getCompanyGuid());
        return globalinfocompany.getConfigValue();
    }

    public ShareRule getShareRule(AccountInfo currentLoginUser) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", currentLoginUser.getCompanyGuid());
        if (globalinfocompany == null) {
            throw new ItemNotFoundException("No global share rule setting found.");
        }
        ShareRule shareRule = ShareRule.valueOf((String)globalinfocompany.getConfigValue());
        return shareRule;
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public SupportCRM getSystemCRM(AccountInfo currentLoginUser) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM", currentLoginUser.getCompanyGuid());
        if (globalinfocompany == null) {
            throw new ItemNotFoundException("No system CRM setting found.");
        }
        SupportCRM supportCRM = SupportCRM.valueOf((String)globalinfocompany.getConfigValue());
        return supportCRM;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void removeSystemCRM(AccountInfo currentLoginUser) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM", currentLoginUser.getCompanyGuid());
        if (globalinfocompany == null) {
            throw new ItemNotFoundException("No system CRM setting found.");
        }
        this.companyGlobalInfoService.deleteProperty(globalinfocompany.getGuid());
    }

    public int getLicenseCount(String companyGuid, boolean IsNeedToCheckAdmin) {
        LicenseMode lm = this.subscriptionService.getLicenseMode(companyGuid);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$LicenseMode[lm.ordinal()]) {
            default: {
                LOG.debug("getLicenseCount lm={}", (Object)lm);
                return this.subscriptionService.getAccountLimit(companyGuid);
            }
            case 2: {
                return this.registryService.getLicenseCount(IsNeedToCheckAdmin);
            }
            case 3: 
        }
        return 0;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public LicenseVo GetLicense(String companyGuid) {
        LicenseMode lm = this.subscriptionService.getLicenseMode(companyGuid);
        LicenseVo lv = new LicenseVo();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$LicenseMode[lm.ordinal()]) {
            default: {
                SubscriptionStatus SS = this.subscriptionService.getSubScriptionStatus(companyGuid);
                lv.setSubscriptionStatus(SS);
                lv.setServerRegisterStatus(ServerRegisterStatus.NONE);
                break;
            }
            case 2: {
                ServerRegisterStatus SRS = this.registryService.GetRegisterStatus(companyGuid);
                lv.setServerRegisterStatus(SRS);
                lv.setSubscriptionStatus(SubscriptionStatus.NONE);
                break;
            }
            case 3: {
                lv.setServerRegisterStatus(ServerRegisterStatus.NONE);
                lv.setSubscriptionStatus(SubscriptionStatus.NONE);
            }
        }
        lv.setLicenseMode(lm);
        LOG.debug("ServerRegisterStatusResponseResult ={}", (Object)lv);
        return lv;
    }
}

