/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.dao.CustomTagDao;
import com.penpower.worldcard.team.dto.CustomTagDto;
import com.penpower.worldcard.team.entity.Tagsfortaskandactivity;
import com.penpower.worldcard.team.enums.CustomTagType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.CustomTagService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomTagServiceImpl
implements CustomTagService {
    @Autowired
    private CustomTagDao customTagDao;

    public List<CustomTagDto> getAllCustomTags(CustomTagType customTagType) {
        List tagsForTaskAndAcctivitys = this.customTagDao.findByTagtype(customTagType);
        if (CollectionUtils.isEmpty((Collection)tagsForTaskAndAcctivitys)) {
            return Collections.emptyList();
        }
        List<CustomTagDto> customTags = tagsForTaskAndAcctivitys.stream().map(tag -> new CustomTagDto(tag.getGuid(), tag.getTagName(), tag.getTagType())).collect(Collectors.toList());
        return customTags;
    }

    public CustomTagDto getCustomTag(CustomTagType customTagType, String tagGuid) {
        Tagsfortaskandactivity tagsForTaskAndAcctivity = this.customTagDao.findByGuidAndTagtype(tagGuid, customTagType);
        if (tagsForTaskAndAcctivity == null) {
            throw new ItemNotFoundException(String.format("Custom tag was not found , tagType : %s , tagGuid : %d", customTagType, tagGuid));
        }
        CustomTagDto customTagDto = new CustomTagDto(tagsForTaskAndAcctivity.getGuid(), tagsForTaskAndAcctivity.getTagName(), tagsForTaskAndAcctivity.getTagType());
        return customTagDto;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public String createCustomTag(CustomTagType customTagType, String tagValue) {
        Tagsfortaskandactivity tagsForTaskAndAcctivity = new Tagsfortaskandactivity();
        tagsForTaskAndAcctivity.setTagName(tagValue);
        tagsForTaskAndAcctivity.setTagType(customTagType);
        tagsForTaskAndAcctivity = (Tagsfortaskandactivity)this.customTagDao.save((Object)tagsForTaskAndAcctivity);
        return tagsForTaskAndAcctivity.getGuid();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteCustomTag(String tagGuid) throws ItemNotFoundException {
        Tagsfortaskandactivity tagsForTaskAndAcctivity = (Tagsfortaskandactivity)this.customTagDao.findOne((Serializable)((Object)tagGuid));
        if (tagsForTaskAndAcctivity == null) {
            throw new ItemNotFoundException(String.format("Failed to delete custom tag ,tag was not found ,tagGuid : %d", tagGuid));
        }
        this.customTagDao.delete((Serializable)((Object)tagGuid));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateCustomTag(String tagGuid, String tagValue) {
        Tagsfortaskandactivity tagsForTaskAndAcctivity = (Tagsfortaskandactivity)this.customTagDao.findOne((Serializable)((Object)tagGuid));
        if (tagsForTaskAndAcctivity == null) {
            throw new ItemNotFoundException(String.format("Failed to update custom tag ,tag was not found ,tagGuid : %d", tagGuid));
        }
        tagsForTaskAndAcctivity.setTagName(tagValue);
        this.customTagDao.save((Object)tagsForTaskAndAcctivity);
    }
}

