/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.CustomFieldDao;
import com.penpower.worldcard.team.dao.PicklistContentDao;
import com.penpower.worldcard.team.dto.CustomFieldDto;
import com.penpower.worldcard.team.dto.PicklistContentCreationDto;
import com.penpower.worldcard.team.dto.PicklistContentDto;
import com.penpower.worldcard.team.entity.Customfield;
import com.penpower.worldcard.team.entity.PicklistContent;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.web.api.vo.CustomFieldCreationVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomFieldServiceImpl
implements CustomFieldService {
    private static final Logger LOG = LoggerFactory.getLogger(CustomFieldServiceImpl.class);
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private PicklistContentDao picklistContentDao;

    public long getAllCustomFieldCountByCategory(CustomFieldCategory category, String companyGuid) {
        return this.customFieldDao.countByCustomfieldcategoryAndCompanyguid(category, companyGuid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public String createNewCustomField(CustomFieldCreationVo fromRequestCreationVo, String companyGuid) {
        Customfield newField = new Customfield();
        newField.setGuid(UUIDGenerator.getRandomUUID());
        newField.setCustomfieldname(fromRequestCreationVo.getCustomFieldName());
        CustomFieldCategory newFieldCategory = fromRequestCreationVo.getCustomFieldCategory();
        newField.setCustomfieldcategory(newFieldCategory);
        newField.setCompanyGuid(companyGuid);
        CustomFieldContactAttribute newCustomFieldContactAttribute = fromRequestCreationVo.getCustomFieldContactAttribute();
        newField.setCustomfieldcontactattribute(fromRequestCreationVo.getCustomFieldContactAttribute());
        List Customfields = this.customFieldDao.findByCustomfieldcategoryOrderAndcompanyGuidBySortorderDesc(fromRequestCreationVo.getCustomFieldCategory(), companyGuid);
        int newFieldOrder = 0;
        if (Customfields.size() > 0) {
            newFieldOrder = ((Customfield)Customfields.get(0)).getSortorder() + 1;
        }
        newField.setSortorder(newFieldOrder);
        Customfield newFieldSaved = (Customfield)this.customFieldDao.saveAndFlush((Object)newField);
        boolean picklistContentType = this.picklistContentType(newFieldCategory, newCustomFieldContactAttribute);
        LOG.debug("picklistContentType : {} ", (Object)picklistContentType);
        if (picklistContentType) {
            List picklistContentCreationDtos = fromRequestCreationVo.getPicklistContents();
            LOG.debug("picklistContentCreationDtos : {} ", (Object)picklistContentCreationDtos);
            int picklistContentOrder = 0;
            for (PicklistContentCreationDto picklistContentCreationDto : picklistContentCreationDtos) {
                PicklistContent newPicklistContent = new PicklistContent();
                newPicklistContent.setSortorder(picklistContentOrder);
                newPicklistContent.setGuid(UUIDGenerator.getRandomUUID());
                newPicklistContent.setContent(picklistContentCreationDto.getContent());
                newPicklistContent.setCustomfield(newFieldSaved);
                this.picklistContentDao.saveAndFlush((Object)newPicklistContent);
                ++picklistContentOrder;
            }
        }
        return newFieldSaved.getGuid();
    }

    private boolean picklistContentType(CustomFieldCategory customFieldCategory, CustomFieldContactAttribute customFieldContactAttribute) {
        return CustomFieldCategory.CONTACT.equals((Object)customFieldCategory) && CustomFieldContactAttribute.PICKLIST.equals((Object)customFieldContactAttribute);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateCustomField(CustomFieldDto customFieldDto) throws ItemNotFoundException {
        String newUpdatedGuid = customFieldDto.getGuid();
        Customfield customFieldUpdated = (Customfield)this.customFieldDao.findOne((Serializable)((Object)newUpdatedGuid));
        if (customFieldUpdated == null) {
            throw new ItemNotFoundException(String.format("No customField found by guid[%s]", newUpdatedGuid));
        }
        int sortOrder = customFieldUpdated.getSortorder();
        this.internalUpdateCustomField(customFieldDto, customFieldUpdated, sortOrder);
    }

    private void internalUpdateCustomField(CustomFieldDto customFieldDto, Customfield customFieldUpdated, int sortOrder) {
        customFieldUpdated.setCustomfieldname(customFieldDto.getCustomFieldName());
        CustomFieldCategory newFieldCategory = customFieldDto.getCustomFieldCategory();
        customFieldUpdated.setCustomfieldcategory(newFieldCategory);
        CustomFieldContactAttribute newCustomFieldContactAttribute = customFieldDto.getCustomFieldContactAttribute();
        customFieldUpdated.setCustomfieldcontactattribute(customFieldDto.getCustomFieldContactAttribute());
        boolean picklistContentType = this.picklistContentType(newFieldCategory, newCustomFieldContactAttribute);
        LOG.debug("picklistContentType : {} ", (Object)picklistContentType);
        if (picklistContentType) {
            List picklistContentDtos = customFieldDto.getPicklistContents();
            List needToUpdatePicklistContentGuids = picklistContentDtos.stream().map(picklistContentDto -> picklistContentDto.getGuid()).collect(Collectors.toList());
            LOG.debug("picklistContentDtos : {} ", (Object)picklistContentDtos);
            LOG.debug("needToUpdatePicklistContentGuids : {} ", needToUpdatePicklistContentGuids);
            if (picklistContentDtos != null && picklistContentDtos.size() > 0) {
                List needToRemoveGuids = this.getNeedToRemovePicklistGuids(customFieldDto.getGuid(), needToUpdatePicklistContentGuids);
                LOG.debug("needToRemoveGuids : {} ", (Object)needToRemoveGuids);
                for (String needToRemoveGuid : needToRemoveGuids) {
                    PicklistContent toDeletePicklistContent = (PicklistContent)this.picklistContentDao.findOne((Serializable)((Object)needToRemoveGuid));
                    this.picklistContentDao.delete((Object)toDeletePicklistContent);
                }
                int picklistContentOrder = 0;
                for (PicklistContentDto picklistContentDto2 : picklistContentDtos) {
                    String fromRequestPickListGuid = picklistContentDto2.getGuid();
                    LOG.debug("fromRequestPickListGuid : {} ", (Object)fromRequestPickListGuid);
                    if (StringUtils.isEmpty((CharSequence)fromRequestPickListGuid)) {
                        LOG.debug("create new one ");
                        PicklistContent newPicklistContentFromUpdate = new PicklistContent();
                        newPicklistContentFromUpdate.setGuid(UUIDGenerator.getRandomUUID());
                        newPicklistContentFromUpdate.setContent(picklistContentDto2.getContent());
                        newPicklistContentFromUpdate.setSortorder(picklistContentOrder);
                        Customfield customField = (Customfield)this.customFieldDao.findOne((Serializable)((Object)customFieldDto.getGuid()));
                        newPicklistContentFromUpdate.setCustomfield(customField);
                        this.picklistContentDao.saveAndFlush((Object)newPicklistContentFromUpdate);
                    } else {
                        PicklistContent toUpdatePicklistContent = (PicklistContent)this.picklistContentDao.findOne((Serializable)((Object)fromRequestPickListGuid));
                        if (toUpdatePicklistContent == null) {
                            throw new ItemNotFoundException("Fail to find picklist content by guid : " + fromRequestPickListGuid);
                        }
                        toUpdatePicklistContent.setContent(picklistContentDto2.getContent());
                        toUpdatePicklistContent.setSortorder(picklistContentOrder);
                        LOG.debug("toUpdatePicklistContent : {}", (Object)toUpdatePicklistContent);
                        this.picklistContentDao.saveAndFlush((Object)toUpdatePicklistContent);
                    }
                    ++picklistContentOrder;
                }
            }
        }
        LOG.debug("customFieldUpdated : {}", (Object)customFieldUpdated);
        this.customFieldDao.save((Object)customFieldUpdated);
    }

    private List<String> getNeedToRemovePicklistGuids(String customFieldGuid, List<String> needToUpdatePicklistContentGuids) {
        List pickListContents = this.picklistContentDao.findByCustomfieldGuid(customFieldGuid);
        List<String> originalPicklistContentGuids = pickListContents.stream().filter(pickListContent -> !needToUpdatePicklistContentGuids.contains(pickListContent.getGuid())).map(pickListContent -> pickListContent.getGuid()).collect(Collectors.toList());
        return originalPicklistContentGuids;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteCustomField(String customFieldGuid) throws ItemNotFoundException {
        Customfield customFieldUpdated = (Customfield)this.customFieldDao.findOne((Serializable)((Object)customFieldGuid));
        if (customFieldUpdated == null) {
            throw new ItemNotFoundException(String.format("No customField found by guid[%s]", customFieldGuid));
        }
        this.customFieldDao.delete((Serializable)((Object)customFieldGuid));
    }

    public CustomFieldDto getCustomField(String customFieldGuid) throws ItemNotFoundException {
        Customfield customField = (Customfield)this.customFieldDao.findOne((Serializable)((Object)customFieldGuid));
        if (customField == null) {
            throw new ItemNotFoundException(String.format("No customField found by guid[%s]", customFieldGuid));
        }
        CustomFieldDto customFieldDto = this.converToDto(customField);
        return customFieldDto;
    }

    private CustomFieldDto converToDto(Customfield customField) {
        CustomFieldDto customFieldDto = new CustomFieldDto();
        customFieldDto.setGuid(customField.getGuid());
        customFieldDto.setCustomFieldName(customField.getCustomfieldname());
        CustomFieldCategory customFieldCategory = customField.getCustomfieldcategory();
        customFieldDto.setCustomFieldCategory(customFieldCategory);
        CustomFieldContactAttribute customFieldContactAttribute = customField.getCustomfieldcontactattribute();
        customFieldDto.setCustomFieldContactAttribute(customFieldContactAttribute);
        if (this.picklistContentType(customFieldCategory, customFieldContactAttribute)) {
            ArrayList<PicklistContentDto> picklistContentDtos = new ArrayList<PicklistContentDto>();
            List picklistContents = customField.getPicklistContents();
            if (picklistContents != null && picklistContents.size() > 0) {
                for (PicklistContent picklistContent : picklistContents) {
                    PicklistContentDto picklistContentDto = new PicklistContentDto();
                    picklistContentDto.setGuid(picklistContent.getGuid());
                    picklistContentDto.setContent(picklistContent.getContent());
                    picklistContentDtos.add(picklistContentDto);
                }
                customFieldDto.setPicklistContents(picklistContentDtos);
            }
        }
        return customFieldDto;
    }

    public List<CustomFieldDto> getAllCustomFields(CustomFieldCategory customFieldCategory, String companyGuid) {
        List customFields = this.customFieldDao.findByCustomfieldcategory(customFieldCategory, companyGuid);
        List<CustomFieldDto> customFieldDtos = customFields.stream().distinct().map(customField -> {
            CustomFieldDto customFieldDto = this.converToDto(customField);
            return customFieldDto;
        }).collect(Collectors.toList());
        return customFieldDtos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateCustomFieldsOrder(ListRequestVo<String> customFieldGuids) {
        List needToUpdateOrderGuids = customFieldGuids.getList();
        if (CollectionUtil.collectionEmpty((Collection)needToUpdateOrderGuids)) {
            return;
        }
        int updaetCustomFieldOrder = 0;
        for (String needToUpdateOrderGuid : needToUpdateOrderGuids) {
            Customfield customField = (Customfield)this.customFieldDao.findOne((Serializable)((Object)needToUpdateOrderGuid));
            if (customField == null) continue;
            customField.setSortorder(updaetCustomFieldOrder);
            this.customFieldDao.save((Object)customField);
            ++updaetCustomFieldOrder;
        }
    }

    public List<PicklistContentDto> getCustomFieldPicklistContent(String customFieldGuid) {
        List picklistContent = this.picklistContentDao.findByCustomfieldGuidBySortOrderAsc(customFieldGuid);
        if (CollectionUtil.collectionEmpty((Collection)picklistContent)) {
            throw new ItemNotFoundException(String.format("No pickListContent found by customFieldGuid[%s]", customFieldGuid));
        }
        List<PicklistContentDto> picklistContentDtos = picklistContent.stream().map(content -> {
            PicklistContentDto picklistContentDto = new PicklistContentDto();
            picklistContentDto.setGuid(content.getGuid());
            picklistContentDto.setContent(content.getContent());
            return picklistContentDto;
        }).collect(Collectors.toList());
        return picklistContentDtos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void UpdateAllCustomFieldwithCompany(String companyGuid) {
        this.customFieldDao.updateAllWithCompany(companyGuid);
    }

    public CustomFieldDto getCustomFieldByCustomFieldNameAndCompany(String customFieldName, String companyGuid) {
        Customfield customField = this.customFieldDao.findByCustomfieldnameAndCompanyguid(customFieldName, companyGuid);
        if (customField == null) {
            return null;
        }
        CustomFieldDto customFieldDto = this.converToDto(customField);
        return customFieldDto;
    }
}

