/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.ListObjectPaginator;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.TimeUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.ContactAddressDao;
import com.penpower.worldcard.team.dao.ContactCustomDataDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactDateDao;
import com.penpower.worldcard.team.dao.ContactEmailDao;
import com.penpower.worldcard.team.dao.ContactIMDao;
import com.penpower.worldcard.team.dao.ContactImageActionLogDao;
import com.penpower.worldcard.team.dao.ContactImageContentDao;
import com.penpower.worldcard.team.dao.ContactImageDao;
import com.penpower.worldcard.team.dao.ContactJobinfoDao;
import com.penpower.worldcard.team.dao.ContactNameDao;
import com.penpower.worldcard.team.dao.ContactPhoneDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.ContactSocialDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dao.ContactUrlDao;
import com.penpower.worldcard.team.dao.ContactfulltextDao;
import com.penpower.worldcard.team.dao.CustomFieldDao;
import com.penpower.worldcard.team.dao.PicklistContentDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoLess;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.ContactForSyncList;
import com.penpower.worldcard.team.dto.ContactIMInfo;
import com.penpower.worldcard.team.dto.ContactInfoForEs;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactProfile;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDuplicate;
import com.penpower.worldcard.team.dto.ContactStatusForAccountDto;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactcustomdataInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContactsocialInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.dto.mapper.DtoMapper;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactaddress;
import com.penpower.worldcard.team.entity.Contactcustomdata;
import com.penpower.worldcard.team.entity.Contactdate;
import com.penpower.worldcard.team.entity.Contactemail;
import com.penpower.worldcard.team.entity.Contactfulltext;
import com.penpower.worldcard.team.entity.Contactim;
import com.penpower.worldcard.team.entity.Contactimage;
import com.penpower.worldcard.team.entity.ContactimageActionLog;
import com.penpower.worldcard.team.entity.Contactimagebasic;
import com.penpower.worldcard.team.entity.Contactimagewithcontent;
import com.penpower.worldcard.team.entity.Contactjobinfo;
import com.penpower.worldcard.team.entity.Contactname;
import com.penpower.worldcard.team.entity.Contactphone;
import com.penpower.worldcard.team.entity.Contactsimpleinfo;
import com.penpower.worldcard.team.entity.Contactsocial;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.entity.Contacturl;
import com.penpower.worldcard.team.entity.Customfield;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.entity.PicklistContent;
import com.penpower.worldcard.team.enums.ActionType;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.enums.ContactField;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.SubscriptionStatus;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.enums.WctSystemExceptionType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactOwningException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactPrivateException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactTotalException;
import com.penpower.worldcard.team.exception.RecordUpdateException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ResourceLockedException;
import com.penpower.worldcard.team.exception.SpecifiedGuidConflictException;
import com.penpower.worldcard.team.exception.UploadFileException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SessionService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.service.impl.ContactPrivateServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactForSync;
import com.penpower.worldcard.team.web.api.vo.ContactInfoExVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import com.penpower.worldcard.team.web.api.vo.GuidWithData;
import com.penpower.worldcard.team.web.api.vo.IntervalFilter;
import com.penpower.worldcard.team.web.api.vo.ItemBasicVo;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.penpower.worldcard.team.web.api.vo.SubscriptionPeriod;
import com.penpower.worldcard.team.web.api.vo.response.PageResult;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.exception.DataException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContactPrivateServiceImpl
implements ContactPrivateService {
    private static final Logger LOG = LoggerFactory.getLogger(ContactPrivateServiceImpl.class);
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private ContactfulltextDao contactfulltextDao;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ContactImageDao contactImageDao;
    @Autowired
    private ContactImageContentDao contactImageContentDao;
    @Autowired
    private ContactNameDao contactNameDao;
    @Autowired
    private ContactAddressDao contactAddressDao;
    @Autowired
    private ContactDateDao contactDateDao;
    @Autowired
    private ContactPhoneDao contactPhoneDao;
    @Autowired
    private ContactJobinfoDao contactJobinfoDao;
    @Autowired
    private ContactEmailDao contactEmailDao;
    @Autowired
    private ContactIMDao contactIMDao;
    @Autowired
    private ContactUrlDao contactUrlDao;
    @Autowired
    private ContactSocialDao contactSocialDao;
    @Autowired
    private ContactCustomDataDao contactCustomDataDao;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private PicklistContentDao picklistContentDao;
    @Autowired
    private PathManager cardPathManager;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    @Qualifier(value="accountInfoDtoMapper")
    private DtoMapper<Account, AccountInfo> accountInfoDtoMapper;
    @Autowired
    private ContactImageActionLogDao contactImageActionLogDao;
    @Autowired
    private PathManager temporaryPathManager;

    public boolean IsContactDeleted(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return true;
        }
        return contact.getIsDeleted();
    }

    public void CreateDefaultContact(String accountGuid, String companyGuid) {
        this.CreateOneCountryContact(accountGuid, companyGuid, "default_card_image/chinese_TC.JPG", "default_card_json/chinese_TC.json");
        this.CreateOneCountryContact(accountGuid, companyGuid, "default_card_image/english.JPG", "default_card_json/english.json");
        this.CreateOneCountryContact(accountGuid, companyGuid, "default_card_image/chinese_SC.JPG", "default_card_json/chinese_SC.json");
    }

    private void CreateOneCountryContact(String accountGuid, String companyGuid, String imageName, String JsonName) {
        block16: {
            LOG.debug("CreateDefaultContact accountGuid={} imageName ={},JsonName={}", new Object[]{accountGuid, imageName, JsonName});
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                String url = classLoader.getResource(JsonName).getFile();
                url = URLDecoder.decode(url, "UTF-8");
                File file = new File(url);
                url = file.getAbsolutePath();
                LOG.debug("GetSUBSCRIPTION_URL in URL={}", (Object)url);
                Path ContactJsonFile = Paths.get(url, new String[0]);
                String imageNameurl = classLoader.getResource(imageName).getFile();
                imageNameurl = URLDecoder.decode(imageNameurl, "UTF-8");
                File imageNamefile = new File(imageNameurl);
                imageNameurl = imageNamefile.getAbsolutePath();
                LOG.debug("GetSUBSCRIPTION_URL in URL={}", (Object)imageNameurl);
                Path JpgFile = Paths.get(imageNameurl, new String[0]);
                String FrontfileID = this.saveFileToTempFolder(JpgFile);
                LOG.debug("CreateDefaultContact engFront={}", (Object)FrontfileID);
                if (!Files.exists(ContactJsonFile, new LinkOption[0])) break block16;
                LOG.debug("CreateDefaultContact 1");
                try (FileReader fr = new FileReader(ContactJsonFile.toFile());){
                    LOG.debug("CreateDefaultContact 2");
                    Gson gson = new Gson();
                    ContactCreationVo vo = (ContactCreationVo)gson.fromJson((Reader)fr, ContactCreationVo.class);
                    vo.setCreatorAccountGuid(accountGuid);
                    String[] shareToAccountGuids = new String[]{accountGuid};
                    vo.setShareToAccountGuids(shareToAccountGuids);
                    LOG.debug("CreateDefaultContact vo=", (Object)vo);
                    vo.setClientCreatedTime(DateTime.now());
                    String contactid = this.createContact(vo, FrontfileID, null, null, companyGuid);
                    LOG.debug("CreateDefaultContact createcontact finish contactid ={}", (Object)contactid);
                }
                catch (IOException ex) {
                    LOG.debug("CreateDefaultContact IOException={}", (Throwable)ex);
                }
            }
            catch (Exception ee) {
                LOG.error("CreateDefaultContact Exception=" + ee.getMessage());
            }
        }
    }

    private String saveFileToTempFolder(Path filePath) {
        LOG.debug("saveFileToTempFolder filePath={}", (Object)filePath);
        String tempGuid = null;
        try {
            LOG.debug("saveFileToTempFolder 1");
            byte[] fileContent = Files.readAllBytes(filePath);
            LOG.debug("saveFileToTempFolder 2");
            tempGuid = this.createContactImage(fileContent);
            LOG.debug("saveFileToTempFolder 3");
        }
        catch (IOException e) {
            throw new UploadFileException("Save to temp folder failed. Reason: " + e.toString());
        }
        return tempGuid;
    }

    public ContactInfoForRequest getContactInfoByGuid_SameCompany(String contactGuid) {
        List infos;
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        ContactInfoForRequest result = new ContactInfoForRequest();
        if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
            infos = contact.getContactjobinfos().stream().map(job -> {
                ContactjobinfoInfo info = new ContactjobinfoInfo();
                info.setCompanyName(job.getCompanyName());
                info.setCompanyPronunce(job.getConpanyPronunce());
                return info;
            }).collect(Collectors.toList());
            result.setJobinfos(infos);
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactphones())) {
            infos = contact.getContactphones().stream().filter(p -> ContactPhoneType.MAIN.equals((Object)p.getPhoneType()) || ContactPhoneType.BUSINESS_FAX.equals((Object)p.getPhoneType()) || ContactPhoneType.BUSINESS_TEL.equals((Object)p.getPhoneType())).map(p -> {
                ContactphoneInfo info = new ContactphoneInfo();
                info.setType(p.getPhoneType());
                info.setValue(p.getPhoneValue());
                return info;
            }).collect(Collectors.toList());
            result.setPhones(infos);
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactaddresses())) {
            infos = contact.getContactaddresses().stream().filter(a -> ContactFieldType.BUSINESS.equals((Object)a.getAddressType())).map(a -> {
                ContactaddressInfo info = new ContactaddressInfo();
                info.setCity(a.getCity());
                info.setCountryCode(a.getCountryCode());
                info.setCountryName(a.getCountryName());
                info.setState(a.getState());
                info.setStreet(a.getStreet());
                info.setZip(a.getZip());
                info.setAddressFormat(a.getAddressFormat());
                info.setType(a.getAddressType());
                return info;
            }).collect(Collectors.toList());
            result.setAddresses(infos);
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContacturls())) {
            infos = contact.getContacturls().stream().filter(u -> ContactUrlType.BUSINESS.equals((Object)u.getUrlType())).map(u -> {
                ContacturlInfo info = new ContacturlInfo();
                info.setType(u.getUrlType());
                info.setValue(u.getUrlValue());
                return info;
            }).collect(Collectors.toList());
            result.setUrls(infos);
        }
        result.setUniformNumber(contact.getUniformNumber());
        return result;
    }

    public ContactInfoVo getContactInfoVoByGuid(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        ContactInfoVo retVo = new ContactInfoVo(contact);
        return retVo;
    }

    public ContactInfoVoForWCT getContactInfoVoForWCTByGuid(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        ContactInfoVoForWCT retVo = new ContactInfoVoForWCT(contact);
        Account creator = this.accountDao.findOne(contact.getCreatorGuid());
        Account editor = this.accountDao.findOne(contact.getEditorguid());
        retVo.setCreatorName(creator.getDisplayName());
        retVo.setEditorName(editor.getDisplayName());
        List accounts = contact.getAccountsCanView();
        if (accounts != null) {
            List accountInfos = accounts.stream().map(a -> new AccountInfoLess(a)).collect(Collectors.toList());
            retVo.setBeSharedAccounts(accountInfos);
        }
        Account myAccount = this.accountDao.findOne(accountGuid);
        List belongMyCategoryInfos = this.categoryDao.findByOwnerAndContactGuid(myAccount, contact.getGuid()).stream().filter(c -> !c.isDeleted()).map(c -> new CategoryInfo(c)).collect(Collectors.toList());
        retVo.setBelongCategories(belongMyCategoryInfos);
        if (belongMyCategoryInfos.stream().anyMatch(c -> CategoryType.FAVORITE.equals((Object)c.getCategoryType()))) {
            retVo.setBeFavorite(Boolean.valueOf(true));
        }
        return retVo;
    }

    public void verifyModifyTime(String contactGuid, DateTime modifyTime, String AccountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found.");
        }
        Account curAccount = this.accountDao.findOne(AccountGuid);
        Contactstatusforaccount contactStatus = this.contactStatusForAccountDao.findFirstByAccountAndContact(curAccount, contact);
        LOG.debug("contactStatus:{}", (Object)contactStatus);
        LOG.debug("contact.getModifyTime():{}", (Object)contact.getModifyTime());
        LOG.debug("contactStatus.getStatusupdatetime():{}", (Object)contactStatus.getStatusupdatetime());
        DateTime contactTime = TimeUtil.GetAfter((DateTime)contact.getModifyTime(), (DateTime)contactStatus.getStatusupdatetime());
        if (contactTime.isAfter((ReadableInstant)modifyTime)) {
            throw new RecordUpdateException("Contact is newer thad client");
        }
    }

    public ContactInfoExVo getContactInfoExByGuid(String contactGuid, String curAccountID) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        Account curAccount = this.accountDao.findOne(curAccountID);
        Contactstatusforaccount contactStatus = this.contactStatusForAccountDao.findFirstByAccountAndContact(curAccount, contact);
        if (contact.getIsDeleted().booleanValue() || contactStatus.getIsdeletedfromaccount().booleanValue()) {
            return null;
        }
        ContactInfoVoForWCT retVo = this.getContactInfoVoForWCTByGuid(contactGuid, curAccountID);
        ContactInfoExVo retVoEx = new ContactInfoExVo(retVo, contactStatus, contact);
        LOG.debug("getContactInfoExByGuid ContactInfoExVo ={}", (Object)retVoEx);
        return retVoEx;
    }

    public ContactForSyncList getContactsModifiedByAccount(DateTime LastRecTime, String curAccountID, boolean isFirstTimeSync, boolean isGetDeleted, DateTime getDeleteFromTime, int MaxCount, DateTime DataSeekTime, boolean IsContinueSeek) {
        ContactForSyncList contactForSyncList = new ContactForSyncList();
        try {
            LOG.debug("getModifyContactsByAccount start LastRecTime ={}, curAccountID ={},isFirstTimeSync ={},isGetDeleted ={},getDeleteFromTime ={},MaxCount ={},DataSeekTime ={},IsContinueSeek ={}", new Object[]{LastRecTime, curAccountID, isFirstTimeSync, isGetDeleted, getDeleteFromTime, MaxCount, DataSeekTime, IsContinueSeek});
            Account curAccount = this.accountDao.findOne(curAccountID);
            if (curAccount == null) {
                return contactForSyncList;
            }
            Category cateAll = null;
            LOG.debug("getModifyContactsByAccount curAccount cates= {}", (Object)curAccount.getCategories());
            Optional<Category> categoryGet = curAccount.getCategories().stream().filter(cate -> cate.getCategoryType() == CategoryType.ALL).findFirst();
            LOG.debug("getModifyContactsByAccount get cates= {}", categoryGet);
            if (categoryGet.isPresent()) {
                cateAll = categoryGet.get();
            }
            LOG.debug("getModifyContactsByAccount 1");
            if (cateAll == null) {
                return contactForSyncList;
            }
            contactForSyncList.setlastRecordTime(TimeUtil.GetZeroTime());
            LOG.debug("getModifyContactsByAccount Category all= {}", (Object)cateAll);
            if (isFirstTimeSync) {
                Object StartTime;
                LOG.debug("isFirstTimeSync = true");
                List contacts = null;
                List contactStatusList = null;
                Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "modifytime")});
                PageRequest pageRequest = new PageRequest(0, MaxCount, sort);
                Sort sortstatus = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "statusupdatetime")});
                PageRequest pageRequestStatus = new PageRequest(0, MaxCount, sortstatus);
                if (!isGetDeleted) {
                    LOG.debug("isGetDeleted 1 = false");
                    StartTime = null;
                    StartTime = IsContinueSeek ? DataSeekTime : LastRecTime;
                    LOG.debug("IsContinueSeek1 = {} StartTime ={} LastRecTime ={} DataSeekTime ={}", new Object[]{IsContinueSeek, StartTime, LastRecTime, DataSeekTime});
                    contacts = this.contactDao.findSeekByCategorybyOrderModifyTimeLimitCountWithoutDeleted(cateAll.getGuid(), (DateTime)StartTime, (Pageable)pageRequest).map(cons -> new ContactForSync(cons)).getContent();
                    LOG.debug("contacts 1 size={}", (Object)contacts.size());
                    block1 : switch (contacts.size()) {
                        case 300: {
                            contactForSyncList.setisNeedContinue(true);
                            contactForSyncList.setlastRecordTime(((ContactForSync)contacts.get(contacts.size() - 1)).getModifyTime());
                            contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTimeWithoutDeleted((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                            if (contactStatusList.size() == 300) {
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                            }
                            LOG.debug("last record time 2={}", (Object)contactForSyncList.getlastRecordTime());
                            break;
                        }
                        default: {
                            contactForSyncList.setisNeedContinue(true);
                            contactForSyncList.setlastRecordTime(((ContactForSync)contacts.get(contacts.size() - 1)).getModifyTime());
                            contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTimeWithoutDeleted((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                            if (contactStatusList.size() == 300) {
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                            }
                            LOG.debug("last record time ={}", (Object)contactForSyncList.getlastRecordTime());
                            break;
                        }
                        case 1: {
                            if (((ContactForSync)contacts.get(0)).getModifyTime().isEqual((ReadableInstant)StartTime)) {
                                contactStatusList = this.contactStatusForAccountDao.findAfterSeekTimeWithoutDeleted((DateTime)StartTime, curAccount, (Pageable)pageRequestStatus).getContent();
                                LOG.debug("contcontactStatusListacts size={}", (Object)contactStatusList.size());
                                switch (contactStatusList.size()) {
                                    case 300: {
                                        contactForSyncList.setisNeedContinue(true);
                                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                        break block1;
                                    }
                                    default: {
                                        contactForSyncList.setisNeedContinue(false);
                                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                        break block1;
                                    }
                                    case 0: 
                                }
                                contactForSyncList.setisNeedContinue(false);
                                contactForSyncList.setlastRecordTime(DataSeekTime);
                                break;
                            }
                            contactForSyncList.setisNeedContinue(true);
                            contactForSyncList.setlastRecordTime(((ContactForSync)contacts.get(contacts.size() - 1)).getModifyTime());
                            contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTimeWithoutDeleted((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                            if (contactStatusList.size() == 300) {
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                            }
                            LOG.debug("last record time ={}", (Object)contactForSyncList.getlastRecordTime());
                            break;
                        }
                        case 0: {
                            contactStatusList = this.contactStatusForAccountDao.findAfterSeekTimeWithoutDeleted((DateTime)StartTime, curAccount, (Pageable)pageRequestStatus).getContent();
                            LOG.debug("contcontactStatusListacts size={}", (Object)contactStatusList.size());
                            switch (contactStatusList.size()) {
                                case 300: {
                                    contactForSyncList.setisNeedContinue(true);
                                    contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                    break;
                                }
                                default: {
                                    contactForSyncList.setisNeedContinue(false);
                                    contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                    break;
                                }
                                case 0: {
                                    contactForSyncList.setisNeedContinue(false);
                                    contactForSyncList.setlastRecordTime(DataSeekTime);
                                }
                            }
                            LOG.debug("last record time ={}", (Object)contactForSyncList.getlastRecordTime());
                            break;
                        }
                    }
                } else {
                    ArrayList contact1;
                    Page Page1;
                    LOG.debug("isGetDeleted = true");
                    if (DataSeekTime.isBefore((ReadableInstant)getDeleteFromTime)) {
                        LOG.debug("DataSeekTime = isbefore");
                        StartTime = null;
                        StartTime = IsContinueSeek ? DataSeekTime : LastRecTime;
                        LOG.debug("IsContinueSeek = {} StartTime ={} LastRecTime ={} DataSeekTime ={}", new Object[]{IsContinueSeek, StartTime, LastRecTime, DataSeekTime});
                        Page1 = this.contactDao.findByCategorybyOrderModifyTimeLimitCountBeforeTime(cateAll.getGuid(), DataSeekTime, getDeleteFromTime, (Pageable)pageRequest).map(cons -> new ContactForSync(cons));
                        contact1 = new ArrayList(Page1.getContent());
                        LOG.debug("contact1 size={}", (Object)contact1.size());
                        block14 : switch (contact1.size()) {
                            case 300: {
                                contactForSyncList.setisNeedContinue(true);
                                contactForSyncList.setlastRecordTime(((ContactForSync)contact1.get(contact1.size() - 1)).getModifyTime());
                                contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTimeWithoutDeleted((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                                if (contactStatusList.size() != 300) break;
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                break;
                            }
                            default: {
                                contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTimeWithoutDeleted((DateTime)StartTime, getDeleteFromTime, curAccount, (Pageable)pageRequestStatus).getContent();
                                contactForSyncList.setisNeedContinue(true);
                                switch (contactStatusList.size()) {
                                    case 300: {
                                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                        break block14;
                                    }
                                    default: {
                                        contactForSyncList.setlastRecordTime(getDeleteFromTime);
                                        break block14;
                                    }
                                    case 0: {
                                        contactForSyncList.setlastRecordTime(getDeleteFromTime);
                                        break block14;
                                    }
                                    case 1: 
                                }
                                contactForSyncList.setlastRecordTime(getDeleteFromTime);
                            }
                        }
                        contacts = contact1;
                    } else {
                        LOG.debug("DataSeekTime = isafter");
                        StartTime = null;
                        StartTime = IsContinueSeek ? DataSeekTime : LastRecTime;
                        LOG.debug("IsContinueSeek = {} StartTime ={} LastRecTime ={} DataSeekTime ={}", new Object[]{IsContinueSeek, StartTime, LastRecTime, DataSeekTime});
                        Page1 = this.contactDao.findSeekByCategorybyOrderModifyTimeLimitCount(cateAll.getGuid(), (DateTime)StartTime, (Pageable)pageRequest).map(cons -> new ContactForSync(cons));
                        contact1 = new ArrayList(Page1.getContent());
                        LOG.debug("contact1 size={}", (Object)contact1.size());
                        switch (contact1.size()) {
                            case 300: {
                                contactForSyncList.setisNeedContinue(true);
                                contactForSyncList.setlastRecordTime(((ContactForSync)contact1.get(contact1.size() - 1)).getModifyTime());
                                contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTime((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                                if (contactStatusList.size() != 300) break;
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                break;
                            }
                            default: {
                                contactForSyncList.setisNeedContinue(true);
                                contactForSyncList.setlastRecordTime(((ContactForSync)contact1.get(contact1.size() - 1)).getModifyTime());
                                contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTime((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                                if (contactStatusList.size() != 300) break;
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                break;
                            }
                            case 1: {
                                if (((ContactForSync)contact1.get(0)).getModifyTime().isEqual((ReadableInstant)StartTime)) {
                                    contactStatusList = this.contactStatusForAccountDao.findAfterSeekTime((DateTime)StartTime, curAccount, (Pageable)pageRequestStatus).getContent();
                                    LOG.debug("curAccount ,contcontactStatusListacts size={}", (Object)curAccount.getDisplayName(), (Object)contactStatusList.size());
                                    switch (contactStatusList.size()) {
                                        case 300: {
                                            contactForSyncList.setisNeedContinue(true);
                                            contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                            break;
                                        }
                                        default: {
                                            contactForSyncList.setisNeedContinue(false);
                                            contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                            break;
                                        }
                                        case 0: {
                                            contactForSyncList.setisNeedContinue(false);
                                            contactForSyncList.setlastRecordTime((DateTime)StartTime);
                                        }
                                    }
                                    LOG.debug("curAccount = {} LastRecTime {} StartTime {} DataSeekTime {}", new Object[]{curAccount.getDisplayName(), LastRecTime, StartTime, DataSeekTime});
                                    break;
                                }
                                contactForSyncList.setisNeedContinue(true);
                                contactForSyncList.setlastRecordTime(((ContactForSync)contact1.get(contact1.size() - 1)).getModifyTime());
                                contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTime((DateTime)StartTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                                if (contactStatusList.size() != 300) break;
                                contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                break;
                            }
                            case 0: {
                                contactStatusList = this.contactStatusForAccountDao.findAfterSeekTime((DateTime)StartTime, curAccount, (Pageable)pageRequestStatus).getContent();
                                LOG.debug("curAccount ,contcontactStatusListacts size={}", (Object)curAccount.getDisplayName(), (Object)contactStatusList.size());
                                switch (contactStatusList.size()) {
                                    case 300: {
                                        contactForSyncList.setisNeedContinue(true);
                                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                        break;
                                    }
                                    default: {
                                        contactForSyncList.setisNeedContinue(false);
                                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                                        break;
                                    }
                                    case 0: {
                                        contactForSyncList.setisNeedContinue(false);
                                        contactForSyncList.setlastRecordTime((DateTime)StartTime);
                                    }
                                }
                                LOG.debug("curAccount = {} LastRecTime {} StartTime {} DataSeekTime {}", new Object[]{curAccount.getDisplayName(), LastRecTime, StartTime, DataSeekTime});
                            }
                        }
                        contacts = contact1;
                    }
                }
                LOG.debug("acnt = {} isNeedContinue {} lastRecordTime {}", new Object[]{curAccount.getDisplayName(), contactForSyncList.getisNeedContinue(), contactForSyncList.getlastRecordTime()});
                for (ContactForSync conC : contacts) {
                    LOG.debug("acnt ={} contact info ={}", (Object)curAccount.getDisplayName(), (Object)conC);
                }
                for (ContactForSync conC : contactStatusList) {
                    LOG.debug("acnt ={} Contactstatus info ={}", (Object)curAccount.getDisplayName(), (Object)conC);
                }
                LOG.debug("getModifyContactsByAccount 16");
                contacts = this.addlost(contacts, contactStatusList);
                contactForSyncList.setContactList(contacts);
                LOG.debug("contacts size={}", (Object)contacts.size());
                return contactForSyncList;
            }
            LOG.debug("getModifyContactsByAccount notfirst 0" + TimeUtil.PrintCurrentUTCTime());
            Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "modifytime")});
            PageRequest pageRequest = new PageRequest(0, MaxCount, sort);
            Sort sortstatus = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "statusupdatetime")});
            PageRequest pageRequestStatus = new PageRequest(0, MaxCount, sortstatus);
            List contacts = null;
            DateTime startTime = null;
            if (!IsContinueSeek) {
                startTime = LastRecTime;
                contacts = this.contactDao.findByCategorybyOrderModifyTimeLimitAfterSetTime(cateAll.getGuid(), LastRecTime, (Pageable)pageRequest).map(cons -> new ContactForSync(cons)).getContent();
            } else {
                startTime = DataSeekTime;
                contacts = this.contactDao.findByCategorybyOrderModifyTimeLimitAfterSeekTime(cateAll.getGuid(), DataSeekTime, (Pageable)pageRequest).map(cons -> new ContactForSync(cons)).getContent();
            }
            LOG.debug("getModifyContactsByAccount notfirst 1 contactsCoount={} {} ", (Object)contacts.size(), (Object)TimeUtil.PrintCurrentUTCTime());
            List contactStatusList = null;
            boolean bLast = true;
            if (contacts.size() == 0) {
                bLast = true;
            } else if (contacts.size() == 1) {
                bLast = ((ContactForSync)contacts.get(0)).getModifyTime().equals((Object)startTime);
            } else {
                boolean bSame = true;
                for (ContactForSync contactForSync : contacts) {
                    if (contactForSync.getModifyTime().equals((Object)startTime)) continue;
                    bSame = false;
                    break;
                }
                bLast = bSame;
            }
            if (!bLast) {
                LOG.debug("getModifyContactsByAccount notfirst 2");
                LOG.debug("getModifyContactsByAccount notfirst 3");
                contactForSyncList.setisNeedContinue(true);
                contactForSyncList.setlastRecordTime(((ContactForSync)contacts.get(contacts.size() - 1)).getModifyTime());
                if (!IsContinueSeek) {
                    LOG.debug("getModifyContactsByAccount notfirst 4");
                    contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTime(LastRecTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                } else {
                    LOG.debug("getModifyContactsByAccount notfirst 5");
                    contactStatusList = this.contactStatusForAccountDao.findBetweenSeekTime(DataSeekTime, contactForSyncList.getlastRecordTime(), curAccount, (Pageable)pageRequestStatus).getContent();
                }
                if (contactStatusList.size() == MaxCount) {
                    LOG.debug("getModifyContactsByAccount notfirst 11");
                    contactForSyncList.setisNeedContinue(true);
                    contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                }
            } else {
                LOG.debug("getModifyContactsByAccount notfirst 10");
                DateTime StartTime = null;
                if (!IsContinueSeek) {
                    StartTime = LastRecTime;
                    contactStatusList = this.contactStatusForAccountDao.findAfterTime(LastRecTime, curAccount, (Pageable)pageRequestStatus).getContent();
                } else {
                    StartTime = DataSeekTime;
                    contactStatusList = this.contactStatusForAccountDao.findAfterSeekTime(DataSeekTime, curAccount, (Pageable)pageRequestStatus).getContent();
                }
                if (contactStatusList.size() == MaxCount) {
                    LOG.debug("getModifyContactsByAccount notfirst 11");
                    contactForSyncList.setisNeedContinue(true);
                    contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                } else {
                    contactForSyncList.setisNeedContinue(false);
                    if (contactStatusList.size() > 0) {
                        contactForSyncList.setlastRecordTime(((Contactstatusforaccount)contactStatusList.get(contactStatusList.size() - 1)).getStatusupdatetime());
                    } else {
                        contactForSyncList.setlastRecordTime(StartTime);
                    }
                }
            }
            contacts = this.addlost(contacts, contactStatusList);
            LOG.debug("getModifyContactsByAccount notfirst 12" + TimeUtil.PrintCurrentUTCTime());
            LOG.debug("getModifyContactsByAccount EXIST");
            LOG.debug("contact info in first size={}", (Object)contacts.size());
            for (ContactForSync conC : contacts) {
                LOG.debug("contact info ={}", (Object)conC);
            }
            contactForSyncList.setContactList(contacts);
            contactForSyncList.sort();
            return contactForSyncList;
        }
        catch (Exception ee) {
            LOG.error("get modifyContactInfo exception ={}", (Throwable)ee);
            return contactForSyncList;
        }
    }

    private List<ContactForSync> addlost(List<ContactForSync> contacts, List<Contactstatusforaccount> contactStatusList) {
        if (contactStatusList == null) {
            return contacts;
        }
        ArrayList<Contactstatusforaccount> lostcontactStatusList = new ArrayList<Contactstatusforaccount>();
        for (Contactstatusforaccount constC : contactStatusList) {
            boolean bfound = false;
            if (contacts != null) {
                int nCount = contacts.size();
                for (int i = nCount - 1; i >= 0; --i) {
                    ContactForSync curC = contacts.get(i);
                    if (constC.getContact().getGuid() != curC.getGuid()) continue;
                    bfound = true;
                    curC.setModifyTime(TimeUtil.GetAfter((DateTime)curC.getModifyTime(), (DateTime)constC.getStatusupdatetime()));
                    curC.setDeleted(constC.getIsdeletedfromaccount());
                    curC.setDeletedFromShare(curC.getIsDeleted());
                    break;
                }
            }
            if (bfound) continue;
            lostcontactStatusList.add(constC);
        }
        if (lostcontactStatusList.size() > 0) {
            LOG.debug("addlost contacts = {},lostcontactStatusList = {}", contacts, lostcontactStatusList);
            List lostcontactList = lostcontactStatusList.stream().map(cons -> new ContactForSync(cons)).collect(Collectors.toList());
            LOG.debug("addlost contacts = {},lostcontactList = {}", contacts, lostcontactList);
            if (contacts == null || contacts.size() == 0) {
                contacts = lostcontactList;
            } else if (lostcontactList != null) {
                List<ContactForSync> newList = Stream.concat(contacts.stream(), lostcontactList.stream()).collect(Collectors.toList());
                return newList;
            }
        }
        return contacts;
    }

    public ContactInfoForResponse getContactResponseInfoByGuid(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            String eString = String.format("Contact not found. (Guid: {})", contactGuid);
            throw new ItemNotFoundException(eString);
        }
        return new ContactInfoForResponse(contact);
    }

    public List<String> getContactGuidsByCategory(String categoryGuid) {
        return this.contactDao.findGuidByCategory_IncludeDeleted(categoryGuid);
    }

    public List<String> getContactGuidsAllInPrivateByAccount(String accountGuid, boolean includeDeleted) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return new ArrayList<String>();
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        if (categoryAll == null) {
            return new ArrayList<String>();
        }
        if (includeDeleted) {
            return this.contactDao.findGuidByCategory_IncludeDeleted(categoryAll.getGuid());
        }
        return this.contactDao.findGuidByCategory(categoryAll.getGuid());
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsByCategory(String categoryGuid, PageInfo<ContactField> pageInfo) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        PageRequest pageRequest = new PageRequest(pageInfo.getPageIndex(), pageInfo.getNumberPerPage(), GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType));
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException("Category is not found.");
        }
        Page infoPage = this.contactSimpleInfoDao.findPageByCategory(categoryGuid, (Pageable)pageRequest);
        return this.transToContactSimpleInfoDtoPage(infoPage, category.getOwneraccount(), nameDisplayOrderSettingType);
    }

    private PageResult<ContactSimpleInfoDto> getSimpleContactsUncorrectedByCategory(String categoryGuid, PageInfo<ContactField> pageInfo) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        PageRequest pageRequest = new PageRequest(pageInfo.getPageIndex(), pageInfo.getNumberPerPage(), GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType));
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException("Category is not found.");
        }
        Page infoPage = this.contactSimpleInfoDao.findPageWithUncorrectedByCategory(categoryGuid, (Pageable)pageRequest);
        return this.transToContactSimpleInfoDtoPage(infoPage, category.getOwneraccount(), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsUncorrectedByAccount(String accountGuid, PageInfo<ContactField> pageInfo) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return new PageResult();
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        if (categoryAll == null) {
            return new PageResult();
        }
        return this.getSimpleContactsUncorrectedByCategory(categoryAll.getGuid(), pageInfo);
    }

    public PageResult<ContactSimpleInfoDto> transToContactSimpleInfoDtoPage(Page<Contactsimpleinfo> infoPage, Account account, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        List<Object> simpleInfos = new ArrayList();
        if (account == null) {
            simpleInfos = infoPage.getContent().stream().map(s -> new ContactSimpleInfoDto(s, nameDisplayOrderSettingType, s.getContact())).collect(Collectors.toList());
        } else {
            try {
                AccountInfo accountInfo = (AccountInfo)this.accountInfoDtoMapper.transformToDto((Object)account);
                SupportCRM supportCRM = this.systemSettingService.getSystemCRM(accountInfo);
                CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(account.getGuid());
                simpleInfos = infoPage.getContent().stream().map(s -> {
                    Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, s.getContact());
                    return new ContactSimpleInfoDto(s, nameDisplayOrderSettingType, s.getContact(), status, supportCRM, crmSettingsDto.getUserCRMAccount());
                }).collect(Collectors.toList());
            }
            catch (ItemNotFoundException e) {
                LOG.debug("systemSettingService.getSystemCRM() ItemNotFoundException");
                simpleInfos = infoPage.getContent().stream().map(s -> new ContactSimpleInfoDto(s, nameDisplayOrderSettingType, s.getContact())).collect(Collectors.toList());
            }
        }
        PageResult dtoPage = new PageResult(simpleInfos, infoPage.getTotalElements(), infoPage.getTotalPages());
        return dtoPage;
    }

    public ContactSimpleInfoDto getSimpleContactDtoByGuid(String contactGuid, String accountGuid) {
        List dtos = this.getSimpleContactDtosByGuids(Arrays.asList(contactGuid), accountGuid);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return new ContactSimpleInfoDto();
        }
        return (ContactSimpleInfoDto)dtos.get(0);
    }

    private List<ContactSimpleInfoDto> getSimpleContactDtosByGuids(List<String> contactGuids, String accountGuid) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = accountGuid == null ? this.accountPrivateSettingService.getNameDisplayOrderSetting() : this.accountPrivateSettingService.getNameDisplayOrderSettingByAccount(accountGuid);
        List contacts = this.contactSimpleInfoDao.findByContactGuids(contactGuids);
        if (CollectionUtils.isEmpty((Collection)contacts)) {
            return new ArrayList<ContactSimpleInfoDto>();
        }
        List<ContactSimpleInfoDto> infoDtos = contacts.stream().map(c -> new ContactSimpleInfoDto(c, nameDisplayOrderSettingType, null)).collect(Collectors.toList());
        return infoDtos;
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactDtoPageByGuids(List<String> contactGuids, PageInfo<ContactField> pageInfo) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        PageRequest pageRequest = new PageRequest(pageInfo.getPageIndex(), pageInfo.getNumberPerPage(), GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType));
        Page infoPage = this.contactSimpleInfoDao.findPageByContactGuidList(contactGuids, (Pageable)pageRequest);
        return this.transToContactSimpleInfoDtoPage(infoPage, null, nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsByAll(PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter, String companyGuid) {
        LOG.debug("getSimpleContactsByAll ");
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidByAllUndeleted(sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd(), companyGuid);
        LOG.debug("getSimpleContactsByAll allSimpleInfoGuids={} ", (Object)allSimpleInfoGuids);
        PageResult contactsimpleinfos = this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
        LOG.debug("getSimpleContactsByAll contactsimpleinfos ={}", (Object)contactsimpleinfos);
        return contactsimpleinfos;
    }

    public PageResult<ContactSimpleInfoDto> transListToContactSimpleInfoDtoPage(List<String> simpleInfoGuids, int pageSize, Integer pageIndex, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        int totalCount = simpleInfoGuids.size();
        if (totalCount == 0) {
            return new PageResult();
        }
        List simpleInfoGuidsInPage = ListObjectPaginator.getPageResult(simpleInfoGuids, (int)pageIndex, (int)pageSize);
        List simpleInfosInPage = this.contactSimpleInfoDao.findByGuidIn(simpleInfoGuidsInPage);
        Collections.sort(simpleInfosInPage, Comparator.comparing(item -> simpleInfoGuidsInPage.indexOf(item.getGuid())));
        List simpleInfoDtos = simpleInfosInPage.stream().filter(Objects::nonNull).map(cs -> new ContactSimpleInfoDto(cs, nameDisplayOrderSettingType, cs.getContact())).collect(Collectors.toList());
        PageResult result = new PageResult(simpleInfoDtos, (long)totalCount, ListObjectPaginator.calculateTotalPagesCeil((int)totalCount, (int)pageSize));
        return result;
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsOwnedByAccount(String accountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        LOG.debug("getSimpleContactsOwnedByAccount accountGuid = {} ", (Object)accountGuid);
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidOwnedByAccount(accountGuid, sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        LOG.debug("getSimpleContactsOwnedByAccount allSimpleInfoGuids = {} ", (Object)allSimpleInfoGuids);
        return this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsUncategoryAndContactOwnerAndAccountCanView(String contactOwnerGuid, String canViewAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        Account contactOwner = this.accountDao.findOne(contactOwnerGuid);
        if (contactOwner == null) {
            return new PageResult();
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactOwner, CategoryType.ALL);
        if (categoryAll == null) {
            return new PageResult();
        }
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidUncategoryByContactOwnerAndAccountCanView(contactOwnerGuid, categoryAll.getGuid(), canViewAccountGuid, sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        return this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsUncategoryAndContactOwner(String contactOwnerGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        Account contactOwner = this.accountDao.findOne(contactOwnerGuid);
        if (contactOwner == null) {
            return new PageResult();
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactOwner, CategoryType.ALL);
        if (categoryAll == null) {
            return new PageResult();
        }
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidUncategoryByContactOwner(contactOwnerGuid, categoryAll.getGuid(), sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        return this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsByCategoryAndContactOwner(String categoryGuid, String contactOwnerGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidByCategoryAndContactOwner(categoryGuid, contactOwnerGuid, sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        return this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getSimpleContactsByCategoryAndContactOwnerAndAccountCanView(String categoryGuid, String contactOwnerGuid, String canViewAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidByCategoryAndContactOwnerAndAccountCanView(categoryGuid, contactOwnerGuid, canViewAccountGuid, sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        return this.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public byte[] getImageContent(String contactGuid, ContactImageType imageType) throws IOException {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found.");
        }
        List images = contact.getContactimagewithcontents();
        if (images == null) {
            throw new ItemNotFoundException("There is no image in this contact.");
        }
        Optional<Contactimagewithcontent> image = images.stream().filter(img -> img.getImageType().equals((Object)imageType)).findFirst();
        if (!image.isPresent()) {
            throw new ItemNotFoundException("There is no such type of image in this contact: " + imageType);
        }
        byte[] imageBytes = image.get().getContentData();
        if (ArrayUtils.isEmpty((byte[])imageBytes)) {
            String contactImageRelativePath = image.get().getFilepath();
            Path imagePath = this.cardPathManager.getFullyPath(contactImageRelativePath);
            try (InputStream iStream = Files.newInputStream(imagePath, new OpenOption[0]);){
                imageBytes = IOUtils.toByteArray((InputStream)iStream);
            }
        }
        return imageBytes;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteContact(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact is not found.");
        }
        List accountGuidsHaveThis = this.getAccountsHaveThisContactInPrivate(contactGuid);
        String ownerGuid = contact.getOwnerAccount().getGuid();
        boolean isInOwnerPrivate = false;
        if (accountGuidsHaveThis.contains(ownerGuid)) {
            accountGuidsHaveThis.remove(ownerGuid);
            isInOwnerPrivate = true;
        }
        if (!CollectionUtils.isEmpty((Collection)accountGuidsHaveThis)) {
            throw new ResourceLockedException("Delete fail: Some other accounts have this contact in Private.");
        }
        DateTime time = new DateTime();
        if (isInOwnerPrivate) {
            this.updateCategoriesOfContact(contactGuid, null, ownerGuid, ListSetBehavior.REMOVE_ALL, time);
        }
        contact.setDeleted(Boolean.valueOf(true));
        LOG.debug("[Ralph Debug modify time] delete contact ({}),setModifyTime: {}", (Object)contactGuid, (Object)time);
        contact.setModifyTime(time);
        this.contactDao.save((Object)contact);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void cleanAllContactFields(Contact contact) {
        if (!CollectionUtils.isEmpty((Collection)contact.getContactnames())) {
            this.contactNameDao.delete((Iterable)contact.getContactnames());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactaddresses())) {
            this.contactAddressDao.delete((Iterable)contact.getContactaddresses());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactdates())) {
            this.contactDateDao.delete((Iterable)contact.getContactdates());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
            this.contactJobinfoDao.delete((Iterable)contact.getContactjobinfos());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactphones())) {
            this.contactPhoneDao.delete((Iterable)contact.getContactphones());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContacturls())) {
            this.contactUrlDao.delete((Iterable)contact.getContacturls());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactims())) {
            this.contactIMDao.delete((Iterable)contact.getContactims());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactemails())) {
            this.contactEmailDao.delete((Iterable)contact.getContactemails());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactsocials())) {
            this.contactSocialDao.delete((Iterable)contact.getContactsocials());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactcustomdata())) {
            this.contactCustomDataDao.delete((Iterable)contact.getContactcustomdata());
        }
    }

    private void updateTextPartOfContactAndSaveThemToDB(ContactInfoForRequest vo, Contact contact) {
        contact.setBirthday(vo.getBirthday());
        contact.setNote(GlobalUtils.getFieldString((String)vo.getNote(), (int)4096));
        contact.setNickname(vo.getNickname());
        contact.setUniformNumber(vo.getUniformNumber());
        contact.setRecogLanguageFront(vo.getRecogLanguageFront());
        contact.setRecogLanguageBack(vo.getRecogLanguageBack());
        LOG.debug("Before contactNameDao.delete() ({})", (Object)contact.getGuid());
        this.cleanAllContactFields(contact);
        LOG.debug("After contactCustomDataDao.delete() ({})", (Object)contact.getGuid());
        List names = this.generateContactNamesAndSaveToDB(vo.getNames(), contact);
        List addresses = this.generateContactAddressesAndSaveToDB(vo.getAddresses(), contact);
        List dates = this.generateContactDatesAndSaveToDB(vo.getDates(), contact);
        List jobinfos = this.generateContactJobinfosAndSaveToDB(vo.getJobinfos(), contact);
        List phones = this.generateContactPhonesAndSaveToDB(vo.getPhones(), contact);
        List emails = this.generateContactEmailsAndSaveToDB(vo.getEmails(), contact);
        List socials = this.generateContactSocialsAndSaveToDB(vo.getSocials(), contact);
        List urls = this.generateContactUrlsAndSaveToDB(vo.getUrls(), contact);
        List ims = this.generateContactIMsAndSaveToDB(vo.getIMs(), contact);
        List customdatas = this.generateContactCustomdatasAndSaveToDB(vo.getCustomDataList(), contact);
        LOG.debug("After generateContactCustomdatasAndSaveToDB() ({})", (Object)contact.getGuid());
        contact.setContactnames(names);
        contact.setContactaddresses(addresses);
        contact.setContactdates(dates);
        contact.setContactjobinfos(jobinfos);
        contact.setContactphones(phones);
        contact.setContactemails(emails);
        contact.setContactsocials(socials);
        contact.setContacturls(urls);
        contact.setContactims(ims);
        contact.setContactcustomdata(customdatas);
        Contactsimpleinfo simpleInfo = this.generateContactSimpleInfoAndSaveToDB(contact);
        LOG.debug("After generateContactSimpleInfoAndSaveToDB() ({})", (Object)contact.getGuid());
        StringBuilder noNeedSearchString = new StringBuilder();
        Contactfulltext fulltext = this.generateContactFulltextAndSaveToDB(contact, noNeedSearchString);
        LOG.debug("After generateContactFulltextAndSaveToDB() ({})", (Object)contact.getGuid());
        contact.setContactsimpleinfo(simpleInfo);
        contact.setContactfulltexts(fulltext);
        contact.setTextSha1(DigestUtils.sha1Hex((String)(fulltext.getTextContent() + noNeedSearchString)));
    }

    private void updateImagePartOfContactAndSaveThemToDB(List<UpdateComponent> updateCompoments, String tempFrontImageFileGuid, String tempRearImageFileGuid, String tempLogoImageFileGuid, Contact contact) {
        LOG.debug("updateImagePartOfContactAndSaveThemToDB 1 ({})", (Object)contact.getGuid());
        if (updateCompoments.contains(UpdateComponent.UC_FRONT_IMAGE)) {
            this.clearContactContentImageByTypes(contact, new ContactImageType[]{ContactImageType.FRONT});
            this.setContactContentImageByType(tempFrontImageFileGuid, ContactImageType.FRONT, contact);
        }
        LOG.debug("updateImagePartOfContactAndSaveThemToDB 2 ({})", (Object)contact.getGuid());
        if (updateCompoments.contains(UpdateComponent.UC_BACK_IMAGE)) {
            this.clearContactContentImageByTypes(contact, new ContactImageType[]{ContactImageType.REAR});
            this.setContactContentImageByType(tempRearImageFileGuid, ContactImageType.REAR, contact);
        }
        LOG.debug("updateImagePartOfContactAndSaveThemToDB 3 ({})", (Object)contact.getGuid());
        if (updateCompoments.contains(UpdateComponent.UC_LOGO)) {
            this.clearContactContentImageByTypes(contact, new ContactImageType[]{ContactImageType.LOGO});
            this.setContactContentImageByType(tempLogoImageFileGuid, ContactImageType.LOGO, contact);
        }
    }

    private void updateContactAndSaveToDB(Contact contact, List<UpdateComponent> updateCompoments, ContactInfoForRequest vo, String tempFrontImageFileGuid, String tempRearImageFileGuid, String tempLogoImageFileGuid, String[] belongingCategoryGuids, Account categoryOwner, String[] shareToAccountGuids) {
        if (vo.getBeCorrected() != null) {
            LOG.debug("Before contact.setCorrected() ({})", (Object)contact.getGuid());
            contact.setCorrected(vo.getBeCorrected());
            this.contactDao.save((Object)contact);
            LOG.debug("After contact.setCorrected() ({})", (Object)contact.getGuid());
        }
        LOG.debug("Before updateImagePartOfContactAndSaveThemToDB() ({})", (Object)contact.getGuid());
        this.updateImagePartOfContactAndSaveThemToDB(updateCompoments, tempFrontImageFileGuid, tempRearImageFileGuid, tempLogoImageFileGuid, contact);
        LOG.debug("After updateImagePartOfContactAndSaveThemToDB() ({})", (Object)contact.getGuid());
        if (updateCompoments.contains(UpdateComponent.UC_CONTENT)) {
            LOG.debug("Before updateTextPartOfContactAndSaveThemToDB() ({})", (Object)contact.getGuid());
            this.updateTextPartOfContactAndSaveThemToDB(vo, contact);
            contact.setModifytimeforsearch((double)new DateTime().getMillis());
            this.contactDao.save((Object)contact);
            LOG.debug("After updateTextPartOfContactAndSaveThemToDB() ({})", (Object)contact.getGuid());
        }
        DateTime passedTime = new DateTime();
        if (updateCompoments.contains(UpdateComponent.UC_SHARE_ACCOUNT)) {
            List<Object> accountGuidList = ArrayUtils.isEmpty((Object[])shareToAccountGuids) ? new ArrayList() : Arrays.asList(shareToAccountGuids);
            LOG.debug("Before contactPublicService.shareContactToAccounts() ({})", (Object)contact.getGuid());
            this.contactPublicService.shareContactToAccounts(contact.getGuid(), accountGuidList, ListSetBehavior.OVERWRITE, passedTime);
            LOG.debug("After contactPublicService.shareContactToAccounts() ({})", (Object)contact.getGuid());
        }
        if (updateCompoments.contains(UpdateComponent.UC_CATEGORY)) {
            ArrayList categories = ArrayUtils.isEmpty((Object[])belongingCategoryGuids) ? new ArrayList() : this.categoryDao.findByGuidList(Arrays.asList(belongingCategoryGuids));
            LOG.debug("Before updateCategoriesOfContact() ({})", (Object)contact.getGuid());
            this.updateCategoriesOfContact(contact, categories, categoryOwner, ListSetBehavior.OVERWRITE, passedTime);
            LOG.debug("After updateCategoriesOfContact() ({})", (Object)contact.getGuid());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateContact(ContactUpdateVo vo, String contactEditorGuid) {
        boolean needUpdateTimeForDisplay;
        boolean needUpdateTimeForCrmSync;
        boolean needUpdateTimeForSync;
        boolean needUpdateEditor;
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)vo.getContactGuid()));
        List<UpdateComponent> updateCompoments = Arrays.asList(vo.getUpdateComponents());
        Account categoryOwner = StringUtils.isBlank((CharSequence)vo.getCategoryOwnerAccountGuid()) ? null : this.accountDao.findOne(vo.getCategoryOwnerAccountGuid());
        LOG.debug("[Ralph Debug modify time] update contact components: {}", updateCompoments);
        String[] belongingCategoryGuidsArray = GlobalUtils.getGuidArrayFromBasicItems((List)vo.getBelongingCategories());
        this.updateContactAndSaveToDB(contact, updateCompoments, (ContactInfoForRequest)vo, vo.getFrontImageFileGuid(), vo.getRearImageFileGuid(), vo.getLogoImageFileGuid(), belongingCategoryGuidsArray, categoryOwner, vo.getShareToAccountGuids());
        boolean bl = needUpdateEditor = !Collections.disjoint(updateCompoments, Arrays.asList(UpdateComponent.UC_CONTENT, UpdateComponent.UC_LOGO, UpdateComponent.UC_FRONT_IMAGE, UpdateComponent.UC_BACK_IMAGE));
        if (needUpdateEditor) {
            contact.setEditorguid(contactEditorGuid);
            this.contactDao.save((Object)contact);
        }
        DateTime timeForStore = new DateTime();
        boolean bl2 = needUpdateTimeForSync = !Collections.disjoint(updateCompoments, Arrays.asList(UpdateComponent.UC_CONTENT, UpdateComponent.UC_LOGO, UpdateComponent.UC_FRONT_IMAGE, UpdateComponent.UC_BACK_IMAGE, UpdateComponent.UC_SHARE_ACCOUNT));
        if (needUpdateTimeForSync) {
            LOG.debug("[Ralph Debug modify time] update contact ({}),setModifyTime: {}", (Object)vo.getContactGuid(), (Object)timeForStore);
            contact.setModifyTime(timeForStore);
            this.contactDao.save((Object)contact);
        }
        boolean bl3 = needUpdateTimeForCrmSync = !Collections.disjoint(updateCompoments, Arrays.asList(UpdateComponent.UC_CONTENT));
        if (needUpdateTimeForCrmSync) {
            LOG.debug("[Ralph Debug modify time] update contact ({}),setModifyTimeForCrmSync: {}", (Object)vo.getContactGuid(), (Object)timeForStore);
            contact.setModifyTimeForCrmSync(timeForStore);
            this.contactDao.save((Object)contact);
        }
        boolean bl4 = needUpdateTimeForDisplay = !Collections.disjoint(updateCompoments, Arrays.asList(UpdateComponent.UC_CONTENT, UpdateComponent.UC_LOGO, UpdateComponent.UC_FRONT_IMAGE, UpdateComponent.UC_BACK_IMAGE));
        if (needUpdateTimeForDisplay) {
            if (vo.getdisplayModifyTime() == null) {
                throw new RequestArgumentNotValidException("there is no client specified update time.");
            }
            contact.setModifytimefordisplay(vo.getdisplayModifyTime());
            this.contactDao.save((Object)contact);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, noRollbackFor={DataException.class})
    public String createContact(ContactCreationVo vo, String tempFrontImageFileGuid, String tempRearImageFileGuid, String tempLogoImageFileGuid, String companyGuid) {
        if (vo.getClientCreatedTime() == null) {
            throw new RequestArgumentNotValidException("there is no client specified created time");
        }
        String contactGuid = vo.getClientCreatedContactGuid();
        if (!StringUtils.isBlank((CharSequence)contactGuid)) {
            if (this.contactDao.findOne((Serializable)((Object)contactGuid)) != null) {
                throw new SpecifiedGuidConflictException("Specified contact guid has been used.");
            }
        } else {
            contactGuid = UUIDGenerator.getRandomUUID();
        }
        LOG.debug("create contact real contactGuid ={}", (Object)contactGuid);
        if (this.doesContactCountInDbReachLimit(companyGuid)) {
            throw new MaxCountExceededContactTotalException(WctSystemExceptionType.MAX_CONTACT_NUMBER_IN_DB_REACHED.toString());
        }
        Contact newContact = new Contact();
        newContact.setGuid(contactGuid);
        String creatorGuid = vo.getCreatorAccountGuid();
        newContact.setCreatorGuid(creatorGuid);
        String ownerGuid = vo.getOwnerAccountGuid();
        if (StringUtil.IsStringNullorEmpty((String)ownerGuid)) {
            ownerGuid = creatorGuid;
        }
        Account contactOwner = this.accountDao.findOne(ownerGuid);
        if (this.doesContactCountOwningReachLimit(ownerGuid)) {
            throw new MaxCountExceededContactOwningException(WctSystemExceptionType.MAX_CONTACT_NUMBER_OWNING_REACHED.toString());
        }
        newContact.setOwnerAccount(contactOwner);
        newContact.setCompanyGuid(companyGuid);
        newContact.setEditorguid(creatorGuid);
        newContact.setCorrected(Boolean.valueOf(false));
        newContact.setDeleted(Boolean.valueOf(false));
        newContact.setModifytimeforsearch((double)new DateTime().getMillis());
        newContact.setModifyTime(new DateTime());
        if (vo.getdisplayModifyTime() != null) {
            newContact.setModifytimefordisplay(vo.getdisplayModifyTime());
        } else {
            newContact.setModifytimefordisplay(vo.getClientCreatedTime());
        }
        newContact.setCreateTime(vo.getClientCreatedTime());
        LOG.debug("Before newContact = contactDao.save(newContact) ({})", (Object)contactGuid);
        newContact = (Contact)this.contactDao.save((Object)newContact);
        LOG.debug("After newContact = contactDao.save(newContact) ({})", (Object)contactGuid);
        List<UpdateComponent> updateCompoments = Arrays.asList(UpdateComponent.UC_CONTENT, UpdateComponent.UC_FRONT_IMAGE, UpdateComponent.UC_BACK_IMAGE, UpdateComponent.UC_LOGO, UpdateComponent.UC_CATEGORY, UpdateComponent.UC_SHARE_ACCOUNT);
        String categoryOwnerGuid = vo.getBelongingCategoriesOwnerAccountGuid();
        if (StringUtil.IsStringNullorEmpty((String)categoryOwnerGuid)) {
            categoryOwnerGuid = creatorGuid;
        }
        Account categoryOwner = this.accountDao.findOne(categoryOwnerGuid);
        String[] belongingCategoryGuidsArray = GlobalUtils.getGuidArrayFromBasicItems((List)vo.getBelongingCategories());
        LOG.debug("Before updateContactAndSaveToDB() ({})", (Object)contactGuid);
        this.updateContactAndSaveToDB(newContact, updateCompoments, (ContactInfoForRequest)vo, tempFrontImageFileGuid, tempRearImageFileGuid, tempLogoImageFileGuid, belongingCategoryGuidsArray, categoryOwner, vo.getShareToAccountGuids());
        newContact.setModifyTime(newContact.getModifyTime());
        LOG.debug("After updateContactAndSaveToDB() ({})", (Object)contactGuid);
        CrmTargetType crmTargetType = vo.getExportedCrmTargetType();
        if (crmTargetType != null) {
            CRMOperationService crmOperationService = GlobalUtils.getCrmOperationService((CrmTargetType)crmTargetType);
            LOG.debug("Before crmOperationService.setExportCrmInfo() ({})", (Object)contactGuid);
            crmOperationService.setExportCrmInfo(categoryOwnerGuid, newContact.getGuid(), vo.getExportedCrmRecordID(), vo.getExportedCrmAccount(), null);
            LOG.debug("After crmOperationService.setExportCrmInfo() ({})", (Object)contactGuid);
        }
        return newContact.getGuid();
    }

    public ContactProfile getContactProfile(String contactGuid, String accountGuid) {
        List accounts;
        LOG.debug("getContactProfile CONTACDID ={} ACCOUNTID={}", (Object)contactGuid, (Object)accountGuid);
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        LOG.debug("getContactProfile 2");
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return null;
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            return null;
        }
        ContactProfile profile = new ContactProfile(contact);
        List contactimages = contact.getContactimages();
        if (!CollectionUtils.isEmpty((Collection)contactimages)) {
            Optional<Contactimage> contactImage = contactimages.stream().filter(image -> image.getImageType().equals((Object)ContactImageType.FRONT)).findFirst();
            if (contactImage.isPresent()) {
                profile.setFrontImageSha1(contactImage.get().getSha1());
            }
            if ((contactImage = contactimages.stream().filter(image -> image.getImageType().equals((Object)ContactImageType.REAR)).findFirst()).isPresent()) {
                profile.setRearImageSha1(contactImage.get().getSha1());
            }
            if ((contactImage = contactimages.stream().filter(image -> image.getImageType().equals((Object)ContactImageType.LOGO)).findFirst()).isPresent()) {
                profile.setLogoImageSha1(contactImage.get().getSha1());
            }
        }
        if ((accounts = contact.getAccountsCanView()) != null) {
            List accountInfos = accounts.stream().map(a -> a.getGuid()).collect(Collectors.toList());
            profile.setAccountGuidsBeShared(accountInfos);
        }
        profile.setDeletedFromShare(contact.getIsDeleted());
        profile.setDeleted(status.getIsdeletedfromaccount());
        profile.setCategorySha1(status.getCategorysha1());
        String categoryGuidsString = status.getCategoryguids();
        if (!StringUtil.IsStringNullorEmpty((String)categoryGuidsString)) {
            ArrayList guidList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)categoryGuidsString));
            profile.setCategoryGuids((List)guidList);
        } else {
            profile.setCategoryGuids(new ArrayList());
        }
        profile.setSyncModifyTime(TimeUtil.GetAfter((DateTime)contact.getModifyTime(), (DateTime)status.getStatusupdatetime()));
        profile.setModifyTime(contact.getModifyTime());
        profile.setDeleted(status.getIsdeletedfromaccount());
        return profile;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void clearContactContentImageByTypes(Contact contact, ContactImageType ... types) {
        LOG.debug("clearContactContentImageByTypes 1 ({})", (Object)contact.getGuid());
        List images = contact.getContactimages();
        if (CollectionUtils.isEmpty((Collection)images)) {
            return;
        }
        LOG.debug("clearContactContentImageByTypes 2 ({})", (Object)contact.getGuid());
        List deleteImages = images.stream().filter(img -> Arrays.asList(types).contains(img.getImageType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deleteImages)) {
            return;
        }
        LOG.debug("[clearContactContentImageByTypes] Before contactImageDao.delete()");
        this.contactImageDao.delete(deleteImages);
        contact.getContactimages().removeAll(deleteImages);
    }

    private void updateCategoriesOfContact(Contact contact, List<Category> categories, Account contactReceiver, ListSetBehavior behavior, DateTime passedTime) {
        DateTime timeForStore;
        LOG.debug("[updateCategoriesOfContact] {} ({}) start", (Object)behavior, (Object)contact.getGuid());
        DateTime dateTime = timeForStore = passedTime == null ? new DateTime() : passedTime;
        if (contact.getIsDeleted().booleanValue()) {
            throw new RequestArgumentNotValidException("contact is deleted, guid: " + contact.getGuid());
        }
        LOG.debug("updateCategoriesOfContact categories {}", categories);
        if (!CollectionUtils.isEmpty(categories) && categories.stream().anyMatch(c -> !contactReceiver.equals((Object)c.getOwneraccount()))) {
            throw new RequestArgumentNotValidException("some input categories do not belong to the account who gets the contact.");
        }
        LOG.debug("[CategorySha1Issue] ({}) categories:{}", (Object)contact.getGuid(), categories.stream().map(c -> c.getGuid()).collect(Collectors.toList()));
        List allCategories = contact.getCategoriesOwnMe();
        if (allCategories == null) {
            allCategories = Lists.newArrayList();
            contact.setCategoriesOwnMe(allCategories);
        }
        List myCurrentCategories = allCategories.stream().filter(c -> contactReceiver.equals((Object)c.getOwneraccount())).collect(Collectors.toList());
        Category typeAllCategory = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactReceiver, CategoryType.ALL);
        Category typeOtherCategory = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactReceiver, CategoryType.OTHER);
        allCategories.removeAll(myCurrentCategories);
        if (behavior.equals((Object)ListSetBehavior.OVERWRITE)) {
            myCurrentCategories = new ArrayList<Category>(categories);
        }
        if (behavior.equals((Object)ListSetBehavior.ADD)) {
            myCurrentCategories.addAll(categories);
        }
        if (behavior.equals((Object)ListSetBehavior.REMOVE)) {
            myCurrentCategories.removeAll(categories);
        }
        if (behavior.equals((Object)ListSetBehavior.REMOVE_ALL)) {
            myCurrentCategories = new ArrayList();
        }
        if (!behavior.equals((Object)ListSetBehavior.REMOVE_ALL)) {
            myCurrentCategories.add(typeAllCategory);
            myCurrentCategories = myCurrentCategories.stream().filter(c -> !c.isDeleted()).collect(Collectors.toList());
            if (!myCurrentCategories.stream().anyMatch(c -> CategoryType.NORMAL.equals((Object)c.getCategoryType()))) {
                myCurrentCategories.add(typeOtherCategory);
            } else {
                myCurrentCategories.remove(typeOtherCategory);
            }
            myCurrentCategories = myCurrentCategories.stream().distinct().collect(Collectors.toList());
        }
        allCategories.addAll(myCurrentCategories);
        contact.setModifytimeforsearch((double)new DateTime().getMillis());
        LOG.debug("[updateCategoriesOfContact] Before contactDao.save() ({}) myCurrentCategories: {}", (Object)contact.getGuid(), myCurrentCategories);
        this.contactDao.save((Object)contact);
        LOG.debug("[updateCategoriesOfContact] 2 {}", categories);
        List newCurrentCategories = myCurrentCategories;
        LOG.debug("updateCategoriesOfContact findFirstByAccountAndContact contactReceiver={},contact={}", (Object)contactReceiver, (Object)contact);
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(contactReceiver, contact);
        LOG.debug("[updateCategoriesOfContact] 3 {}", categories);
        int contactCount = contactReceiver.getContactcountinprivate();
        boolean isActionAddIntoPrivate = false;
        if (status == null) {
            status = new Contactstatusforaccount();
            status.setGuid(UUIDGenerator.getRandomUUID());
            status.setContact(contact);
            status.setAccount(contactReceiver);
            if (!CollectionUtils.isEmpty(newCurrentCategories)) {
                ++contactCount;
                isActionAddIntoPrivate = true;
                status.setModifyTimeForCrmSync(timeForStore);
            }
        } else {
            if (status.getIsdeletedfromaccount().booleanValue() && !CollectionUtils.isEmpty(newCurrentCategories)) {
                ++contactCount;
                isActionAddIntoPrivate = true;
                status.setModifyTimeForCrmSync(timeForStore);
            }
            if (!status.getIsdeletedfromaccount().booleanValue() && CollectionUtils.isEmpty(newCurrentCategories)) {
                --contactCount;
                status.setModifyTimeForCrmSync(timeForStore);
            }
        }
        if (this.needCalibratePrivateContactCount(contactCount)) {
            contactCount = this.getContactNumAllInPrivateByAccount(contactReceiver.getGuid()).intValue();
        }
        if ((long)contactCount > this.getSettingMaxContactCountInPrivate() && isActionAddIntoPrivate) {
            throw new MaxCountExceededContactPrivateException(WctSystemExceptionType.MAX_CONTACT_NUMBER_IN_PRIVATE_REACHED.toString());
        }
        contactReceiver.setContactcountinprivate(Integer.valueOf(contactCount));
        this.accountDao.save((Object)contactReceiver);
        LOG.debug("[updateCategoriesOfContact] 4 {}", categories);
        if (CollectionUtils.isEmpty(newCurrentCategories)) {
            status.setIsdeletedfromaccount(Boolean.valueOf(true));
        } else {
            status.setIsdeletedfromaccount(Boolean.valueOf(false));
        }
        LOG.debug("[updateCategoriesOfContact] 5 {}", categories);
        List categoryStrings = newCurrentCategories.stream().map(c -> c.getGuid()).collect(Collectors.toList());
        LOG.debug("[CategorySha1Issue] ({}) categoryStrings:{}", (Object)contact.getGuid(), categoryStrings);
        String serialGuid = Joiner.on((String)",").skipNulls().join(categoryStrings);
        LOG.debug("[CategorySha1Issue] ({}) serialGuid:{}", (Object)contact.getGuid(), (Object)serialGuid);
        status.setCategoryguids(serialGuid);
        status.setCategorysha1(DigestUtils.sha1Hex((String)serialGuid));
        LOG.debug("[CategorySha1Issue] ({}) DigestUtils.sha1Hex(serialGuid):{}", (Object)contact.getGuid(), (Object)DigestUtils.sha1Hex((String)serialGuid));
        status.setStatusupdatetime(timeForStore);
        this.contactStatusForAccountDao.save((Object)status);
        LOG.debug("[updateCategoriesOfContact] {} ({}) end", (Object)behavior, (Object)contact.getGuid());
    }

    private boolean needCalibratePrivateContactCount(int contactCount) {
        long topLimitation = this.getSettingMaxContactCountInPrivate();
        if (Math.abs((long)contactCount - topLimitation) > 100L) {
            return false;
        }
        int digitInOnesOfLimitation = (int)(topLimitation % 10L);
        int digitInOnesOfCount = contactCount % 10;
        if ((long)contactCount < topLimitation && digitInOnesOfCount == (digitInOnesOfLimitation + 9) % 10) {
            return true;
        }
        return (long)contactCount > topLimitation && digitInOnesOfCount == (digitInOnesOfLimitation + 3) % 10;
    }

    private Contactfulltext generateContactFulltextAndSaveToDB(Contact contact, StringBuilder noNeedSearchString) {
        Contactfulltext fullTextContent = contact.getContactfulltexts();
        if (fullTextContent == null) {
            fullTextContent = new Contactfulltext();
            fullTextContent.setGuid(UUIDGenerator.getRandomUUID());
        }
        String fullTextContentString = this.generateContactSearchContent(contact, noNeedSearchString);
        fullTextContent.setTextContent(fullTextContentString.toLowerCase());
        fullTextContent.setContact(contact);
        LOG.debug("before save contactfulltext : {}", (Object)fullTextContent);
        Contactfulltext contactfulltextSaved = (Contactfulltext)this.contactfulltextDao.save((Object)fullTextContent);
        LOG.debug("after save contactfulltext : {}", (Object)contactfulltextSaved);
        return contactfulltextSaved;
    }

    private Contactsimpleinfo generateContactSimpleInfoAndSaveToDB(Contact contact) {
        List jobinfos;
        Contactsimpleinfo simpleInfo = contact.getContactsimpleinfo();
        LOG.debug("[generateContactSimpleInfoAndSaveToDB] simpleInfo:{}", (Object)simpleInfo);
        if (simpleInfo == null) {
            simpleInfo = new Contactsimpleinfo();
            simpleInfo.setGuid(UUIDGenerator.getRandomUUID());
            simpleInfo.setCreateTime(contact.getCreateTime());
        }
        if (!CollectionUtils.isEmpty((Collection)(jobinfos = contact.getContactjobinfos()))) {
            Optional<Contactjobinfo> optJobinfo = jobinfos.stream().filter(j -> j.getFieldOrder().equals(0)).findFirst();
            Contactjobinfo jobinfo = optJobinfo.isPresent() ? optJobinfo.get() : (Contactjobinfo)jobinfos.get(0);
            simpleInfo.setCompany(jobinfo.getCompanyName());
            simpleInfo.setJobTitle(jobinfo.getJobTitle());
            simpleInfo.setDepartment(jobinfo.getDepartment());
        } else {
            simpleInfo.setCompany("");
            simpleInfo.setJobTitle("");
            simpleInfo.setDepartment("");
        }
        List names = contact.getContactnames();
        if (!CollectionUtils.isEmpty((Collection)names)) {
            Optional<Contactname> optName = names.stream().filter(n -> n.getFieldOrder().equals(0)).findFirst();
            Contactname name = optName.isPresent() ? optName.get() : (Contactname)names.get(0);
            String first = name.getFirstName() == null ? "" : name.getFirstName();
            String last = name.getLastName() == null ? "" : name.getLastName();
            String fullnameFL = String.format("%s%s", first, last);
            String fullnameLF = String.format("%s%s", last, first);
            if (!GlobalUtils.stringContainsChineseWord((String)fullnameFL)) {
                fullnameFL = String.format("%s %s", first, last);
                fullnameLF = String.format("%s %s", last, first);
                fullnameFL = fullnameFL.trim().replaceAll(" +", " ");
                fullnameLF = fullnameLF.trim().replaceAll(" +", " ");
                simpleInfo.setFullnameeastlastwestfirst(fullnameFL);
                simpleInfo.setFullnameeastfirstwestlast(fullnameLF);
            } else {
                simpleInfo.setFullnameeastlastwestfirst(fullnameLF);
                simpleInfo.setFullnameeastfirstwestlast(fullnameFL);
            }
            simpleInfo.setFullnameeastfirstwestfirst(fullnameFL);
            simpleInfo.setFullnameeastlastwestlast(fullnameLF);
        } else {
            simpleInfo.setFullnameeastfirstwestfirst("");
            simpleInfo.setFullnameeastfirstwestlast("");
            simpleInfo.setFullnameeastlastwestfirst("");
            simpleInfo.setFullnameeastlastwestlast("");
        }
        simpleInfo.setContact(contact);
        return (Contactsimpleinfo)this.contactSimpleInfoDao.save((Object)simpleInfo);
    }

    private Contactimage setContactContentImageByType(String tempContactImageGuid, ContactImageType imageType, Contact contact) {
        LOG.debug("[setContactContentImage] tempFileGuid: {}", (Object)tempContactImageGuid);
        if (StringUtil.IsStringNullorEmpty((String)tempContactImageGuid)) {
            return null;
        }
        Contactimage image = (Contactimage)this.contactImageDao.findOne((Serializable)((Object)tempContactImageGuid));
        if (image == null) {
            return null;
        }
        image.setImageType(imageType);
        image.setCreateTime(new DateTime());
        image.setUpdateTime(new DateTime());
        image.setContact(contact);
        contact.getContactimages().add(image);
        LOG.debug("[setContactContentImage] Before contactImageDao.save() {}", (Object)image.getGuid());
        return (Contactimage)this.contactImageDao.save((Object)image);
    }

    private Contactimage setContactContentImageByType1(String tempFileGuid, ContactImageType imageType, Contact contact) throws IOException {
        LOG.debug("[setContactContentImage] tempFileGuid: {}", (Object)tempFileGuid);
        if (StringUtil.IsStringNullorEmpty((String)tempFileGuid)) {
            return null;
        }
        Path tempFullyFilePath = this.temporaryPathManager.createNewOne(tempFileGuid, "OOOXXX", false);
        Path tempFolderPath = tempFullyFilePath.getParent();
        File[] tempFiles = tempFolderPath.toFile().listFiles();
        if (tempFiles == null) {
            return null;
        }
        List<File> tempFileList = Arrays.asList(tempFiles);
        if (CollectionUtils.isEmpty(tempFileList)) {
            return null;
        }
        tempFullyFilePath = tempFileList.get(0).toPath();
        LOG.debug("[setContactContentImage] tempFullyFilePath: {}", (Object)tempFullyFilePath);
        LOG.debug("[setContactContentImage] tempFullyFilePath.getFileName: {}", (Object)tempFullyFilePath.getFileName());
        Path imageFullyFilePath = this.cardPathManager.createNewOne(contact.getGuid(), tempFullyFilePath.getFileName().toString(), true);
        LOG.debug("[setContactContentImage] imageFullyFilePath: {}", (Object)imageFullyFilePath);
        Files.createDirectories(imageFullyFilePath.getParent(), new FileAttribute[0]);
        Files.move(tempFullyFilePath, imageFullyFilePath, StandardCopyOption.REPLACE_EXISTING);
        Optional<String[]> fileListOptional = Optional.ofNullable(tempFolderPath.toFile().list());
        if (fileListOptional.isPresent() && fileListOptional.get().length == 0) {
            LOG.debug("[setContactContentImage] delete imageFolder: {}", (Object)tempFolderPath);
            Files.deleteIfExists(tempFolderPath);
        }
        String imageFilePath = this.cardPathManager.getRelativePath(imageFullyFilePath);
        Contactimage image = new Contactimage();
        image.setGuid(UUIDGenerator.getRandomUUID());
        image.setImageType(imageType);
        image.setFilepath(imageFilePath);
        try (InputStream iStream = Files.newInputStream(imageFullyFilePath, new OpenOption[0]);){
            image.setSha1(DigestUtils.sha1Hex((InputStream)iStream));
        }
        byte[] content = Files.readAllBytes(imageFullyFilePath);
        image.setContact(contact);
        contact.getContactimages().add(image);
        ContactimageActionLog actionLog = new ContactimageActionLog(contact.getGuid(), imageType);
        actionLog.setFilePath(imageFilePath);
        actionLog.setActionType(ActionType.AT_ADD);
        actionLog.setActionTime(new DateTime());
        this.contactImageActionLogDao.save((Object)actionLog);
        LOG.debug("[setContactContentImage] Before contactImageDao.save() {}", (Object)image.getGuid());
        return (Contactimage)this.contactImageDao.save((Object)image);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String createContactImage(byte[] imageContent) {
        LOG.debug("createContactImage 1");
        Contactimagewithcontent image = new Contactimagewithcontent();
        LOG.debug("createContactImage 2");
        image.setGuid(UUIDGenerator.getRandomUUID());
        image.setSha1(DigestUtils.sha1Hex((byte[])imageContent));
        image.setContentData(imageContent);
        LOG.debug("createContactImage 3");
        this.contactImageContentDao.save((Object)image);
        LOG.debug("createContactImage 4");
        return image.getGuid();
    }

    private List<Contactname> generateContactNamesAndSaveToDB(List<ContactnameInfo> nameInfos, Contact contact) {
        List<Object> names = new ArrayList<Contactname>();
        if (CollectionUtils.isEmpty(nameInfos)) {
            return names;
        }
        names = nameInfos.stream().map(info -> {
            Contactname name = info.newContactname();
            name.setContact(contact);
            return name;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactname contactname : names) {
            contactname.setFieldOrder(Integer.valueOf(fieldOrder++));
        }
        return this.contactNameDao.save(names);
    }

    private List<Contactaddress> generateContactAddressesAndSaveToDB(List<ContactaddressInfo> addressInfos, Contact contact) {
        List<Object> addresses = new ArrayList<Contactaddress>();
        if (CollectionUtils.isEmpty(addressInfos)) {
            return addresses;
        }
        addresses = addressInfos.stream().map(info -> {
            Contactaddress address = info.newContactaddress();
            address.setContact(contact);
            return address;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactaddress contactaddress : addresses) {
            contactaddress.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactAddressDao.save(addresses);
    }

    private List<Contactdate> generateContactDatesAndSaveToDB(List<ContactdateInfo> dateInfos, Contact contact) {
        List<Object> dates = new ArrayList<Contactdate>();
        if (CollectionUtils.isEmpty(dateInfos)) {
            return dates;
        }
        dates = dateInfos.stream().map(info -> {
            Contactdate date = info.newConctactdate();
            date.setContact(contact);
            return date;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactdate contactdate : dates) {
            contactdate.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactDateDao.save(dates);
    }

    private List<Contactjobinfo> generateContactJobinfosAndSaveToDB(List<ContactjobinfoInfo> jobinfoInfos, Contact contact) {
        List<Object> jobinfos = new ArrayList<Contactjobinfo>();
        if (CollectionUtils.isEmpty(jobinfoInfos)) {
            return jobinfos;
        }
        jobinfos = jobinfoInfos.stream().map(info -> {
            Contactjobinfo jobinfo = info.newContactjobinfo();
            jobinfo.setContact(contact);
            return jobinfo;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactjobinfo contactjobinfo : jobinfos) {
            contactjobinfo.setFieldOrder(Integer.valueOf(fieldOrder++));
        }
        return this.contactJobinfoDao.save(jobinfos);
    }

    private List<Contactphone> generateContactPhonesAndSaveToDB(List<ContactphoneInfo> phoneInfos, Contact contact) {
        List<Object> phones = new ArrayList<Contactphone>();
        if (CollectionUtils.isEmpty(phoneInfos)) {
            return phones;
        }
        phones = phoneInfos.stream().map(info -> {
            Contactphone phone = info.newContactphone();
            phone.setContact(contact);
            return phone;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactphone contactphone : phones) {
            contactphone.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactPhoneDao.save(phones);
    }

    private List<Contactcustomdata> generateContactCustomdatasAndSaveToDB(List<ContactcustomdataInfo> customdatainfos, Contact contact) {
        List<Object> customdatas = new ArrayList<Contactcustomdata>();
        if (CollectionUtils.isEmpty(customdatainfos)) {
            return customdatas;
        }
        customdatas = customdatainfos.stream().map(info -> {
            String customFieldSettingGuid = info.getCustomfieldSettingGuid();
            Customfield fieldSetting = (Customfield)this.customFieldDao.findOne((Serializable)((Object)customFieldSettingGuid));
            CustomFieldContactAttribute fieldType = info.getFieldType();
            if (fieldType == null) {
                throw new RequestArgumentNotValidException("Input custom field type is null.");
            }
            if (fieldSetting != null && !fieldSetting.getCustomfieldcontactattribute().equals((Object)fieldType)) {
                throw new RequestArgumentNotValidException("Input custom field type is not the same with field setting.");
            }
            if (fieldType.equals((Object)CustomFieldContactAttribute.EMAIL) && info.getTextValue().length() > 128) {
                throw new RequestArgumentNotValidException(String.format("Custom email field is too long.(> %d)", 128));
            }
            if (fieldType.equals((Object)CustomFieldContactAttribute.URL) && info.getTextValue().length() > 128) {
                throw new RequestArgumentNotValidException(String.format("Custom URL field is too long.(> %d)", 128));
            }
            Contactcustomdata custom = info.newContactcustomdata();
            custom.setContact(contact);
            custom.setFieldsettingguid(customFieldSettingGuid);
            return custom;
        }).collect(Collectors.toList());
        return this.contactCustomDataDao.save(customdatas);
    }

    private List<Contactim> generateContactIMsAndSaveToDB(List<ContactIMInfo> imInfos, Contact contact) {
        List<Object> ims = new ArrayList<Contactim>();
        if (CollectionUtils.isEmpty(imInfos)) {
            return ims;
        }
        ims = imInfos.stream().map(info -> {
            Contactim im = info.newContactim();
            im.setContact(contact);
            return im;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactim contactim : ims) {
            contactim.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactIMDao.save(ims);
    }

    private List<Contactemail> generateContactEmailsAndSaveToDB(List<ContactemailInfo> emailInfos, Contact contact) {
        List<Object> emails = new ArrayList<Contactemail>();
        if (CollectionUtils.isEmpty(emailInfos)) {
            return emails;
        }
        emails = emailInfos.stream().map(info -> {
            Contactemail email = info.newContactemail();
            email.setContact(contact);
            return email;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactemail contactemail : emails) {
            contactemail.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactEmailDao.save(emails);
    }

    private List<Contacturl> generateContactUrlsAndSaveToDB(List<ContacturlInfo> urlInfos, Contact contact) {
        List<Object> urls = new ArrayList<Contacturl>();
        if (CollectionUtils.isEmpty(urlInfos)) {
            return urls;
        }
        urls = urlInfos.stream().map(info -> {
            Contacturl url = info.newContacturl();
            url.setContact(contact);
            return url;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contacturl contacturl : urls) {
            contacturl.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactUrlDao.save(urls);
    }

    private List<Contactsocial> generateContactSocialsAndSaveToDB(List<ContactsocialInfo> socialInfos, Contact contact) {
        List<Object> socials = new ArrayList<Contactsocial>();
        if (CollectionUtils.isEmpty(socialInfos)) {
            return socials;
        }
        socials = socialInfos.stream().map(info -> {
            Contactsocial social = info.newContactsocial();
            social.setContact(contact);
            return social;
        }).collect(Collectors.toList());
        int fieldOrder = 0;
        for (Contactsocial contactsocial : socials) {
            contactsocial.setFieldorder(Integer.valueOf(fieldOrder++));
        }
        return this.contactSocialDao.save(socials);
    }

    private String generateContactSearchContent(Contact newContact, StringBuilder noNeedSearchString) {
        List customs;
        List socials;
        List urls;
        List emails;
        List ims;
        List contactJobInfos;
        List contactphones;
        List contactAddresses;
        StringBuilder totalContent = new StringBuilder();
        List contactNames = newContact.getContactnames();
        LOG.debug("[generateContactSearchContent] contactNames: {}", (Object)contactNames);
        if (!CollectionUtil.collectionEmpty((Collection)contactNames)) {
            contactNames.stream().forEach(contactName -> {
                totalContent.append(contactName.getLastName()).append(" ");
                totalContent.append(contactName.getFirstName()).append(" ");
                totalContent.append(contactName.getLastName());
                totalContent.append(contactName.getFirstName());
                totalContent.append(contactName.getLastName());
                totalContent.append(contactName.getFirstNamePronunce()).append(" ");
                totalContent.append(contactName.getLastNamePronunce()).append(" ");
                totalContent.append(contactName.getMiddleName()).append(" ");
                totalContent.append(contactName.getPrefix()).append(" ");
                totalContent.append(contactName.getSuffix()).append(" ");
            });
        }
        if (!CollectionUtil.collectionEmpty((Collection)(contactAddresses = newContact.getContactaddresses()))) {
            contactAddresses.stream().forEach(contactaddress -> {
                totalContent.append(contactaddress.getCountryName()).append(" ");
                totalContent.append(contactaddress.getCountryCode()).append(" ");
                totalContent.append(contactaddress.getCity()).append(" ");
                totalContent.append(contactaddress.getStreet()).append(" ");
                totalContent.append(contactaddress.getZip()).append(" ");
                totalContent.append(contactaddress.getState()).append(" ");
                totalContent.append(contactaddress.GetFullAddress()).append(" ");
                noNeedSearchString.append(contactaddress.getAddressType().toString()).append(" ");
            });
        }
        if (!CollectionUtil.collectionEmpty((Collection)(contactphones = newContact.getContactphones()))) {
            contactphones.stream().forEach(contactphone -> {
                totalContent.append(contactphone.getPhoneValue()).append(" ");
                noNeedSearchString.append(contactphone.getPhoneType().toString()).append(" ");
            });
        }
        if (!CollectionUtil.collectionEmpty((Collection)(contactJobInfos = newContact.getContactjobinfos()))) {
            contactJobInfos.stream().forEach(contactjobinfo -> {
                totalContent.append(contactjobinfo.getCompanyName()).append(" ");
                totalContent.append(contactjobinfo.getConpanyPronunce()).append(" ");
                totalContent.append(contactjobinfo.getDepartment()).append(" ");
                totalContent.append(contactjobinfo.getJobTitle()).append(" ");
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(ims = newContact.getContactims()))) {
            ims.stream().forEach(f -> {
                totalContent.append(f.getImValue()).append(" ");
                noNeedSearchString.append(f.getImType().toString()).append(" ");
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(emails = newContact.getContactemails()))) {
            emails.stream().forEach(f -> {
                totalContent.append(f.getEmailValue()).append(" ");
                noNeedSearchString.append(f.getEmailType().toString()).append(" ");
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(urls = newContact.getContacturls()))) {
            urls.stream().forEach(f -> {
                totalContent.append(f.getUrlValue()).append(" ");
                noNeedSearchString.append(f.getUrlType().toString()).append(" ");
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(socials = newContact.getContactsocials()))) {
            socials.stream().forEach(f -> {
                totalContent.append(f.getSocialValue()).append(" ");
                noNeedSearchString.append(f.getSocialType().toString()).append(" ");
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(customs = newContact.getContactcustomdata()))) {
            customs.stream().forEach(f -> {
                if (f.getFieldtype().equals((Object)CustomFieldContactAttribute.PICKLIST)) {
                    String guid = f.getTextvalue();
                    PicklistContent content = (PicklistContent)this.picklistContentDao.findOne((Serializable)((Object)guid));
                    if (content != null) {
                        totalContent.append(content.getContent()).append(" ");
                    }
                } else {
                    ContactcustomdataInfo info = new ContactcustomdataInfo(f);
                    totalContent.append(info.getTextValue()).append(" ");
                }
            });
        }
        totalContent.append(newContact.getNote()).append(" ");
        totalContent.append(newContact.getUniformNumber()).append(" ");
        totalContent.append(newContact.getNickname()).append(" ");
        return totalContent.toString();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void removeContactsFromCategory(List<String> contactGuids, String categoryGuid, String categoryOwnerAccountGuid) {
        if (CollectionUtils.isEmpty(contactGuids)) {
            return;
        }
        List contacts = this.contactDao.findByGuidIn(contactGuids);
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        Account categoryOwner = this.accountDao.findOne(categoryOwnerAccountGuid);
        contacts.forEach(contact -> this.updateCategoriesOfContact(contact, Arrays.asList(category), categoryOwner, ListSetBehavior.REMOVE, null));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void toggleFavoriteContacts(List<String> contactGuids, String accountGuid, boolean toggleFavorite) {
        if (CollectionUtils.isEmpty(contactGuids)) {
            return;
        }
        List contacts = this.contactDao.findByGuidIn(contactGuids);
        if (CollectionUtils.isEmpty((Collection)contacts)) {
            return;
        }
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return;
        }
        Category favoriteCategory = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.FAVORITE);
        contacts.forEach(contact -> {
            List currentFavoriteCategories = this.getCategoriesOfContactByAccountAndType(contact, account, CategoryType.FAVORITE);
            if (toggleFavorite && currentFavoriteCategories.isEmpty()) {
                this.updateCategoriesOfContact(contact, Arrays.asList(favoriteCategory), account, ListSetBehavior.ADD, null);
            } else if (!toggleFavorite && !currentFavoriteCategories.isEmpty()) {
                this.updateCategoriesOfContact(contact, currentFavoriteCategories, account, ListSetBehavior.REMOVE, null);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateCategoriesOfContact(String contactGuid, List<String> categoryGuids, String contactReceiverAccountGuid, ListSetBehavior behavior, DateTime passedTime) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return;
        }
        Account contactReceiver = this.accountDao.findOne(contactReceiverAccountGuid);
        if (contactReceiver == null) {
            return;
        }
        List categories = CollectionUtils.isEmpty(categoryGuids) ? new ArrayList() : this.categoryDao.findByGuidList(categoryGuids);
        this.updateCategoriesOfContact(contact, categories, contactReceiver, behavior, passedTime);
    }

    private List<Category> getCategoriesOfContactByAccountAndType(Contact contact, Account account, CategoryType type) {
        if (contact == null || contact.getCategoriesOwnMe() == null) {
            return new ArrayList<Category>();
        }
        List<Category> categories = contact.getCategoriesOwnMe().stream().filter(cate -> cate.getCategoryType().equals((Object)type) && cate.getOwneraccount().equals((Object)account)).collect(Collectors.toList());
        return categories;
    }

    public ContactStatusForAccountDto getContactStatusForAccount(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return null;
        }
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return null;
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            return null;
        }
        return new ContactStatusForAccountDto(status);
    }

    public void verifyContactGuid(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact guid is not found.");
        }
        if (contact.getIsDeleted().booleanValue()) {
            throw new ItemNotFoundException("Contact is marked as deleted.");
        }
    }

    public void verifyContactGuids(List<String> contactGuids) {
        if (contactGuids == null) {
            throw new ItemNotFoundException("Input contact GUIDs is null.");
        }
        if (contactGuids.isEmpty()) {
            throw new ItemNotFoundException("Input contact GUIDs list is empty.");
        }
        List distinctContactGuids = contactGuids.stream().distinct().collect(Collectors.toList());
        List contacts = this.contactDao.findByGuidIn(distinctContactGuids);
        if (contacts.size() != distinctContactGuids.size()) {
            throw new ItemNotFoundException("Some contact guids can not be found.");
        }
    }

    public void verifyContactGuidsOfCategory(List<String> contactGuids, String categoryGuid) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        List contactGuidsOfCategory = category.getContacts().stream().map(contact -> contact.getGuid()).collect(Collectors.toList());
        if (!contactGuidsOfCategory.containsAll(contactGuids)) {
            throw new RequestArgumentNotValidException("Some contacts are not belonging to specified category.");
        }
    }

    public String getOwnerGuidByContact(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            LOG.error("Contact is not found. ({})", (Object)contactGuid);
            throw new ItemNotFoundException("Contact is not found.");
        }
        Account owner = contact.getOwnerAccount();
        return owner.getGuid();
    }

    public Long getContactNumOwnedByAccount(String accountGuid, IntervalFilter intervalFilter) {
        Account ownerAccount = this.accountDao.findOne(accountGuid);
        if (ownerAccount == null) {
            return 0L;
        }
        LOG.debug("getContactNumOwnedByAccount ownerAccount={}, intervalFilter ={}", (Object)ownerAccount, (Object)intervalFilter);
        return this.contactDao.countByOwneraccountAndIsdeleted(ownerAccount.getGuid(), Boolean.valueOf(false), intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
    }

    public Contact getFirstContactOwnedByAccount(String accountGuid) {
        return this.contactDao.findFirstByIsdeletedAndOwneraccountGuid(false, accountGuid);
    }

    public Long getcontactNumUncorrectedByAccount(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return 0L;
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        if (categoryAll == null) {
            return 0L;
        }
        return this.contactDao.countUncorrectedByCategory(categoryAll.getGuid());
    }

    public Long getContactNumAllInPrivateByAccount(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return 0L;
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        if (categoryAll == null) {
            return 0L;
        }
        return this.contactDao.countByCategory(categoryAll.getGuid());
    }

    public Long getContactNumByCategory(String categoryGuid) {
        Long contactNum = this.contactDao.countByCategoryByNativeQuery(categoryGuid);
        return contactNum;
    }

    public Long getContactNumByCategoryAndContactOwner(String categoryGuid, String contactOwnerGuid) {
        Long contactNum = this.contactDao.countByCategoryAndOwner(categoryGuid, contactOwnerGuid);
        return contactNum;
    }

    public Long getContactNumByCategoryAndContactOwnerAndAccountCanView(String categoryGuid, String contactOwnerGuid, String canViewAccountGuid) {
        Long contactNum = this.contactDao.countByCategoryAndOwnerAndAccountCanView(categoryGuid, contactOwnerGuid, canViewAccountGuid);
        return contactNum;
    }

    public Long getContactNumUncategoryByContactOwner(String contactOwnerGuid) {
        Account contactOwner = this.accountDao.findOne(contactOwnerGuid);
        if (contactOwner == null) {
            return 0L;
        }
        Category allCategory = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactOwner, CategoryType.ALL);
        Long contactNum = this.contactDao.countUncategoryByOwner(contactOwnerGuid, allCategory.getGuid());
        return contactNum;
    }

    public Long getContactNumUncategoryByContactOwnerAndAccountCanView(String contactOwnerGuid, String canViewAccountGuid) {
        Account contactOwner = this.accountDao.findOne(contactOwnerGuid);
        if (contactOwner == null) {
            return 0L;
        }
        Category allCategory = this.categoryDao.findFirstByOwneraccountAndCategorytype(contactOwner, CategoryType.ALL);
        Long contactNum = this.contactDao.countUncategoryByOwnerAndAccountCanView(contactOwnerGuid, allCategory.getGuid(), canViewAccountGuid);
        return contactNum;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setContactToNewOwner(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[setContactToNewOwner]Contact is not found.");
        }
        Account newOwner = this.accountDao.findOne(accountGuid);
        if (newOwner == null) {
            throw new ItemNotFoundException("[setContactToNewOwner]Account is not found.");
        }
        if (this.doesContactCountOwningReachLimit(accountGuid)) {
            throw new MaxCountExceededContactOwningException(WctSystemExceptionType.MAX_CONTACT_NUMBER_OWNING_REACHED.toString());
        }
        contact.setOwnerAccount(newOwner);
        contact.setModifytimeforsearch((double)new DateTime().getMillis());
        this.contactDao.save((Object)contact);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setContactToNewOwnerAndShareToOriginOwner(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact is not found.");
        }
        String originOwnerGuid = this.getOwnerGuidByContact(contactGuid);
        Account newOwner = this.accountDao.findOne(accountGuid);
        if (newOwner == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        if (this.doesContactCountOwningReachLimit(accountGuid)) {
            throw new MaxCountExceededContactOwningException(WctSystemExceptionType.MAX_CONTACT_NUMBER_OWNING_REACHED.toString());
        }
        contact.setOwnerAccount(newOwner);
        contact.setModifytimeforsearch((double)new DateTime().getMillis());
        this.contactDao.save((Object)contact);
        LOG.debug("[Ralph Debug modify time] setContactToNewOwnerAndShareToOriginOwner,contactGuid: {}", (Object)contactGuid);
        this.contactPublicService.shareContactToAccounts(contactGuid, Arrays.asList(originOwnerGuid), ListSetBehavior.ADD, null);
    }

    public List<ContactSimpleInfoDuplicate> getContactSimpleInfoDuplicates(List<String> contactGuids) {
        if (CollectionUtils.isEmpty(contactGuids)) {
            return new ArrayList<ContactSimpleInfoDuplicate>();
        }
        List contactsimpleinfos = this.contactSimpleInfoDao.findByContactGuids(contactGuids);
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        List<ContactSimpleInfoDuplicate> contactSimpleInfoDtos = contactsimpleinfos.stream().map(s -> new ContactSimpleInfoDuplicate(s, nameDisplayOrderSettingType, s.getContact())).collect(Collectors.toList());
        return contactSimpleInfoDtos;
    }

    public List<List<ContactSimpleInfoDuplicate>> getDuplicateContacts(String accountGuid) {
        ArrayList<List<ContactSimpleInfoDuplicate>> dupContacts = new ArrayList<List<ContactSimpleInfoDuplicate>>();
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return dupContacts;
        }
        Category categoryAll = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        if (categoryAll == null) {
            return dupContacts;
        }
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        List contacts = this.contactDao.findByCategory(categoryAll.getGuid());
        ArrayList needscannedContacts = new ArrayList(contacts);
        for (int i = 0; i < contacts.size(); ++i) {
            List contactsimpleinfos;
            Contact contact = (Contact)contacts.get(i);
            needscannedContacts.remove(contact);
            if (needscannedContacts.isEmpty()) break;
            List dup = this.getDuplicateContacts(contact, needscannedContacts);
            if (dup.isEmpty()) continue;
            List dupGroup = dup.stream().map(c -> c.getGuid()).collect(Collectors.toList());
            List someoneList = null;
            for (List list : dupContacts) {
                if (!list.stream().anyMatch(c -> contact.getGuid().equals(c.getContactGuid()))) continue;
                someoneList = list;
                break;
            }
            if (someoneList == null) {
                dupGroup.add(contact.getGuid());
                contactsimpleinfos = this.contactSimpleInfoDao.findByContactGuids(dupGroup);
                List list = contactsimpleinfos.stream().map(s -> new ContactSimpleInfoDuplicate(s, nameDisplayOrderSettingType, s.getContact())).collect(Collectors.toList());
                dupContacts.add(list);
            } else {
                contactsimpleinfos = this.contactSimpleInfoDao.findByContactGuids(dupGroup);
                List list = contactsimpleinfos.stream().map(s -> new ContactSimpleInfoDuplicate(s, nameDisplayOrderSettingType, s.getContact())).collect(Collectors.toList());
                someoneList.addAll(list);
            }
            needscannedContacts.removeAll(dup);
        }
        return dupContacts;
    }

    private List<Contact> getDuplicateContacts(Contact contact, List<Contact> needscannedContacts) {
        String fullContactText = this.convertContactfulltext(contact);
        LOG.debug("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        LOG.debug("fullContactText: {}", (Object)fullContactText);
        ArrayList<Contact> dupContacts = new ArrayList<Contact>();
        for (Contact contact2 : needscannedContacts) {
            if (!this.isContactDuplicatedStep1(contact, fullContactText, contact2)) continue;
            dupContacts.add(contact2);
        }
        return dupContacts;
    }

    private String convertContactname(Contactname name) {
        return "!" + name.getFirstName() + name.getLastName();
    }

    private String convertContactcompany(Contactjobinfo jobinfo) {
        return "^" + jobinfo.getCompanyName();
    }

    private String convertContactemail(Contactemail email) {
        return "#" + email.getEmailValue();
    }

    private String convertContactfulltext(Contact contact) {
        String fullContactText = "";
        if (!CollectionUtils.isEmpty((Collection)contact.getContactnames())) {
            for (Contactname name : contact.getContactnames()) {
                fullContactText = fullContactText + this.convertContactname(name);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
            for (Contactjobinfo jobinfo : contact.getContactjobinfos()) {
                fullContactText = fullContactText + this.convertContactcompany(jobinfo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactemails())) {
            for (Contactemail email : contact.getContactemails()) {
                fullContactText = fullContactText + this.convertContactemail(email);
            }
        }
        return fullContactText;
    }

    private boolean confirmEqualName(Contact c1, Contact c2) {
        List name1 = c1.getContactnames();
        List name2 = c2.getContactnames();
        if (CollectionUtils.isEmpty((Collection)name1) || CollectionUtils.isEmpty((Collection)name2)) {
            return false;
        }
        for (Contactname n1 : name1) {
            String n1String = this.convertContactname(n1);
            for (Contactname n2 : name2) {
                if (!n1String.equals(this.convertContactname(n2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean confirmEqualCompany(Contact c1, Contact c2) {
        List job1 = c1.getContactjobinfos();
        List job2 = c2.getContactjobinfos();
        if (CollectionUtils.isEmpty((Collection)job1) || CollectionUtils.isEmpty((Collection)job2)) {
            return false;
        }
        for (Contactjobinfo j1 : job1) {
            String j1String = this.convertContactcompany(j1);
            for (Contactjobinfo j2 : job2) {
                if (!j1String.equals(this.convertContactcompany(j2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean confirmEqualEmail(Contact c1, Contact c2) {
        List email1 = c1.getContactemails();
        List email2 = c2.getContactemails();
        if (CollectionUtils.isEmpty((Collection)email1) || CollectionUtils.isEmpty((Collection)email2)) {
            return false;
        }
        for (Contactemail e1 : email1) {
            String e1String = this.convertContactemail(e1);
            for (Contactemail e2 : email2) {
                if (!e1String.equals(this.convertContactemail(e2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isContactDuplicatedStep2(Contact contact1, String fullContactText, Contact contact2) {
        if (!CollectionUtils.isEmpty((Collection)contact2.getContactjobinfos())) {
            boolean companyEqual = contact2.getContactjobinfos().stream().anyMatch(j -> fullContactText.contains(this.convertContactcompany(j)));
            LOG.debug("contact2's jobs: **************************************");
            contact2.getContactjobinfos().forEach(n -> LOG.debug("{}", (Object)this.convertContactcompany(n)));
            if (companyEqual && this.confirmEqualCompany(contact1, contact2)) {
                return true;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)contact2.getContactemails())) {
            boolean emailEqual = contact2.getContactemails().stream().anyMatch(e -> fullContactText.contains(this.convertContactemail(e)));
            LOG.debug("contact2's emails: ********************************************");
            contact2.getContactemails().forEach(n -> LOG.debug("{}", (Object)this.convertContactemail(n)));
            if (emailEqual && this.confirmEqualEmail(contact1, contact2)) {
                return true;
            }
        }
        return false;
    }

    private boolean isContactDuplicatedStep1(Contact contact1, String fullContactText, Contact contact2) {
        if (CollectionUtils.isEmpty((Collection)contact2.getContactnames())) {
            if (!CollectionUtils.isEmpty((Collection)contact1.getContactnames())) {
                return false;
            }
            return this.isContactDuplicatedStep2(contact1, fullContactText, contact2);
        }
        if (CollectionUtils.isEmpty((Collection)contact1.getContactnames())) {
            return false;
        }
        boolean nameEqual = contact2.getContactnames().stream().anyMatch(n -> fullContactText.contains(this.convertContactname(n)));
        LOG.debug("contact2's names: *************************************");
        contact2.getContactnames().forEach(n -> LOG.debug("{}", (Object)this.convertContactname(n)));
        if (!nameEqual || !this.confirmEqualName(contact1, contact2)) {
            return false;
        }
        return this.isContactDuplicatedStep2(contact1, fullContactText, contact2);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ContactUpdateVo mergeContacts(List<String> contactGuids, String mergedContactGuid) {
        int j;
        ContactUpdateVo result = new ContactUpdateVo();
        result.setContactGuid(mergedContactGuid);
        ArrayList contactnames = new ArrayList();
        ArrayList contactjobinfos = new ArrayList();
        ArrayList contactaddresses = new ArrayList();
        ArrayList contactphones = new ArrayList();
        ArrayList contacturls = new ArrayList();
        ArrayList contactemails = new ArrayList();
        ArrayList contactims = new ArrayList();
        ArrayList contactsocials = new ArrayList();
        ArrayList contactdates = new ArrayList();
        List<Object> birthdays = new ArrayList<DateTime>();
        List<Object> uniformNumbers = new ArrayList<String>();
        List<Object> nicknames = new ArrayList<String>();
        List<Object> notes = new ArrayList<String>();
        List contacts = this.contactDao.findByGuidIn(contactGuids);
        for (Contact contact : contacts) {
            if (!CollectionUtils.isEmpty((Collection)contact.getContactnames())) {
                contactnames.addAll(contact.getContactnames());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
                contactjobinfos.addAll(contact.getContactjobinfos());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactaddresses())) {
                contactaddresses.addAll(contact.getContactaddresses());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactphones())) {
                contactphones.addAll(contact.getContactphones());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContacturls())) {
                contacturls.addAll(contact.getContacturls());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactemails())) {
                contactemails.addAll(contact.getContactemails());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactims())) {
                contactims.addAll(contact.getContactims());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactsocials())) {
                contactsocials.addAll(contact.getContactsocials());
            }
            if (!CollectionUtils.isEmpty((Collection)contact.getContactdates())) {
                contactdates.addAll(contact.getContactdates());
            }
            if (contact.getBirthday() != null) {
                birthdays.add(contact.getBirthday());
            }
            if (contact.getUniformNumber() != null) {
                uniformNumbers.add(contact.getUniformNumber());
            }
            if (contact.getNickname() != null) {
                nicknames.add(contact.getNickname());
            }
            if (contact.getNote() == null) continue;
            notes.add(contact.getNote());
        }
        List<ContactnameInfo> names = contactnames.stream().distinct().map(i -> new ContactnameInfo(i)).collect(Collectors.toList());
        names.forEach(i -> i.setGuid(null));
        List<ContactjobinfoInfo> jobs = contactjobinfos.stream().distinct().map(i -> new ContactjobinfoInfo(i)).collect(Collectors.toList());
        jobs.forEach(i -> i.setGuid(null));
        List<ContactaddressInfo> addresses = contactaddresses.stream().distinct().map(i -> new ContactaddressInfo(i)).collect(Collectors.toList());
        addresses.forEach(i -> i.setGuid(null));
        List<ContactphoneInfo> phones = contactphones.stream().distinct().map(i -> new ContactphoneInfo(i)).collect(Collectors.toList());
        phones.forEach(i -> i.setGuid(null));
        List<ContacturlInfo> urls = contacturls.stream().distinct().map(i -> new ContacturlInfo(i)).collect(Collectors.toList());
        urls.forEach(i -> i.setGuid(null));
        List<ContactemailInfo> emails = contactemails.stream().distinct().map(i -> new ContactemailInfo(i)).collect(Collectors.toList());
        emails.forEach(i -> i.setGuid(null));
        List<ContactIMInfo> ims = contactims.stream().distinct().map(i -> new ContactIMInfo(i)).collect(Collectors.toList());
        ims.forEach(i -> i.setGuid(null));
        List<ContactsocialInfo> socials = contactsocials.stream().distinct().map(i -> new ContactsocialInfo(i)).collect(Collectors.toList());
        socials.forEach(i -> i.setGuid(null));
        List<ContactdateInfo> dates = contactdates.stream().distinct().map(i -> new ContactdateInfo(i)).collect(Collectors.toList());
        dates.forEach(i -> i.setGuid(null));
        birthdays = birthdays.stream().distinct().collect(Collectors.toList());
        uniformNumbers = uniformNumbers.stream().distinct().filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        nicknames = nicknames.stream().distinct().filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        notes = notes.stream().distinct().filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        result.setNames(names);
        result.setJobinfos(jobs);
        result.setAddresses(addresses);
        result.setPhones(phones);
        result.setUrls(urls);
        result.setEmails(emails);
        result.setIMs(ims);
        result.setSocials(socials);
        result.setDates(dates);
        StringBuilder mergedNote = new StringBuilder();
        if (!CollectionUtils.isEmpty(notes)) {
            mergedNote.append((String)notes.get(0));
            if (notes.size() > 1) {
                for (j = 1; j < notes.size(); ++j) {
                    mergedNote.append("\n\n");
                    mergedNote.append((String)notes.get(j));
                }
            }
        }
        if (!CollectionUtils.isEmpty(birthdays)) {
            result.setBirthday((DateTime)birthdays.get(0));
            if (birthdays.size() > 1) {
                mergedNote.append("\n\n");
                mergedNote.append("BIRTHDAY:");
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
                for (int j2 = 1; j2 < birthdays.size(); ++j2) {
                    mergedNote.append("\n");
                    mergedNote.append(fmt.print((ReadableInstant)birthdays.get(j2)));
                }
            }
        }
        if (!CollectionUtils.isEmpty(uniformNumbers)) {
            result.setUniformNumber((String)uniformNumbers.get(0));
            if (uniformNumbers.size() > 1) {
                mergedNote.append("\n\n");
                mergedNote.append("UNIFORM NUMBER:");
                for (j = 1; j < uniformNumbers.size(); ++j) {
                    mergedNote.append("\n");
                    mergedNote.append((String)uniformNumbers.get(j));
                }
            }
        }
        if (!CollectionUtils.isEmpty(nicknames)) {
            result.setNickname((String)nicknames.get(0));
            if (nicknames.size() > 1) {
                mergedNote.append("\n\n");
                mergedNote.append("NICKNAME:");
                for (int i2 = 1; i2 < nicknames.size(); ++i2) {
                    mergedNote.append("\n");
                    mergedNote.append((String)nicknames.get(i2));
                }
            }
        }
        result.setNote(mergedNote.toString());
        result.setBeCorrected(Boolean.valueOf(false));
        ArrayList updateComponents = Lists.newArrayList();
        updateComponents.add(UpdateComponent.UC_CONTENT);
        result.setUpdateComponents(updateComponents.toArray(new UpdateComponent[updateComponents.size()]));
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)mergedContactGuid));
        List contactimages = contact.getContactimages();
        boolean bNeedFrontImage = true;
        boolean bNeedRearImage = true;
        boolean bNeedLogoImage = true;
        if (contactimages.stream().anyMatch(i -> ContactImageType.FRONT.equals((Object)i.getImageType()))) {
            bNeedFrontImage = false;
        }
        if (contactimages.stream().anyMatch(i -> ContactImageType.REAR.equals((Object)i.getImageType()))) {
            bNeedRearImage = false;
        }
        if (contactimages.stream().anyMatch(i -> ContactImageType.LOGO.equals((Object)i.getImageType()))) {
            bNeedLogoImage = false;
        }
        if (!(bNeedFrontImage || bNeedRearImage || bNeedLogoImage)) {
            return result;
        }
        Comparator timeComparator = (o1, o2) -> o1.getModifyTime().compareTo((ReadableInstant)o2.getModifyTime());
        contacts.sort(timeComparator.reversed());
        for (int j3 = 0; j3 < contacts.size(); ++j3) {
            Contact c = (Contact)contacts.get(j3);
            List images = c.getContactimages();
            if (bNeedFrontImage && images.stream().anyMatch(i -> ContactImageType.FRONT.equals((Object)i.getImageType()))) {
                bNeedFrontImage = false;
                result.setFrontImageFileGuid(this.saveContactImageToTempFolder(c.getGuid(), ContactImageType.FRONT));
                updateComponents.add(UpdateComponent.UC_FRONT_IMAGE);
            }
            if (bNeedRearImage && images.stream().anyMatch(i -> ContactImageType.REAR.equals((Object)i.getImageType()))) {
                bNeedRearImage = false;
                result.setRearImageFileGuid(this.saveContactImageToTempFolder(c.getGuid(), ContactImageType.REAR));
                updateComponents.add(UpdateComponent.UC_BACK_IMAGE);
            }
            if (!bNeedLogoImage || !images.stream().anyMatch(i -> ContactImageType.LOGO.equals((Object)i.getImageType()))) continue;
            bNeedLogoImage = false;
            result.setLogoImageFileGuid(this.saveContactImageToTempFolder(c.getGuid(), ContactImageType.LOGO));
            updateComponents.add(UpdateComponent.UC_LOGO);
        }
        result.setUpdateComponents(updateComponents.toArray(new UpdateComponent[updateComponents.size()]));
        return result;
    }

    private String saveContactImageToTempFolder(String contactGuid, ContactImageType imageType) {
        String tempFileGuid = "";
        return tempFileGuid;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String saveFileToTempFolder(String tempFilename, InputStream inStream) throws IOException {
        String tempFileGuid = UUIDGenerator.getRandomUUID();
        boolean autoRename = false;
        if (StringUtils.isBlank((CharSequence)tempFilename)) {
            tempFilename = UUIDGenerator.getRandomUUID();
        }
        Path tempFilePath = this.temporaryPathManager.createNewOne(tempFileGuid, tempFilename, autoRename);
        Files.createDirectories(tempFilePath.getParent(), new FileAttribute[0]);
        try (OutputStream outStream = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE);){
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        }
        LOG.debug("tempFilePath.toString():{}", (Object)tempFilePath.toString());
        return tempFileGuid;
    }

    public List<String> getAccountsHaveThisContactInPrivate(String contactGuid) {
        List statuses = this.contactStatusForAccountDao.findByContactGuid(contactGuid);
        List<String> accountGuids = statuses.stream().filter(s -> s.getIsdeletedfromaccount() == false).map(s -> s.getAccount().getGuid()).collect(Collectors.toList());
        return accountGuids;
    }

    public Long getContactNumByAll(String companyGuid) {
        return this.contactDao.countByIsdeletedwithCompany(Boolean.valueOf(false), companyGuid);
    }

    public Contact getLastModifyContact(String companyGuid) {
        Sort sortnew = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "modifytime")});
        PageRequest newpageRequest = new PageRequest(0, 1, sortnew);
        List contacts = this.contactDao.getLastContactByCompanyGuid(companyGuid, (Pageable)newpageRequest).getContent();
        if (contacts.size() > 0) {
            return (Contact)contacts.get(0);
        }
        return null;
    }

    public List<GuidWithData<Boolean>> areContactsInAccountFavorite(String accountGuid, List<String> contactGuids) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("account not found");
        }
        List favContactGuids = this.contactDao.findGuidByCategorytypeOfAccount(account, CategoryType.FAVORITE);
        ArrayList<String> notInFavGuids = new ArrayList<String>(contactGuids);
        ArrayList<String> inFavGuids = new ArrayList<String>(contactGuids);
        inFavGuids.retainAll(favContactGuids);
        notInFavGuids.removeAll(inFavGuids);
        List<GuidWithData<Boolean>> result = inFavGuids.stream().map(c -> new GuidWithData(c, (Object)true)).collect(Collectors.toList());
        List result1 = notInFavGuids.stream().map(c -> new GuidWithData(c, (Object)false)).collect(Collectors.toList());
        result.addAll(result1);
        return result;
    }

    public List<String> getContactGuidsOwnedByAccount(String accountGuid) {
        List contactGuids = this.contactDao.findGuidOwnedByAccount(accountGuid);
        return contactGuids;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void moveContactWithCategoriesOfAccountToAccount(String contactGuid, String accountGuid, String receiverAccountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[moveContactWithCategoriesOfAccountToAccount]Contact is not found.");
        }
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[moveContactWithCategoriesOfAccountToAccount]Origin account is not found.");
        }
        Account receiverAccount = this.accountDao.findOne(receiverAccountGuid);
        if (receiverAccount == null) {
            throw new ItemNotFoundException("[moveContactWithCategoriesOfAccountToAccount]Receiver account is not found.");
        }
        List originalCategories = this.categoryDao.findByOwnerAndContactGuid(account, contactGuid).stream().filter(c -> !CategoryType.ALL.equals((Object)c.getCategoryType()) && !CategoryType.FAVORITE.equals((Object)c.getCategoryType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(originalCategories)) {
            throw new RequestArgumentNotValidException("There is no belonging category of account for contact, the contact is not in private of account.");
        }
        String accountName = account.getDisplayName();
        ArrayList<String> targetCategoryGuids = new ArrayList<String>();
        for (Category category : originalCategories) {
            String inheriteCateGuid = category.getInheritecategoryguid();
            Category inheriteCategory = null;
            if (!StringUtils.isEmpty((CharSequence)inheriteCateGuid) && (inheriteCategory = (Category)this.categoryDao.findOne((Serializable)((Object)inheriteCateGuid))) != null && !inheriteCategory.getOwneraccount().getGuid().equals(receiverAccountGuid)) {
                throw new RequestArgumentNotValidException("The contacts receiver is not previous account.");
            }
            if (inheriteCategory == null) {
                String categoryName = category.getCategoryType().equals((Object)CategoryType.OTHER) ? String.format("Other contacts(%s)", accountName) : String.format("%s(%s)", category.getName(), accountName);
                CategoryInfo newCateInfo = this.categoryService.createCategory(categoryName, receiverAccountGuid, null, false);
                category.setInheritecategoryguid(newCateInfo.getGuid());
                targetCategoryGuids.add(newCateInfo.getGuid());
                continue;
            }
            targetCategoryGuids.add(inheriteCategory.getGuid());
        }
        this.categoryDao.save(originalCategories);
        List targetCategories = this.categoryDao.findByGuidList(targetCategoryGuids);
        this.updateCategoriesOfContact(contact, targetCategories, receiverAccount, ListSetBehavior.ADD, null);
        this.updateCategoriesOfContact(contact, new ArrayList(), account, ListSetBehavior.REMOVE_ALL, null);
    }

    private long getSettingMaxContactCountInPrivate() {
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE");
        long maxCount = Long.parseLong(globalInfo.getConfigValue());
        return maxCount;
    }

    public boolean doesContactCountInPrivateReachLimit(String accountGuid) {
        long maxCount;
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        int contactCount = account.getContactcountinprivate();
        return (long)contactCount >= (maxCount = this.getSettingMaxContactCountInPrivate());
    }

    private boolean doesContactCountOwningReachLimit(String accountGuid) {
        Long contactCount = this.contactDao.countByOwneraccountAndIsdeleted(accountGuid, Boolean.valueOf(false), GlobalUtils.getEarliestTime(), new DateTime());
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE");
        long maxCount = (long)((float)Long.parseLong(globalInfo.getConfigValue()) * 1.2f);
        return contactCount >= maxCount;
    }

    private boolean doesContactCountInDbReachLimit(String companyGuid) {
        Long contactCount = this.contactDao.countByIsdeletedwithCompany(Boolean.valueOf(false), companyGuid);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[this.registryService.GetServerType().ordinal()]) {
            case 1: {
                SubscriptionPeriod lastSubscriptionPeriod;
                return this.subscriptionService.getLicenseMode(companyGuid) == LicenseMode.SUBSCRIPTION && (this.subscriptionService.getSubScriptionStatus(companyGuid) == SubscriptionStatus.TRIAL || this.subscriptionService.getSubScriptionStatus(companyGuid) == SubscriptionStatus.TRIAL_LEFT_2_WEEK) && (lastSubscriptionPeriod = this.subscriptionService.getSubscriptionInfo(companyGuid).GetLastPeriod()) != null && lastSubscriptionPeriod.getTimeRangeStart().plusDays(30).isBeforeNow() && contactCount >= 500L;
            }
            case 2: 
            case 3: {
                Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_DB");
                long maxCount = Long.parseLong(globalInfo.getConfigValue());
                return contactCount >= maxCount;
            }
        }
        return false;
    }

    public DateTime getContactModifyTimeByGuid(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found");
        }
        return contact.getModifyTime();
    }

    public List<ItemBasicVo> getBelongCategoriesByAccount(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return new ArrayList<ItemBasicVo>();
        }
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return new ArrayList<ItemBasicVo>();
        }
        List allCategories = contact.getCategoriesOwnMe();
        List myCurrentCategories = allCategories.stream().filter(c -> account.equals((Object)c.getOwneraccount())).collect(Collectors.toList());
        List<ItemBasicVo> result = myCurrentCategories.stream().map(c -> new ItemBasicVo(c.getGuid(), c.getName())).collect(Collectors.toList());
        return result;
    }

    public List<ContactimageActionLog> getContactImagesBetweenUpdateTimeAsc(DateTime beginTime, DateTime endTime) {
        List actionLogs = this.contactImageActionLogDao.findBetweenUpdateTimeAsc(beginTime, endTime);
        return actionLogs;
    }

    public List<ContactInfoForEs> getContactForEsByContactGuids(List<String> contactGuids) {
        List<ContactInfoForEs> contacts = this.contactDao.findByGuidIn(contactGuids).stream().map(c -> new ContactInfoForEs(c)).collect(Collectors.toList());
        return contacts;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean insertImageFileToDB(String contactImageGuid) throws IOException {
        Contactimagewithcontent image = (Contactimagewithcontent)this.contactImageContentDao.findOne((Serializable)((Object)contactImageGuid));
        if (image != null) {
            String contactImageRelativePath = image.getFilepath();
            if (StringUtil.IsStringNullorEmpty((String)image.getFilepath())) {
                return false;
            }
            Path originFullyFilePath = this.cardPathManager.getFullyPath(contactImageRelativePath);
            byte[] arrayByte = null;
            try (InputStream inputStream = Files.newInputStream(originFullyFilePath, new OpenOption[0]);){
                arrayByte = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Exception ex) {
                return false;
            }
            if (arrayByte != null) {
                image.setContentData(arrayByte);
                this.contactImageContentDao.save((Object)image);
            } else {
                return false;
            }
        }
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteContactImageFile(String contactImageGuid) {
        try {
            Contactimagewithcontent image = (Contactimagewithcontent)this.contactImageContentDao.findOne((Serializable)((Object)contactImageGuid));
            if (image != null) {
                String contactImageRelativePath = image.getFilepath();
                Path originFullyFilePath = this.cardPathManager.getFullyPath(contactImageRelativePath);
                Files.delete(originFullyFilePath);
                Files.delete(originFullyFilePath.getParent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void checkAndMarkContactImageContentToDeleted(String contactImageGuid) {
        Contactimagewithcontent image = (Contactimagewithcontent)this.contactImageContentDao.findOne((Serializable)((Object)contactImageGuid));
        if (image != null) {
            String contactImageRelativePath = image.getFilepath();
            boolean originFullyFilePathExist = false;
            if (image.getFilepath() != null) {
                Path originFullyFilePath = this.cardPathManager.getFullyPath(contactImageRelativePath);
                originFullyFilePathExist = Files.exists(originFullyFilePath, new LinkOption[0]);
                LOG.debug("originFullyFilePath: {}", (Object)originFullyFilePath);
                LOG.debug("originFullyFilePathExist: {}", (Object)originFullyFilePathExist);
            } else {
                LOG.debug("originFullyFilePath: null");
                LOG.debug("originFullyFilePathExist: {}", (Object)originFullyFilePathExist);
            }
            if (originFullyFilePathExist) {
                LOG.debug("Mark contactimagewithcontent[guid={}] is deleted to true", (Object)contactImageGuid);
                image.setIsdeleted(true);
                this.contactImageContentDao.save((Object)image);
            } else {
                Path rootPath = this.cardPathManager.getRootPath();
                boolean rootPathExist = Files.exists(rootPath, new LinkOption[0]);
                LOG.debug("Card rootPath: {}", (Object)rootPath);
                LOG.debug("RootPathExist: {}", (Object)rootPathExist);
                if (rootPathExist) {
                    LOG.debug("Mark contactimagewithcontent[guid={}] is deleted to true", (Object)contactImageGuid);
                    image.setIsdeleted(true);
                    this.contactImageContentDao.save((Object)image);
                } else {
                    LOG.error("Card root path not found...");
                    throw new ItemNotFoundException("Card root path not found");
                }
            }
        }
    }

    public List<ContactimageInfo> getImagesWithoutBinaryDataWithLimit(int limitNumber) {
        List images = this.contactImageContentDao.findByContentDataAndIsdeleted((Pageable)new PageRequest(0, limitNumber), null, false).getContent();
        List<ContactimageInfo> infos = images.stream().map(image -> new ContactimageInfo((Contactimagebasic)image)).collect(Collectors.toList());
        return infos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteContactImageData(String contactImageGuid) {
        this.contactImageContentDao.delete((Serializable)((Object)contactImageGuid));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void UpdateAllContactWithCompanyGuid(String companyGuid) {
        this.contactDao.updateContactWithCompanyGuid(companyGuid);
    }
}

