/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.dao.PostgreSqlSystemInfoDao;
import com.penpower.worldcard.team.dto.BackupScheduleInfo;
import com.penpower.worldcard.team.dto.BackupStoragInfos;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.notice.content.BackupFailedContent;
import com.penpower.worldcard.team.service.BackupInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import oshi.SystemInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

@Service
public class BackupInfoServiceImpl
implements BackupInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(BackupInfoServiceImpl.class);
    public static final String DEFAULT_NAS_USB_STORAGE_MOUNT_POINT_NAME_SUFFIX = "USB";
    @Autowired
    private PostgreSqlSystemInfoDao postgreSqlSystemInfoDao;
    @Autowired
    private GlobalInfoService globalInfoService;

    public List<BackupStoragInfos> getBackupStorageInfos() {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        FileSystem fs = os.getFileSystem();
        OSFileStore[] osFileStores = fs.getFileStores();
        LOG.debug("OS : {}", (Object)os.getFamily());
        LOG.debug("OS version : {}", (Object)os.getVersion());
        List<BackupStoragInfos> backupStoragInfos = Arrays.stream(osFileStores).filter(osFileStore -> osFileStore.getMount() != null).filter(osFileStore -> StringUtils.isNotBlank((CharSequence)osFileStore.getMount())).filter(osFileStore -> {
            String mountPath = osFileStore.getMount().toUpperCase();
            return mountPath.contains(DEFAULT_NAS_USB_STORAGE_MOUNT_POINT_NAME_SUFFIX);
        }).map(osFileStore -> {
            String mountPoint = osFileStore.getMount();
            Path mountPath = Paths.get(mountPoint, new String[0]);
            DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)mountPath);
            LOG.debug("mountPath : {}", (Object)mountPath);
            String storageName = "";
            storageName = mountPath.getFileName().toString();
            BackupStoragInfos backupStoragInfo = new BackupStoragInfos();
            backupStoragInfo.setStorageName(storageName);
            backupStoragInfo.setStoragePath(mountPoint);
            long totalSpace = diskInfos.getTotalSpaceBytes();
            long usableSpace = diskInfos.getUsableSpaceBytes();
            long usedSpace = totalSpace - usableSpace;
            backupStoragInfo.setFreeSpace(FileSystemUtil.convertToStringRepresentation((long)totalSpace));
            backupStoragInfo.setUsableSpace(FileSystemUtil.convertToStringRepresentation((long)usableSpace));
            backupStoragInfo.setUsedSpace(FileSystemUtil.convertToStringRepresentation((long)usedSpace));
            return backupStoragInfo;
        }).collect(Collectors.toList());
        return backupStoragInfos;
    }

    public String getCurrentPostgreSqlVersion() {
        return this.postgreSqlSystemInfoDao.getVersionString();
    }

    public DateTime getLastBackUpTime() {
        String lastBackupTimeLongValue = this.globalInfoService.getPropertiesStringByKey("LAST_BACKUP_TIME_LONG_STRING");
        if (StringUtils.isEmpty((CharSequence)lastBackupTimeLongValue)) {
            throw new ItemNotFoundException("No last backup time settings found.");
        }
        DateTime lastBackUpTime = new DateTime(Long.parseLong(lastBackupTimeLongValue));
        return lastBackUpTime;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setLastBackupTime(DateTime backupTime) {
        long backupTimeMillis = backupTime.getMillis();
        this.globalInfoService.createNewProperties("LAST_BACKUP_TIME_LONG_STRING", String.valueOf(backupTimeMillis));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void writeScheduleTmpInfo(BackupScheduleInfo backupScheduleInfo) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)backupScheduleInfo);
        this.globalInfoService.createNewProperties("BACKUP_SCHEDULE_TMP_INFO", json);
    }

    public BackupScheduleInfo readScheduleTmpInfo() {
        Gson gson = new Gson();
        String tmpJson = this.globalInfoService.getPropertiesStringByKey("BACKUP_SCHEDULE_TMP_INFO");
        if (tmpJson == null) {
            throw new ItemNotFoundException("There is no tmp backupjob json in database....");
        }
        BackupScheduleInfo backupScheduleInfo = (BackupScheduleInfo)gson.fromJson(tmpJson, BackupScheduleInfo.class);
        return backupScheduleInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteScheduleTmpInfo() {
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("BACKUP_SCHEDULE_TMP_INFO");
        if (globalInfo != null) {
            String guidToDelete = globalInfo.getGuid();
            this.globalInfoService.deleteProperty(guidToDelete);
        }
    }

    public BackupFailedContent getLastBackupErrorMessage() {
        Gson gson = new Gson();
        String tmpJson = this.globalInfoService.getPropertiesStringByKey("LAST_BACKUP_ERROR_MESSAGE");
        if (StringUtils.isNotBlank((CharSequence)tmpJson)) {
            return null;
        }
        BackupFailedContent backupFailedContent = (BackupFailedContent)gson.fromJson(tmpJson, BackupFailedContent.class);
        return backupFailedContent;
    }

    public void updateLastBackupErrorMessage(String errorMessage) {
        this.globalInfoService.createNewProperties("LAST_BACKUP_ERROR_MESSAGE", errorMessage);
    }
}

