/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.AccountShareTargetDao;
import com.penpower.worldcard.team.dao.AccountShareToAccountItemDao;
import com.penpower.worldcard.team.dto.AccountShareTargetDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.AccountShareToAccountItem;
import com.penpower.worldcard.team.entity.Accountsharetargetsetting;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.TempStoredDataType;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.web.api.vo.AccountShareTargetUpdateListVo;
import com.penpower.worldcard.team.web.api.vo.AccountShareTargetVo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountShareTargetServiceImpl
implements AccountShareTargetService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountShareTargetServiceImpl.class);
    @Autowired
    private AccountShareTargetDao accountShareTargetDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ScheduleManager scheduleManager;
    @Autowired
    private AccountShareToAccountItemDao accountShareToAccountItemDao;

    public List<AccountShareTargetDto> getAllShareTargets(String userGuid) {
        List accountShareTargets = this.accountShareTargetDao.findByAccountGuid(userGuid);
        LOG.debug("accountShareTargets : {} ", (Object)accountShareTargets);
        List accountShareTargetsDto = this.internalExtractDto(userGuid, accountShareTargets);
        return accountShareTargetsDto;
    }

    public List<AccountShareTargetDto> getShareTargetsByShareItem(String userGuid, ShareItem shareItem) {
        List accountShareTargets = this.accountShareTargetDao.findByAccountGuidAndShareItem(userGuid, shareItem);
        LOG.debug("accountShareTargets : {} ", (Object)accountShareTargets);
        List accountShareTargetsDto = this.internalExtractDto(userGuid, accountShareTargets);
        return accountShareTargetsDto;
    }

    private List<AccountShareTargetDto> internalExtractDto(String userGuid, List<Accountsharetargetsetting> accountShareTargets) {
        List subordinates = this.accountDao.findByBossGuid(userGuid);
        Account account = this.accountDao.findOne(userGuid);
        Account boss = account.getBoss();
        List<AccountShareTargetDto> accountShareTargetsDto = accountShareTargets.stream().map(accountShareTargetSetting -> {
            Account sharedTargetAccount = this.accountDao.findOne(accountShareTargetSetting.getSharedAccountGuid());
            LOG.debug("sharedTargetAccount :{}", (Object)sharedTargetAccount);
            if (sharedTargetAccount == null) {
                AccountShareTargetDto accountShareTargetDto = new AccountShareTargetDto(null, null, null, false, false);
                return accountShareTargetDto;
            }
            if (sharedTargetAccount.getAccountSubscriptionStatus() == AccountSubscriptionStatus.TEMPLATE_INVALIDATE) {
                AccountShareTargetDto accountShareTargetDto = new AccountShareTargetDto(null, null, null, false, false);
                return accountShareTargetDto;
            }
            boolean isBoss = this.checkIsBoss(boss, sharedTargetAccount);
            boolean isSubordinate = subordinates.contains(sharedTargetAccount);
            AccountShareTargetDto accountShareTargetDto = new AccountShareTargetDto(sharedTargetAccount.getGuid(), sharedTargetAccount.getDisplayName(), accountShareTargetSetting.getShareItem(), isBoss, isSubordinate);
            return accountShareTargetDto;
        }).filter(accountShareTargetDto -> accountShareTargetDto.getAccountGuid() != null).collect(Collectors.toList());
        return accountShareTargetsDto;
    }

    private Account getBossWithoutResignedStatus(Account account) {
        if (account != null && SecurityUtils.validUser((UserStatus)account.getStatus())) {
            return account;
        }
        return null;
    }

    private boolean checkIsBoss(Account boss, Account account) {
        if (boss == null) {
            return false;
        }
        return boss.getGuid().equals(account.getGuid());
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addNewShareTarget(String accountGuid, String shareAccountGuid, ShareItem shareItem) {
        Accountsharetargetsetting newShareTarget = new Accountsharetargetsetting();
        newShareTarget.setGuid(UUIDGenerator.getRandomUUID());
        newShareTarget.setShareItem(shareItem);
        String newShareAccountGuid = shareAccountGuid;
        Account sharedTargetAccount = this.accountDao.findOne(newShareAccountGuid);
        if (sharedTargetAccount == null) {
            throw new ItemNotFoundException(String.format("Failed to add new share target , account[guid=%s] not found.", newShareAccountGuid));
        }
        Accountsharetargetsetting shareTarget = this.accountShareTargetDao.findByAccountGuidAndSharedAccountGuidAndShareItem(accountGuid, shareAccountGuid, shareItem);
        if (shareTarget != null) {
            return;
        }
        newShareTarget.setSharedAccountGuid(newShareAccountGuid);
        Account currentLoginUser = this.accountDao.findOne(accountGuid);
        newShareTarget.setAccount(currentLoginUser);
        this.accountShareTargetDao.save((Object)newShareTarget);
    }

    public AccountShareTargetDto getShareTarget(String accountGuid, ShareItem shareItem) {
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        Accountsharetargetsetting accountsharetargetsetting = this.accountShareTargetDao.findByAccountGuidAndSharedAccountGuidAndShareItem(currentLoginUserGuid, accountGuid, shareItem);
        if (accountsharetargetsetting == null) {
            throw new ItemNotFoundException(String.format("Failed to get share target by guid %s", accountGuid));
        }
        List subordinates = this.accountDao.findByBossGuid(currentLoginUserGuid);
        Account account = this.accountDao.findOne(currentLoginUserGuid);
        Account boss = account.getBoss();
        Account sharedTargetAccount = this.accountDao.findOne(accountGuid);
        LOG.debug("boss  {} ", (Object)boss);
        boolean isBoss = this.checkIsBoss(boss, sharedTargetAccount);
        boolean isSubordinate = subordinates.contains(sharedTargetAccount);
        AccountShareTargetDto accountShareTargetDto = new AccountShareTargetDto(sharedTargetAccount.getGuid(), sharedTargetAccount.getDisplayName(), accountsharetargetsetting.getShareItem(), isBoss, isSubordinate);
        return accountShareTargetDto;
    }

    public boolean newShareTargetExists(String accountGuid, ShareItem shareItem) {
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        Accountsharetargetsetting accountsharetargetsetting = this.accountShareTargetDao.findByAccountGuidAndSharedAccountGuidAndShareItem(currentLoginUserGuid, accountGuid, shareItem);
        return accountsharetargetsetting != null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteShareTarget(String accountGuid, String shareAccountGuid, ShareItem shareItem) {
        Accountsharetargetsetting accountsharetargetsetting = this.accountShareTargetDao.findByAccountGuidAndSharedAccountGuidAndShareItem(accountGuid, shareAccountGuid, shareItem);
        if (accountsharetargetsetting == null) {
            return;
        }
        this.accountShareTargetDao.delete((Object)accountsharetargetsetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateAccountShareTargetList(String userGuid, AccountShareTargetUpdateListVo accountShareTargetUpdateListVo) {
        ShareItem shareItem = accountShareTargetUpdateListVo.getShareItem();
        List updateGuids = accountShareTargetUpdateListVo.getAccountGuids();
        LOG.debug("updateGuids : {}  , updateGuids size : {} ", (Object)updateGuids, (Object)updateGuids.size());
        List accountShareTargets = this.accountShareTargetDao.findByAccountGuidAndShareItem(userGuid, shareItem);
        LOG.debug("accountShareTargets : {} ", (Object)accountShareTargets);
        this.accountShareTargetDao.delete((Iterable)accountShareTargets);
        LOG.debug("remove items...");
        LOG.debug("before return , updateGuids : {} ", (Object)updateGuids);
        if (updateGuids == null || updateGuids.size() <= 0) {
            LOG.debug("Flag...");
            return;
        }
        LOG.debug("after return , updateGuids : {} ", (Object)updateGuids);
        Account userAccount = this.accountDao.findOne(userGuid);
        List newTargetList = updateGuids.stream().filter(updateGuid -> StringUtils.isNotEmpty((CharSequence)updateGuid)).map(shareTargetGuid -> new Accountsharetargetsetting(UUIDGenerator.getRandomUUID(), shareItem, shareTargetGuid, userAccount)).collect(Collectors.toList());
        this.accountShareTargetDao.save(newTargetList);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addItemIntoShareNotice(String shareAccountGuid, String beSharedAccountGuid, String beSharedItemGuid, TempStoredDataType itemType) {
        AccountShareToAccountItem shareItem = new AccountShareToAccountItem(beSharedAccountGuid, beSharedItemGuid, shareAccountGuid, itemType);
        this.accountShareToAccountItemDao.save((Object)shareItem);
    }

    public List<String> getSharedItemGuids(String shareAccountGuid, String beSharedAccountGuid, TempStoredDataType itemType) {
        List itemGuids = this.accountShareToAccountItemDao.findItemGuids(shareAccountGuid, beSharedAccountGuid, itemType);
        return itemGuids;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void removeSharedItems(String shareAccountGuid, String beSharedAccountGuid, TempStoredDataType itemType, List<String> itemGuids) {
        List sharedItems = this.accountShareToAccountItemDao.findByShareaccountguidAndBesharedaccountguidAndItemtypeAndInItemGuids(shareAccountGuid, beSharedAccountGuid, itemType, itemGuids);
        this.accountShareToAccountItemDao.delete((Iterable)sharedItems);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addNewShareTargets(String userGuid, List<AccountShareTargetVo> list) {
        if (list == null) {
            return;
        }
        for (AccountShareTargetVo accountShareTargetVo : list) {
            try {
                this.addNewShareTarget(userGuid, accountShareTargetVo.getAccountGuid(), accountShareTargetVo.getShareItem());
            }
            catch (Exception ex) {
                LOG.warn("Fail to add new share target from list.", (Throwable)ex);
            }
        }
    }
}

