/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.AesUtil;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.AccountPrivateSettingDao;
import com.penpower.worldcard.team.dao.AccountShareTargetDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.CompanyDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoForDS;
import com.penpower.worldcard.team.dto.PassWordHistory;
import com.penpower.worldcard.team.dto.ResignedAcountInfo;
import com.penpower.worldcard.team.dto.mapper.DtoMapper;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.AccountPrivateSetting;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Session;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.FailureType;
import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.enums.VerifySource;
import com.penpower.worldcard.team.exception.AccessWithUnbindingDeviceOrNotAllowedIpException;
import com.penpower.worldcard.team.exception.AccountCreateException;
import com.penpower.worldcard.team.exception.AccountUpdateException;
import com.penpower.worldcard.team.exception.DeleteAccountException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LicenseCountMaxExceededException;
import com.penpower.worldcard.team.exception.LoginWithUnbindingDeviceException;
import com.penpower.worldcard.team.exception.PasswordLengthIncorrectException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.UpdateToResignedException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.notice.content.AccountAbilityChangedContent;
import com.penpower.worldcard.team.notice.content.AccountBossChangedContent;
import com.penpower.worldcard.team.notice.content.AccountLockCasebyUnactive;
import com.penpower.worldcard.team.notice.content.AccountRoleChangedContent;
import com.penpower.worldcard.team.notice.content.AccountSetToResignedContent;
import com.penpower.worldcard.team.notice.content.AccountSetToTemplateInvalidate;
import com.penpower.worldcard.team.notice.content.AccountSubordinateChangedContent;
import com.penpower.worldcard.team.notice.event.WebSocketNoticePublisher;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.LoginfailedlinfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SessionService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.service.impl.AccountServiceImpl;
import com.penpower.worldcard.team.web.api.vo.AccountCreationVo;
import com.penpower.worldcard.team.web.api.vo.AccountUpdateVo;
import com.penpower.worldcard.team.websokcet.WebSocketNotifyEvent;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="accountService")
@Transactional
public class AccountServiceImpl
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private LoginfailedlinfoService loginfailedlinfoService;
    @Autowired
    @Qualifier(value="accountInfoDtoMapper")
    private DtoMapper<Account, AccountInfo> accountInfoDtoMapper;
    @Autowired
    private AesUtil aesUtil;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private PathManager accountPathManager;
    @Autowired
    private PathManager temporaryPathManager;
    @Autowired
    private AccountPrivateSettingDao accountPrivateSettingDao;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private SystemSettingService databaseSystemSettingService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private AccountShareTargetDao accountShareTargetDao;
    @Autowired
    @Qualifier(value="webSocketNoticePublisher")
    private WebSocketNoticePublisher webSocketNoticePublisher;
    @Autowired
    private AccountSecurityService accountSecurityService;

    public void verifyAccount(String guid, String email) {
        if (this.accountQueryParamsNull(guid, email)) {
            throw new RequestArgumentNotValidException("Failed to verify account , The parameter is incorrect.");
        }
        Account account = null;
        account = StringUtils.isEmpty((CharSequence)guid) ? this.accountDao.findByEmailIgnoreCase(email) : this.accountDao.findOne(guid);
        if (account == null) {
            throw new ItemNotFoundException(String.format("Verify account failed, Can't find account by guid[%s] Or email[%s]", guid, email));
        }
    }

    public UserStatus getAccountStatus(String guid) {
        Account account = this.accountDao.findOne(guid);
        LOG.debug("account :  {}", (Object)account);
        if (account == null) {
            throw new RequestArgumentNotValidException("account guid not found");
        }
        return account.getStatus();
    }

    public void checkUnActiveAccountExipred() {
        LOG.info("checkUnActiveAccountExipred");
        List companys = this.companyDao.findAll();
        for (Company company : companys) {
            LOG.info("checkUnActiveAccountExipred COMPANY={}", (Object)company);
            if (this.companyGlobalInfoService.getStringByKeyWithDefault("AUTO_LOCK_UNACTIVE", SystemConstantProperties.DEFAULT_AUTO_LOCK_UNACTIVE, company.getGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) != 0) continue;
            int days = this.companyGlobalInfoService.getValueByKeyWithDefault("AUTO_LOCK_UNACTIVE_DAYS", 14, company.getGuid());
            LOG.info("checkUnActiveAccountExipred days={}", (Object)days);
            List accounts = this.accountDao.findAllbyCompany(company.getGuid());
            for (Account account : accounts) {
                if (account.getStatus() != UserStatus.INACTIVE) continue;
                LOG.info("checkUnActiveAccountExipred createtime={} plusdays={} now={} account={}", new Object[]{account.getCreateTime(), account.getCreateTime().plusDays(days), DateTime.now(), account});
                if (!account.getCreateTime().plusDays(days).isBeforeNow() || account.getLockIssue() == AccountLockedIssue.ACCOUNT_NOT_ACTIVE_EXPIRED) continue;
                Duration duration = new Duration((ReadableInstant)account.getCreateTime(), (ReadableInstant)DateTime.now());
                long differentDays = duration.getStandardDays();
                account.setLockIssue(AccountLockedIssue.ACCOUNT_NOT_ACTIVE_EXPIRED);
                account.setLockCase(AccountLockCase.UNACTIVE_EXPIRED);
                String AccountLockCasebyUnactiveContent = GlobalUtils.getJsonString((Object)new AccountLockCasebyUnactive(account.getGuid(), account.getDisplayName(), differentDays));
                LOG.debug("checkUnActiveAccountExipred AccountLockCasebyUnactiveContent ={}", (Object)AccountLockCasebyUnactiveContent);
                this.noticeService.addSystemNoticeToAdmin(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_LOCKBY_UNACTIVE, AccountLockCasebyUnactiveContent, company.getGuid());
            }
        }
    }

    public void checkPasswordValidate(String newPassword) {
        int newPasswordLength = Optional.ofNullable(newPassword).orElse("").length();
        LOG.debug("newPasswordLength : {} ", (Object)newPasswordLength);
        boolean passwordLengthLessThanMin = newPasswordLength < 12;
        boolean passwordLengthLargeThanMax = newPasswordLength > 256;
        LOG.debug("passwordLengthLessThanMin : {} ", (Object)passwordLengthLessThanMin);
        LOG.debug("passwordLengthLargeThanMax : {} ", (Object)passwordLengthLargeThanMax);
        if (passwordLengthLessThanMin || passwordLengthLargeThanMax) {
            throw new PasswordLengthIncorrectException("password length has to be minimum of 8 characters and maximum of 16 characters.");
        }
        boolean hasUppercase = false;
        boolean hasLowercase = false;
        boolean hasDigit = false;
        boolean hasSpecialChar = false;
        for (char ch : newPassword.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                hasUppercase = true;
                continue;
            }
            if (Character.isLowerCase(ch)) {
                hasLowercase = true;
                continue;
            }
            if (Character.isDigit(ch)) {
                hasDigit = true;
                continue;
            }
            if ("&@/~!#$%^&*()_+-=[]{}|;:',.<>?".indexOf(ch) == -1) continue;
            hasSpecialChar = true;
        }
        LOG.debug("hasUppercase : {} hasLowercase : {} hasDigit : {} hasSpecialChar : {} ", new Object[]{hasUppercase, hasLowercase, hasDigit, hasSpecialChar});
        int count = 0;
        if (hasUppercase) {
            ++count;
        }
        if (hasLowercase) {
            ++count;
        }
        if (hasDigit) {
            ++count;
        }
        if (hasSpecialChar) {
            ++count;
        }
        if (count < 3) {
            throw new PasswordLengthIncorrectException("password not match rule");
        }
        int nMaxSameCount = 2;
        int nSame = 0;
        char lastChar = '\u0000';
        for (char charone : newPassword.toCharArray()) {
            if (lastChar == '\u0000') {
                lastChar = charone;
            } else {
                nSame = charone == lastChar ? ++nSame : 0;
                lastChar = charone;
                LOG.debug("nsam={},nMaxSameCount={}");
            }
            if (nSame < nMaxSameCount) continue;
            throw new PasswordLengthIncorrectException("password has same character  ");
        }
    }

    public boolean verifyPassword(String guid, String email, String password) {
        if (this.accountQueryParamsNull(guid, email)) {
            throw new RequestArgumentNotValidException("Failed to verify account , The parameter is incorrect.");
        }
        Account account = null;
        account = StringUtils.isEmpty((CharSequence)guid) ? this.accountDao.findByEmailIgnoreCase(email) : this.accountDao.findOne(guid);
        LOG.debug("account :  {}", (Object)account);
        if (account == null) {
            return false;
        }
        String passwordDecoded = new String(this.aesUtil.decodeFromBase64(account.getPassword()));
        return password.equals(passwordDecoded);
    }

    private static boolean checkLastNMatch(List<PassWordHistory> list, String target, int n) {
        LOG.debug("checkLastNMatch target :  {} ", (Object)target);
        if (list == null) {
            return false;
        }
        int size = list.size();
        for (int i = size - 1; i >= size - n && i >= 0; --i) {
            LOG.debug("checkLastNMatch getPassword i :  {} : {} ", (Object)i, (Object)list.get(i).getPassword());
            if (!target.equals(list.get(i).getPassword())) continue;
            LOG.debug("checkLastNMatch match :  {} ", (Object)list.get(i).getPassword());
            return true;
        }
        return false;
    }

    public boolean IsPasswordInHistory(String guid, String email, String password) {
        if (this.accountQueryParamsNull(guid, email)) {
            throw new RequestArgumentNotValidException("Failed to verify account , The parameter is incorrect.");
        }
        LOG.debug("IsPasswordInHistory in ");
        Account account = null;
        account = StringUtils.isEmpty((CharSequence)guid) ? this.accountDao.findByEmailIgnoreCase(email) : this.accountDao.findOne(guid);
        if (account == null) {
            return false;
        }
        LOG.debug("IsPasswordInHistory account :  {}", (Object)account);
        int checkCount = this.companyGlobalInfoService.getValueByKeyWithDefault("RECENT_PASSWORD_REPETITION", 4, account.getCompanyGuid());
        LOG.debug("IsPasswordInHistory checkCount :  {} getPasswordhistory :{}", (Object)checkCount, (Object)account.getPasswordhistory());
        if (!StringUtils.isEmpty((CharSequence)account.getPasswordhistory())) {
            String passwordHistoryJson = new String(this.aesUtil.decodeFromBase64(account.getPasswordhistory()));
            LOG.debug("IsPasswordInHistory passwordHistoryJson :  {} ", (Object)passwordHistoryJson);
            if (!StringUtils.isEmpty((CharSequence)passwordHistoryJson)) {
                Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
                Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
                List passwordHistorys = (List)gson.fromJson(passwordHistoryJson, listType);
                LOG.debug("IsPasswordInHistory passwordHistorys :  {} ", (Object)passwordHistorys);
                if (AccountServiceImpl.checkLastNMatch((List)passwordHistorys, (String)password, (int)checkCount)) {
                    return true;
                }
            }
        } else {
            String passwordDecoded = new String(this.aesUtil.decodeFromBase64(account.getPassword()));
            LOG.debug("IsPasswordInHistory passwordDecoded :  {} ", (Object)passwordDecoded);
            if (password.equals(passwordDecoded)) {
                return true;
            }
        }
        return false;
    }

    private boolean accountQueryParamsNull(String guid, String email) {
        boolean paramsIsNull = StringUtils.isEmpty((CharSequence)guid) && StringUtils.isEmpty((CharSequence)email);
        LOG.debug("guid : {} , email : {} , paramsIsNull : {}", new Object[]{guid, email, paramsIsNull});
        return paramsIsNull;
    }

    public AccountInfo getAccountInfo(String guid, String email) {
        if (this.accountQueryParamsNull(guid, email)) {
            throw new RequestArgumentNotValidException("Failed to verify account , The parameter is incorrect.");
        }
        AccountInfo accountInfo = null;
        Account account = null;
        account = StringUtils.isEmpty((CharSequence)guid) ? this.accountDao.findByEmailIgnoreCase(email) : this.accountDao.findOne(guid);
        if (account == null) {
            throw new ItemNotFoundException("Account not found.");
        }
        accountInfo = this.getDtoFromEntity(account);
        return accountInfo;
    }

    private AccountInfo getDtoFromEntity(Account account) {
        if (account == null) {
            return null;
        }
        LOG.debug("AccountServiceImpl getDtoFromEntity");
        return (AccountInfo)this.accountInfoDtoMapper.transformToDto((Object)account);
    }

    private ResignedAcountInfo getResignedAccountInfoDtoFromEntity(Account account) {
        if (account == null) {
            return null;
        }
        ResignedAcountInfo accountInfo = new ResignedAcountInfo();
        accountInfo.setGuid(account.getGuid() == null ? null : account.getGuid());
        accountInfo.setEmail(account.getEmail());
        accountInfo.setName(account.getDisplayName());
        accountInfo.setRole(account.getRole());
        accountInfo.setStatus(account.getStatus());
        accountInfo.setCreateDate(account.getCreateTime());
        accountInfo.setExportAbility(account.isExportAbility());
        accountInfo.setPrintAbility(account.isPrintability());
        accountInfo.setInheritorGuid(account.getInheritedAccount());
        accountInfo.setInheritanceStatus(account.getInheritancestatus());
        LOG.debug("account: {}", (Object)account);
        LOG.debug("account.getBoss() : {}", (Object)account.getBoss());
        if (account.getBoss() != null) {
            accountInfo.setBoss(account.getBoss().getGuid());
        }
        accountInfo.setInheritDate(account.getInheritDate());
        accountInfo.setResignDate(account.getResignDate());
        return accountInfo;
    }

    public List<AccountInfo> getAccountInfos(String companyGuid) {
        List accounts = this.accountDao.findAllbyCompany(companyGuid);
        LOG.debug("getAccountInfos companyGuid={} accounts = {}", (Object)companyGuid, (Object)accounts);
        List<AccountInfo> accountInfos = accounts.stream().filter(account -> !UserStatus.DELETED.equals((Object)account.getStatus())).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        LOG.debug("getAccountInfos accountInfos={} ", accountInfos);
        return accountInfos;
    }

    public void UpdateAccountCompanyGuid(String accountGuid, String companyGuid) {
        LOG.info("UpdateAccountCompanyGuid accountGuid={} companyGuid={}", (Object)accountGuid, (Object)companyGuid);
        Account account = this.accountDao.findOne(accountGuid);
        if (account != null) {
            LOG.info("UpdateAccountCompanyGuid accountGuid ={}", (Object)accountGuid);
            account.setCompanyGuid(companyGuid);
            this.accountDao.saveAndFlush((Object)account);
        }
    }

    public List<AccountInfo> GetAccountByCompany(String companyGuid) throws ItemNotFoundException {
        List accounts = this.accountDao.findAllbyCompany(companyGuid);
        List<AccountInfo> accountforCompany = accounts.stream().filter(account -> companyGuid.compareToIgnoreCase(account.getCompanyGuid()) == 0).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        if (accountforCompany == null || accountforCompany.size() == 0) {
            throw new ItemNotFoundException("Account for company not found.");
        }
        return accountforCompany;
    }

    public List<AccountInfoForDS> getAccountList() {
        List<AccountInfoForDS> accountInfoDS = this.accountDao.findAll().stream().filter(account -> this.validatePublicAccount(account)).map(account -> this.getDtoFromEntity(account).ConvertToforDS()).collect(Collectors.toList());
        return accountInfoDS;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public String createAccount(AccountCreationVo accountCreationVo, String companyGuid, boolean IsNoticeBoss) {
        LOG.debug("create new accountfrom vo : {}", (Object)accountCreationVo);
        Account newAccount = new Account();
        newAccount.setCompanyGuid(companyGuid);
        newAccount.setGuid(UUIDGenerator.getRandomUUID());
        newAccount.setEmail(accountCreationVo.getEmail());
        newAccount.setDisplayName(accountCreationVo.getName());
        newAccount.setRole(accountCreationVo.getRole());
        String passwordAesEncodedBase64 = this.getEncryptedBase64Password("penpower");
        newAccount.setPassword(passwordAesEncodedBase64);
        newAccount.setAccountSubscriptionStatus(AccountSubscriptionStatus.IN_SUBSCRIPTION);
        AccountType accountType = accountCreationVo.getAccountType();
        if (AccountType.AD.equals((Object)accountType)) {
            newAccount.setExportAbility(false);
            newAccount.setSecretary(false);
            newAccount.setPrintability(false);
            newAccount.setAccounttype(accountType);
            newAccount.setActivedirectoryserver(accountCreationVo.getAdServer());
            newAccount.setActivedirectorybasedn(accountCreationVo.getAdServerBaseDn());
            newAccount.setActivedirectoryaccountmail(accountCreationVo.getAdAccountMail());
            newAccount.setStatus(UserStatus.INACTIVE);
        } else {
            newAccount.setExportAbility(accountCreationVo.isExportAbility());
            newAccount.setSecretary(accountCreationVo.isSecretary());
            newAccount.setPrintability(accountCreationVo.isPrintAbility());
            newAccount.setAccounttype(AccountType.LOCAL);
            if (accountCreationVo.getStatus() != null) {
                newAccount.setStatus(accountCreationVo.getStatus());
            } else {
                newAccount.setStatus(UserStatus.INACTIVE);
            }
        }
        Account boss = this.accountDao.findOne(accountCreationVo.getBoss());
        if (boss != null) {
            if (!this.validStatusAccount(boss.getStatus())) {
                throw new AccountCreateException("New Account boss status was invalid. status : " + boss.getStatus());
            }
            newAccount.setBoss(boss);
        }
        newAccount.setCreateTime(new DateTime());
        newAccount.setLastPasswordChangeTime(new DateTime());
        String logoTmpGuid = accountCreationVo.getLogoTmpGuid();
        Session tmpGuidSession = this.sessionService.getSessionByKey(logoTmpGuid);
        if (tmpGuidSession != null) {
            String saveLogoRelativePath = this.accountLogoProcess(tmpGuidSession, newAccount.getGuid());
            newAccount.setLogoFilepath(saveLogoRelativePath);
        }
        newAccount.setLockIssue(AccountLockedIssue.NO_ISSUE);
        newAccount.setLockCase(AccountLockCase.NO);
        LOG.debug("create  newAccount : {}", (Object)newAccount);
        Account savedAccount = (Account)this.accountDao.saveAndFlush((Object)newAccount);
        LOG.debug("create  newAccount after savedAccount :{}", (Object)savedAccount);
        Account savedAccountBoss = savedAccount.getBoss();
        AccountPrivateSetting defaultAccountPrivateSetting = new AccountPrivateSetting();
        defaultAccountPrivateSetting.setAccount(savedAccount);
        defaultAccountPrivateSetting.setGuid(UUIDGenerator.getRandomUUID());
        defaultAccountPrivateSetting.setLastNoticeCountView(new DateTime());
        defaultAccountPrivateSetting.setModifytime(new DateTime());
        defaultAccountPrivateSetting.setShowOwnerInfo(false);
        this.accountPrivateSettingDao.save((Object)defaultAccountPrivateSetting);
        if (accountCreationVo.getAccountSecurityInfos() == null) {
            this.accountSecurityService.createDefaultSecuritySettingOfAccount(savedAccount);
        } else {
            this.accountSecurityService.createAccountSecurityInfo(savedAccount, accountCreationVo.getAccountSecurityInfos());
        }
        this.categoryService.createDefaultCategoriesOfAccount(savedAccount);
        String savedAccountGuid = savedAccount.getGuid();
        String savedAccountName = savedAccount.getDisplayName();
        if (savedAccountBoss != null && IsNoticeBoss) {
            AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
            String savedAccountBossGuid = savedAccountBoss.getGuid();
            String newBossContnet = GlobalUtils.getJsonString((Object)new AccountBossChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), savedAccountBoss.getDisplayName(), savedAccountBossGuid));
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_BOSS_CHANGED, newBossContnet, savedAccountGuid, null);
            String newSubordinateContent = GlobalUtils.getJsonString((Object)new AccountSubordinateChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), savedAccountName, savedAccountGuid));
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_SUBORDINATE_CHANGED, newSubordinateContent, savedAccountBossGuid, null);
        }
        return savedAccount.getGuid();
    }

    private String getEncryptedBase64Password(String password) {
        String passwordAesEncodedBase64 = this.aesUtil.encodeBase64(password);
        return passwordAesEncodedBase64;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteAccountbyCompany(String companyGuid) {
        List accounts = this.accountDao.findAllbyCompany(companyGuid);
        for (Account account : accounts) {
            account.setStatus(UserStatus.DELETED);
            this.accountDao.save((Object)account);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteAccount(String guid) {
        Account account = this.accountDao.findOne(guid);
        if (this.accountActive(account)) {
            throw new DeleteAccountException("Account status is ACTIVE.");
        }
        LOG.debug("account : {} ", (Object)account);
        this.accountDao.delete((Object)account);
    }

    private boolean accountActive(Account account) {
        return UserStatus.ACTIVE.equals((Object)account.getStatus());
    }

    @Deprecated
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public List<AccountInfo> deleteAccounts(List<String> guids) {
        List<Account> deleteAccounts = guids.stream().map(guid -> this.accountDao.findOne(guid)).filter(Objects::nonNull).collect(Collectors.toList());
        List<AccountInfo> undeletedAccounts = deleteAccounts.stream().filter(account -> this.accountActive(account)).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        deleteAccounts = deleteAccounts.stream().filter(account -> !account.getStatus().equals((Object)UserStatus.ACTIVE)).collect(Collectors.toList());
        deleteAccounts.forEach(account -> account.setStatus(UserStatus.DELETED));
        this.accountDao.save(deleteAccounts);
        return undeletedAccounts;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updatePassword(String guid, String newPassword) {
        Account account = this.accountDao.findOne(guid);
        String passwordAesEncodedBase64 = this.getEncryptedBase64Password(newPassword);
        account.setPassword(passwordAesEncodedBase64);
        this.accountDao.save((Object)account);
        this.setUserTokensInvalidQuiet(guid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void changePassword(String guid, String oldPassword, String newPassword) {
        Gson gson;
        String passwordHistoryJson;
        Account account = this.accountDao.findOne(guid);
        String passwordAesEncodedBase64 = this.getEncryptedBase64Password(newPassword);
        ArrayList<PassWordHistory> passwordHistorys = new ArrayList<PassWordHistory>();
        if (!StringUtils.isEmpty((CharSequence)account.getPasswordhistory()) && !StringUtils.isEmpty((CharSequence)(passwordHistoryJson = new String(this.aesUtil.decodeFromBase64(account.getPasswordhistory()))))) {
            gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
            Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
            List listcurr = (List)gson.fromJson(passwordHistoryJson, listType);
            passwordHistorys.addAll(listcurr);
        }
        PassWordHistory newPasswordHistory = new PassWordHistory();
        newPasswordHistory.setPassword(newPassword);
        newPasswordHistory.setUpdateTime(DateTime.now());
        if (passwordHistorys.size() > 6) {
            passwordHistorys.remove(0);
        }
        passwordHistorys.add(newPasswordHistory);
        gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
        String newpasswordHistoryJson = gson.toJson(passwordHistorys);
        String newpasswordHistoryAesEncodedBase64 = this.getEncryptedBase64Password(newpasswordHistoryJson);
        account.setPasswordhistory(newpasswordHistoryAesEncodedBase64);
        account.setPassword(passwordAesEncodedBase64);
        account.setLastPasswordChangeTime(DateTime.now());
        account.setStatus(UserStatus.ACTIVE);
        this.accountDao.save((Object)account);
        this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_PASSWORD_CHANGED, Arrays.asList(guid));
        this.setUserTokensInvalidQuiet(guid);
    }

    private void setUserTokensInvalidQuiet(String guid) {
        try {
            LOG.debug("set user token to invalid....");
            this.tokenService.setTokensInvalid(guid);
        }
        catch (Exception ex) {
            LOG.warn("failed to set user tokens expired.", (Throwable)ex);
        }
    }

    public void SetAllUserTokenInvalidate() {
        this.tokenService.setAllTokenIvalidate();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateAccount(AccountUpdateVo accountUpdateRequestVo, AccountInfo currentLoginAccount) {
        LOG.debug("accountUpdateVo : {} ", (Object)accountUpdateRequestVo);
        AccountValueChangedNotice accountValueChangedNotice = new AccountValueChangedNotice(this);
        AccountUpdateEventContentData accountUpdateEventContentData = new AccountUpdateEventContentData(this);
        Account accountToUpdate = this.accountDao.findOne(accountUpdateRequestVo.getGuid());
        LOG.debug("accountUpdated : {} ", (Object)accountToUpdate);
        accountUpdateEventContentData.setAccountToUpdateGuid(accountToUpdate.getGuid());
        accountUpdateEventContentData.setAccountToUpdateName(accountToUpdate.getDisplayName());
        this.updateUserRole(accountUpdateRequestVo, accountToUpdate, accountValueChangedNotice, accountUpdateEventContentData, currentLoginAccount.getCompanyGuid());
        this.updateExportAbility(accountUpdateRequestVo, accountToUpdate, accountValueChangedNotice, accountUpdateEventContentData);
        this.updateSecretary(accountUpdateRequestVo, accountToUpdate, accountValueChangedNotice, accountUpdateEventContentData);
        this.updatePrintability(accountUpdateRequestVo, accountToUpdate, accountValueChangedNotice, accountUpdateEventContentData);
        this.updateBoss(accountUpdateRequestVo, accountToUpdate, accountValueChangedNotice, accountUpdateEventContentData, currentLoginAccount);
        String logoTmpGuid = accountUpdateRequestVo.getLogo();
        Session tmpGuidSession = this.sessionService.getSessionByKey(logoTmpGuid);
        if (tmpGuidSession != null) {
            String saveLogoRelativePath = this.accountLogoProcess(tmpGuidSession, accountToUpdate.getGuid());
            accountToUpdate.setLogoFilepath(saveLogoRelativePath);
        } else {
            accountToUpdate.setLogoFilepath(logoTmpGuid);
        }
        accountToUpdate.setDisplayName(accountUpdateRequestVo.getName());
        accountToUpdate.setSecretary(accountUpdateRequestVo.isSecretary());
        accountToUpdate.setPrintability(accountUpdateRequestVo.isPrintAbility());
        this.accountSecurityService.updateAccountSecurityInfo(accountToUpdate, accountUpdateRequestVo.getAccountSecurityInfos());
        accountToUpdate.setActivedirectoryaccountmail(accountUpdateRequestVo.getAdAccountMail());
        this.accountDao.save((Object)accountToUpdate);
        this.publishAccountModifiedNoticeEvents(accountValueChangedNotice, accountUpdateEventContentData, currentLoginAccount);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, noRollbackFor={LoginWithUnbindingDeviceException.class, AccessWithUnbindingDeviceOrNotAllowedIpException.class})
    public void publishAccountSecurityChangedEvent(AccountUpdateVo accountUpdateRequestVo) {
        String updateUserGuid = accountUpdateRequestVo.getGuid();
        List updateUserTokenInfos = this.tokenService.getAllTokenInfoByUserGuid(updateUserGuid);
        List tokensNeedToRemove = updateUserTokenInfos.stream().filter(info -> {
            try {
                this.accountSecurityService.verifyAccountSecurity(VerifySource.API, updateUserGuid, info.getIp(), info.getDeviceId(), "", info.getPlatform(), DateTime.now());
                return false;
            }
            catch (Exception ex) {
                return true;
            }
        }).map(info -> info.getToken()).collect(Collectors.toList());
        LOG.debug("Tokens:{} need to remove, because of security change", tokensNeedToRemove);
        if (tokensNeedToRemove.size() != 0) {
            this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_SECURITY_SETTING_CHANGED, Arrays.asList(updateUserGuid));
            tokensNeedToRemove.stream().forEach(token -> this.tokenService.setToInvalid(token));
        }
    }

    private void updatePrintability(AccountUpdateVo accountUpdateRequestVo, Account accountToUpdate, AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData) {
        boolean newPrintAbility;
        boolean updatePrintAbility = accountToUpdate.isPrintability();
        if (updatePrintAbility != (newPrintAbility = accountUpdateRequestVo.isPrintAbility())) {
            accountToUpdate.setPrintability(newPrintAbility);
            accountUpdateEventContentData.setNewPrintAbility(newPrintAbility);
            accountValueChangedNotice.setAccountPrintAbilityChanged(true);
        }
    }

    private void updateSecretary(AccountUpdateVo accountUpdateRequestVo, Account accountToUpdate, AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData) {
        boolean newSecretary;
        boolean updateSecretary = accountToUpdate.isSecretary();
        if (updateSecretary != (newSecretary = accountUpdateRequestVo.isSecretary())) {
            accountToUpdate.setSecretary(updateSecretary);
            accountUpdateEventContentData.setNewSecretary(newSecretary);
            accountValueChangedNotice.setAccountSecretaryChanged(true);
        }
    }

    private void updateBoss(AccountUpdateVo accountUpdateRequestVo, Account accountToUpdate, AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData, AccountInfo currentLoginAccount) {
        String newBossGuid = accountUpdateRequestVo.getBoss();
        String accountToUpdateGuid = accountToUpdate.getGuid();
        LOG.debug("newBossGuid : {}  ,accountToUpdateGuid : {}  ", (Object)newBossGuid, (Object)accountToUpdateGuid);
        Account originalBoss = accountToUpdate.getBoss();
        String originalBossGuid = originalBoss == null ? null : originalBoss.getGuid();
        boolean boossChanged = this.bossChanged(newBossGuid, originalBossGuid);
        LOG.debug("boossChanged : {} ", (Object)boossChanged);
        if (boossChanged) {
            if (this.bossGuidPresent(newBossGuid)) {
                LOG.debug("newBossGuid isPresent.....originalBoss : {}  , newBossGuid : {}", (Object)originalBoss, (Object)newBossGuid);
                Account updatedBoss = this.accountDao.findOne(newBossGuid);
                if (updatedBoss != null) {
                    LOG.debug("updated boss not null....start update");
                    this.checkBossValid(accountToUpdateGuid, updatedBoss.getGuid());
                    if (!this.validStatusAccount(updatedBoss.getStatus())) {
                        throw new AccountUpdateException("New boss account status was invalid. status : " + updatedBoss.getStatus());
                    }
                    accountToUpdate.setBoss(updatedBoss);
                    accountValueChangedNotice.setAccountBossChanged(true);
                    accountValueChangedNotice.setAccountBossSubordinateChanged(true);
                    accountUpdateEventContentData.setNewBossGuid(newBossGuid);
                    accountUpdateEventContentData.setNewBossName(updatedBoss.getDisplayName());
                    GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"HAVE_SET_BOSS", (String)"true", (String)currentLoginAccount.getCompanyGuid());
                }
            } else {
                LOG.debug("newBossGuid notPresent.....originalBoss : {} ", (Object)originalBoss);
                if (originalBoss != null) {
                    accountToUpdate.setBoss(null);
                    accountValueChangedNotice.setAccountBossRemoved(true);
                } else {
                    accountValueChangedNotice.setAccountBossChanged(true);
                }
            }
        }
    }

    private void updateExportAbility(AccountUpdateVo accountUpdateRequestVo, Account accountToUpdate, AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData) {
        boolean newExportAbility;
        boolean exportAbility = accountToUpdate.isExportAbility();
        if (exportAbility != (newExportAbility = accountUpdateRequestVo.isExportAbility())) {
            accountToUpdate.setExportAbility(newExportAbility);
            accountUpdateEventContentData.setNewExportAbility(newExportAbility);
            accountValueChangedNotice.setAccountExportAbilityChanged(true);
        }
    }

    private void updateUserRole(AccountUpdateVo accountUpdateRequestVo, Account accountToUpdate, AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData, String companyGuid) {
        UserRole userRole = accountToUpdate.getRole();
        UserRole newUserRole = accountUpdateRequestVo.getRole();
        LOG.debug("userRole : {} ,newUserRole : {}", (Object)userRole, (Object)newUserRole);
        if (!userRole.equals((Object)newUserRole)) {
            Long adminAccountCounts;
            if (UserRole.ADMIN.equals((Object)userRole) && (adminAccountCounts = this.accountDao.countByRole(UserRole.ADMIN, companyGuid)) <= 1L) {
                throw new AccountUpdateException("Total ADMIN account size cannot less than 1 , update account failed.");
            }
            accountToUpdate.setRole(newUserRole);
            accountUpdateEventContentData.setNewUserRole(newUserRole);
            accountValueChangedNotice.setAccountRoleChanged(true);
        }
    }

    private boolean validStatusAccount(UserStatus accountStatus) {
        boolean validUser = SecurityUtils.validUser((UserStatus)accountStatus);
        return validUser;
    }

    private void checkBossValid(String accountGuid, String newBossGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        List subordinateGuids = this.getAllSubordinateGuids(accountGuid);
        if (subordinateGuids.contains(newBossGuid)) {
            throw new AccountUpdateException("Fail to update account boss ,the new boss is a subordinates or subsidiary of subordinates.");
        }
    }

    private boolean bossChanged(String newBossGuid, String originalBossGuid) {
        LOG.debug(" >>\u3000newBossGuid : {} , originalBossGuid : {} ", (Object)newBossGuid, (Object)originalBossGuid);
        boolean newBossEmpty = StringUtils.isEmpty((CharSequence)newBossGuid);
        boolean originalBossEmpty = StringUtils.isEmpty((CharSequence)originalBossGuid);
        boolean bothGuidEmpty = newBossEmpty && originalBossEmpty;
        LOG.debug("newBossEmpty : {} ", (Object)newBossEmpty);
        LOG.debug("originalBossEmpty : {} ", (Object)originalBossEmpty);
        LOG.debug("bothGuidEmpty : {} ", (Object)bothGuidEmpty);
        if (bothGuidEmpty) {
            LOG.debug("all empty > false");
            return false;
        }
        if (originalBossEmpty && !newBossEmpty || !originalBossEmpty && newBossEmpty) {
            LOG.debug("any one empty , change");
            return true;
        }
        LOG.debug("originalBossGuid.equals(newBossGuid) : {}", (Object)originalBossGuid.equals(newBossGuid));
        return !originalBossGuid.equals(newBossGuid);
    }

    private boolean bossGuidPresent(String bossGuid) {
        return bossGuid != null && !bossGuid.toLowerCase().equals("null") && bossGuid.length() > 0;
    }

    private void publishAccountModifiedNoticeEvents(AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData, AccountInfo currentLoginAccount) {
        String accountToUpdateGuid = accountUpdateEventContentData.getAccountToUpdateGuid();
        if (accountValueChangedNotice.isAccountRoleChanged()) {
            String userRoleChangeContent = GlobalUtils.getJsonString((Object)new AccountRoleChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), accountUpdateEventContentData.getNewUserRole()));
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_USER_ROLE_CHANGE, userRoleChangeContent, accountToUpdateGuid, null);
            this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.USER_ROLE_CHANGED, Arrays.asList(accountToUpdateGuid));
            this.setUserTokensInvalidQuiet(accountToUpdateGuid);
        }
        this.publishAccountAbilityChangedNotice(accountValueChangedNotice, accountUpdateEventContentData, accountToUpdateGuid, currentLoginAccount);
        if (accountValueChangedNotice.isAccountBossChanged()) {
            String newBossGuid = accountUpdateEventContentData.getNewBossGuid();
            LOG.debug("before send boss changed notice , newBossGuid :{} ", (Object)newBossGuid);
            if (StringUtils.isNotEmpty((CharSequence)newBossGuid)) {
                String accountBossChangedContent = GlobalUtils.getJsonString((Object)new AccountBossChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), accountUpdateEventContentData.getNewBossName(), accountUpdateEventContentData.getNewBossGuid()));
                this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_BOSS_CHANGED, accountBossChangedContent, accountToUpdateGuid, null);
            }
        }
        if (accountValueChangedNotice.isAccountBossSubordinateChanged()) {
            String newSubordinateContent = GlobalUtils.getJsonString((Object)new AccountSubordinateChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), accountUpdateEventContentData.getAccountToUpdateName(), accountToUpdateGuid));
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_SUBORDINATE_CHANGED, newSubordinateContent, accountUpdateEventContentData.getNewBossGuid(), null);
        }
        if (accountValueChangedNotice.isAccountBossRemoved()) {
            LOG.debug("boss remove event");
        }
    }

    private void publishAccountAbilityChangedNotice(AccountValueChangedNotice accountValueChangedNotice, AccountUpdateEventContentData accountUpdateEventContentData, String accountToUpdateGuid, AccountInfo currentLoginAccount) {
        boolean multipleAbilitiesChanged = accountValueChangedNotice.isAccountExportAbilityChanged() || accountValueChangedNotice.isAccountPrintAbilityChanged() || accountValueChangedNotice.isAccountSecretaryChanged();
        LOG.debug("multipleAbilitiesChanged : {} ", (Object)multipleAbilitiesChanged);
        if (multipleAbilitiesChanged) {
            Gson gson = new GsonBuilder().serializeNulls().create();
            String newExportAbilityVal = accountValueChangedNotice.isAccountExportAbilityChanged() ? String.valueOf(accountUpdateEventContentData.getNewExportAbility()) : null;
            String newPrintAbilityVal = accountValueChangedNotice.isAccountPrintAbilityChanged() ? String.valueOf(accountUpdateEventContentData.getNewPrintAbility()) : null;
            String newSecretaryVal = accountValueChangedNotice.isAccountSecretaryChanged() ? String.valueOf(accountUpdateEventContentData.getNewSecretary()) : null;
            String miltipleAbilitiesChangedContent = gson.toJson((Object)new AccountAbilityChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), newExportAbilityVal, newPrintAbilityVal, newSecretaryVal));
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_MULTIPLE_ABILITIES_CHANGED, miltipleAbilitiesChangedContent, accountToUpdateGuid, null);
            this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.USER_ABILITIES_CHANGED, Arrays.asList(accountToUpdateGuid));
            this.setUserTokensInvalidQuiet(accountToUpdateGuid);
        }
    }

    private String accountLogoProcess(Session tmpGuidSession, String userAccountGuid) {
        Path tmpLogo = this.temporaryPathManager.getFullyPath(tmpGuidSession.getItemValue());
        String fileName = tmpLogo.getFileName().toString();
        String newFileName = String.format("%s.%s", "accountLogo", FilenameUtils.getExtension((String)fileName));
        Path savedLogo = this.accountPathManager.createNewOne(userAccountGuid, newFileName, false);
        LOG.debug("tmpLogo : {} ", (Object)tmpLogo);
        LOG.debug("fileName : {} ", (Object)fileName);
        LOG.debug("newFileName : {} ", (Object)newFileName);
        LOG.debug("savedLogo : {} ", (Object)savedLogo);
        try {
            Files.createDirectories(savedLogo.getParent(), new FileAttribute[0]);
            Files.move(tmpLogo, savedLogo, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to process temporary image file ....", e);
        }
        String saveLogoRelativePath = this.accountPathManager.getRelativePath(savedLogo);
        return saveLogoRelativePath;
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class}, readOnly=true)
    public AccountInfo getBoss(String guid) {
        Account account = this.accountDao.findOne(guid);
        LOG.debug("account : {} ", (Object)account);
        Account boss = account.getBoss();
        LOG.debug("boss : {} ", (Object)boss);
        if (boss == null) {
            throw new ItemNotFoundException("Account boss not found.");
        }
        LOG.debug("AccountServiceImpl getBoss");
        return (AccountInfo)this.accountInfoDtoMapper.transformToDto((Object)boss);
    }

    public List<AccountInfo> getSubordinates(String guid) {
        List subordinates = this.accountDao.findByBossGuid(guid);
        List<AccountInfo> accountInfos = subordinates.stream().filter(account -> SecurityUtils.validUser((UserStatus)account.getStatus())).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        if (CollectionUtil.collectionEmpty(accountInfos)) {
            throw new ItemNotFoundException("Account subordinates not found.");
        }
        return accountInfos;
    }

    public List<String> getAllBossGuids(String guid) {
        ArrayList<String> bossGuids = new ArrayList<String>();
        Account account = this.accountDao.findOne(guid);
        Account boss = account.getBoss();
        if (boss != null) {
            List rBossGuids = this.getAllBossGuids(boss.getGuid());
            bossGuids.addAll(rBossGuids);
            bossGuids.add(boss.getGuid());
        }
        return bossGuids;
    }

    public List<String> findGuidsByBossGuid(List<Account> accounts, String guid) {
        LOG.debug("findGuidsByBossGuid guid={} ", (Object)guid);
        ArrayList<String> subGuids = new ArrayList<String>();
        for (int i = 0; i < accounts.size(); ++i) {
            Account account = accounts.get(i);
            if (account.getBoss() == null) continue;
            LOG.debug("findGuidsByBossGuid account.BOSS={} guid ={}", (Object)account.getBoss().getGuid(), (Object)guid);
            if (account.getBoss().getGuid().compareToIgnoreCase(guid) != 0) continue;
            LOG.debug("findGuidsByBossGuid ADD account={} ", (Object)account);
            subGuids.add(account.getGuid());
        }
        LOG.debug("findGuidsByBossGuid all subGuids={} ", subGuids);
        return subGuids;
    }

    public List<String> getSubordinateGuids(List<Account> accounts, String guid) {
        LOG.debug("getSubordinateGuids guid={} ", (Object)guid);
        List subGuids = this.findGuidsByBossGuid(accounts, guid);
        ArrayList<String> allGuids = new ArrayList<String>();
        allGuids.addAll(subGuids);
        for (int i = 0; i < subGuids.size(); ++i) {
            List guids = this.getSubordinateGuids(accounts, (String)subGuids.get(i));
            LOG.debug("getSubordinateGuids guids={} loop i={}", (Object)guids, (Object)i);
            LOG.debug("getSubordinateGuids allGuids={} loop i={}", allGuids, (Object)i);
            allGuids.addAll(guids);
            LOG.debug("getSubordinateGuids allGuids={}loop i={} ", allGuids, (Object)i);
        }
        LOG.debug("getSubordinateGuids all allGuids={} ", allGuids);
        return allGuids;
    }

    public List<String> getAllSubordinateGuids(String guid) {
        Account myAccount = this.accountDao.findOne(guid);
        LOG.debug("getAllSubordinateGuids guid={} ", (Object)guid);
        List accounts = this.accountDao.findAllbyCompany(myAccount.getCompanyGuid());
        LOG.debug("getAllSubordinateGuids accounts={} ", (Object)accounts);
        List subGuids = this.getSubordinateGuids(accounts, guid);
        LOG.debug("getAllSubordinateGuids subGuids={} ", (Object)subGuids);
        return subGuids;
    }

    public List<AccountInfo> getAccountsByStatus(String companyGuid, UserStatus ... status) {
        List<UserStatus> statuses = Arrays.asList(status);
        List accounts = this.accountDao.findByStatusIn(statuses, companyGuid);
        if (CollectionUtil.collectionEmpty((Collection)accounts)) {
            throw new ItemNotFoundException("Can't find accounts by status : " + status);
        }
        List<AccountInfo> accountInfos = accounts.stream().map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        return accountInfos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    @Deprecated
    public List<String> setAccountsStatusToResigned(List<String> accountGuids) {
        List accountsUpdateStatusToResigned = accountGuids.stream().map(accountGuid -> this.accountDao.findOne(accountGuid)).filter(Objects::nonNull).filter(account -> UserStatus.ACTIVE.equals((Object)account.getStatus())).map(account -> {
            account.setStatus(UserStatus.RESIGNED);
            account.setResignDate(new DateTime());
            return account;
        }).collect(Collectors.toList());
        this.accountDao.save(accountsUpdateStatusToResigned);
        for (Account setToResignedAccount : accountsUpdateStatusToResigned) {
            AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
            String newAccountNoticeContent = GlobalUtils.getJsonString((Object)new AccountSetToResignedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), setToResignedAccount.getDisplayName(), setToResignedAccount.getGuid()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_SET_TO_RESIGNED, newAccountNoticeContent, null, currentLoginAccount.getCompanyGuid());
        }
        List<String> accountsUnupdated = accountGuids.stream().filter(accountGuid -> {
            Account containsAccount = new Account();
            containsAccount.setGuid(accountGuid);
            boolean contains = !accountsUpdateStatusToResigned.contains(containsAccount);
            return contains;
        }).collect(Collectors.toList());
        return accountsUnupdated;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAccountLockissue(String accountEmail, AccountLockedIssue accountLockedIssue, AccountLockCase lockCase) {
        Account account = this.accountDao.findByEmailIgnoreCase(accountEmail);
        if (account != null) {
            account.setLockIssue(accountLockedIssue);
            account.setLockCase(lockCase);
            this.accountDao.save((Object)account);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAccountStatusToResigned(String setToResignedAccountGuid, String companyGuid) {
        Account setToResignedAccount = this.accountDao.findOne(setToResignedAccountGuid);
        LOG.debug("account will be setted to resigned : {}", (Object)setToResignedAccount);
        Long adminAccountCounts = this.accountDao.countByRole(UserRole.ADMIN, companyGuid);
        if (UserRole.ADMIN.equals((Object)setToResignedAccount.getRole()) && adminAccountCounts <= 1L) {
            throw new UpdateToResignedException("Fail to set account status to resigned , ADMIN account counts cannt less than 1.");
        }
        boolean validUser = SecurityUtils.validUser((UserStatus)setToResignedAccount.getStatus());
        if (!validUser) {
            throw new UpdateToResignedException("Fail to set account status to resigned , account was not ACTIVE.");
        }
        setToResignedAccount.setStatus(UserStatus.RESIGNED);
        setToResignedAccount.setResignDate(new DateTime());
        List shareTargets = setToResignedAccount.getAccountsharetargetsettings();
        shareTargets.clear();
        setToResignedAccount.setAccountsharetargetsettings(shareTargets);
        this.accountShareTargetDao.deleteBySharedaccountguid(setToResignedAccountGuid);
        this.accountDao.save((Object)setToResignedAccount);
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        String newAccountNoticeContent = GlobalUtils.getJsonString((Object)new AccountSetToResignedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), setToResignedAccount.getDisplayName(), setToResignedAccount.getGuid()));
        this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_SET_TO_RESIGNED, newAccountNoticeContent, null, companyGuid);
        this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_SET_TO_RESIGNED, Arrays.asList(setToResignedAccount.getGuid()));
        this.setUserTokensInvalidQuiet(setToResignedAccount.getGuid());
    }

    public String getAccountLogoRelativePath(String guid) throws ItemNotFoundException {
        Account account = this.accountDao.findOne(guid);
        if (account == null) {
            throw new ItemNotFoundException("can't find account logo , account not exists.");
        }
        String accountRelativePath = account.getLogoFilepath();
        if (StringUtils.isEmpty((CharSequence)accountRelativePath)) {
            throw new ItemNotFoundException(String.format("No account logo image found , account guid : %s ", guid));
        }
        return accountRelativePath;
    }

    public List<ResignedAcountInfo> getResignedAccounts(boolean inherited, String companyGuid) {
        List accounts = this.accountDao.findByStatusIn(Arrays.asList(UserStatus.RESIGNED), companyGuid);
        if (CollectionUtil.collectionEmpty((Collection)accounts)) {
            throw new ItemNotFoundException("No resigned status account found. inherited = " + inherited);
        }
        if (inherited) {
            List<ResignedAcountInfo> inheritedAndResignedAccounts = accounts.stream().filter(account -> InheritanceStatus.INHERITED.equals((Object)account.getInheritancestatus()) || InheritanceStatus.INHERITING.equals((Object)account.getInheritancestatus())).map(account -> this.getResignedAccountInfoDtoFromEntity(account)).collect(Collectors.toList());
            if (CollectionUtil.collectionEmpty(inheritedAndResignedAccounts)) {
                throw new ItemNotFoundException("No inherited and resigned account found.");
            }
            return inheritedAndResignedAccounts;
        }
        List<ResignedAcountInfo> nonInheritedAndResignedAccounts = accounts.stream().filter(account -> StringUtils.isEmpty((CharSequence)account.getInheritedAccount())).map(account -> this.getResignedAccountInfoDtoFromEntity(account)).collect(Collectors.toList());
        if (CollectionUtil.collectionEmpty(nonInheritedAndResignedAccounts)) {
            throw new ItemNotFoundException("No not inherited and resigned account found.");
        }
        return nonInheritedAndResignedAccounts;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void resetPassword(String guid) {
        Account account = this.accountDao.findOne(guid);
        String passwordAesEncodedBase64 = this.getEncryptedBase64Password("penpower");
        account.setPassword(passwordAesEncodedBase64);
        this.accountDao.save((Object)account);
        this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_PASSWORD_RESETED, Arrays.asList(guid));
        this.setUserTokensInvalidQuiet(guid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void UpdateAllAccountToTemplateInvalidate(boolean IsNeedToInvalidateToken, String companyGuid, AccountInfo currentLoginAccount, AccountLockCase lockcase, boolean hideAccountInNotice) {
        if (IsNeedToInvalidateToken) {
            List subscriptionAccounts = this.accountDao.findAllbyCompany(companyGuid).stream().filter(account -> account.getAccountSubscriptionStatus() == AccountSubscriptionStatus.IN_SUBSCRIPTION).collect(Collectors.toList());
            for (Account account2 : subscriptionAccounts) {
                if (account2.getStatus() != UserStatus.INACTIVE && account2.getStatus() != UserStatus.ACTIVE) continue;
                account2.setAccountSubscriptionStatus(AccountSubscriptionStatus.TEMPLATE_INVALIDATE);
                account2.setLockCase(lockcase);
                this.accountDao.save((Object)account2);
                String AccountToTemplateInvalidateContent = "";
                AccountToTemplateInvalidateContent = currentLoginAccount == null || hideAccountInNotice ? GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate("", "", account2.getDisplayName(), account2.getGuid())) : GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate(currentLoginAccount.getName(), currentLoginAccount.getGuid(), account2.getDisplayName(), account2.getGuid()));
                LOG.debug("UpdateAllAccountToTemplateInvalidate AccountToTemplateInvalidateContent ={}", (Object)AccountToTemplateInvalidateContent);
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_TEMPLATE_INVALIDATE, AccountToTemplateInvalidateContent, null, companyGuid);
                if (currentLoginAccount == null) {
                    this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_TEMPLATE_INVALIDATE, Arrays.asList(account2.getGuid()));
                    this.setUserTokensInvalidQuiet(account2.getGuid());
                    continue;
                }
                if (account2.getGuid().compareTo(currentLoginAccount.getGuid()) == 0) {
                    this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_TEMPLATE_INVALIDATE, Arrays.asList(account2.getGuid()));
                    continue;
                }
                this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_TEMPLATE_INVALIDATE, Arrays.asList(account2.getGuid()));
                this.setUserTokensInvalidQuiet(account2.getGuid());
            }
        } else {
            String currentLoginCompanyGuid = companyGuid;
            try {
                currentLoginCompanyGuid = currentLoginAccount.getCompanyGuid();
            }
            catch (Exception exception) {
                // empty catch block
            }
            List subscriptionAccounts = this.accountDao.findAllbyCompany(currentLoginCompanyGuid).stream().filter(account -> account.getAccountSubscriptionStatus() == AccountSubscriptionStatus.IN_SUBSCRIPTION).collect(Collectors.toList());
            for (Account account3 : subscriptionAccounts) {
                if (account3.getStatus() != UserStatus.INACTIVE && account3.getStatus() != UserStatus.ACTIVE) continue;
                account3.setAccountSubscriptionStatus(AccountSubscriptionStatus.TEMPLATE_INVALIDATE);
                account3.setLockCase(lockcase);
                this.accountDao.save((Object)account3);
                String AccountToTemplateInvalidateContent = "";
                AccountToTemplateInvalidateContent = currentLoginAccount == null || hideAccountInNotice ? GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate("", "", account3.getDisplayName(), account3.getGuid())) : GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate(currentLoginAccount.getName(), currentLoginAccount.getGuid(), account3.getDisplayName(), account3.getGuid()));
                LOG.debug("UpdateAllAccountToTemplateInvalidate AccountToTemplateInvalidateContent ={}", (Object)AccountToTemplateInvalidateContent);
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_TEMPLATE_INVALIDATE, AccountToTemplateInvalidateContent, null, companyGuid);
                this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_TEMPLATE_INVALIDATE, Arrays.asList(account3.getGuid()));
                this.setUserTokensInvalidQuiet(account3.getGuid());
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void unLockAccount(List<String> accountsGuids, String companyGuid) {
        this.updateSubscriptionStatus(accountsGuids, AccountSubscriptionStatus.IN_SUBSCRIPTION, companyGuid, AccountLockCase.NO);
        for (String accountGuid : accountsGuids) {
            Account account = this.accountDao.findOne(accountGuid);
            account.setLockIssue(AccountLockedIssue.NO_ISSUE);
            account.setLockCase(AccountLockCase.NO);
            this.accountDao.save((Object)account);
            this.loginfailedlinfoService.resetAccountLimit(account.getEmail(), FailureType.LOGIN);
            this.setUserTokensInvalidQuiet(account.getGuid());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateSubscriptionStatus(List<String> accountsGuids, AccountSubscriptionStatus accountSubscriptionStatus, String companyGuid, AccountLockCase lockCase) {
        if (accountSubscriptionStatus == AccountSubscriptionStatus.IN_SUBSCRIPTION) {
            List subscriptionAccounts = this.accountDao.findAllbyCompany(companyGuid).stream().filter(account -> this.validStatusAccount(account)).collect(Collectors.toList());
            long subscriptionCount = subscriptionAccounts.size();
            LOG.debug("updateSubscriptionStatus subscriptionCount ={}", (Object)subscriptionCount);
            long accountLimit = this.databaseSystemSettingService.getLicenseCount(companyGuid, true);
            LOG.debug("updateSubscriptionStatus accountLimit ={}", (Object)accountLimit);
            ArrayList<String> needSubAccounts = new ArrayList<String>();
            for (String accountGuid : accountsGuids) {
                boolean bFound = false;
                for (Account account2 : subscriptionAccounts) {
                    if (account2.getGuid().compareToIgnoreCase(accountGuid) != 0) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                needSubAccounts.add(accountGuid);
            }
            LOG.debug("updateSubscriptionStatus needSubAccounts ={}", (Object)needSubAccounts.size());
            if (subscriptionCount + (long)needSubAccounts.size() > accountLimit) {
                throw new LicenseCountMaxExceededException(String.format("updateSubscriptionStatus Max account count limit exceeded. (limit=%d , current=%d) ", accountLimit, needSubAccounts.size() + subscriptionAccounts.size()));
            }
            for (String accountGuid : needSubAccounts) {
                Account account3 = this.accountDao.findOne(accountGuid);
                account3.setAccountSubscriptionStatus(accountSubscriptionStatus);
                account3.setLockCase(AccountLockCase.NO);
                this.accountDao.save((Object)account3);
                this.setUserTokensInvalidQuiet(account3.getGuid());
            }
        } else {
            AccountInfo currentLoginAccount = null;
            try {
                currentLoginAccount = SecurityUtils.getCurrentLoginUser();
            }
            catch (Exception e) {
                LOG.debug("No login user error={}", (Object)e.getMessage());
            }
            for (String accountGuid : accountsGuids) {
                Account account4 = this.accountDao.findOne(accountGuid);
                if (account4.getAccountSubscriptionStatus() != AccountSubscriptionStatus.IN_SUBSCRIPTION) continue;
                account4.setAccountSubscriptionStatus(accountSubscriptionStatus);
                account4.setLockCase(lockCase);
                this.accountDao.save((Object)account4);
                String AccountToTemplateInvalidateContent = "";
                AccountToTemplateInvalidateContent = currentLoginAccount == null ? GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate("", "", account4.getDisplayName(), account4.getGuid())) : GlobalUtils.getJsonString((Object)new AccountSetToTemplateInvalidate(currentLoginAccount.getName(), currentLoginAccount.getGuid(), account4.getDisplayName(), account4.getGuid()));
                LOG.debug("UpdateAllAccountToTemplateInvalidate AccountToTemplateInvalidateContent ={}", (Object)AccountToTemplateInvalidateContent);
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_TEMPLATE_INVALIDATE, AccountToTemplateInvalidateContent, null, account4.getCompanyGuid());
                this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.ACCOUNT_TEMPLATE_INVALIDATE, Arrays.asList(account4.getGuid()));
                this.setUserTokensInvalidQuiet(account4.getGuid());
            }
        }
    }

    public void verifyAccountGuids(List<String> accountGuids) {
        if (CollectionUtils.isEmpty(accountGuids)) {
            throw new RequestArgumentNotValidException("Input account guids are null or empty.");
        }
        List distinctAccountGuids = accountGuids.stream().distinct().collect(Collectors.toList());
        List accounts = this.accountDao.findByGuidList(distinctAccountGuids);
        if (accounts.size() != distinctAccountGuids.size()) {
            throw new ItemNotFoundException("Some account guids can not be found.");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAccountUserStatus(String guid, UserStatus userstatus) {
        Account account = this.accountDao.findOne(guid);
        account.setStatus(userstatus);
        this.accountDao.save((Object)account);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void changeDisplayName(String guid, String newDisplayName) {
        Account account = this.accountDao.findOne(guid);
        account.setDisplayName(newDisplayName);
        this.accountDao.save((Object)account);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public long getAccountCountforAllCompany() {
        long accountCount = this.accountDao.findAll().stream().filter(account -> this.validStatusAccount(account)).count();
        LOG.debug("Total valid account count : {} ", (Object)accountCount);
        return accountCount;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public long getAccountCount(String companyGuid) {
        long accountCount = this.accountDao.findAllbyCompany(companyGuid).stream().filter(account -> this.validStatusAccount(account)).count();
        LOG.debug("Total valid account count : {} ", (Object)accountCount);
        return accountCount;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public long getAccountCountIncludeNotValid(String companyGuid) {
        long accountCount = this.accountDao.findAllbyCompany(companyGuid).stream().count();
        LOG.debug("Total valid account count IncludeNotValid : {} ", (Object)accountCount);
        return accountCount;
    }

    public String getAccountPasswordMd5(String email) {
        return null;
    }

    public List<AccountInfo> getAccountsByRole(String companyGuid, UserRole userRole) {
        List accounts = this.accountDao.findAllbyCompany(companyGuid);
        List<AccountInfo> accountInfos = accounts.stream().filter(account -> userRole.equals((Object)account.getRole())).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        return accountInfos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateInheritanceStatus(String accountGuid, InheritanceStatus inheritanceStatus) {
        Account account = this.accountDao.findOne(accountGuid);
        account.setInheritancestatus(inheritanceStatus);
        account.setInheritDate(new DateTime());
        this.accountDao.saveAndFlush((Object)account);
    }

    public AccountInfo getAccountInfoByDisplayName(String displayname, String companyGuid) {
        Account account = this.accountDao.findByDisplayname(displayname, companyGuid);
        if (account == null) {
            throw new ItemNotFoundException("Account not found.");
        }
        AccountInfo accountInfo = this.getDtoFromEntity(account);
        return accountInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateInheritorAccountField(String accountGuid, String inheritorAccountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        account.setInheritedAccount(inheritorAccountGuid);
        this.accountDao.save((Object)account);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void cleanInheritorAccountField(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        account.setInheritedAccount(null);
        this.accountDao.save((Object)account);
    }

    private boolean validatePublicAccount(Account account) {
        if (account == null) {
            return false;
        }
        return account.getStatus() == UserStatus.INACTIVE || account.getStatus() == UserStatus.ACTIVE;
    }

    private boolean validStatusAccount(Account account) {
        if (account == null) {
            return false;
        }
        boolean validSubscribUser = SecurityUtils.validSubscribUser((AccountSubscriptionStatus)account.getAccountSubscriptionStatus());
        boolean validUser = SecurityUtils.validUser((UserStatus)account.getStatus());
        boolean validLockUser = SecurityUtils.validLock((AccountLockedIssue)account.getLockIssue());
        return account != null && validUser && validSubscribUser && validLockUser;
    }

    public boolean verifyInheritorStatus(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        InheritanceStatus inheritanceStatus = account.getInheritancestatus();
        DateTime inheritDate = account.getInheritDate();
        LOG.debug("inheritanceStatus :{} ", (Object)inheritanceStatus);
        LOG.debug("inheritDate :{} ", (Object)inheritDate);
        return !InheritanceStatus.INHERITING.equals((Object)inheritanceStatus) || inheritDate != null;
    }

    public List<AccountInfo> getAccountByInheritanceStatus(InheritanceStatus inheriting) {
        List inheritingAccounts = this.accountDao.findByInheritancestatusIn(Arrays.asList(inheriting));
        List<AccountInfo> accountInfos = inheritingAccounts.stream().map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        return accountInfos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void resetInheriteStatus(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        account.setInheritancestatus(null);
        account.setInheritDate(null);
        account.setInheritedAccount(null);
        this.accountDao.save((Object)account);
    }

    public ResignedAcountInfo getResignedAccountInfo(String guid, String email) throws RequestArgumentNotValidException, ItemNotFoundException {
        if (this.accountQueryParamsNull(guid, email)) {
            throw new RequestArgumentNotValidException("Failed to verify account , The parameter is incorrect.");
        }
        Account account = null;
        account = StringUtils.isEmpty((CharSequence)guid) ? this.accountDao.findByEmailIgnoreCase(email) : this.accountDao.findOne(guid);
        if (account == null) {
            throw new ItemNotFoundException("Account not found.");
        }
        ResignedAcountInfo resignedAccountInfo = this.getResignedAccountInfoDtoFromEntity(account);
        return resignedAccountInfo;
    }

    public boolean verifyAccountIsInheritor(String guid) {
        long inheritorCount = this.accountDao.countByInheritor(guid, InheritanceStatus.INHERITING);
        LOG.debug("inheritorCount : {} ", (Object)inheritorCount);
        return inheritorCount > 0L;
    }

    public List<AccountInfo> getAccountInfosByType(String companyGuid, AccountType accountType) throws ItemNotFoundException {
        List accounts = this.accountDao.findByAccounttype(accountType, companyGuid);
        List<AccountInfo> accountInfos = accounts.stream().filter(account -> !UserStatus.DELETED.equals((Object)account.getStatus())).map(account -> this.getDtoFromEntity(account)).collect(Collectors.toList());
        return accountInfos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void changeActiveDirectoryAccountMail(String guid, String newAdAdcountMail) {
        Account account = this.accountDao.findOne(guid);
        account.setActivedirectoryaccountmail(newAdAdcountMail);
        this.accountDao.save((Object)account);
    }

    public boolean isSubordinateOf(String subordinateGuid, String bossGuid) {
        Account account = this.accountDao.findOne(subordinateGuid);
        while (account != null) {
            Account boss = account.getBoss();
            if (boss == null) {
                return false;
            }
            if (boss.getGuid().equals(bossGuid)) {
                return true;
            }
            account = boss;
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void resetUnderInheritingAccountsInheritanceStatus() {
        List inheritingAccounts = this.accountDao.findByInheritancestatusIn(Arrays.asList(InheritanceStatus.INHERITING));
        if (CollectionUtils.isNotEmpty((Collection)inheritingAccounts)) {
            LOG.info("Some accounts inheritance job are not finished");
            for (Account account : inheritingAccounts) {
                LOG.debug("Ready to reset inheritingAccount: {}", (Object)account.getGuid());
                account.setInheritancestatus(null);
                account.setInheritDate(null);
                account.setInheritedAccount(null);
                this.accountDao.save((Object)account);
            }
        } else {
            LOG.info("No inhering accounts found");
        }
    }

    public List<String> getAllAccountGuidsInTheSameCompany(String accountGuid) {
        Account myAccount = this.accountDao.findOne(accountGuid);
        List accounts = this.accountDao.findAllbyCompany(myAccount.getCompanyGuid());
        LOG.debug("getAllAccountGuidsInTheSameCompany accounts={} ", (Object)accounts);
        return accounts.stream().map(account -> account.getGuid()).collect(Collectors.toList());
    }
}

