/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountBindingDeviceInfoDao;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.AccountLoginRecordDao;
import com.penpower.worldcard.team.dao.AccountSecuritySettingDao;
import com.penpower.worldcard.team.dao.DeviceDao;
import com.penpower.worldcard.team.dto.AccountSecurityInfo;
import com.penpower.worldcard.team.dto.AccountSecurityInfoForCreation;
import com.penpower.worldcard.team.dto.AccountSecurityInfoForRequest;
import com.penpower.worldcard.team.dto.DeviceAndIpConstraint;
import com.penpower.worldcard.team.dto.DeviceInfoLess;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Accountbindingdeviceinfo;
import com.penpower.worldcard.team.entity.Accountloginrecord;
import com.penpower.worldcard.team.entity.Accountsecuritysetting;
import com.penpower.worldcard.team.entity.Device;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformForDevice;
import com.penpower.worldcard.team.enums.PlatformForSecurity;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.VerifySource;
import com.penpower.worldcard.team.exception.AccessWithUnbindingDeviceOrNotAllowedIpException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LoginWithUnbindingDeviceException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.notice.content.LoginWithUnbindingDeviceContent;
import com.penpower.worldcard.team.notice.event.WebSocketNoticePublisher;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.IpConstraintService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.impl.AccountSecurityServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="accountSecurityService")
@Transactional
public class AccountSecurityServiceImpl
implements AccountSecurityService {
    private static final String WEB = "WEB";
    private static final int DEVICE_ID_MAX_LENGTH = 36;
    private static final Logger LOG = LoggerFactory.getLogger(AccountSecurityServiceImpl.class);
    private static final int MAX_BINDING_DEVICE_NUMBER_FOR_EACH_PLATFORM = 2;
    private static final int MAX_NUMBER_OF_RECENT_RECORDS = 10;
    @Autowired
    private AccountSecuritySettingDao accountSecuritySettingDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private AccountLoginRecordDao accountLoginRecordDao;
    @Autowired
    private AccountBindingDeviceInfoDao accountBindingDeviceInfoDao;
    @Autowired
    private IpConstraintService ipConstraintService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    @Qualifier(value="webSocketNoticePublisher")
    private WebSocketNoticePublisher webSocketNoticePublisher;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createDefaultSecuritySettingOfAccount(Account account) {
        Accountsecuritysetting accountSecuritySetting = new Accountsecuritysetting();
        accountSecuritySetting.setAccount(account);
        accountSecuritySetting.setGuid(UUIDGenerator.getRandomUUID());
        accountSecuritySetting.setDefaultSettingValue();
        this.accountSecuritySettingDao.save((Object)accountSecuritySetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateAccountSecurityInfo(Account account, List<AccountSecurityInfoForRequest> securityInfos) {
        securityInfos = securityInfos.stream().filter(info -> !PlatformForSecurity.SCANNER.equals((Object)info.getPlatform())).collect(Collectors.toList());
        LOG.debug("Update account security info start.....");
        this.verifyPlatformNum(securityInfos);
        String accountGuid = account.getGuid();
        SecuritySetting securitySetting = new SecuritySetting(this);
        ArrayList toUpdateDevices = new ArrayList();
        for (AccountSecurityInfoForRequest accountSecurityInfoForRequest : securityInfos) {
            if (PlatformForSecurity.WEB.equals((Object)accountSecurityInfoForRequest.getPlatform())) {
                this.verifyWebRequestArgument(accountSecurityInfoForRequest, account.getRole());
            } else {
                this.verifyBindingDevice(accountSecurityInfoForRequest);
                toUpdateDevices.addAll(accountSecurityInfoForRequest.getBindingdevicesAndIpConstraint());
            }
            this.setSecuritySetting(account, securitySetting, accountSecurityInfoForRequest);
        }
        Accountsecuritysetting accountSecuritySetting = this.accountSecuritySettingDao.findByAccountGuid(accountGuid);
        accountSecuritySetting.setAllSettingValue(SecuritySetting.access$000((SecuritySetting)securitySetting), SecuritySetting.access$100((SecuritySetting)securitySetting), SecuritySetting.access$200((SecuritySetting)securitySetting), SecuritySetting.access$300((SecuritySetting)securitySetting), SecuritySetting.access$400((SecuritySetting)securitySetting), SecuritySetting.access$500((SecuritySetting)securitySetting), SecuritySetting.access$600((SecuritySetting)securitySetting), SecuritySetting.access$700((SecuritySetting)securitySetting), SecuritySetting.access$800((SecuritySetting)securitySetting));
        LOG.debug("Account security Setting :{}", (Object)accountSecuritySetting);
        this.accountSecuritySettingDao.save((Object)accountSecuritySetting);
        List list = this.accountBindingDeviceInfoDao.findByAccountGuid(accountGuid);
        account.getAccountbindingdeviceinfos().clear();
        LOG.debug("original bindingDeviceInfos: {}", (Object)list);
        this.accountBindingDeviceInfoDao.delete((Iterable)list);
        if (toUpdateDevices.size() > 0) {
            List newBindingDeviceInfos = toUpdateDevices.stream().map(d -> {
                Accountbindingdeviceinfo info = new Accountbindingdeviceinfo();
                Device device = this.deviceDao.findOne(d.getDeviceId());
                info.setGuid(UUIDGenerator.getRandomUUID());
                info.setAccount(account);
                info.setDevice(device);
                info.setIpConstraintEnable(d.getIpConstraintEnable().booleanValue());
                return info;
            }).collect(Collectors.toList());
            LOG.debug("new bindingDeviceInfos: {}", newBindingDeviceInfos);
            this.accountBindingDeviceInfoDao.save(newBindingDeviceInfos);
        } else {
            LOG.debug("new bindingDeviceInfos: {}", Collections.emptyList());
        }
    }

    private void verifyWebRequestArgument(AccountSecurityInfoForRequest info, UserRole userRole) {
        if (info.getBindingDeviceEnable() != null && info.getBindingDeviceEnable().booleanValue()) {
            throw new RequestArgumentNotValidException("Can not bind devices or set bindingDeviceEnable to true on WEB platform");
        }
        if (info.getBindingdevicesAndIpConstraint() != null && info.getBindingdevicesAndIpConstraint().size() > 0) {
            throw new RequestArgumentNotValidException("Can not bind devices or set bindingDeviceEnable to true on WEB platform");
        }
        if (userRole == UserRole.ADMIN && !info.getAccountAvailable().booleanValue()) {
            throw new RequestArgumentNotValidException("Can not set WEB availability to false of ADMIN account");
        }
    }

    private void verifyBindingDevice(AccountSecurityInfoForRequest info) {
        boolean bindingDeviceGuidsHasDuplicate;
        PlatformForDevice platformForDevice = PlatformForDevice.valueOf((String)info.getPlatform().toString());
        if (info.getBindingDeviceEnable() == null) {
            throw new RequestArgumentNotValidException("Binding deviceEnable cannot be null");
        }
        if (info.getBindingdevicesAndIpConstraint() == null) {
            info.setBindingdevicesAndIpConstraint(Collections.emptyList());
        }
        if (info.getBindingdevicesAndIpConstraint().size() > 2) {
            throw new RequestArgumentNotValidException("Can not bind more than 2 devices for each platform");
        }
        if (info.getBindingDeviceEnable().equals(false) && info.getBindingdevicesAndIpConstraint().size() > 0) {
            throw new RequestArgumentNotValidException("Can not bind device when bindingDeviceEnable is false");
        }
        List bindingdevicesAndIpConstraint = info.getBindingdevicesAndIpConstraint();
        boolean containEmptyId = bindingdevicesAndIpConstraint.stream().anyMatch(device -> StringUtils.isEmpty((CharSequence)device.getDeviceId()));
        if (containEmptyId) {
            throw new RequestArgumentNotValidException("Device id can not be null or empty");
        }
        List bindingDeviceGuids = bindingdevicesAndIpConstraint.stream().map(device -> device.getDeviceId()).collect(Collectors.toList());
        int distinctDeviceGuidNumbers = (int)bindingDeviceGuids.stream().distinct().count();
        boolean bl = bindingDeviceGuidsHasDuplicate = bindingDeviceGuids.size() != distinctDeviceGuidNumbers;
        if (bindingDeviceGuidsHasDuplicate) {
            throw new RequestArgumentNotValidException(String.format("There are duplicate deviceId at [%s] platform", platformForDevice));
        }
        List devices = this.deviceDao.findByGuidIn(bindingDeviceGuids);
        if (devices.size() != bindingDeviceGuids.size()) {
            throw new ItemNotFoundException(String.format("Some devices id are not found at [%s] platform", platformForDevice));
        }
        if (devices.stream().anyMatch(device -> GlobalUtils.getPlatformForDevice((Platform)device.getPlatform()) != platformForDevice)) {
            throw new RequestArgumentNotValidException(String.format("Some devices id are not belongs to [%s]", platformForDevice));
        }
    }

    private void setSecuritySetting(Account account, SecuritySetting securitySetting, AccountSecurityInfoForRequest info) {
        PlatformForSecurity platform = info.getPlatform();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$PlatformForSecurity[platform.ordinal()]) {
            case 1: {
                securitySetting.setIosenable(info.getAccountAvailable().booleanValue());
                securitySetting.setIosbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 2: {
                securitySetting.setAndroidenable(info.getAccountAvailable().booleanValue());
                securitySetting.setAndroidbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 3: {
                securitySetting.setWindowsenable(info.getAccountAvailable().booleanValue());
                securitySetting.setWindowsbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 4: {
                securitySetting.setMacenable(info.getAccountAvailable().booleanValue());
                securitySetting.setMacbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 5: {
                securitySetting.setWebenable(info.getAccountAvailable().booleanValue());
            }
        }
    }

    private int getPlatformNumbersExcludeScanner() {
        return PlatformForSecurity.values().length - 1;
    }

    private void verifyPlatformNum(List<AccountSecurityInfoForRequest> securityInfos) {
        int platformNum = securityInfos.size();
        if (platformNum != this.getPlatformNumbersExcludeScanner()) {
            throw new RequestArgumentNotValidException("Provided platform numbers are incorrect");
        }
        int platformDistinctNum = (int)securityInfos.stream().map(info -> info.getPlatform()).distinct().count();
        if (platformDistinctNum != platformNum) {
            throw new RequestArgumentNotValidException("Can not contain same platforms");
        }
    }

    public List<AccountSecurityInfo> getAccountSecurityInfos(String accountGuid) {
        ArrayList<AccountSecurityInfo> securityInfos = new ArrayList<AccountSecurityInfo>();
        Accountsecuritysetting securitysetting = this.accountSecuritySettingDao.findByAccountGuid(accountGuid);
        List infos = this.accountBindingDeviceInfoDao.findByAccountGuid(accountGuid);
        for (PlatformForSecurity platform : PlatformForSecurity.values()) {
            if (PlatformForSecurity.SCANNER.equals((Object)platform)) continue;
            AccountSecurityInfo securityInfo = this.getSecuityInfoByPlatform(platform, securitysetting, infos);
            securityInfos.add(securityInfo);
        }
        return securityInfos;
    }

    private AccountSecurityInfo getSecuityInfoByPlatform(PlatformForSecurity platform, Accountsecuritysetting setting, List<Accountbindingdeviceinfo> infos) {
        AccountSecurityInfo securityInfo = new AccountSecurityInfo();
        Map platformSecuritySetting = this.getPlatformSecuritySetting(setting);
        securityInfo.setPlatform(platform);
        securityInfo.setAccountAvailable(((SecurityTemp)platformSecuritySetting.get(platform)).isPlatformAvailable());
        securityInfo.setBindingDeviceEnable(((SecurityTemp)platformSecuritySetting.get(platform)).isBindingDeviceEnable());
        List devicesAndIpConstraints = infos.stream().filter(info -> GlobalUtils.getPlatformForSecurity((Platform)info.getDevice().getPlatform()) == platform).map(info -> {
            DeviceAndIpConstraint deviceAndIpConstraint = new DeviceAndIpConstraint();
            deviceAndIpConstraint.setDeviceId(info.getDevice().getGuid());
            deviceAndIpConstraint.setDeviceName(info.getDevice().getName());
            deviceAndIpConstraint.setIpConstraintEnable(Boolean.valueOf(info.isIpConstraintEnable()));
            return deviceAndIpConstraint;
        }).collect(Collectors.toList());
        securityInfo.setBindingdevicesAndIpConstraint(devicesAndIpConstraints);
        return securityInfo;
    }

    private Map<PlatformForSecurity, SecurityTemp> getPlatformSecuritySetting(Accountsecuritysetting setting) {
        HashMap<PlatformForSecurity, SecurityTemp> platformSecuritySetting = new HashMap<PlatformForSecurity, SecurityTemp>();
        platformSecuritySetting.put(PlatformForSecurity.IOS, new SecurityTemp(this, setting.isIosenable(), setting.isIosbindingenable()));
        platformSecuritySetting.put(PlatformForSecurity.ANDROID, new SecurityTemp(this, setting.isAndroidenable(), setting.isAndroidbindingenable()));
        platformSecuritySetting.put(PlatformForSecurity.WINDOWS, new SecurityTemp(this, setting.isWindowsenable(), setting.isWindowsbindingenable()));
        platformSecuritySetting.put(PlatformForSecurity.MAC, new SecurityTemp(this, setting.isMacenable(), setting.isMacbindingenable()));
        platformSecuritySetting.put(PlatformForSecurity.WEB, new SecurityTemp(this, setting.isWebenable()));
        platformSecuritySetting.put(PlatformForSecurity.SCANNER, new SecurityTemp(this, true, true));
        return platformSecuritySetting;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, noRollbackFor={LoginWithUnbindingDeviceException.class, AccessWithUnbindingDeviceOrNotAllowedIpException.class})
    public void verifyAccountSecurity(VerifySource source, String accountGuid, String remoteIpaddress, String deviceId, String deviceName, Platform platform, DateTime loginTime) {
        LOG.debug("Account security verify start........");
        LOG.debug("Login platform:{} , Verify source:{}, deviceId:{}, remoteIpaddress:{}", new Object[]{platform, source, deviceId, remoteIpaddress});
        if (Platform.SCANNER.equals((Object)platform)) {
            return;
        }
        PlatformForSecurity platformForSecurity = GlobalUtils.getPlatformForSecurity((Platform)platform);
        LOG.debug("verifyAccountSecurity deviceId={}", (Object)deviceId);
        if (VerifySource.API.equals((Object)source) && StringUtils.isNotEmpty((CharSequence)deviceId)) {
            Device device = this.deviceDao.findOne(deviceId);
            if (device == null) {
                throw new ItemNotFoundException("Device id is not found");
            }
            if (device.getPlatform() != platform) {
                throw new RequestArgumentNotValidException("Provided device and platform are not match");
            }
        }
        Accountsecuritysetting setting = this.accountSecuritySettingDao.findByAccountGuid(accountGuid);
        Map platformSecuritySetting = this.getPlatformSecuritySetting(setting);
        Account account = this.accountDao.findOne(accountGuid);
        boolean ipNeedToConstraintGlobal = this.ipConstraintService.getIpNeedToConstraint(account.getCompanyGuid());
        SecurityTemp securityTemp = (SecurityTemp)platformSecuritySetting.get(platformForSecurity);
        LOG.debug("PlatformForSecurity:{}, securityTemp:{} ", (Object)platformForSecurity, (Object)securityTemp);
        try {
            this.verifyAllSecurity(accountGuid, remoteIpaddress, deviceId, platform, ipNeedToConstraintGlobal, securityTemp);
            LOG.debug("Account security verify successfully........");
        }
        catch (LoginWithUnbindingDeviceException ex) {
            if (VerifySource.LOGIN.equals((Object)source)) {
                LOG.debug("LoginWithUnbindingDeviceException occurs");
                String loginWithUnbindingDeviceContent = GlobalUtils.getJsonString((Object)new LoginWithUnbindingDeviceContent(account.getDisplayName(), accountGuid, deviceId, deviceName, loginTime.toString("yyyy-MM-dd HH:mm:ss.SSS").toUpperCase()));
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.LOGIN_WITH_UNBINDING_DEVICE, loginWithUnbindingDeviceContent, null, account.getCompanyGuid());
                LOG.debug("LoginWithUnbindingDevice noticeContent:{}", (Object)loginWithUnbindingDeviceContent);
                throw ex;
            }
            throw new AccessWithUnbindingDeviceOrNotAllowedIpException("Access with unbinding device");
        }
    }

    private void verifyAllSecurity(String accountGuid, String remoteIpaddress, String deviceId, Platform platform, boolean ipNeedToConstraintGlobal, SecurityTemp securityTemp) {
        if (!securityTemp.isPlatformAvailable()) {
            throw new AccessWithUnbindingDeviceOrNotAllowedIpException(String.format("Account[guid=%s] cannot use platform[%s]", accountGuid, platform));
        }
        boolean usingBindingDevice = false;
        if (platform != Platform.WEB && securityTemp.isBindingDeviceEnable()) {
            List bindingDeviceIds = this.accountBindingDeviceInfoDao.findBindingDeviceGuidsByAccountAndPlatform(accountGuid, platform);
            LOG.debug("bindingDeviceIds:{}", (Object)bindingDeviceIds);
            if (bindingDeviceIds.size() == 0) {
                LOG.debug("No binding device in platform:{}, but account set bindingenable to true", (Object)platform);
                throw new LoginWithUnbindingDeviceException("Login with unbinding device");
            }
            if (!bindingDeviceIds.contains(deviceId)) {
                throw new LoginWithUnbindingDeviceException("Login with unbinding device");
            }
            usingBindingDevice = true;
        }
        if (ipNeedToConstraintGlobal) {
            boolean ipConstraintEnable = ipNeedToConstraintGlobal;
            if (usingBindingDevice) {
                ipConstraintEnable = this.accountBindingDeviceInfoDao.findByDeviceGuidAndAccountGuid(deviceId, accountGuid).isIpConstraintEnable();
                LOG.debug("Account using binding device, device ipConstraintEnable:{}", (Object)ipConstraintEnable);
                if (!ipConstraintEnable) {
                    LOG.debug("ignore ipConstraint");
                }
            }
            if (ipConstraintEnable) {
                Account account = this.accountDao.findOne(accountGuid);
                boolean ipValid = this.ipConstraintService.isIpValid(remoteIpaddress, account.getCompanyGuid());
                LOG.debug("ipValid: {}", (Object)ipValid);
                if (!ipValid) {
                    throw new AccessWithUnbindingDeviceOrNotAllowedIpException("Access with restricted IP address");
                }
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createNewLoginRecord(String accountGuid, String deviceId, String deviceName, Platform platform, DateTime clientLocalTime) {
        Account account;
        Device savedDevice = new Device();
        if (Platform.WEB != platform) {
            account = this.accountDao.findOne(accountGuid);
            Device device = this.deviceDao.findOne(deviceId);
            if (device == null) {
                device = new Device();
                device.setGuid(deviceId);
            } else if (device.getPlatform() != platform) {
                throw new RequestArgumentNotValidException("Provided device and platform are not match");
            }
            device.setName(deviceName);
            device.setPlatform(platform);
            savedDevice = (Device)this.deviceDao.saveAndFlush((Object)device);
        } else {
            account = this.accountDao.findOne(accountGuid);
            deviceId = "WEB";
            deviceName = "";
            Device device = this.deviceDao.findOne(deviceId);
            if (device == null) {
                device = new Device();
                device.setGuid(deviceId);
                device.setName(deviceName);
                device.setPlatform(Platform.WEB);
            }
            savedDevice = (Device)this.deviceDao.saveAndFlush((Object)device);
        }
        Accountloginrecord loginRecord = this.accountLoginRecordDao.findFirstByAccountGuidAndDeviceGuid(accountGuid, savedDevice.getGuid());
        if (loginRecord == null) {
            loginRecord = new Accountloginrecord();
            loginRecord.setGuid(UUIDGenerator.getRandomUUID());
            loginRecord.setAccount(account);
            loginRecord.setDevice(savedDevice);
        }
        loginRecord.setLogintime(clientLocalTime);
        LOG.debug("loginRecord to be created or updated:{}, ", (Object)loginRecord);
        this.accountLoginRecordDao.save((Object)loginRecord);
    }

    public List<DeviceInfoLess> getRecentLoginDevicesByPlatfrom(String accountGuid, PlatformForDevice platformForSecurity) {
        ArrayList<DeviceInfoLess> deviceInfos = new ArrayList();
        List platforms = GlobalUtils.getPlatformByPlatformForSecurity((PlatformForDevice)platformForSecurity);
        List devices = this.deviceDao.findRecentLoginDeviceByAccountGuidAndPlatform(accountGuid, platforms);
        deviceInfos = devices.stream().map(device -> new DeviceInfoLess(device)).limit(10L).collect(Collectors.toList());
        return deviceInfos;
    }

    public void verifyPlatformAndDevice(String deviceId, String deviceName, Platform platform) {
        if (!Platform.WEB.equals((Object)platform)) {
            if (StringUtils.isEmpty((CharSequence)deviceId) || StringUtils.isEmpty((CharSequence)deviceName)) {
                throw new RequestArgumentNotValidException("Device information is not found");
            }
            if (deviceId.length() > 36) {
                throw new RequestArgumentNotValidException(String.format("Device id is too long(max=%d)", 36));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)deviceId) || StringUtils.isNotEmpty((CharSequence)deviceName)) {
            throw new RequestArgumentNotValidException("There is no device in WEB platform");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createAccountSecuritySetting() {
        List accounts = this.accountDao.findAll();
        if (accounts != null) {
            accounts.stream().forEach(account -> {
                Accountsecuritysetting securitySetting = account.getAccountsecuritysetting();
                if (securitySetting == null) {
                    this.createDefaultSecuritySettingOfAccount(account);
                }
            });
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createAccountSecurityInfo(Account account, List<AccountSecurityInfoForCreation> securityInfos) {
        this.verifyPlatformNumForCreation(securityInfos);
        String accountGuid = account.getGuid();
        SecuritySetting securitySetting = new SecuritySetting(this);
        for (AccountSecurityInfoForCreation info : securityInfos) {
            if (PlatformForSecurity.WEB.equals((Object)info.getPlatform())) {
                this.verifyWebRequestArgumentForCreation(info, account.getRole());
            } else {
                this.verifyBindingDeviceForCreation(info);
            }
            this.setSecuritySettingForCreation(account, securitySetting, info);
        }
        Accountsecuritysetting accountSecuritySetting = new Accountsecuritysetting();
        accountSecuritySetting.setAccount(account);
        accountSecuritySetting.setGuid(UUIDGenerator.getRandomUUID());
        accountSecuritySetting.setAllSettingValue(SecuritySetting.access$000((SecuritySetting)securitySetting), SecuritySetting.access$100((SecuritySetting)securitySetting), SecuritySetting.access$200((SecuritySetting)securitySetting), SecuritySetting.access$300((SecuritySetting)securitySetting), SecuritySetting.access$400((SecuritySetting)securitySetting), SecuritySetting.access$500((SecuritySetting)securitySetting), SecuritySetting.access$600((SecuritySetting)securitySetting), SecuritySetting.access$700((SecuritySetting)securitySetting), SecuritySetting.access$800((SecuritySetting)securitySetting));
        LOG.debug("Account security Setting :{}", (Object)accountSecuritySetting);
        this.accountSecuritySettingDao.save((Object)accountSecuritySetting);
    }

    private void setSecuritySettingForCreation(Account account, SecuritySetting securitySetting, AccountSecurityInfoForCreation info) {
        PlatformForSecurity platform = info.getPlatform();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$PlatformForSecurity[platform.ordinal()]) {
            case 1: {
                securitySetting.setIosenable(info.getAccountAvailable().booleanValue());
                securitySetting.setIosbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 2: {
                securitySetting.setAndroidenable(info.getAccountAvailable().booleanValue());
                securitySetting.setAndroidbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 3: {
                securitySetting.setWindowsenable(info.getAccountAvailable().booleanValue());
                securitySetting.setWindowsbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 4: {
                securitySetting.setMacenable(info.getAccountAvailable().booleanValue());
                securitySetting.setMacbindingenable(info.getBindingDeviceEnable().booleanValue());
                break;
            }
            case 5: {
                securitySetting.setWebenable(info.getAccountAvailable().booleanValue());
            }
        }
    }

    private void verifyBindingDeviceForCreation(AccountSecurityInfoForCreation info) {
        if (info.getBindingDeviceEnable() == null) {
            throw new RequestArgumentNotValidException("Binding deviceEnable cannot be null");
        }
    }

    private void verifyWebRequestArgumentForCreation(AccountSecurityInfoForCreation info, UserRole userRole) {
        if (info.getBindingDeviceEnable() != null && info.getBindingDeviceEnable().booleanValue()) {
            throw new RequestArgumentNotValidException("Can not bind devices or set bindingDeviceEnable to true on WEB platform");
        }
        if (userRole == UserRole.ADMIN && !info.getAccountAvailable().booleanValue()) {
            throw new RequestArgumentNotValidException("Can not set WEB availability to false of ADMIN account");
        }
    }

    private void verifyPlatformNumForCreation(List<AccountSecurityInfoForCreation> securityInfos) {
        int platformNum = securityInfos.size();
        if (platformNum != this.getPlatformNumbersExcludeScanner()) {
            throw new RequestArgumentNotValidException("Provided platform numbers are incorrect");
        }
        int platformDistinctNum = (int)securityInfos.stream().map(info -> info.getPlatform()).distinct().count();
        if (platformDistinctNum != platformNum) {
            throw new RequestArgumentNotValidException("Can not contain same platforms");
        }
    }

    public DateTime getLoginTimeForbackupRestore(String email, String deviceId) {
        Account account;
        if (StringUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = "WEB";
        }
        if ((account = this.accountDao.findByEmailIgnoreCase(email)) == null) {
            return null;
        }
        Accountloginrecord loginRecord = this.accountLoginRecordDao.findFirstByAccountGuidAndDeviceGuid(account.getGuid(), deviceId);
        if (loginRecord == null) {
            return null;
        }
        return loginRecord.getLogintimeforbackuprestore();
    }

    public void updateLoginTimeForBackupRestoreRecord(String accountGuid, String deviceId, DateTime loginTimeForBackupRestore) {
        Accountloginrecord accountLoginRecord;
        if (StringUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = "WEB";
        }
        if ((accountLoginRecord = this.accountLoginRecordDao.findFirstByAccountGuidAndDeviceGuid(accountGuid, deviceId)) != null) {
            accountLoginRecord.setLogintimeforbackuprestore(loginTimeForBackupRestore);
            this.accountLoginRecordDao.save((Object)accountLoginRecord);
        }
    }
}

