/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.dao.AccountPrivateSettingDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountPrivateSettingDto;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.entity.AccountPrivateSetting;
import com.penpower.worldcard.team.enums.CRMExportMode;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.IdentificationResult;
import com.penpower.worldcard.team.enums.MapEngine;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.SortingOrder;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.SystemSettingService;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountPrivateSettingServiceImpl
implements AccountPrivateSettingService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountPrivateSettingServiceImpl.class);
    @Autowired
    private AccountPrivateSettingDao accountPrivateSettingDao;
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private AccountService accountService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserMapEngineSetting(String userGuid, MapEngine mapEngine) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setMapEngine(mapEngine);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public NameOrder getUserWesternSurnameOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        NameOrder nameOrder = accountPrivateSetting.getWesternSurnameOrder();
        return nameOrder;
    }

    private AccountPrivateSetting getPrivateSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.accountPrivateSettingDao.findByAccountGuid(userGuid);
        return accountPrivateSetting;
    }

    public NameOrder getUserAsianSurnameOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        NameOrder nameOrder = accountPrivateSetting.getAsianSurnameOrder();
        return nameOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserWesternSurnameOrder(String userGuid, NameOrder nameOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setWesternSurnameOrder(nameOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserAsianSurnameOrder(String userGuid, NameOrder nameOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setAsianSurnameOrder(nameOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    private AccountPrivateSetting getAccountPrivateSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.accountPrivateSettingDao.findByAccountGuid(userGuid);
        return accountPrivateSetting;
    }

    public boolean getShowOwner(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        return accountPrivateSetting.getShowOwnerInfo();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserShowOwner(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShowOwnerInfo(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public MapEngine getUserMapEngineSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        MapEngine mapEngine = accountPrivateSetting.getMapEngine();
        return mapEngine;
    }

    public boolean getAutoShareSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.isAutoShare();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAutoShareSetting(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setAutoShare(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareContactSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareContact();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareContactSetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareContact(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareActivitySetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareActivity();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareActivitySetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareActivity(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareTaskSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareTask();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareTaskSetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareTask(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getLastNoticeCountView(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        DateTime lastNoticeCountView = Optional.ofNullable(accountPrivateSetting.getLastNoticeCountView()).orElse(new DateTime());
        return lastNoticeCountView;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setLastNoticeCountView(String userGuid, DateTime dateTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setLastNoticeCountView(dateTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public SortingOrder getSortingOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        SortingOrder sortingOrder = accountPrivateSetting.getSortingOrder();
        return sortingOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setSortingOrder(String userGuid, SortingOrder sortingOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setSortingOrder(sortingOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setIdentificationResult(String userGuid, IdentificationResult identificationResult) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setIdentificationResult(identificationResult);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public IdentificationResult getIdentificationResult(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        IdentificationResult identificationResult = accountPrivateSetting.getIdentificationResult();
        return identificationResult;
    }

    public AccountPrivateSettingDto getAllUserSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        AccountPrivateSettingDto dto = new AccountPrivateSettingDto();
        dto.setAsianSurnameOrder(accountPrivateSetting.getAsianSurnameOrder());
        dto.setWesternSurnameOrder(accountPrivateSetting.getWesternSurnameOrder());
        dto.setIdentificationResult(accountPrivateSetting.getIdentificationResult());
        dto.setSortingOrder(accountPrivateSetting.getSortingOrder());
        dto.setMapEngine(accountPrivateSetting.getMapEngine());
        dto.setAutoShare(accountPrivateSetting.isAutoShare());
        dto.setModifytime(accountPrivateSetting.getModifytime());
        AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
        ShareRule shareRule = this.systemSettingService.getShareRule(accountInfo);
        dto.setGlobalShareRule(shareRule);
        List contactShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.CONTACT);
        dto.setContactShareTargets(contactShareTargets);
        List taskShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.TASK);
        dto.setTaskShareTargets(taskShareTargets);
        List activityShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.ACTIVITY);
        dto.setActivityShareTargets(activityShareTargets);
        dto.setUserCRMAccount(accountPrivateSetting.getUsercrmaccount());
        dto.setUserCRMExportMode(accountPrivateSetting.getCrmexportmode());
        dto.setUserCRMPassword(accountPrivateSetting.getUsercrmpassword());
        dto.setUserCRMSecretToken(accountPrivateSetting.getUsercrmsecrettoken());
        dto.setUserStoredCRMType(accountPrivateSetting.getUserstoredcrmtype());
        dto.setLastexporttime(accountPrivateSetting.getLastexporttime());
        dto.setLastexportcount(accountPrivateSetting.getLastexportcount());
        dto.setLastexportresult(accountPrivateSetting.getLastexportresult());
        return dto;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMSettings(String userGuid, CRMSettingsDto CRMSettingsDto2) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        try {
            AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
            SupportCRM currentSystemCRM = this.systemSettingService.getSystemCRM(accountInfo);
            accountPrivateSetting.setUserstoredcrmtype(currentSystemCRM);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        accountPrivateSetting.setCrmexportmode(CRMSettingsDto2.getUserCRMExportMode());
        accountPrivateSetting.setUsercrmaccount(CRMSettingsDto2.getUserCRMAccount());
        accountPrivateSetting.setUsercrmpassword(CRMSettingsDto2.getUserCRMPassword());
        accountPrivateSetting.setUsercrmsecrettoken(CRMSettingsDto2.getUserCRMSecretToken());
        accountPrivateSetting.setUsercrmtokentype(SalesForceOAuthTokenType.USERNAME_PASSWORD);
        accountPrivateSetting.setModifytime(new DateTime());
        LOG.debug("set crm settings....");
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public CRMSettingsDto getUserCRMSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        if (this.CRMSettingsNull(accountPrivateSetting)) {
            throw new ItemNotFoundException("No user CRM settings found.");
        }
        CRMSettingsDto CRMSettingsDto2 = new CRMSettingsDto();
        CRMSettingsDto2.setUserCRMAccount(accountPrivateSetting.getUsercrmaccount());
        CRMSettingsDto2.setUserCRMPassword(accountPrivateSetting.getUsercrmpassword());
        CRMSettingsDto2.setUserCRMSecretToken(accountPrivateSetting.getUsercrmsecrettoken());
        CRMSettingsDto2.setUserCRMExportMode(accountPrivateSetting.getCrmexportmode());
        return CRMSettingsDto2;
    }

    private boolean CRMSettingsNull(AccountPrivateSetting accountPrivateSetting) {
        String crmAccount = accountPrivateSetting.getUsercrmaccount();
        String crmPassword = accountPrivateSetting.getUsercrmpassword();
        String crmSecurityToken = accountPrivateSetting.getUsercrmsecrettoken();
        CRMExportMode crmExportMode = accountPrivateSetting.getCrmexportmode();
        boolean CRMAccountSettingsAnyoneEmpty = StringUtils.isEmpty((CharSequence)crmAccount) || StringUtils.isEmpty((CharSequence)crmPassword) || StringUtils.isEmpty((CharSequence)crmSecurityToken);
        LOG.debug("CRMAccountSettingsAnyoneEmpty : {} ", (Object)CRMAccountSettingsAnyoneEmpty);
        boolean CRMSettingsNull = CRMAccountSettingsAnyoneEmpty || crmExportMode == null;
        LOG.debug("CRMSettingsNull : {} ", (Object)CRMSettingsNull);
        if (CRMSettingsNull) {
            String accessToken = accountPrivateSetting.getCrmlogintoken();
            boolean userAgentIncorrectParams = StringUtils.isEmpty((CharSequence)crmAccount) || crmExportMode == null || StringUtils.isEmpty((CharSequence)accessToken);
            LOG.debug("userAgentIncorrectParams : {} ", (Object)userAgentIncorrectParams);
            return userAgentIncorrectParams;
        }
        return CRMSettingsNull;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void cleanUserCRMSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setUsercrmaccount(null);
        accountPrivateSetting.setUsercrmpassword(null);
        accountPrivateSetting.setUsercrmsecrettoken(null);
        accountPrivateSetting.setUserstoredcrmtype(null);
        accountPrivateSetting.setConsumerkey(null);
        accountPrivateSetting.setConsumersecret(null);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public String getUserCRMLoginToken(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        return accountPrivateSetting.getCrmlogintoken();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeUserCRMloginToken(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmlogintoken(null);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMloginToken(String userGuid, String authString, SalesForceOAuthTokenType userCRMTokenType) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmlogintoken(authString);
        accountPrivateSetting.setUsercrmtokentype(userCRMTokenType);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public SalesForceOAuthTokenType getUserCRMTokenType(String currentLoginUserGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(currentLoginUserGuid);
        return accountPrivateSetting.getUsercrmtokentype();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMExportMode(String userGuid, CRMExportMode CRMExportMode2) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmexportmode(CRMExportMode2);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public NameDisplayOrderSettingType getNameDisplayOrderSettingByAccount(String accountGuid) {
        return this.getNameDisplayOrderSetting(accountGuid);
    }

    public NameDisplayOrderSettingType getNameDisplayOrderSetting() {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        return this.getNameDisplayOrderSetting(loginAccount.getGuid());
    }

    private NameDisplayOrderSettingType getNameDisplayOrderSetting(String accountGuid) {
        NameOrder eastNameOrder = this.getUserAsianSurnameOrder(accountGuid);
        NameOrder westNameOrder = this.getUserWesternSurnameOrder(accountGuid);
        if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)eastNameOrder)) {
            if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)westNameOrder)) {
                return NameDisplayOrderSettingType.EAST_FL_WEST_FL;
            }
            return NameDisplayOrderSettingType.EAST_FL_WEST_LF;
        }
        if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)westNameOrder)) {
            return NameDisplayOrderSettingType.EAST_LF_WEST_FL;
        }
        return NameDisplayOrderSettingType.EAST_LF_WEST_LF;
    }

    public String getUserCRMExportResult(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        return accountPrivateSetting.getLastexportresult();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMExportInfo(String userGuid, int exportCount, DateTime exportTime, String exportResult) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setLastexportcount(exportCount);
        accountPrivateSetting.setLastexporttime(exportTime);
        accountPrivateSetting.setLastexportresult(exportResult);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isManualExportToCRM(String accountGuid) {
        CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
        return CRMExportMode.MANUAL_EXPORT.equals((Object)crmSettingsDto.getUserCRMExportMode());
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isAutoSyncWithCRM(String accountGuid) {
        CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
        return CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmSettingsDto.getUserCRMExportMode());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class}, readOnly=false)
    public void resetUserCRMsettings(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setUsercrmaccount("");
        accountPrivateSetting.setUsercrmpassword("");
        accountPrivateSetting.setUsercrmsecrettoken("");
        accountPrivateSetting.setCrmlogintoken("");
        accountPrivateSetting.setCrmexportmode(CRMExportMode.MANUAL_EXPORT);
        accountPrivateSetting.setUsercrmtokentype(SalesForceOAuthTokenType.USERNAME_PASSWORD);
        accountPrivateSetting.setUserstoredcrmtype(SupportCRM.SALESFORCE);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(null);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(null);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CrmTargetType getCrmAutoExportTargetType(String accountGuid) {
        CrmTargetType type = null;
        AccountInfo accountInfo = this.accountService.getAccountInfo(accountGuid, null);
        SupportCRM supportCRM = this.systemSettingService.getSystemCRM(accountInfo);
        if (SupportCRM.SALESFORCE.equals((Object)supportCRM)) {
            CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
            if (!CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmSettingsDto.getUserCRMExportMode())) throw new ItemNotFoundException("There is no auto export CRM settings for this account.");
            return CrmTargetType.SALESFORCE_CONTACT;
        }
        if (!SupportCRM.SUGAR_CRM.equals((Object)supportCRM)) throw new ItemNotFoundException("There is no auto export CRM settings for this account.");
        return CrmTargetType.SUGAR_CRM;
    }

    public DateTime getCrmSyncLastCompletedTimeForWCT(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getCrmSyncLastCompletedTimeForWCT();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setCrmSyncLastCompletedTimeForWCT(String accountGuid, DateTime modifiedTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(modifiedTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getCrmSyncLastCompletedTimeForCRM(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getCrmSyncLastCompletedTimeForCRM();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setCrmSyncLastCompletedTimeForCRM(String accountGuid, DateTime modifiedTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(modifiedTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setLastDeeplyDeletedContactTime(String accountGuid, DateTime time) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setLastDeeplyDeletedContactTime(time);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getLastDeeplyDeletedContactTime(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getLastDeeplyDeletedContactTime();
    }
}

