/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.search;

import com.penpower.worldcard.team.dao.NormalSearchDao;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.enums.NormalSearchRule;
import com.penpower.worldcard.team.search.DatabaseSearchMechanism;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseSearchMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseSearchMechanism.class);
    protected NormalSearchDao normalSearchDao;

    public DatabaseSearchMechanism(NormalSearchDao normalSearchDao) {
        this.normalSearchDao = normalSearchDao;
    }

    public List<String> searchGuidsByKeyword(String lowerCaseKeyword, ContactRangeType contactRangeType, String accountGuid, boolean isAdmin, String orderByString) {
        NormalSearchRule rule = this.checkNormalSearchRule(lowerCaseKeyword);
        LOG.debug("search rule : {} ", (Object)rule);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$NormalSearchRule[rule.ordinal()]) {
            case 1: {
                return this.doSearchRuleEqual_1(lowerCaseKeyword, contactRangeType, accountGuid, isAdmin, orderByString);
            }
            case 2: {
                return this.doSearchRuleEqual_2(lowerCaseKeyword, contactRangeType, accountGuid, isAdmin, orderByString);
            }
        }
        return this.doSearchRuleDefault(lowerCaseKeyword, contactRangeType, accountGuid, isAdmin, orderByString);
    }

    protected abstract NormalSearchRule checkNormalSearchRule(String var1);

    protected abstract List<String> doSearchRuleEqual_1(String var1, ContactRangeType var2, String var3, boolean var4, String var5);

    protected abstract List<String> doSearchRuleEqual_2(String var1, ContactRangeType var2, String var3, boolean var4, String var5);

    protected List<String> doSearchRuleDefault(String keyWord, ContactRangeType contactRangeType, String accountGuid, boolean isAdmin, String orderByString) {
        if (ContactRangeType.PUBLIC.equals((Object)contactRangeType)) {
            return this.internalPublicSearch(keyWord, null, contactRangeType, accountGuid, isAdmin, orderByString);
        }
        return this.normalSearchDao.findUserPrivateContactByKeyword(keyWord, accountGuid, orderByString);
    }

    protected List<String> internalPublicSearch(String keyWord, String keyWord2, ContactRangeType contactRangeType, String accountGuid, boolean isAdmin, String orderByString) {
        if (isAdmin) {
            if (keyWord != null && keyWord2 != null) {
                LOG.debug("Two keywords..ADMIN public");
                return this.normalSearchDao.findAdminUserPublicContactByTwoKeyword(keyWord, keyWord2, orderByString);
            }
            return this.normalSearchDao.findAdminUserPublicContactByKeyword(keyWord, orderByString);
        }
        if (keyWord != null && keyWord2 != null) {
            LOG.debug("Two keywords..public");
            return this.normalSearchDao.findUserPublicContactGuidsByTwoKeywords(keyWord, keyWord2, accountGuid, orderByString);
        }
        return this.normalSearchDao.findUserPublicContactGuidsByKeyword(keyWord, accountGuid, orderByString);
    }
}

