/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.search;

import com.hankcs.hanlp.HanLP;
import com.penpower.worldcard.team.dao.NormalSearchDao;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.enums.NormalSearchRule;
import com.penpower.worldcard.team.enums.UnicodeFontType;
import com.penpower.worldcard.team.search.DatabaseSearchMechanism;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseSearchMechanism
extends DatabaseSearchMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(ChineseSearchMechanism.class);

    protected NormalSearchRule checkNormalSearchRule(String keyWord) {
        String sourceKeyWord = keyWord;
        String big5KeyWord = this.getKeyWordByUnicodeType(keyWord, UnicodeFontType.BIG5);
        String gbKeyWord = this.getKeyWordByUnicodeType(keyWord, UnicodeFontType.GB);
        boolean allEquals = sourceKeyWord.equals(big5KeyWord) && sourceKeyWord.equals(gbKeyWord);
        boolean allNotEquals = !sourceKeyWord.equals(big5KeyWord) && !sourceKeyWord.equals(gbKeyWord);
        boolean equal_1_Big5 = sourceKeyWord.equals(big5KeyWord) && !sourceKeyWord.equals(gbKeyWord);
        boolean equal_2_gb = sourceKeyWord.equals(gbKeyWord) && !sourceKeyWord.equals(big5KeyWord);
        this.printDebugInfo(sourceKeyWord, big5KeyWord, gbKeyWord, allEquals, allNotEquals, equal_1_Big5, equal_2_gb);
        if (allEquals) {
            return NormalSearchRule.KEYWORD_ALL_EQUALS;
        }
        if (equal_1_Big5) {
            return NormalSearchRule.KEYWORD_EQUAL_1;
        }
        if (equal_2_gb) {
            return NormalSearchRule.KEYWORD_EQUAL_2;
        }
        return NormalSearchRule.KEYWORD_ALL_NOT_EQUALS;
    }

    private void printDebugInfo(String sourceKeyWord, String big5KeyWord, String gbKeyWord, boolean allEquals, boolean allNotEquals, boolean equal_1_Big5, boolean equal_2_gb) {
        LOG.debug("-------- Check normal search rule ---------");
        LOG.debug("\tsourceKeyWord : {} ", (Object)sourceKeyWord);
        LOG.debug("\tbig5KeyWord : {} ", (Object)big5KeyWord);
        LOG.debug("\tgbKeyWord : {} ", (Object)gbKeyWord);
        LOG.debug("\tallEquals : {} ", (Object)allEquals);
        LOG.debug("\tallNotEquals : {} ", (Object)allNotEquals);
        LOG.debug("\tequal_1_Big5 : {} ", (Object)equal_1_Big5);
        LOG.debug("\tequal_2_gb : {} ", (Object)equal_2_gb);
    }

    private String getKeyWordByUnicodeType(String keyWord, UnicodeFontType unicodeFontType) {
        try {
            char[] chars = keyWord.toCharArray();
            StringBuilder sb = new StringBuilder();
            for (char c : chars) {
                if (UnicodeFontType.BIG5.equals((Object)unicodeFontType)) {
                    sb.append(HanLP.convertToTraditionalChinese((String)String.valueOf(c)));
                    continue;
                }
                sb.append(HanLP.convertToSimplifiedChinese((String)String.valueOf(c)));
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return keyWord;
        }
    }

    public ChineseSearchMechanism(NormalSearchDao normalSearchDao) {
        super(normalSearchDao);
    }

    protected List<String> doSearchRuleEqual_1(String keyWord, ContactRangeType contactRangeType, String accountGuid, boolean isAdmin, String orderByString) {
        String gbKeyWord = this.getKeyWordByUnicodeType(keyWord, UnicodeFontType.GB);
        if (ContactRangeType.PUBLIC.equals((Object)contactRangeType)) {
            return this.internalPublicSearch(keyWord, gbKeyWord, contactRangeType, accountGuid, isAdmin, orderByString);
        }
        return this.normalSearchDao.findUserPrivateContactByTwoKeywords(keyWord, gbKeyWord, accountGuid, orderByString);
    }

    protected List<String> doSearchRuleEqual_2(String keyWord, ContactRangeType contactRangeType, String accountGuid, boolean isAdmin, String orderByString) {
        String big5KeyWord = this.getKeyWordByUnicodeType(keyWord, UnicodeFontType.BIG5);
        if (ContactRangeType.PUBLIC.equals((Object)contactRangeType)) {
            return this.internalPublicSearch(keyWord, big5KeyWord, contactRangeType, accountGuid, isAdmin, orderByString);
        }
        return this.normalSearchDao.findUserPrivateContactByTwoKeywords(keyWord, big5KeyWord, accountGuid, orderByString);
    }
}

