/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.enums.MonitorType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SystemMonitorService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SystemPerformanceMonitorJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(SystemPerformanceMonitorJob.class);
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SystemMonitorService systemMonitorService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ServerType serverType = this.registryService.GetServerType();
        LOG.debug("SystemPerformanceMonitorJob started, serverType:{}", (Object)serverType);
        if (serverType == ServerType.ASUSTOR_NAS_AUTOMATION || serverType == ServerType.ASUSTOR_NAS_Cloud || serverType == ServerType.Linux_Server_Cloud || serverType == ServerType.Google_Linux_Server_Cloud) {
            this.systemMonitorService.executeMonitorOnce(MonitorType.CPU_USAGE_PERCENTAGE);
        }
        LOG.debug("SystemPerformanceMonitorJob finished");
    }
}

