/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.StorageSpaceNotEnoughException;
import com.penpower.worldcard.team.notice.content.CrmSyncResultContent;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SyncContactsOfAccountsWithSalesforceJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SyncContactsOfAccountsWithSalesforceJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private SalesForceTokenService salesForceTokenService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("==============SyncContactsOfAccountsWithSalesforceJob start===============");
        this.thisContext = context;
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            throw new StorageSpaceNotEnoughException("Disk space is not enough, CRM sync process is stopped.");
        }
        List companys = this.companyService.FindAllCompany();
        for (Company company : companys) {
            List accountInfos = new ArrayList();
            try {
                accountInfos = this.accountService.getAccountsByStatus(company.getGuid(), new UserStatus[]{UserStatus.ACTIVE});
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            for (AccountInfo account : accountInfos) {
                String accountGuid = account.getGuid();
                LOG.debug("accountGuid:{}, account.getName():{}", (Object)accountGuid, (Object)account.getName());
                try {
                    CrmTargetType crmTargetType = CrmTargetType.SALESFORCE_CONTACT;
                    boolean isAutoSyncWithCRM = false;
                    isAutoSyncWithCRM = this.accountPrivateSettingService.isAutoSyncWithCRM(accountGuid);
                    if (!isAutoSyncWithCRM) {
                        LOG.debug("CRM export settings is not auto({}, {})", (Object)accountGuid, (Object)account.getName());
                        continue;
                    }
                    crmTargetType = this.accountPrivateSettingService.getCrmAutoExportTargetType(accountGuid);
                    CRMOperationService crmOperationService = GlobalUtils.getCrmOperationService((CrmTargetType)crmTargetType);
                    BasicToken basicToken = null;
                    try {
                        basicToken = this.salesForceTokenService.retrieveToken(accountGuid);
                        if (basicToken instanceof NullCRMToken) {
                            throw new CRMOperationException("Get basicToken is NullCRMToken.");
                        }
                    }
                    catch (CRMOperationException e) {
                        LOG.error("Get CRM access token for this account failed.({}, {})", (Object)accountGuid, (Object)account.getName());
                        this.checkIfSendNoticeAndSetExportResult(accountGuid, "Get CRM access token for this account failed.", "Get CRM access token for this account failed.", NotifyType.GET_CRM_TOKEN_FAILED, 0);
                        continue;
                    }
                    CrmSyncResultContent result = new CrmSyncResultContent();
                    if (isAutoSyncWithCRM) {
                        CrmSyncResultContent resultExport = this.exportContactsInPrivate(accountGuid, crmOperationService, basicToken);
                        result.appendResultContent(resultExport);
                    }
                    if (isAutoSyncWithCRM && CollectionUtils.isEmpty((Collection)result.getFailedList())) {
                        CrmSyncResultContent resultImport = this.importRecordsIntoPrivate(accountGuid, crmOperationService, basicToken);
                        result.appendResultContent(resultImport);
                    }
                    if (CollectionUtils.isEmpty((Collection)result.getFailedList())) continue;
                    NotifyType notifyType = isAutoSyncWithCRM ? NotifyType.CONTACT_SYNC_WITH_CRM : NotifyType.CONTACT_EXPORTED;
                    this.checkIfSendNoticeAndSetExportResult(accountGuid, GlobalUtils.getJsonString((Object)result), GlobalUtils.getJsonString((Object)result.getFailedList()), notifyType, result.getNumSucceeded());
                }
                catch (Exception e) {
                    LOG.debug("Account({},{}) encounter exception in sync process: {}", new Object[]{accountGuid, account.getName(), e.getMessage()});
                }
            }
        }
        LOG.debug("==============SyncContactsOfAccountsWithSalesforceJob end===============");
    }

    private CrmSyncResultContent exportContactsInPrivate(String accountGuid, CRMOperationService crmOperationService, BasicToken basicToken) {
        DateTime lastSyncCompletedTime = this.accountPrivateSettingService.getCrmSyncLastCompletedTimeForWCT(accountGuid);
        List contactsNeedSync = crmOperationService.getWctSyncInfosByAccount(accountGuid, lastSyncCompletedTime);
        CrmSyncResultContent result = new CrmSyncResultContent();
        boolean isCheckMode = false;
        for (ContactCrmSyncInfoForWCT syncInfo : contactsNeedSync) {
            String contactGuid = syncInfo.getContactGuid();
            try {
                CrmSyncActionType crmActionType = this.syncContactFromWCT(syncInfo, accountGuid, crmOperationService, basicToken, isCheckMode);
                if (!isCheckMode) {
                    this.accountPrivateSettingService.setCrmSyncLastCompletedTimeForWCT(accountGuid, syncInfo.getModifiedTime());
                }
                this.dealWithCrmSyncResult(result, crmActionType);
            }
            catch (Exception e) {
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                result.getFailedList().add(new ContactFailToExport(contactGuid, e.getMessage(), infoDto.getFullname(), infoDto.getCompany()));
                LOG.debug("syncContactFromWCT fail(account guid:{}, contact guid:{})", (Object)accountGuid, (Object)contactGuid);
                LOG.debug("syncContactFromWCT fail:{}", (Throwable)e);
                isCheckMode = true;
            }
        }
        return result;
    }

    private void dealWithCrmSyncResult(CrmSyncResultContent result, CrmSyncActionType crmActionType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$scheduler$job$SyncContactsOfAccountsWithSalesforceJob$CrmSyncActionType[crmActionType.ordinal()]) {
            case 1: {
                result.increaseNumCrmAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 2: {
                result.increaseNumCrmUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 3: {
                result.increaseNumCrmDelete();
                result.increaseNumSucceeded();
                break;
            }
            case 4: {
                result.increaseNumWctAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 5: {
                result.increaseNumWctUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 6: {
                result.increaseNumWctDelete();
                result.increaseNumSucceeded();
                break;
            }
        }
    }

    private CrmSyncResultContent importRecordsIntoPrivate(String accountGuid, CRMOperationService crmOperationService, BasicToken basicToken) {
        DateTime lastSyncCompletedTime = this.accountPrivateSettingService.getCrmSyncLastCompletedTimeForCRM(accountGuid);
        List crmRecordsNeedSync = crmOperationService.getCrmSyncInfosByAccount(accountGuid, lastSyncCompletedTime, basicToken);
        CrmSyncResultContent result = new CrmSyncResultContent();
        for (ContactCrmSyncInfoForCRM syncInfo : crmRecordsNeedSync) {
            try {
                CrmSyncActionType crmSyncActionType = this.syncContactFromCRM(syncInfo, accountGuid, crmOperationService, basicToken);
                this.accountPrivateSettingService.setCrmSyncLastCompletedTimeForCRM(accountGuid, syncInfo.getModifiedTime());
                this.dealWithCrmSyncResult(result, crmSyncActionType);
            }
            catch (Exception e) {
                result.getFailedList().add(new ContactFailToExport("", e.getMessage(), "", ""));
                LOG.debug("syncContactFromCRM fail(account guid:{}, CRM ID:{})", (Object)accountGuid, (Object)syncInfo.getCrmID());
                LOG.debug("syncContactFromCRM fail:{}", (Throwable)e);
                break;
            }
        }
        return result;
    }

    private CrmSyncActionType syncContactFromCRM(ContactCrmSyncInfoForCRM syncInfoCRM, String accountGuid, CRMOperationService crmService, BasicToken basicToken) {
        String crmID = syncInfoCRM.getCrmID();
        if (syncInfoCRM.isDeleted().booleanValue()) {
            ContactCrmSyncInfoForWCT syncInfoWCT = crmService.getWctSyncInfoByCorrespondingCrmSyncInfo(accountGuid, syncInfoCRM);
            if (syncInfoWCT != null && !syncInfoWCT.isDeleted().booleanValue()) {
                LOG.debug("[syncContactFromCRM]WCT_DELETE");
                this.contactPrivateService.updateCategoriesOfContact(syncInfoWCT.getContactGuid(), null, accountGuid, ListSetBehavior.REMOVE_ALL, null);
                crmService.setExportCrmInfo(accountGuid, syncInfoWCT.getContactGuid(), syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
                return CrmSyncActionType.WCT_DELETE;
            }
            LOG.debug("[syncContactFromCRM]NONE - if (syncInfoCRM.isDeleted())");
            return CrmSyncActionType.NONE;
        }
        ContactCrmSyncInfoForWCT syncInfoWCT = crmService.getWctSyncInfoByCorrespondingCrmSyncInfo(accountGuid, syncInfoCRM);
        if (syncInfoWCT == null) {
            LOG.debug("[syncContactFromCRM]WCT_ADD");
            ContactCreationVo contactCreationVo = crmService.getContactCreationVoByCrmID(accountGuid, crmID, basicToken);
            AccountInfo accountinfo = this.accountService.getAccountInfo(accountGuid, null);
            if (accountinfo != null) {
                String contactGuid = this.contactPrivateService.createContact(contactCreationVo, null, null, null, accountinfo.getCompanyGuid());
                crmService.setExportCrmInfo(accountGuid, contactGuid, syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
            }
            return CrmSyncActionType.WCT_ADD;
        }
        if (!syncInfoWCT.isDeleted().booleanValue() && syncInfoCRM.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getPreviousCrmModifiedTime()) && syncInfoCRM.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getModifiedTime())) {
            LOG.debug("[syncContactFromCRM]WCT_UPDATE");
            ContactInfoVoForWCT originContact = this.contactPrivateService.getContactInfoVoForWCTByGuid(syncInfoWCT.getContactGuid(), accountGuid);
            ContactUpdateVo vo = crmService.getContactUpdateVoByCrmID(syncInfoWCT, basicToken, (ContactInfoForRequest)originContact);
            this.contactPrivateService.updateContact(vo, accountGuid);
            crmService.setExportCrmInfo(accountGuid, syncInfoWCT.getContactGuid(), syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
            return CrmSyncActionType.WCT_UPDATE;
        }
        LOG.debug("[syncContactFromCRM]NONE");
        return CrmSyncActionType.NONE;
    }

    private CrmSyncActionType syncContactFromWCT(ContactCrmSyncInfoForWCT syncInfoWCT, String accountGuid, CRMOperationService crmService, BasicToken basicToken, boolean isCheckMode) {
        ContactCrmSyncInfoForCRM syncInfoCRM = null;
        if (syncInfoWCT.isDeleted().booleanValue()) {
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - if (syncInfoWCT.isDeleted()) && if (isCheckMode)");
                return CrmSyncActionType.NONE;
            }
            syncInfoCRM = this.getCorrespondingInCRM(syncInfoWCT, accountGuid, crmService, basicToken);
            if (syncInfoCRM != null && !syncInfoCRM.isDeleted().booleanValue()) {
                LOG.debug("[syncContactFromWCT]CRM_DELETE");
                crmService.deleteRecord(accountGuid, syncInfoWCT.getCrmID(), syncInfoWCT.getContactGuid(), true, basicToken);
                return CrmSyncActionType.CRM_DELETE;
            }
            LOG.debug("[syncContactFromWCT]NONE - if (syncInfoWCT.isDeleted())");
            return CrmSyncActionType.NONE;
        }
        syncInfoCRM = this.getCorrespondingInCRM(syncInfoWCT, accountGuid, crmService, basicToken);
        if (syncInfoCRM == null || syncInfoCRM.isDeleted().booleanValue() && syncInfoCRM.getModifiedTime().equals((Object)syncInfoWCT.getPreviousCrmModifiedTime())) {
            ContactInfoForResponse contact = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - exportContactCheck(), exportContactToCRM()");
                crmService.exportContactCheck(contact);
                return CrmSyncActionType.NONE;
            }
            LOG.debug("[syncContactFromWCT]CRM_ADD");
            crmService.exportContactToCRM(accountGuid, contact, true, basicToken);
            return CrmSyncActionType.CRM_ADD;
        }
        if (!syncInfoCRM.isDeleted().booleanValue() && syncInfoWCT.getModifiedTime().isAfter((ReadableInstant)syncInfoCRM.getModifiedTime())) {
            ContactInfoForResponse contact = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - exportContactCheck(), updateContactToCRM()");
                crmService.exportContactCheck(contact);
                return CrmSyncActionType.NONE;
            }
            LOG.debug("[syncContactFromWCT]CRM_UPDATE");
            crmService.updateContactToCRM(accountGuid, contact, syncInfoWCT.getCrmID(), true, basicToken);
            return CrmSyncActionType.CRM_UPDATE;
        }
        LOG.debug("[syncContactFromWCT]NONE");
        return CrmSyncActionType.NONE;
    }

    private ContactCrmSyncInfoForCRM getCorrespondingInCRM(ContactCrmSyncInfoForWCT syncInfo, String accountGuid, CRMOperationService crmService, BasicToken basicToken) {
        if (StringUtil.IsStringNullorEmpty((String)syncInfo.getCrmID())) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        if (!crmSettingsDto.getUserCRMAccount().equals(syncInfo.getSyncCrmAccount())) {
            return null;
        }
        ContactCrmSyncInfoForCRM syncInfoCRM = crmService.getRecordSyncInfo(accountGuid, syncInfo.getCrmID(), basicToken);
        if (syncInfoCRM == null) {
            return null;
        }
        return syncInfoCRM;
    }

    private void checkIfSendNoticeAndSetExportResult(String accountGuid, String exportResultContentString, String checkSameNoticeString, NotifyType notifyType, int exportCount) {
        String lastExportResultContentString = this.accountPrivateSettingService.getUserCRMExportResult(accountGuid);
        String str1 = checkSameNoticeString;
        String str2 = lastExportResultContentString;
        if (StringUtil.IsStringNullorEmpty((String)str2) || !str1.equals(str2)) {
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, notifyType, exportResultContentString, accountGuid, null);
        }
        this.accountPrivateSettingService.setUserCRMExportInfo(accountGuid, exportCount, new DateTime(), checkSameNoticeString);
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

