/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.SystemInitialMainInfoBuilder;
import javax.mail.internet.MimeMessage;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SendMailJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SendMailJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    public static final String SEND_EMAIL = "SEND_EMAIL";
    public static final String SEND_USERNAME = "SEND_USERNAME";
    public static final String SEND_LANGUAGECODE = "SEND_LANGUAGECODE";
    private JobExecutionContext thisContext;
    @Autowired
    private JavaMailSender javaMailSender;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("==============SendMailJob start===============");
        this.thisContext = context;
        try {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            String email = dataMap.getString(SEND_EMAIL);
            String username = dataMap.getString(SEND_USERNAME);
            String languagecode = dataMap.getString(SEND_LANGUAGECODE);
            LOG.info("SendMailJob lang={}", (Object)languagecode);
            LanguageCode languageCode = LanguageCode.valueOf((String)languagecode);
            LOG.info("SendMailJob lang={}", (Object)languageCode);
            this.SendMailtoRegister(email, username, languageCode);
        }
        catch (Exception e) {
            LOG.error("SendMailJob error" + e.getMessage());
        }
        LOG.info("==============SendMailJob end===============");
    }

    void SendMailtoRegister(String email, String userName, LanguageCode languageCode) {
        try {
            JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
            try {
                javaMailSenderImpl.testConnection();
            }
            catch (Exception ex) {
                LOG.error("fail to test mail connection.....", (Throwable)ex);
            }
            SystemInitialMainInfoBuilder mailInfoBuilder = new SystemInitialMainInfoBuilder(userName, email, languageCode);
            MailInfo systemInitialMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)systemInitialMailInfo);
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            helper.setTo(email);
            helper.setFrom("WorldCard Team Service<wctservice@mail.worldcardteam.com>");
            helper.setSubject(systemInitialMailInfo.getMailSubject());
            mimeMessage.setContent((Object)systemInitialMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)mimeMessage);
            this.javaMailSender.send(dkimSignedMessage);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ", (Throwable)ex);
        }
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

