/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.TempStoredDataType;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SendCreateContactsForNoticeToAccountJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(SendCreateContactsForNoticeToAccountJob.class);
    public static final String CREATOR_ACCOUNT_GUID = "CREATOR_ACCOUNT_GUID";
    public static final String RECEIVER_ACCOUNT_GUID = "RECEIVER_ACCOUNT_GUID";
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private NoticeService noticeService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String creatorAccountGuid = dataMap.getString(CREATOR_ACCOUNT_GUID);
        String receiverAccountGuid = dataMap.getString(RECEIVER_ACCOUNT_GUID);
        TempStoredDataType itemType = TempStoredDataType.CONTACT_CREATE_FOR_SOMEONE;
        List itemGuids = this.accountShareTargetService.getSharedItemGuids(creatorAccountGuid, receiverAccountGuid, itemType);
        ListRequestVo noticeContentModel = new ListRequestVo();
        noticeContentModel.setList(itemGuids);
        this.noticeService.addNewNotice(NotifyCategory.CONTACT, NotifyType.CONTACT_CREATED_FROM_SOMEONE, GlobalUtils.getJsonString((Object)noticeContentModel), receiverAccountGuid, creatorAccountGuid);
        this.accountShareTargetService.removeSharedItems(creatorAccountGuid, receiverAccountGuid, itemType, itemGuids);
    }
}

