/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.DatabaseCreationTime;
import com.penpower.worldcard.team.Utils.DatabaseCreationTimeUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.backup.BackupFileManager;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.dto.RestoreStorageInfosLess;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.enums.RestoreJobRunningStaus;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.notice.content.SystemMaintenanceContent;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.InsertExistedImageFilesToDbJob;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SystemService;
import com.penpower.worldcard.team.service.TokenService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.flywaydb.core.Flyway;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class RestoreJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreJob.class);
    public static final String DEFAULT_DATABASE_NAME = "worldcardteam";
    public static final String DEFAULT_DATABASE_NAME_TO_RENAME_TMP1 = "worldcardteam_r1";
    public static final String DEFAULT_DATABASE_NAME_TO_RENAME_TMP2 = "worldcardteam_r2";
    public static final String DEFAULT_DATABASE_NAME_RESTORE = "worldcardteam_restore";
    public static final String DEFAULT_QUARTZ_GROP_NAME = "RESTORE_JOB_GROUP";
    public static final String RESTORE_JOB_RESTORESTORAGINFOSLESS_PARAM_NAME = "restoreStoragInfosLess";
    public static final AtomicReference<RestoreJobRunningStaus> RESTORE_RUNNING_STATUS = new AtomicReference<RestoreJobRunningStaus>(RestoreJobRunningStaus.STOPPED);
    public static final AtomicReference<RestoreStorageInfosLess> RESTORE_STORAGE_INFO_LESS_TMP = new AtomicReference<Object>(null);
    @Autowired
    @Qualifier(value="scheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private Environment env;
    @Autowired
    private Flyway flyway;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private DatabaseCreationTimeUtil databaseCreationTimeUtil;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private AccountService accountService;

    public static final void resetAllTemporaryValues() {
        RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.STOPPED);
        RESTORE_STORAGE_INFO_LESS_TMP.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)true, (ReadOnlyType)ReadOnlyType.RESTORE);
        RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.RUNNING);
        Company company = null;
        List companys = this.companyService.FindAllCompany();
        if (companys.size() == 0) {
            throw new InvalidBackupPathException("no company for  backup");
        }
        if (companys.size() > 1) {
            throw new InvalidBackupPathException("multi company no support backup");
        }
        company = (Company)companys.get(0);
        String systemMaintenanceContent = GlobalUtils.getJsonString((Object)new SystemMaintenanceContent(true, DateTime.now().toString("yyyy-MM-dd HH:mm:ss.SSS")));
        this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_MAINTENANCE, systemMaintenanceContent, null, company.getGuid());
        Scheduler scheduler = this.scheduleManager.getScheduler();
        DatabaseType databaseType = this.getDatabaseType();
        DatabaseConnectionInfo databaseConnectionInfo = this.createDatabaseConnectionInfo();
        PostgreSqlJdbcUtils restoreJdbcUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
        Path restorTmpFile = this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS ? SystemConstantProperties.RESTORE_CHECK_TMP_FILE_SYNOLOGY_NAS : SystemConstantProperties.RESTORE_CHECK_TMP_FILE;
        boolean restoreFailed = false;
        try {
            this.tokenService.cleanTokens();
            this.createRestoreTmpFile(restorTmpFile);
            this.stopAndPauseAllRunningSchedule(scheduler);
            this.cleanElasticSearchIndex();
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            RestoreStorageInfosLess restoreStoragInfosLess = (RestoreStorageInfosLess)dataMap.get((Object)RESTORE_JOB_RESTORESTORAGINFOSLESS_PARAM_NAME);
            RESTORE_STORAGE_INFO_LESS_TMP.set(restoreStoragInfosLess);
            String storagePath = restoreStoragInfosLess.getStoragePath();
            BackupFileManager manager = new BackupFileManager(storagePath);
            Path restoreFolder = manager.getRestoreFolder();
            restoreJdbcUtils.cleanDatabaseSessions(DEFAULT_DATABASE_NAME);
            restoreJdbcUtils.deleteDatabase(DEFAULT_DATABASE_NAME);
            LOG.debug("databaseType : {} ", (Object)databaseType);
            restoreJdbcUtils.createDatabase(DEFAULT_DATABASE_NAME);
            restoreJdbcUtils.cleanDatabaseSessions(DEFAULT_DATABASE_NAME);
            this.postgreSqlRestoreDatabase(databaseConnectionInfo, restoreFolder);
            this.cleanRestoreTmpFileContent(restorTmpFile);
            this.flyway.migrate();
            this.systemService.ConvertDBtoMultiCompany();
            RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.FINISHED);
            LOG.debug("All resotre stage finsihed..........");
            return;
        }
        catch (DatabaseUtilsRuntimeException | IOException ex) {
            LOG.error("Fail to process restore job....", ex);
            restoreFailed = true;
            RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.FAILED);
            return;
        }
        finally {
            ReadOnlyStatusManager.READ_ONLY_STATUS.set(false);
            ReadOnlyStatusManager.READ_ONLY_TYPE.set(ReadOnlyType.NONE);
            systemMaintenanceContent = GlobalUtils.getJsonString((Object)new SystemMaintenanceContent(false, DateTime.now().toString("yyyy-MM-dd HH:mm:ss.SSS")));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_MAINTENANCE, systemMaintenanceContent, null, company.getGuid());
            if (restoreFailed) {
                LOG.debug("Restore failed..... create a empty database from source migration sql......");
                restoreJdbcUtils.cleanDatabaseSessions(DEFAULT_DATABASE_NAME);
                restoreJdbcUtils.deleteDatabase(DEFAULT_DATABASE_NAME);
                restoreJdbcUtils.createDatabase(DEFAULT_DATABASE_NAME);
                restoreJdbcUtils.cleanDatabaseSessions(DEFAULT_DATABASE_NAME);
                this.flyway.migrate();
            } else {
                try {
                    DatabaseCreationTime databaseCreationTime = new DatabaseCreationTime();
                    databaseCreationTime.setCreationTime(DateTime.now());
                    this.databaseCreationTimeUtil.writeCreationTime(databaseCreationTime);
                }
                catch (RuntimeException ex) {
                    LOG.error("failed to update database creation time...", (Throwable)ex);
                }
                finally {
                    this.flyway.migrate();
                }
            }
            this.accountService.resetUnderInheritingAccountsInheritanceStatus();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {}
            try {
                boolean insertExistedImageFilesToDbJobRunning;
                LOG.debug("Resume all scheduler..");
                scheduler.resumeAll();
                boolean rebuildElasticsearchIndexJobRunning = this.scheduleManager.jobRunning(RebuildElasticsearchIndexJob.class);
                if (!rebuildElasticsearchIndexJobRunning) {
                    LOG.debug("re-schedule the RebuildElasticsearchIndexJob.");
                    JobIdentify jobIdentify = new JobIdentify("REBUILD_ELASTICSEARCH_INDEX" + UUIDGenerator.getRandomUUID(), RebuildElasticsearchIndexJob.class);
                    this.scheduleManager.startScheduleOnce(jobIdentify, null, new JobDataMap());
                }
                if (!(insertExistedImageFilesToDbJobRunning = this.scheduleManager.jobRunning(InsertExistedImageFilesToDbJob.class))) {
                    LOG.debug("re-schedule the InsertExistedImageFilesToDbJob.");
                    this.scheduleManager.startScheduleOnce(new JobIdentify("INSERT_IMAGE_FILES_TO_DB", InsertExistedImageFilesToDbJob.class), null, new JobDataMap());
                }
            }
            catch (SchedulerException e) {
                throw new DatabaseUtilsRuntimeException("Resume scheduler failed.", (Throwable)e);
            }
            try {
                Files.deleteIfExists(restorTmpFile);
            }
            catch (IOException iOException) {}
        }
    }

    private void cleanRestoreTmpFileContent(Path restorTmpFile) throws IOException {
        Files.write(restorTmpFile, "".getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void createRestoreTmpFile(Path restorTmpFile) throws IOException {
        LOG.debug("create a restorTmpFile : {} ", (Object)restorTmpFile);
        if (Files.exists(restorTmpFile, new LinkOption[0])) {
            Files.delete(restorTmpFile);
        }
        Files.write(restorTmpFile, "running".getBytes(), StandardOpenOption.CREATE);
    }

    private void cleanElasticSearchIndex() {
        try {
            LOG.debug("Try to delete elasticsearch index");
            this.elasticSearchService.removeAllIndex();
        }
        catch (Exception ex) {
            LOG.debug("ElasticsearchError", (Throwable)ex);
            LOG.debug("Do not handle exception for elasticsearch removeindex job !!!");
        }
    }

    private DatabaseType getDatabaseType() {
        String databaseTypeValue = this.env.getProperty("dataSource.nas.type");
        DatabaseType databaseType = DatabaseType.valueOf((String)databaseTypeValue);
        return databaseType;
    }

    private DatabaseConnectionInfo createDatabaseConnectionInfo() {
        if (this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS) {
            String rootUrlFormat = "%s%s:%s/";
            String serverIpAddress = this.env.getProperty("dataSource.synology_nas.ip");
            String serverPort = this.env.getProperty("dataSource.synology_nas.port");
            String dbUserName = this.env.getProperty("dataSource.synology_nas.username");
            String dbPassword = this.env.getProperty("dataSource.synology_nas.password");
            DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, dbUserName, dbPassword);
            return databaseConnectionInfo;
        }
        String rootUrlFormat = "%s%s:%s/";
        String serverIpAddress = this.env.getProperty("dataSource.nas.ip");
        String serverPort = this.env.getProperty("dataSource.nas.port");
        String dbUserName = this.env.getProperty("dataSource.nas.username");
        String dbPassword = this.env.getProperty("dataSource.nas.password");
        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, dbUserName, dbPassword);
        return databaseConnectionInfo;
    }

    private void postgreSqlRestoreDatabase(DatabaseConnectionInfo databaseConnectionInfo, Path restoreFolder) {
        RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.RESTORING_DB);
        try {
            LOG.debug("Execute psql to restore database from backup sql file.");
            Path backupSqlFile = restoreFolder.resolve("wct_backup.sql");
            String dbNameParam = "";
            String pgRestoreCmd = "";
            if (this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS) {
                pgRestoreCmd = String.format("%s/psql", "/var/packages/WorldCardTeam/target/app/pgsql/bin");
                dbNameParam = String.format("--dbname=postgresql://%s:%s@127.0.0.1:5433/%s", databaseConnectionInfo.getDbUserName(), databaseConnectionInfo.getDbPassword(), DEFAULT_DATABASE_NAME);
            } else {
                pgRestoreCmd = String.format("%s/psql", "/usr/local/AppCentral/PenpowerWCT/app/pgsql/bin");
                dbNameParam = String.format("--dbname=postgresql://%s:%s@127.0.0.1:5432/%s", databaseConnectionInfo.getDbUserName(), databaseConnectionInfo.getDbPassword(), DEFAULT_DATABASE_NAME);
            }
            LOG.debug("pgRestoreCmd : {} ", (Object)pgRestoreCmd);
            LOG.debug("dbNameParam : {} ", (Object)dbNameParam);
            LOG.debug("backupSqlFile : {} ", (Object)backupSqlFile);
            ProcessBuilder postgreSqlRestoreProcess = new ProcessBuilder("/bin/sh", pgRestoreCmd, dbNameParam, "-f", backupSqlFile.toString());
            postgreSqlRestoreProcess.redirectErrorStream();
            Process p = postgreSqlRestoreProcess.start();
            try (InputStream is = p.getInputStream();
                 InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                }
                LOG.debug("psql Line >>>>>> {}", (Object)line);
            }
            String errorStream = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)Charset.forName("UTF-8"));
            if (errorStream != null && errorStream.length() > 0) {
                throw new IOException(errorStream);
            }
        }
        catch (IOException e) {
            throw new DatabaseUtilsRuntimeException("Restore database failed.", (Throwable)e);
        }
    }

    private void stopAndPauseAllRunningSchedule(Scheduler scheduler) {
        LOG.debug("Stop all running schedule and shutdown schedule......");
        try {
            List executingJobs = scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : executingJobs) {
                JobDetail executingJobDetai = jobExecutionContext.getJobDetail();
                JobKey key = executingJobDetai.getKey();
                scheduler.interrupt(key);
            }
            LOG.debug("Pause all schedule .....");
            scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new DatabaseUtilsRuntimeException("Fail to interrupt current running jobs.....", (Throwable)e);
        }
    }
}

