/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.notice.content.SystemTurnToReadOnlyStatusContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.LocalStorageSpaceMonitor;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class LocalStorageSpaceMonitor
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStorageSpaceMonitor.class);
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    AccountService accountService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private CompanyService companyService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ServerType serverType = this.registryService.GetServerType();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                LOG.debug(String.format("serverType:%s, skip the storage check", serverType));
                return;
            }
        }
        if (!HardwareIdUtil.linuxSystem()) {
            LOG.debug("Windows system detected! , skip the storage check.....");
            return;
        }
        if (this.interrupted()) {
            return;
        }
        ReadOnlyType readOnlyType = (ReadOnlyType)ReadOnlyStatusManager.READ_ONLY_TYPE.get();
        boolean backupReadOnly = ReadOnlyType.BACKUP.equals((Object)readOnlyType);
        boolean restoreReadOnly = ReadOnlyType.RESTORE.equals((Object)readOnlyType);
        LOG.debug("backupReadOnly : {}", (Object)backupReadOnly);
        LOG.debug("restoreReadOnly : {}", (Object)restoreReadOnly);
        if (backupReadOnly || restoreReadOnly) {
            return;
        }
        String fileSystemRootPath = this.applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
        Path fileSystemRoot = Paths.get(fileSystemRootPath, new String[0]);
        if (!Files.exists(fileSystemRoot, new LinkOption[0])) {
            try {
                Files.createDirectories(fileSystemRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.warn("Fail to create filesystem root path : {}", (Object)fileSystemRoot);
            }
        }
        Company company = null;
        List companys = this.companyService.FindAllCompany();
        if (companys.size() == 0) {
            throw new InvalidBackupPathException("no company for  backup");
        }
        if (companys.size() > 1) {
            throw new InvalidBackupPathException("multi company no support backup");
        }
        company = (Company)companys.get(0);
        DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)fileSystemRoot);
        boolean storageReadOnlyLimitExceeded = FileSystemUtil.storageLessThan50GReadOnlyMode((DiskInfos)diskInfos);
        boolean readOnly = ReadOnlyStatusManager.READ_ONLY_STATUS.get();
        LOG.debug("Check storage status ... read-only flag : {} ", (Object)readOnly);
        LOG.debug("diskInfos : {} ", (Object)diskInfos);
        LOG.debug("read-only flag limit is 50GB, exceeded : {} ", (Object)storageReadOnlyLimitExceeded);
        if (!readOnly && storageReadOnlyLimitExceeded) {
            LOG.debug("Turn to read-only status , add new notice.....");
            String systemTurnToReadOnlyContent = GlobalUtils.getJsonString((Object)new SystemTurnToReadOnlyStatusContent(FileSystemUtil.convertToStringRepresentation((long)diskInfos.getTotalSpaceBytes()), FileSystemUtil.convertToStringRepresentation((long)diskInfos.getUsableSpaceBytes())));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.FILESYSTEM_READ_ONLY, systemTurnToReadOnlyContent, null, company.getGuid());
            ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)true, (ReadOnlyType)ReadOnlyType.STORAGE_NOT_ENOUGH);
            return;
        }
        if (readOnly && !storageReadOnlyLimitExceeded) {
            ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)false, (ReadOnlyType)ReadOnlyType.NONE);
        }
    }
}

