/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactImageTransferStatus;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.SystemService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class InsertExistedImageFilesToDbJob
extends QuartzJobBean
implements InterruptableJob {
    public static final String DEFAULT_QUARTZ_GROP_NAME = "INSERT_IMAGE_FILES_TO_DB";
    private static final Logger LOG = LoggerFactory.getLogger(InsertExistedImageFilesToDbJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private PathManager cardPathManager;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.thisContext = context;
        this.systemService.ConvertDBtoMultiCompany();
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS");
        ContactImageTransferStatus status = ContactImageTransferStatus.IN_PROGRESS;
        try {
            status = ContactImageTransferStatus.valueOf((String)globalInfo.getConfigValue());
            LOG.info("ContactImageTransferStauts: {}", (Object)status);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!ContactImageTransferStatus.TRANSFER_SUCCESS.equals((Object)status)) {
            List imageInfos;
            LOG.debug("Set contactImageTransferStatus from {} to {}", (Object)status.toString(), (Object)ContactImageTransferStatus.IN_PROGRESS.toString());
            this.globalInfoService.updatePropertyValue(globalInfo.getGuid(), ContactImageTransferStatus.IN_PROGRESS.toString());
            LOG.info("Image transfer started at: {}", (Object)DateTime.now());
            boolean errorOccurs = false;
            while (!CollectionUtils.isEmpty((Collection)(imageInfos = this.contactPrivateService.getImagesWithoutBinaryDataWithLimit(1000)))) {
                for (ContactimageInfo info : imageInfos) {
                    if (this.isInterrupted()) break;
                    try {
                        boolean insertImageSuccess = this.contactPrivateService.insertImageFileToDB(info.getGuid());
                        if (insertImageSuccess) {
                            LOG.debug("contactGuid: {}, insertImageSuccess: {}, ready to delete contact image file", (Object)info.getGuid(), (Object)insertImageSuccess);
                            this.contactPrivateService.deleteContactImageFile(info.getGuid());
                        } else {
                            LOG.debug("contactGuid: {}, insertImageSuccess: {}, ready to mark contact image to isDeleted", (Object)info.getGuid(), (Object)insertImageSuccess);
                            this.contactPrivateService.checkAndMarkContactImageContentToDeleted(info.getGuid());
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        LOG.error("Insert image file to DB failed", (Throwable)e);
                        errorOccurs = true;
                        break;
                    }
                }
                if (!errorOccurs) continue;
                break;
            }
            LOG.info("errorOccurs: {}", (Object)errorOccurs);
            if (errorOccurs) {
                this.globalInfoService.updatePropertyValue(globalInfo.getGuid(), ContactImageTransferStatus.TRANSFER_ERROR.toString());
                LOG.info("Set contactImageTransferStatus to {}", (Object)ContactImageTransferStatus.TRANSFER_ERROR.toString());
            } else {
                try {
                    Path cardRootPath = this.cardPathManager.getRootPath();
                    LOG.debug("cardRootPath:{}", (Object)cardRootPath);
                    if (Files.exists(cardRootPath, new LinkOption[0])) {
                        LOG.info("Delete card root path:{}", (Object)cardRootPath);
                        Files.delete(cardRootPath);
                    }
                }
                catch (Exception e) {
                    LOG.debug("delete card root path failed", (Throwable)e);
                }
                this.globalInfoService.updatePropertyValue(globalInfo.getGuid(), ContactImageTransferStatus.TRANSFER_SUCCESS.toString());
                LOG.info("Set contactImageTransferStatus to {}", (Object)ContactImageTransferStatus.TRANSFER_SUCCESS.toString());
            }
            LOG.info("Image transfer end at: {}", (Object)DateTime.now());
        }
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

