/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.notice.content.CrmExportResultContent;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExportContactsToCrmJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(ExportContactsToCrmJob.class);
    public static final String EXPORT_CONTACT_GUIDS = "EXPORT_CONTACT_GUIDS";
    public static final String EXPORT_ACCOUNT_GUID = "EXPORT_ACCOUNT_GUID";
    public static final String EXPORT_IS_SEND_NOTICE = "EXPORT_IS_SEND_NOTICE";
    public static final String CRM_TARGET_TYPE = "CRM_TARGET_TYPE";
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private SalesForceTokenService salesForceTokenService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.thisContext = context;
        LOG.info("================================================ExportContactsToCrmJob start({})==============================", (Object)Thread.currentThread().getName());
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        List contactGuids = (List)dataMap.get((Object)EXPORT_CONTACT_GUIDS);
        LOG.debug("contactGuids: {}", (Object)contactGuids);
        String accountGuid = dataMap.getString(EXPORT_ACCOUNT_GUID);
        boolean isSendNotice = dataMap.getBooleanValue(EXPORT_IS_SEND_NOTICE);
        CrmTargetType crmTargetType = (CrmTargetType)dataMap.get((Object)CRM_TARGET_TYPE);
        BasicToken basicToken = null;
        try {
            basicToken = this.salesForceTokenService.retrieveToken(accountGuid);
            if (basicToken instanceof NullCRMToken) {
                throw new CRMOperationException("Get basicToken is NullCRMToken.");
            }
        }
        catch (CRMOperationException e) {
            LOG.error("retrieveToken fail({}): {}", (Object)accountGuid, (Object)e);
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.GET_CRM_TOKEN_FAILED, "Get CRM access token for this account failed.", accountGuid, null);
            return;
        }
        CRMOperationService crmOperationService = GlobalUtils.getCrmOperationService((CrmTargetType)crmTargetType);
        ArrayList failedExportReasonList = new ArrayList();
        boolean isInterrupted = this.manualExportContactsToCRM(crmOperationService, accountGuid, contactGuids, failedExportReasonList, basicToken);
        if (isSendNotice) {
            if (isInterrupted) {
                this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.CONTACT_EXPORTED_CANCELED, "Export process is interrupted.", accountGuid, null);
            } else {
                int numSucceed = contactGuids.size() - failedExportReasonList.size();
                CrmExportResultContent noticeModel = new CrmExportResultContent(numSucceed, failedExportReasonList);
                this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.CONTACT_EXPORTED, GlobalUtils.getJsonString((Object)noticeModel), accountGuid, null);
            }
        }
        LOG.debug("================================================ExportContactsToCrmJob end({})==============================", (Object)Thread.currentThread().getName());
    }

    private boolean manualExportContactsToCRM(CRMOperationService crmOperationService, String accountGuid, List<String> contactGuids, List<ContactFailToExport> failedExportReasonList, BasicToken basicToken) {
        for (String contactGuid : contactGuids) {
            LOG.debug("[manualExportContactsToCRM] (Contact: {}) Before check isInterrupted()", (Object)contactGuid);
            if (this.isInterrupted()) {
                return true;
            }
            ContactInfoForResponse contact = null;
            try {
                contact = this.contactPrivateService.getContactResponseInfoByGuid(contactGuid);
                LOG.debug("[manualExportContactsToCRM] (Contact: {}) After getContactResponseInfoByGuid()", (Object)contactGuid);
                String crmID = crmOperationService.getExportedCrmID(accountGuid, contactGuid);
                if (StringUtil.IsStringNullorEmpty((String)crmID)) {
                    LOG.debug("[manualExportContactsToCRM] (Contact: {}) exportContactToCRM()", (Object)contactGuid);
                    crmOperationService.exportContactToCRM(accountGuid, contact, false, basicToken);
                } else {
                    LOG.debug("[manualExportContactsToCRM] (Contact: {}) updateContactToCRM()", (Object)contactGuid);
                    crmOperationService.updateContactToCRM(accountGuid, contact, crmID, false, basicToken);
                }
                LOG.debug("[manualExportContactsToCRM] (Contact: {}) Complete export/update CRM", (Object)contactGuid);
            }
            catch (Exception e) {
                List names;
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                ContactFailToExport failReason = new ContactFailToExport(contactGuid, e.getMessage(), infoDto.getFullname(), infoDto.getCompany());
                failedExportReasonList.add(failReason);
                String contactname = "";
                List list = names = contact == null ? null : contact.getNames();
                if (!CollectionUtils.isEmpty((Collection)names)) {
                    ContactnameInfo name = (ContactnameInfo)names.get(0);
                    contactname = name.getFirstName() + " " + name.getLastName();
                }
                LOG.error("[manualExportContactsToCRM failed] (Contact: {}) {}", (Object)contactname, (Object)e.getMessage());
            }
        }
        return false;
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

