/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DeleteUndownloadedContactsOfAccountJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteUndownloadedContactsOfAccountJob.class);
    public static final String ACCOUNT_GUID = "ACCOUNT_GUID";
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private NoticeService noticeService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.thisContext = context;
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String accountGuid = dataMap.getString(ACCOUNT_GUID);
        int numSucceed = 0;
        ArrayList<ContactFailToExport> failedReasonList = new ArrayList<ContactFailToExport>();
        List contactGuids = this.contactPrivateService.getContactGuidsOwnedByAccount(accountGuid);
        for (String contactGuid : contactGuids) {
            List accountGuidsHaveIt;
            if (this.contactPrivateService.IsContactDeleted(contactGuid) || !CollectionUtils.isEmpty((Collection)(accountGuidsHaveIt = this.contactPrivateService.getAccountsHaveThisContactInPrivate(contactGuid)))) continue;
            try {
                this.contactPrivateService.deleteContact(contactGuid);
                ++numSucceed;
            }
            catch (Exception e) {
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                ContactFailToExport failReason = new ContactFailToExport(contactGuid, e.getMessage(), infoDto.getFullname(), infoDto.getCompany());
                failedReasonList.add(failReason);
            }
        }
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

