/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DeadLockAccountInheritorJobChecker
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(DeadLockAccountInheritorJobChecker.class);
    @Autowired
    @Qualifier(value="scheculerFactoryBeanManually")
    private SchedulerFactoryBean schedulerFactory;
    @Autowired
    private AccountService accountService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        try {
            List inheritingAccounts = this.accountService.getAccountByInheritanceStatus(InheritanceStatus.INHERITING);
            List inheritingAccountGuids = inheritingAccounts.stream().map(inheritingAccount -> inheritingAccount.getGuid()).collect(Collectors.toList());
            LOG.debug("inheritingAccountGuids : {} ", inheritingAccountGuids);
            List allExecutingJobs = scheduler.getCurrentlyExecutingJobs();
            LOG.debug("allExecutingJobs size : {} ", (Object)allExecutingJobs.size());
            for (JobExecutionContext jobExecutionContext : allExecutingJobs) {
                boolean bothParamsEmpty;
                JobDetail jobDetail = jobExecutionContext.getJobDetail();
                JobDataMap dataMap = jobDetail.getJobDataMap();
                String accountGuid = dataMap.getString("accountGuid");
                String inheritorAccountGuid = dataMap.getString("inheritorAccountGuid");
                boolean bl = bothParamsEmpty = StringUtils.isEmpty((CharSequence)accountGuid) && StringUtils.isEmpty((CharSequence)inheritorAccountGuid);
                if (!bothParamsEmpty) {
                    if (!inheritingAccountGuids.contains(accountGuid)) continue;
                    inheritingAccountGuids.remove(accountGuid);
                    continue;
                }
                if (!this.interrupted()) continue;
                break;
            }
            LOG.debug("After scheduler job check , inheritingAccountGuids : {} ", inheritingAccountGuids);
            for (String inheritingAccountGuid : inheritingAccountGuids) {
                if (!this.interrupted()) {
                    boolean inheritorStatusValid = this.accountService.verifyInheritorStatus(inheritingAccountGuid);
                    LOG.debug("inheritingAccountGuid : {}  , inheritorStatusValid : {} ", (Object)inheritingAccountGuid, (Object)inheritorStatusValid);
                    if (inheritorStatusValid) continue;
                    LOG.debug("Reset incorrect inherit status ....");
                    this.accountService.resetInheriteStatus(inheritingAccountGuid);
                    continue;
                }
                break;
            }
        }
        catch (SchedulerException e) {
            LOG.error("error : ", (Throwable)e);
        }
    }
}

