/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DailyCheckRegisterJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(DailyCheckRegisterJob.class);
    @Autowired
    AccountService accountService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private CompanyService companyService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("DailyCheckRegisterJob start");
        List companys = this.companyService.FindAllCompany();
        for (Company company : companys) {
            if (this.subscriptionService.getLicenseMode(company.getGuid()) != LicenseMode.BUYOUT) {
                LOG.debug("DailyCheckRegisterJob not BUYOUT MODE ");
                return;
            }
            DateTime dtStart = new DateTime();
            double sleepTime = Math.random() * 60.0;
            DateTime dtEnd = dtStart.plusSeconds((int)sleepTime);
            LOG.debug("DailyCheckRegisterJob sleep ={}", (Object)sleepTime);
            while (!this.interrupted()) {
                DateTime dtcurr;
                try {
                    Thread.sleep(1000L);
                    LOG.debug("DailyCheckRegisterJob WAIT");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!(dtcurr = new DateTime()).isAfter((ReadableInstant)dtEnd)) continue;
                break;
            }
            LOG.debug("DailyCheckRegisterJob WAIT END");
            this.registryService.DownloadRegistryInfo(company.getGuid(), this.interrupted());
            LOG.debug("DailyCheckRegisterJob work");
        }
    }
}

