/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.NoticeService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class CleanOutOBoundNoticesPerUserJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(CleanOutOBoundNoticesPerUserJob.class);
    public static final String DEFAULT_QUARTZ_GROP_NAME = "CLEAN_OUTOFBOUND_NOTICES_GROUP";
    public static final String JOB_DATA_ACCOUNT_GUID_PARAM_NAME = "accountGuid";
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CompanyService companyService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("To clear all out of bound notices per user start....");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String cleanAccountGuid = dataMap.getString(JOB_DATA_ACCOUNT_GUID_PARAM_NAME);
        LOG.debug("cleanAccountGuid : {} ", (Object)cleanAccountGuid);
        if (StringUtils.isEmpty((CharSequence)cleanAccountGuid)) {
            LOG.debug("cleanAccountGuid is null , foreach all account to clean notice table......");
            List companys = this.companyService.FindAllCompany();
            block2: for (Company company : companys) {
                List accounts = this.accountService.getAccountInfos(company.getGuid());
                for (AccountInfo accountInfo : accounts) {
                    if (this.interrupted()) continue block2;
                    String accountGuid = accountInfo.getGuid();
                    try {
                        this.noticeService.deleteUserNoticeByCountLargerThan500(accountGuid);
                    }
                    catch (Exception ex) {
                        LOG.warn("Clean out of bound notices by user failed, account:[{}] , guid:[{}]", new Object[]{accountInfo.getEmail(), accountGuid, ex});
                    }
                    if (!this.interrupted()) continue;
                    continue block2;
                }
            }
        } else {
            this.noticeService.deleteUserNoticeByCountLargerThan500(cleanAccountGuid);
        }
    }
}

