/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.backup.BackupControlFile;
import com.penpower.worldcard.team.backup.BackupFileManager;
import com.penpower.worldcard.team.dto.BackupStoragInfosLess;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.BackupFailedType;
import com.penpower.worldcard.team.enums.BackupRunningStaus;
import com.penpower.worldcard.team.enums.BackupStatus;
import com.penpower.worldcard.team.enums.ContactImageTransferStatus;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.BackupRuntimException;
import com.penpower.worldcard.team.exception.ImageDataMigrationJobRunningException;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.exception.UnsupportFileSystemTypeException;
import com.penpower.worldcard.team.notice.content.BackupFailedContent;
import com.penpower.worldcard.team.notice.content.SystemMaintenanceContent;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.BackupInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class BackupJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(BackupJob.class);
    public static final String DEFAULT_QUARTZ_GROP_NAME = "BACKUP_JOB_GROUP";
    public static final String BACKUP_JOB_BACKUPSTORAGINFOSLESS_PARAM_NAME = "backupStoragInfosLess";
    public static final AtomicReference<BackupRunningStaus> BACKUP_RUNNING_STATUS = new AtomicReference<BackupRunningStaus>(BackupRunningStaus.STOPPED);
    public static final AtomicReference<Path> BACKUP_FILE_PATH = new AtomicReference<Object>(null);
    @Autowired
    private BackupInfoService backupService;
    @Autowired
    private Environment env;
    @Autowired
    private BackupInfoService backupInfoService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private GlobalInfoService globalInfoService;

    public static final JobKey createBackupJobQuartzJobKey() {
        JobKey jobKey = new JobKey(BackupJob.class.getName(), DEFAULT_QUARTZ_GROP_NAME);
        return jobKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Backup job verify.....................");
        boolean backupStorageInfoVerifySuccess = false;
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        BackupStoragInfosLess backupStoragInfosLess = (BackupStoragInfosLess)dataMap.get((Object)BACKUP_JOB_BACKUPSTORAGINFOSLESS_PARAM_NAME);
        String storagePath = backupStoragInfosLess.getStoragePath();
        Company company = null;
        try {
            List companys = this.companyService.FindAllCompany();
            if (companys.size() == 0) {
                throw new InvalidBackupPathException("no company for  backup");
            }
            if (companys.size() > 1) {
                throw new InvalidBackupPathException("multi company no support backup");
            }
            company = (Company)companys.get(0);
            Path backpPath = Paths.get(storagePath, new String[0]);
            boolean backupPathExists = Files.isDirectory(backpPath, new LinkOption[0]);
            LOG.debug("backupPathExists : {}", (Object)backupPathExists);
            if (!backupPathExists) {
                String backupFailedContent = GlobalUtils.getJsonString((Object)new BackupFailedContent(BackupFailedType.INVALID_PATH, null));
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.BACKUP_FAILED, backupFailedContent, null, company.getGuid());
                throw new InvalidBackupPathException("The backup destination path does not exists.");
            }
            boolean supportFileSystem = FileSystemUtil.verifySupportFileSystem((Path)backpPath);
            if (!supportFileSystem) {
                String backupFailedContent = GlobalUtils.getJsonString((Object)new BackupFailedContent(BackupFailedType.UNSUPPORT_FILE_SYSTEM, null));
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.BACKUP_FAILED, backupFailedContent, null, company.getGuid());
                throw new UnsupportFileSystemTypeException("Backup path file system will be EXT4 or NTFS.");
            }
            Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS");
            ContactImageTransferStatus status = ContactImageTransferStatus.valueOf((String)globalInfo.getConfigValue());
            if (ContactImageTransferStatus.IN_PROGRESS.equals((Object)status)) {
                throw new ImageDataMigrationJobRunningException("The image data migration job already running.....");
            }
        }
        finally {
            ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)false, (ReadOnlyType)ReadOnlyType.NONE);
        }
        backupStorageInfoVerifySuccess = true;
        if (backupStorageInfoVerifySuccess) {
            LOG.debug("Backup jp start.......................");
            ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)true, (ReadOnlyType)ReadOnlyType.BACKUP);
            BACKUP_RUNNING_STATUS.set(BackupRunningStaus.RUNNING);
            String systemMaintenanceContent = GlobalUtils.getJsonString((Object)new SystemMaintenanceContent(true, DateTime.now().toString("yyyy-MM-dd HH:mm:ss.SSS")));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_MAINTENANCE, systemMaintenanceContent, null, company.getGuid());
            BackupFileManager backupFileManager = null;
            BackupControlFile controlFile = null;
            DateTime backupTime = DateTime.now();
            try {
                String databaseName = "";
                String username = "";
                String password = "";
                String databaseType = "";
                String rootUrlFormat = "";
                String serverIpAddress = "";
                String serverPort = "";
                if (this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS) {
                    databaseName = this.env.getProperty("dataSource.synology_nas.databaseName");
                    username = this.env.getProperty("dataSource.synology_nas.username");
                    password = this.env.getProperty("dataSource.synology_nas.password");
                    databaseType = this.env.getProperty("dataSource.synology_nas.type");
                    rootUrlFormat = "%s%s:%s/";
                    serverIpAddress = this.env.getProperty("dataSource.synology_nas.ip");
                    serverPort = this.env.getProperty("dataSource.synology_nas.port");
                } else {
                    databaseName = this.env.getProperty("dataSource.nas.databaseName");
                    username = this.env.getProperty("dataSource.nas.username");
                    password = this.env.getProperty("dataSource.nas.password");
                    databaseType = this.env.getProperty("dataSource.nas.type");
                    rootUrlFormat = "%s%s:%s/";
                    serverIpAddress = this.env.getProperty("dataSource.nas.ip");
                    serverPort = this.env.getProperty("dataSource.nas.port");
                }
                DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, username, password);
                PostgreSqlJdbcUtils jdbcDatabaseUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
                String currentPostgresqlVersion = this.backupService.getCurrentPostgreSqlVersion();
                backupFileManager = new BackupFileManager(storagePath);
                controlFile = null;
                this.cleanIncorrectControllerFileStatus(backupFileManager.getBackupFilesRoot());
                boolean controlFileNotFound = controlFile == null;
                LOG.debug("controlFileNotFound : {} ", (Object)controlFileNotFound);
                if (controlFileNotFound) {
                    backupFileManager.createDirectorys();
                    controlFile = new BackupControlFile();
                    controlFile.setPostgreSqlVersion(currentPostgresqlVersion);
                    controlFile.setBackupStatus(BackupStatus.INIT);
                    controlFile.setDatabaseType(databaseType);
                    controlFile.setApiVersion("6.0.0.41");
                    backupFileManager.writeControlFileJsonObject(controlFile);
                }
                controlFile.setBackupTime(backupTime);
                LOG.debug("---------------executePgdumpProcess-------------");
                this.executePgdumpProcess(username, password, databaseName, backupFileManager.getBackupFilesFolder());
                try {
                    Path backupFiles = backupFileManager.getBackupFilesFolder();
                    try (Stream<Path> walkFilesStream = Files.walk(backupFiles, new FileVisitOption[0]);){
                        long size = walkFilesStream.filter(backupFile -> !Files.isDirectory(backupFile, new LinkOption[0])).mapToLong(backupFile -> backupFile.toFile().length()).sum();
                        controlFile.setBackupSizeBytes(size);
                        controlFile.setBackupStatus(BackupStatus.FINISHED);
                        long databaseSize = jdbcDatabaseUtils.queryDatabaseSize(databaseName);
                        controlFile.setBackupDatabaseSize(databaseSize);
                        backupFileManager.writeControlFileJsonObject(controlFile);
                        this.backupInfoService.setLastBackupTime(backupTime);
                    }
                    catch (IOException e) {
                        throw new BackupRuntimException("Fail to calculate the size of backup folder...", (Throwable)e);
                    }
                    BACKUP_RUNNING_STATUS.set(BackupRunningStaus.FINISHED);
                    this.backupInfoService.updateLastBackupErrorMessage("");
                    this.removeOldBackupFolderQuiet(backupFileManager);
                }
                catch (Exception ex) {
                    LOG.error("Can not access target file");
                    throw new BackupRuntimException("Can not access target file");
                }
            }
            catch (Exception ex) {
                LOG.error("Backup failed...", (Throwable)ex);
                BACKUP_RUNNING_STATUS.set(BackupRunningStaus.FAILED);
                String exceptionMessage = "";
                String failedTypeContent = "";
                if (ex instanceof BackupRuntimException) {
                    failedTypeContent = GlobalUtils.getJsonString((Object)new BackupFailedContent(BackupFailedType.INVALID_PATH, null));
                } else {
                    exceptionMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
                    failedTypeContent = GlobalUtils.getJsonString((Object)new BackupFailedContent(BackupFailedType.UNKNOW_TYPE, exceptionMessage));
                }
                this.backupInfoService.updateLastBackupErrorMessage(failedTypeContent);
                this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.BACKUP_FAILED, failedTypeContent, null, company.getGuid());
                this.sleep(5000L);
                Path currentBackupFileFolder = backupFileManager.getBackupFilesFolder();
                try {
                    LOG.debug("backup failed, clean all files..... currentBackupFileFolder : {}", (Object)currentBackupFileFolder.toString());
                    FileSystemUtil.deleteDirectory((Path)currentBackupFileFolder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)false, (ReadOnlyType)ReadOnlyType.NONE);
                systemMaintenanceContent = GlobalUtils.getJsonString((Object)new SystemMaintenanceContent(false, DateTime.now().toString("yyyy-MM-dd HH:mm:ss.SSS")));
                this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_MAINTENANCE, systemMaintenanceContent, null, company.getGuid());
                BACKUP_FILE_PATH.set(null);
                this.sleep(5000L);
            }
        }
    }

    private void cleanIncorrectControllerFileStatus(Path backupFilePathRoot) {
        try {
            LOG.debug("check backup folder status......");
            List<Object> incorrectBackupFolders = new ArrayList();
            Throwable throwable = null;
            try (Stream<Path> pathStream = Files.list(backupFilePathRoot);){
                incorrectBackupFolders = pathStream.filter(p -> Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                    Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
                    Path controlFilePath = p.resolve("wct_backup.json");
                    LOG.debug("controlFilePath: {} ", (Object)controlFilePath);
                    if (controlFilePath == null) return false;
                    if (!Files.exists(controlFilePath, new LinkOption[0])) return false;
                    LOG.debug("exists , read controler file.....");
                    try (FileReader fr = new FileReader(controlFilePath.toFile());){
                        BackupControlFile controlFile = (BackupControlFile)gson.fromJson((Reader)fr, BackupControlFile.class);
                        BackupStatus backupStatus = controlFile.getBackupStatus();
                        LOG.debug("controlFile : {}", (Object)controlFile);
                        if (!BackupStatus.FINISHED.equals((Object)backupStatus)) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException ex) {
                        LOG.warn("read json failed...", (Throwable)ex);
                        return false;
                    }
                }).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Path path : incorrectBackupFolders) {
                try {
                    FileSystemUtil.deleteDirectory((Path)path);
                }
                catch (IOException ex) {
                    LOG.warn("delete failed", (Throwable)ex);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("warn to clean old backup files......", (Throwable)e);
        }
    }

    private void removeOldBackupFolderQuiet(BackupFileManager backupFileManager) {
        try {
            LOG.debug("remove all old backup folders......");
            Path backupRoot = backupFileManager.getBackupFilesRoot();
            List<Object> files = new ArrayList();
            try (Stream<Path> pathStream2 = Files.list(backupRoot);){
                files = pathStream2.filter(p -> Files.isDirectory(p, new LinkOption[0])).sorted().map(p -> p.toString()).collect(Collectors.toList());
            }
            catch (IOException pathStream2) {
                // empty catch block
            }
            int allFolderCount = files.size();
            LOG.debug("files : {}", files);
            LOG.debug("allFolderCount : {}", (Object)allFolderCount);
            if (allFolderCount == 1) {
                return;
            }
            for (int i = 0; i < allFolderCount - 1; ++i) {
                Path deletedPath = Paths.get((String)files.get(i), new String[0]);
                LOG.debug("deletedPath : {} ", (Object)deletedPath);
                FileSystemUtil.deleteDirectory((Path)deletedPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void executePgdumpProcess(String username, String password, String databaseName, Path backupPath) throws IOException {
        LOG.debug("dump all database tables..........");
        String dbNameParam = "";
        String pgdumpCommand = "";
        if (this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS) {
            pgdumpCommand = String.format("%s/pg_dump", "/var/packages/WorldCardTeam/target/app/pgsql/bin");
            dbNameParam = String.format("--dbname=postgresql://%s:%s@127.0.0.1:5433/%s", username, password, databaseName);
        } else {
            pgdumpCommand = String.format("%s/pg_dump", "/usr/local/AppCentral/PenpowerWCT/app/pgsql/bin");
            dbNameParam = String.format("--dbname=postgresql://%s:%s@127.0.0.1:5432/%s", username, password, databaseName);
        }
        Path backupSqlFile = backupPath.resolve("wct_backup.sql");
        BACKUP_FILE_PATH.set(backupSqlFile);
        String backupFileDest = backupSqlFile.toString();
        LOG.debug("pgdumpCommand : {} ", (Object)pgdumpCommand);
        LOG.debug("dbNameParam : {} ", (Object)dbNameParam);
        LOG.debug("backupFileDest : {} ", (Object)backupFileDest);
        ProcessBuilder postgreSqlDumpProcess = new ProcessBuilder(pgdumpCommand, dbNameParam, "-f", backupFileDest);
        postgreSqlDumpProcess.redirectErrorStream();
        Process p = postgreSqlDumpProcess.start();
        try (InputStream is = p.getInputStream();
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
            }
            LOG.debug("Line : {}", (Object)line);
        }
        String errorStream = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)Charset.forName("UTF-8"));
        if (errorStream != null && errorStream.length() > 0) {
            throw new IOException(errorStream);
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean sqlExists = Files.exists(backupSqlFile, new LinkOption[0]);
        LOG.debug("backupSqlFile exist : {} ", (Object)sqlExists);
        if (!sqlExists) {
            throw new BackupRuntimException("Can not access target file");
        }
    }
}

