/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.restore;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.DatabaseJdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsSqlJdbcUtils
implements DatabaseJdbcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MsSqlJdbcUtils.class);
    private String SQLSERVER_LOCALHOST_ROOT_URL = "jdbc:sqlserver://127.0.0.1";
    private DatabaseConnectionInfo databaseConnectionInfo;

    public MsSqlJdbcUtils(DatabaseConnectionInfo databaseConnectionInfo) {
        this.databaseConnectionInfo = databaseConnectionInfo;
    }

    public void deleteDatabase(String databaseName) throws DatabaseUtilsRuntimeException {
        LOG.debug("Delete database , databaseName : {} ", (Object)databaseName);
        try {
            String driver = SQLServerDriver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(this.SQLSERVER_LOCALHOST_ROOT_URL, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String deleteDatabaseSql = "USE master;IF EXISTS(select * from sys.databases where name='" + databaseName + "')DROP DATABASE " + databaseName;
                statement.execute(deleteDatabaseSql);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to delete database , databaseName : " + databaseName, (Throwable)e1);
        }
    }

    public void cleanDatabaseSessions(String databaseName) throws DatabaseUtilsRuntimeException {
        LOG.debug("Clean all database sessions , databaseName : {} ", (Object)databaseName);
        try {
            String driver = SQLServerDriver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(this.SQLSERVER_LOCALHOST_ROOT_URL, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String cleanAllSessionSql = " DECLARE @kill varchar(8000) = '';  SELECT @kill = @kill + 'kill ' + CONVERT(varchar(5), session_id) + ';'  FROM sys.dm_exec_sessions  WHERE database_id  = db_id('" + databaseName + "')  EXEC(@kill); ";
                statement.execute(cleanAllSessionSql);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to clean all database sessions... databaseName: " + databaseName, (Throwable)e1);
        }
    }

    public void createDatabase(String databaseName) throws DatabaseUtilsRuntimeException {
        LOG.warn("No implements......");
    }

    public void renameDatabase(String databaseNameFrom, String databaseNameTo) throws DatabaseUtilsRuntimeException {
        LOG.warn("No implements......");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDatabaseExists(String databaseName) throws DatabaseUtilsRuntimeException {
        LOG.debug("Check database exists or not , databaseName  : {}", (Object)databaseName);
        try {
            String driver = SQLServerDriver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(this.SQLSERVER_LOCALHOST_ROOT_URL, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String checkDatabaseExistsSql = "select * from sys.databases where name = '" + databaseName + "';";
                ResultSet rs = statement.executeQuery(checkDatabaseExistsSql);
                rs.next();
                int count = rs.getInt(1);
                if (count > 0) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e1) {
            return false;
        }
    }

    public long queryDatabaseSize(String databaseName) {
        return 0L;
    }
}

