/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.mail;

import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfoBuilder;
import com.penpower.worldcard.team.mail.MailInfoType;
import java.util.HashMap;

public class SystemInitialMainInfoBuilder
extends MailInfoBuilder {
    private String defaultSystemInitialBodyHtmlMsg;
    private String defaultSystemInitialSubjectHtmlMsg;

    public SystemInitialMainInfoBuilder(String userName, String email, LanguageCode languageCode) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("userName", userName);
        this.setSubjectContext(null);
        this.setBodyContext(context);
        this.setLanguageCode(languageCode);
        this.defaultSystemInitialBodyHtmlMsg = String.format("Hi %s.<BR><BR>WorldCard Team is initial <BR>Please go to password reset interface to change password <BR><BR>Default id/password is admin/PenPower <BR>Email : <a href=\"mailto:support@penpower.com.tw\">support@penpower.com.tw</a><BR><BR>Thanks!<BR><BR>", userName);
        this.defaultSystemInitialSubjectHtmlMsg = "WorldCard Team is initial";
    }

    protected String getPebbleEngineTemplateFile(MailInfoType mailInfoType) {
        String templateEnginePath = null;
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            String SysteminitialTemplateFileName = String.format("system_initia_subject-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/SystemInitial/subject/" + SysteminitialTemplateFileName;
        } else {
            String SysteminitialTemplateFileName = String.format("system_initia_body-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/SystemInitial/body/" + SysteminitialTemplateFileName;
        }
        return templateEnginePath;
    }

    protected String getDefaultContent(MailInfoType mailInfoType) {
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            return this.defaultSystemInitialSubjectHtmlMsg;
        }
        return this.defaultSystemInitialBodyHtmlMsg;
    }
}

