/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.mail;

import com.penpower.worldcard.team.dto.WctInfo;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfoBuilder;
import com.penpower.worldcard.team.mail.MailInfoType;
import java.util.HashMap;

public class SearchEngineFailedMailInfoBuilder
extends MailInfoBuilder {
    private String defaultSearchEngineFailedBodyHtmlMsg;
    private String defaultSearchEngineFailedSubjectHtmlMsg;

    public SearchEngineFailedMailInfoBuilder(String message, WctInfo wctInfo) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("message", message);
        if (wctInfo != null) {
            context.put("databaseName", wctInfo.getDatabaseName());
            context.put("ip", wctInfo.getIp());
            context.put("port", wctInfo.getPort());
        }
        this.setSubjectContext(null);
        this.setBodyContext(context);
        this.setLanguageCode(LanguageCode.TW);
        this.defaultSearchEngineFailedBodyHtmlMsg = "Public Cloud search engine failed: " + message;
        this.defaultSearchEngineFailedSubjectHtmlMsg = "Public Cloud search engine failed:";
    }

    protected String getPebbleEngineTemplateFile(MailInfoType mailInfoType) {
        String templateEnginePath = null;
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            String forgetPasswordTemplateFileName = String.format("search_engine_failed_subject-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/searchEngineFailed/subject/" + forgetPasswordTemplateFileName;
        } else {
            String forgetPasswordTemplateFileName = String.format("search_engine_failed_body-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/searchEngineFailed/body/" + forgetPasswordTemplateFileName;
        }
        return templateEnginePath;
    }

    protected String getDefaultContent(MailInfoType mailInfoType) {
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            return this.defaultSearchEngineFailedSubjectHtmlMsg;
        }
        return this.defaultSearchEngineFailedBodyHtmlMsg;
    }
}

