/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.mail;

import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfoBuilder;
import com.penpower.worldcard.team.mail.MailInfoType;
import java.util.HashMap;

public class PasswordChangedMailInfoBuilder
extends MailInfoBuilder {
    private String defaultPasswordChangedBodyHtmlMsg;
    private String defaultPasswordChangedSubjectHtmlMsg;

    public PasswordChangedMailInfoBuilder(String userName) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("userName", userName);
        this.setSubjectContext(null);
        this.setBodyContext(context);
        this.setLanguageCode(LanguageCode.TW);
        this.defaultPasswordChangedBodyHtmlMsg = String.format("Hi %s.<BR><BR>WorldCard Team password is changed <BR>Please relogin account with new password<BR><BR><BR>Thanks!<BR><BR>", userName);
        this.defaultPasswordChangedSubjectHtmlMsg = "WorldCard Team password changed";
    }

    protected String getPebbleEngineTemplateFile(MailInfoType mailInfoType) {
        String templateEnginePath = null;
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            String PasswordChangedTemplateFileName = String.format("PasswordChanged-subject-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/PasswordChanged/subject/" + PasswordChangedTemplateFileName;
        } else {
            String PasswordChangedTemplateFileName = String.format("PasswordChanged-body-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/PasswordChanged/body/" + PasswordChangedTemplateFileName;
        }
        return templateEnginePath;
    }

    protected String getDefaultContent(MailInfoType mailInfoType) {
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            return this.defaultPasswordChangedSubjectHtmlMsg;
        }
        return this.defaultPasswordChangedBodyHtmlMsg;
    }
}

