/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.mail;

import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfoBuilder;
import com.penpower.worldcard.team.mail.MailInfoType;
import java.util.HashMap;

public class ForgetPasswordMailInfoBuilder
extends MailInfoBuilder {
    private String defaultForgetPasswordBodyHtmlMsg;
    private String defaultForgetPasswordSubjectHtmlMsg;

    public ForgetPasswordMailInfoBuilder(String userName, String resetPasswordUrl, LanguageCode languageCode) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("userName", userName);
        context.put("url", resetPasswordUrl);
        this.setSubjectContext(null);
        this.setBodyContext(context);
        this.setLanguageCode(languageCode);
        this.defaultForgetPasswordBodyHtmlMsg = String.format("Hi %s.<BR><BR>Someone recently requested a password change for your WorldCard Team<BR>account.If this was you, you can set a new password :<BR><BR><a href=\"%s\">Reset Password</a><BR><BR>If you don't want to change your password or didn't request this.<BR>just ignore and delete this message.<BR><BR>To keep your account secure. please don't forward this email to<BR>anyone. <BR><BR>Thanks!<BR><BR>", userName, resetPasswordUrl);
        this.defaultForgetPasswordSubjectHtmlMsg = "WorldCard Team password recovery";
    }

    protected String getPebbleEngineTemplateFile(MailInfoType mailInfoType) {
        String templateEnginePath = null;
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            String forgetPasswordTemplateFileName = String.format("forgetpassword-subject-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/forgetpassword/subject/" + forgetPasswordTemplateFileName;
        } else {
            String forgetPasswordTemplateFileName = String.format("forgetpassword-body-%S.tmp", this.languageCode.toString().toUpperCase());
            templateEnginePath = "template/mail/forgetpassword/body/" + forgetPasswordTemplateFileName;
        }
        return templateEnginePath;
    }

    protected String getDefaultContent(MailInfoType mailInfoType) {
        if (MailInfoType.SUBJECT.equals((Object)mailInfoType)) {
            return this.defaultForgetPasswordSubjectHtmlMsg;
        }
        return this.defaultForgetPasswordBodyHtmlMsg;
    }
}

