/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.listener;

import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.AssignAccountInheritorJob;
import com.penpower.worldcard.team.scheduler.job.InsertExistedImageFilesToDbJob;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.IpConstraintService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ContextReadyListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ContextReadyListener.class);
    private static final String DEFAULT_SERVLET_CONTEXT_NAMESPACE = "dispatcher-servlet";
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    @Qualifier(value="scheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private IpConstraintService ipConstraintService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ServerType svrType;
        String tomcatRoot;
        Path restorTmpFile;
        boolean restoreTmpFileExists;
        LOG.debug("####### ApplicationContext initialized or refreshed{} ,{} ,{}", new Object[]{event.getSource(), event.getApplicationContext(), event.getTimestamp()});
        LOG.debug("####### ApplicationContext initialized or refreshed");
        ApplicationContext context = event.getApplicationContext();
        String contextDisplayName = context.getDisplayName();
        ApplicationContext parentContext = context.getParent();
        String systemOptionFileLocation = context.getEnvironment().getProperty("SystemOption.fileLocation");
        LOG.info("systemOptionFileLocation = {}", (Object)systemOptionFileLocation);
        if (HardwareIdUtil.linuxSystem() && (restoreTmpFileExists = Files.exists(restorTmpFile = this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS ? SystemConstantProperties.RESTORE_CHECK_TMP_FILE_SYNOLOGY_NAS : SystemConstantProperties.RESTORE_CHECK_TMP_FILE, new LinkOption[0]))) {
            try {
                List<String> allLines = Files.readAllLines(restorTmpFile);
                int lineSize = allLines.size();
                LOG.info("found the restore failed status.... cleal the tmp file....");
                if (lineSize > 0) {
                    Files.write(restorTmpFile, "".getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                }
            }
            catch (IOException e) {
                LOG.warn("fail to read all lines from restoreTmpFile..", (Throwable)e);
            }
        }
        if (!StringUtil.IsStringNullorEmpty((String)systemOptionFileLocation)) {
            Path filesRoot = Paths.get(systemOptionFileLocation, new String[0]);
            this.applicationProperties.updateProperty("FILE_SYSTEM_ROOT_PATH", filesRoot.toString());
        } else {
            tomcatRoot = System.getProperty("catalina.base");
            if (tomcatRoot != null) {
                Path tomcatRootPath = Paths.get(tomcatRoot, new String[0]);
                Path filesRoot = Paths.get(tomcatRootPath.getParent().toString(), "wctdb", "files");
                this.applicationProperties.updateProperty("FILE_SYSTEM_ROOT_PATH", filesRoot.toString());
            }
        }
        if (parentContext != null && contextDisplayName.indexOf(DEFAULT_SERVLET_CONTEXT_NAMESPACE) > 0) {
            tomcatRoot = System.getProperty("catalina.base");
            Path tomcatRootPath = Paths.get(tomcatRoot, new String[0]);
            Path uploadPath = Paths.get(tomcatRootPath.toString(), "webapps", "ROOT", "assets", "service-initial-property.json");
            try {
                File file = new File(uploadPath.toString());
                if (file.delete()) {
                    LOG.info("tomcat start and initkeyfile delete success={}", (Object)uploadPath.toString());
                } else {
                    LOG.error("tomcat start and initkeyfile delete fail={}", (Object)uploadPath.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean assignAccountInheritorJobRunning = this.scheduleManager.jobRunning(AssignAccountInheritorJob.class);
            if (!assignAccountInheritorJobRunning) {
                LOG.info("no assignAccountInheritorJobRunning");
                this.accountService.resetUnderInheritingAccountsInheritanceStatus();
            }
            JobIdentify jobIdentify = new JobIdentify("REBUILD_ELASTICSEARCH_INDEX" + UUIDGenerator.getRandomUUID(), RebuildElasticsearchIndexJob.class);
            this.scheduleManager.startScheduleOnce(jobIdentify, null, new JobDataMap());
            this.scheduleManager.startScheduleOnce(new JobIdentify("INSERT_IMAGE_FILES_TO_DB", InsertExistedImageFilesToDbJob.class), null, new JobDataMap());
        }
        if (ServerType.ASUSTOR_NAS_AUTOMATION.equals((Object)(svrType = this.registryService.GetServerType()))) {
            this.subscriptionService.freeTrialServerStartup();
        } else if (ServerType.Google_Linux_Server_Cloud.equals((Object)svrType)) {
            this.subscriptionService.googleCloudServerStartup();
        }
        LOG.info("onApplicationEvent end");
    }
}

