/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(value={"/*"})
public class CSPFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CSPFilter.class);
    public static final String POLICY = "frame-src https://*.cathaylife.com.tw";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        LOG.debug("CSPFilter doFilter 1");
        if (servletResponse instanceof HttpServletResponse) {
            LOG.debug("CSPFilter doFilter 2 Cache-control");
            ((HttpServletResponse)servletResponse).setHeader("Content-Security-Policy", POLICY);
            ((HttpServletResponse)servletResponse).setHeader("Cache-control", "no-store, no-cache, must-revalidate, max-age=0");
        }
        LOG.debug("CSPFilter doFilter 3");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        LOG.debug("CSPFilter doFilter 4" + request.getRequestURL().toString());
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        request.getMethod();
        chain.doFilter((ServletRequest)request, servletResponse);
        LOG.debug("CSPFilter doFilter 5" + request.getRequestURL().toString());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

