/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.files;

import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.files.PathManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public abstract class SystemPathManager
implements PathManager {
    private static final Logger LOG = LoggerFactory.getLogger(SystemPathManager.class);
    private String wctFileSystemRoot;
    @Autowired
    private Environment env;
    private ApplicationProperties applicationProperties;

    public SystemPathManager(ApplicationProperties applicationProperties) {
        LOG.debug("SystemPathManager   : {} ", (Object)applicationProperties);
        this.applicationProperties = applicationProperties;
        String fileSystemRootPath = applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
        LOG.debug("SystemPathManager  fileSystemRootPath={} ", (Object)fileSystemRootPath);
        this.wctFileSystemRoot = fileSystemRootPath;
    }

    public String getWctFileSystemRoot() {
        return this.wctFileSystemRoot;
    }

    public Path createNewOne(String guid, String fileName, boolean autoRename) {
        String newPathValue = String.format("%s/%s/%s", this.getPathRoot(), guid, fileName);
        Path newPath = Paths.get(newPathValue, new String[0]);
        if (autoRename) {
            boolean startCount = true;
            newPath = this.renamePath(newPath, 1);
        }
        return newPath;
    }

    private Path renamePath(Path path, int count) {
        if (Files.exists(path, new LinkOption[0])) {
            String originalFileName = path.getFileName().toString();
            String originalFileNameWithoutExtension = FilenameUtils.getBaseName((String)originalFileName).replaceAll("(\\(_\\d\\))", "");
            String originalFileNameExtension = FilenameUtils.getExtension((String)originalFileName);
            String newFileName = String.format("%s(_%d).%s", originalFileNameWithoutExtension, count, originalFileNameExtension);
            Path renamePath = path.getParent().resolve(newFileName);
            if (Files.exists(renamePath, new LinkOption[0])) {
                return this.renamePath(renamePath, count + 1);
            }
            return renamePath;
        }
        return path;
    }

    public String getRelativePath(Path filePath) {
        String fullyPath = filePath.toString();
        int fullyPathLength = fullyPath.length();
        int rootPathLength = this.getPathRoot().length();
        LOG.debug("getPathRoot() : {} ", (Object)this.getPathRoot());
        LOG.debug("fullyPathLength : {} ", (Object)fullyPathLength);
        LOG.debug("rootPathLength : {} ", (Object)rootPathLength);
        String relativePath = fullyPath.substring(rootPathLength, fullyPathLength);
        LOG.debug("relativePath : {} ", (Object)relativePath);
        return relativePath;
    }

    public Path CreateFullyPath(String relativePath) {
        Path newPath = this.getFullyPath(relativePath);
        try {
            Files.createDirectories(newPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.debug("Error create path={}", (Object)e.getMessage());
            throw new RuntimeException("IOError create path ");
        }
        return newPath;
    }

    public Path getFullyPath(String relativePath) {
        Path newPath = Paths.get(this.getPathRoot(), relativePath);
        return newPath;
    }

    public Path getRootPath() {
        Path rootPath = Paths.get(this.getPathRoot(), new String[0]);
        return rootPath;
    }

    public abstract String getPathRoot();
}

