/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.entity;

import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Activity;
import com.penpower.worldcard.team.entity.Contact;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.hibernate.annotations.DynamicUpdate;
import org.joda.time.DateTime;

@Entity
@DynamicUpdate
@NamedQuery(name="Task.findAll", query="SELECT t FROM Task t")
public class Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String guid;
    private DateTime createtime = new DateTime();
    private String description;
    private String title;
    @ManyToMany(mappedBy="tasks1")
    private List<Account> accounts = new ArrayList();
    @OneToMany(mappedBy="task")
    private List<Activity> activities = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ownerguid")
    private Account owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="creatorguid")
    private Account creator;
    @ManyToMany
    @JoinTable(name="task_has_contact", joinColumns={@JoinColumn(name="task_guid")}, inverseJoinColumns={@JoinColumn(name="contact_guid")})
    private List<Contact> contacts = new ArrayList();

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public DateTime getCreateTime() {
        return this.createtime;
    }

    public void setCreateTime(DateTime createTime) {
        this.createtime = createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public Activity addActivity(Activity activity) {
        this.getActivities().add(activity);
        activity.setTask(this);
        return activity;
    }

    public Activity removeActivity(Activity activity) {
        this.getActivities().remove(activity);
        activity.setTask(null);
        return activity;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public Account getOwner() {
        return this.owner;
    }

    public void setOwner(Account owner) {
        this.owner = owner;
    }

    public Account getCreator() {
        return this.creator;
    }

    public void setCreator(Account creator) {
        this.creator = creator;
    }
}

