/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.entity;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.enums.ActionType;
import com.penpower.worldcard.team.enums.ContactImageType;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import org.hibernate.annotations.DynamicUpdate;
import org.joda.time.DateTime;

@Entity
@DynamicUpdate
public class ContactimageActionLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String guid;
    @Column(name="actiontime")
    private DateTime actionTime;
    @Enumerated(value=EnumType.STRING)
    @Column(name="actiontype")
    private ActionType actionType;
    @Column(name="filepath")
    private String filePath;
    @Column(name="contactguid")
    private String contactGuid;
    @Enumerated(value=EnumType.STRING)
    @Column(name="imagetype")
    private ContactImageType imageType;

    public ContactimageActionLog() {
        this.setGuid(UUIDGenerator.getRandomUUID());
    }

    public ContactimageActionLog(String contactGuid, ContactImageType imageType) {
        this();
        this.setContactGuid(contactGuid);
        this.setImageType(imageType);
    }

    public String getGuid() {
        return this.guid;
    }

    public DateTime getActionTime() {
        return this.actionTime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setActionTime(DateTime actionTime) {
        this.actionTime = actionTime;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getContactGuid() {
        return this.contactGuid;
    }

    public ContactImageType getImageType() {
        return this.imageType;
    }

    public void setContactGuid(String contactGuid) {
        this.contactGuid = contactGuid;
    }

    public void setImageType(ContactImageType imageType) {
        this.imageType = imageType;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public String toString() {
        return "ContactimageActionLog [guid=" + this.guid + ", actionTime=" + this.actionTime + ", actionType=" + this.actionType + ", filePath=" + this.filePath + ", contactGuid=" + this.contactGuid + ", imageType=" + this.imageType + "]";
    }
}

