/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.TimeUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.StringTokenizer;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;

public class RegistryDto {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryDto.class);
    private String cmd;
    private String snid;
    private String hwid;
    private String hwid2;
    private String acdate;
    private String validatedate;
    private String email;
    private boolean canSubscrib;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime updateTime;
    private int licenseCount;
    private String loginCode;

    private static String getTokenStringValue(String token) {
        String originalToken = token;
        String[] tokenSplit = originalToken.split(":");
        String tokenValue = tokenSplit[tokenSplit.length - 1];
        return tokenValue;
    }

    public int GetIntValue(String rawData, String keyString) {
        String valueString = this.GetStringValue(rawData, keyString);
        if (valueString != null) {
            int tokenValue = Integer.parseInt(valueString);
            return tokenValue;
        }
        return 0;
    }

    public String GetStringValue(String rawData, String keyString) {
        StringTokenizer st = new StringTokenizer(rawData, "\n");
        while (st.hasMoreTokens()) {
            String tokenKey;
            String[] tokenSplit;
            String tokenString = st.nextToken();
            if (tokenString == null || tokenString.length() <= 0 || (tokenSplit = tokenString.split(":")).length < 2 || (tokenKey = tokenSplit[0]).compareToIgnoreCase(keyString) != 0) continue;
            return tokenSplit[1];
        }
        return null;
    }

    public RegistryDto(String rawData) {
        LOG.debug("RegistryDto 1");
        this.cmd = this.GetStringValue(rawData, "code");
        LOG.debug("RegistryDto cmd={}", (Object)this.cmd);
        this.snid = this.GetStringValue(rawData, "actcode");
        LOG.debug("RegistryDto actcode={}", (Object)this.snid);
        this.hwid = this.GetStringValue(rawData, "hwid1");
        LOG.debug("RegistryDto hwid1={}", (Object)this.hwid);
        this.hwid2 = this.GetStringValue(rawData, "hwid2");
        LOG.debug("RegistryDto hwid2={}", (Object)this.hwid2);
        this.acdate = this.GetStringValue(rawData, "acdate");
        LOG.debug("RegistryDto acdate={}", (Object)this.acdate);
        this.validatedate = this.GetStringValue(rawData, "validatedate");
        LOG.debug("RegistryDto validatedate={}", (Object)this.validatedate);
        this.email = this.GetStringValue(rawData, "email");
        LOG.debug("RegistryDto email={}", (Object)this.email);
        this.email = this.email.toLowerCase();
        this.licenseCount = this.GetIntValue(rawData, "LicenseCount");
        LOG.debug("RegistryDto LicenseCount={}", (Object)this.licenseCount);
        this.loginCode = this.GetStringValue(rawData, "LoginCode");
        LOG.debug("RegistryDto LoginCode={}", (Object)this.loginCode);
        this.canSubscrib = this.GetIntValue(rawData, "canSubscrib") > 0;
        LOG.debug("RegistryDto canSubscrib={}", (Object)this.canSubscrib);
    }

    public RegistryDto(String cmd, String snid, String hwid, String hwid2, String acdate, String email, int licenseCount, String loginCode, String validatedate, int canSubscrib) {
        this.cmd = cmd;
        this.snid = snid;
        this.hwid = hwid;
        this.hwid2 = hwid2;
        this.acdate = acdate;
        this.validatedate = validatedate;
        this.email = email.toLowerCase();
        this.licenseCount = licenseCount;
        this.loginCode = loginCode;
        this.canSubscrib = canSubscrib > 0;
    }

    public String toString() {
        return "Contact  snid=" + this.snid + ", hwid=" + this.hwid + ", hwid2=" + this.hwid2 + ", licenseCount=" + this.licenseCount + ", loginCode=" + this.loginCode + ", validatedate=" + this.validatedate + ", IsTrial=" + this.getIsTrial() + ", ParserValidateDate=" + this.ParserValidateDate() + ", canSubscrib=" + this.canSubscrib + "]";
    }

    public String getCmd() {
        return this.cmd;
    }

    public boolean getIsTrial() {
        if (!StringUtil.IsStringNullorEmpty((String)this.validatedate)) {
            DateTime dtValidateDate = this.ParserValidateDate();
            return dtValidateDate != null;
        }
        return false;
    }

    public long getExpiredLeftDays() {
        if (this.getIsTrial()) {
            DateTime dtValidateDate = this.ParserValidateDate();
            if (dtValidateDate.isAfterNow()) {
                DateTime now = DateTime.now();
                return Days.daysBetween((ReadableInstant)now, (ReadableInstant)dtValidateDate).getDays() + 1;
            }
            return 0L;
        }
        return 0L;
    }

    public boolean getIsExpired() {
        if (this.getIsTrial()) {
            DateTime dtValidateDate = this.ParserValidateDate();
            return !dtValidateDate.isAfterNow();
        }
        return false;
    }

    public DateTime ParserValidateDate() {
        if (!StringUtil.IsStringNullorEmpty((String)this.validatedate)) {
            try {
                DateTime dt = TimeUtil.ParserTime((String)"yyyyMMdd-HHmmss", (String)this.validatedate);
                return dt;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    public DateTime getValidateDate() {
        DateTime dtValidateDate = this.ParserValidateDate();
        return dtValidateDate;
    }

    public boolean getCanSubscrib() {
        return this.canSubscrib;
    }

    public String getSnid() {
        return this.snid;
    }

    public String getHwid() {
        return this.hwid;
    }

    public String getHwid2() {
        return this.hwid2;
    }

    public String getAcdate() {
        return this.acdate;
    }

    public String getEmail() {
        return this.email;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public String GetLoginCode() {
        return this.loginCode;
    }

    public DateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(DateTime updateTime) {
        this.updateTime = updateTime;
    }
}

