/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contacturl;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;

public class ContacturlInfo {
    private String guid;
    @NotBlank
    @Size(max=128)
    private String value;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactUrlType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContacturlInfo() {
    }

    public ContacturlInfo(Contacturl url) {
        this.guid = url.getGuid();
        this.value = url.getUrlValue();
        this.type = url.getUrlType();
        this.recognizeSource = url.getRecognizeSource();
    }

    public Contacturl newContacturl() {
        Contacturl url = new Contacturl();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            url.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            url.setGuid(this.guid);
        }
        url.setUrlType(this.type);
        url.setUrlValue(GlobalUtils.getFieldString((String)this.value, (int)128));
        url.setRecognizeSource(this.recognizeSource);
        return url;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactUrlType getType() {
        return this.type;
    }

    public void setType(ContactUrlType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }
}

