/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactsocial;
import com.penpower.worldcard.team.enums.ContactSocialType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;

public class ContactsocialInfo {
    private String guid;
    @NotBlank
    @Size(max=128)
    private String value;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactSocialType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactsocialInfo() {
    }

    public ContactsocialInfo(Contactsocial social) {
        this.guid = social.getGuid();
        this.value = social.getSocialValue();
        this.type = social.getSocialType();
        this.recognizeSource = social.getRecognizeSource();
    }

    public Contactsocial newContactsocial() {
        Contactsocial social = new Contactsocial();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            social.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            social.setGuid(this.guid);
        }
        social.setSocialType(this.type);
        social.setSocialValue(GlobalUtils.getFieldString((String)this.value, (int)128));
        social.setRecognizeSource(this.recognizeSource);
        return social;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactSocialType getType() {
        return this.type;
    }

    public void setType(ContactSocialType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }
}

