/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactphone;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;

public class ContactphoneInfo {
    private String guid;
    @NotBlank
    @Size(max=32)
    private String value;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactPhoneType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactphoneInfo() {
    }

    public ContactphoneInfo(Contactphone phone) {
        this.guid = phone.getGuid();
        this.type = phone.getPhoneType();
        this.value = phone.getPhoneValue();
        this.recognizeSource = phone.getRecognizeSource();
    }

    public ContactphoneInfo(String value, ContactPhoneType type, RecognizeSourceType recognizeSource) {
        this.value = value;
        this.type = type;
        this.recognizeSource = recognizeSource;
    }

    public Contactphone newContactphone() {
        Contactphone phone = new Contactphone();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            phone.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            phone.setGuid(this.guid);
        }
        phone.setPhoneType(this.type);
        phone.setPhoneValue(GlobalUtils.getFieldString((String)this.value, (int)32));
        phone.setRecognizeSource(this.recognizeSource);
        return phone;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactPhoneType getType() {
        return this.type;
    }

    public void setType(ContactPhoneType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }
}

