/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactname;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ContactnameInfo {
    private String guid;
    @Size(max=64)
    private String firstName;
    @Size(max=64)
    private String firstNamePronunce;
    @Size(max=64)
    private String lastName;
    @Size(max=64)
    private String lastNamePronunce;
    @Size(max=64)
    private String middleName;
    @Size(max=64)
    private String prefix;
    @Size(max=64)
    private String suffix;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactnameInfo() {
    }

    public ContactnameInfo(Contactname contactname) {
        this.guid = contactname.getGuid();
        this.firstName = contactname.getFirstName();
        this.firstNamePronunce = contactname.getFirstNamePronunce();
        this.lastName = contactname.getLastName();
        this.lastNamePronunce = contactname.getLastNamePronunce();
        this.middleName = contactname.getMiddleName();
        this.prefix = contactname.getPrefix();
        this.suffix = contactname.getSuffix();
        this.recognizeSource = contactname.getRecognizeSource();
    }

    public Contactname newContactname() {
        Contactname name = new Contactname();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            name.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            name.setGuid(this.guid);
        }
        name.setFirstName(GlobalUtils.getFieldString((String)this.firstName, (int)64));
        name.setFirstNamePronunce(GlobalUtils.getFieldString((String)this.firstNamePronunce, (int)64));
        name.setLastName(GlobalUtils.getFieldString((String)this.lastName, (int)64));
        name.setLastNamePronunce(GlobalUtils.getFieldString((String)this.lastNamePronunce, (int)64));
        name.setMiddleName(GlobalUtils.getFieldString((String)this.middleName, (int)64));
        name.setPrefix(GlobalUtils.getFieldString((String)this.prefix, (int)64));
        name.setSuffix(GlobalUtils.getFieldString((String)this.suffix, (int)64));
        name.setRecognizeSource(this.recognizeSource);
        return name;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstNamePronunce() {
        return this.firstNamePronunce;
    }

    public void setFirstNamePronunce(String firstNamePronunce) {
        this.firstNamePronunce = firstNamePronunce;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastNamePronunce() {
        return this.lastNamePronunce;
    }

    public void setLastNamePronunce(String lastNamePronunce) {
        this.lastNamePronunce = lastNamePronunce;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }

    public String toString() {
        return "ContactnameInfo [firstName=" + this.firstName + ", lastName=" + this.lastName + ", middleName=" + this.middleName + ", recognizeSource=" + this.recognizeSource + "]";
    }
}

