/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactjobinfo;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ContactjobinfoInfo {
    private String guid;
    @Size(max=128)
    private String companyName;
    @Size(max=128)
    private String companyPronunce;
    @Size(max=128)
    private String department;
    @Size(max=128)
    private String jobTitle;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactjobinfoInfo() {
    }

    public ContactjobinfoInfo(Contactjobinfo job) {
        this.guid = job.getGuid();
        this.companyName = job.getCompanyName();
        this.companyPronunce = job.getConpanyPronunce();
        this.department = job.getDepartment();
        this.jobTitle = job.getJobTitle();
        this.recognizeSource = job.getRecognizeSource();
    }

    public ContactjobinfoInfo(String companyName, String department, String jobTitle, RecognizeSourceType recognizeSource) {
        this.companyName = companyName;
        this.department = department;
        this.jobTitle = jobTitle;
        this.recognizeSource = recognizeSource;
    }

    public Contactjobinfo newContactjobinfo() {
        Contactjobinfo jobinfo = new Contactjobinfo();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            jobinfo.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            jobinfo.setGuid(this.guid);
        }
        jobinfo.setCompanyName(GlobalUtils.getFieldString((String)this.companyName, (int)128));
        jobinfo.setConpanyPronunce(GlobalUtils.getFieldString((String)this.companyPronunce, (int)128));
        jobinfo.setDepartment(GlobalUtils.getFieldString((String)this.department, (int)128));
        jobinfo.setJobTitle(GlobalUtils.getFieldString((String)this.jobTitle, (int)128));
        jobinfo.setRecognizeSource(this.recognizeSource);
        return jobinfo;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getCompanyPronunce() {
        return this.companyPronunce;
    }

    public void setCompanyPronunce(String companyPronunce) {
        this.companyPronunce = companyPronunce;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }

    public String toString() {
        return "ContactjobinfoInfo [guid=" + this.guid + ", companyName=" + this.companyName + ", companyPronunce=" + this.companyPronunce + ", department=" + this.department + ", jobTitle=" + this.jobTitle + "]";
    }
}

