/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactaddress;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ContactaddressInfo {
    private String guid;
    private String countryCode;
    @Size(max=64)
    private String countryName;
    @Size(max=64)
    private String city;
    @Size(max=64)
    private String state;
    @Size(max=256)
    private String street;
    @Size(max=64)
    private String zip;
    @NotNull
    private Integer addressFormat;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactFieldType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactaddressInfo() {
    }

    public ContactaddressInfo(Contactaddress ad) {
        this.guid = ad.getGuid();
        this.city = ad.getCity();
        this.countryCode = ad.getCountryCode();
        this.countryName = ad.getCountryName();
        this.state = ad.getState();
        this.street = ad.getStreet();
        this.type = ad.getAddressType();
        this.zip = ad.getZip();
        this.addressFormat = ad.getAddressFormat();
        this.recognizeSource = ad.getRecognizeSource();
    }

    public ContactaddressInfo(String countryName, String city, String state, String street, String zip, Integer addressFormat, ContactFieldType type, RecognizeSourceType recognizeSource) {
        this.countryName = countryName;
        this.city = city;
        this.state = state;
        this.street = street;
        this.zip = zip;
        this.addressFormat = addressFormat;
        this.type = type;
        this.recognizeSource = recognizeSource;
    }

    public Contactaddress newContactaddress() {
        Contactaddress address = new Contactaddress();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            address.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            address.setGuid(this.guid);
        }
        address.setCity(GlobalUtils.getFieldString((String)this.city, (int)64));
        address.setCountryName(GlobalUtils.getFieldString((String)this.countryName, (int)64));
        address.setState(GlobalUtils.getFieldString((String)this.state, (int)64));
        address.setStreet(GlobalUtils.getFieldString((String)this.street, (int)256));
        address.setZip(GlobalUtils.getFieldString((String)this.zip, (int)64));
        address.setAddressType(this.type);
        address.setCountryCode(this.countryCode);
        address.setAddressFormat(this.addressFormat);
        address.setRecognizeSource(this.recognizeSource);
        return address;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public ContactFieldType getType() {
        return this.type;
    }

    public void setType(ContactFieldType type) {
        this.type = type;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public Integer getAddressFormat() {
        return this.addressFormat;
    }

    public void setAddressFormat(Integer addressFormat) {
        this.addressFormat = addressFormat;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }

    public String GetFullAddress() {
        String fullAddress = "";
        String Comma = ",";
        String Space = " ";
        String CommaSpace = ", ";
        String PostSym = "\u3012";
        switch (this.addressFormat) {
            case 1: {
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                }
                if (StringUtil.IsStringNullorEmpty((String)this.zip)) break;
                fullAddress = fullAddress + CommaSpace;
                fullAddress = fullAddress + this.zip;
                break;
            }
            default: {
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = this.street;
                    if (!StringUtil.IsStringNullorEmpty((String)this.city) || !StringUtil.IsStringNullorEmpty((String)this.state)) {
                        fullAddress = fullAddress + CommaSpace;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                        fullAddress = fullAddress + CommaSpace;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.countryName)) break;
                fullAddress = fullAddress + this.countryName;
                break;
            }
            case 3: {
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.zip) && StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!StringUtil.IsStringNullorEmpty((String)this.state) || !StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.countryName)) break;
                fullAddress = fullAddress + this.countryName;
                break;
            }
            case 4: {
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + PostSym;
                    fullAddress = fullAddress + this.zip;
                    fullAddress = fullAddress + Space;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                }
                if (StringUtil.IsStringNullorEmpty((String)this.street)) break;
                fullAddress = fullAddress + this.street;
                break;
            }
            case 5: {
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    fullAddress = fullAddress + Space;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                }
                if (StringUtil.IsStringNullorEmpty((String)this.street)) break;
                fullAddress = fullAddress + this.street;
                break;
            }
            case 6: {
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName) || !StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                    if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.zip)) break;
                fullAddress = fullAddress + this.zip;
                break;
            }
            case 7: {
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.zip) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.zip) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    if (!StringUtil.IsStringNullorEmpty((String)this.state) || !StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.countryName)) break;
                fullAddress = fullAddress + this.countryName;
                break;
            }
            case 8: {
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + CommaSpace;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!StringUtil.IsStringNullorEmpty((String)this.state) || !StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    } else if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                    if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.zip)) break;
                fullAddress = fullAddress + this.zip;
                break;
            }
            case 9: {
                if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                    fullAddress = fullAddress + this.countryName;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.zip) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.street))) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.street))) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.city) || !StringUtil.IsStringNullorEmpty((String)this.street)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.street)) break;
                fullAddress = fullAddress + this.street;
                break;
            }
            case 10: {
                if (!StringUtil.IsStringNullorEmpty((String)this.zip)) {
                    fullAddress = fullAddress + this.zip;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.city) && StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.street) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + Space;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.city)) {
                    fullAddress = fullAddress + this.city;
                    if (!(StringUtil.IsStringNullorEmpty((String)this.state) && StringUtil.IsStringNullorEmpty((String)this.street) && StringUtil.IsStringNullorEmpty((String)this.countryName))) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.state)) {
                    fullAddress = fullAddress + this.state;
                    if (!StringUtil.IsStringNullorEmpty((String)this.street) || !StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (!StringUtil.IsStringNullorEmpty((String)this.street)) {
                    fullAddress = fullAddress + this.street;
                    if (!StringUtil.IsStringNullorEmpty((String)this.countryName)) {
                        fullAddress = fullAddress + CommaSpace;
                    }
                }
                if (StringUtil.IsStringNullorEmpty((String)this.countryName)) break;
                fullAddress = fullAddress + this.countryName;
            }
        }
        return fullAddress;
    }
}

