/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactsimpleinfo;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.SupportCRM;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class ContactSimpleInfoDto {
    private String contactGuid;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime createdTime;
    private String ownerAccountGuid;
    private String ownerAccountName;
    private Integer contactImageNum;
    private String fullname;
    private String company;
    private String jobTitle;
    private String department;
    private Boolean iscorrected;
    private Boolean isexportedtosalesforce;
    private Boolean isexportedtosugarcrm;
    private Boolean isdownloadedtoprivate;

    public ContactSimpleInfoDto() {
        this.setContactImageNum(Integer.valueOf(0));
        this.setIscorrected(Boolean.valueOf(false));
        this.setIsexportedtosalesforce(Boolean.valueOf(false));
        this.setIsexportedtosugarcrm(Boolean.valueOf(false));
        this.setIsdownloadedtoprivate(Boolean.valueOf(false));
    }

    public String toString() {
        return "ContactSimpleInfoDto [ownerAccountGuid=" + this.ownerAccountGuid + ", contactGuid=" + this.contactGuid + ", fullname=" + this.fullname + "]";
    }

    public ContactSimpleInfoDto(Contactsimpleinfo simpleInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType, Contact contact) {
        this();
        if (NameDisplayOrderSettingType.EAST_FL_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
            this.setFullname(simpleInfo.getFullnameeastfirstwestfirst());
        } else if (NameDisplayOrderSettingType.EAST_FL_WEST_LF.equals((Object)nameDisplayOrderSettingType)) {
            this.setFullname(simpleInfo.getFullnameeastfirstwestlast());
        } else if (NameDisplayOrderSettingType.EAST_LF_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
            this.setFullname(simpleInfo.getFullnameeastlastwestfirst());
        } else {
            this.setFullname(simpleInfo.getFullnameeastlastwestlast());
        }
        this.setCompany(simpleInfo.getCompany());
        this.setJobTitle(simpleInfo.getJobTitle());
        this.setDepartment(simpleInfo.getDepartment());
        this.setCreatedTime(simpleInfo.getCreateTime());
        if (contact != null) {
            this.setContactGuid(contact.getGuid());
            this.setOwnerAccountGuid(contact.getOwnerAccount().getGuid());
            this.setOwnerAccountName(contact.getOwnerAccount().getDisplayName());
            this.setIscorrected(contact.getIsCorrected());
            List contactimages = contact.getContactimages();
            if (!CollectionUtils.isEmpty((Collection)contactimages)) {
                this.setContactImageNum(Integer.valueOf((int)contactimages.stream().filter(im -> !ContactImageType.LOGO.equals((Object)im.getImageType())).count()));
            }
        }
    }

    public ContactSimpleInfoDto(Contactsimpleinfo s, NameDisplayOrderSettingType nameDisplayOrderSettingType, Contact contact, Contactstatusforaccount status, SupportCRM supportCRM, String crmAccount) {
        this(s, nameDisplayOrderSettingType, contact);
        if (status != null) {
            if (SupportCRM.SALESFORCE.equals((Object)supportCRM) && crmAccount.equals(status.getSalesforceaccount()) && (!StringUtil.IsStringNullorEmpty((String)status.getExporttosalesforceid()) || !StringUtil.IsStringNullorEmpty((String)status.getExporttosalesforceleadid()))) {
                this.setIsexportedtosalesforce(Boolean.valueOf(true));
            }
            if (SupportCRM.SUGAR_CRM.equals((Object)supportCRM) && crmAccount.equals(status.getSugarcrmaccount()) && !StringUtil.IsStringNullorEmpty((String)status.getExporttosugarcrmid())) {
                this.setIsexportedtosugarcrm(Boolean.valueOf(true));
            }
        }
    }

    public String getDepartment() {
        return this.department;
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    public String getOwnerAccountGuid() {
        return this.ownerAccountGuid;
    }

    public String getOwnerAccountName() {
        return this.ownerAccountName;
    }

    public Integer getContactImageNum() {
        return this.contactImageNum;
    }

    public void setContactImageNum(Integer contactImageNum) {
        this.contactImageNum = contactImageNum;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setCreatedTime(DateTime createdTime) {
        this.createdTime = createdTime;
    }

    public void setOwnerAccountGuid(String ownerAccountGuid) {
        this.ownerAccountGuid = ownerAccountGuid;
    }

    public void setOwnerAccountName(String ownerAccountName) {
        this.ownerAccountName = ownerAccountName;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getContactGuid() {
        return this.contactGuid;
    }

    public void setContactGuid(String contactGuid) {
        this.contactGuid = contactGuid;
    }

    public Boolean getIscorrected() {
        return this.iscorrected;
    }

    public void setIscorrected(Boolean iscorrected) {
        this.iscorrected = iscorrected;
    }

    public Boolean getIsexportedtosalesforce() {
        return this.isexportedtosalesforce;
    }

    public Boolean getIsexportedtosugarcrm() {
        return this.isexportedtosugarcrm;
    }

    public void setIsexportedtosalesforce(Boolean isexportedtosalesforce) {
        this.isexportedtosalesforce = isexportedtosalesforce;
    }

    public void setIsexportedtosugarcrm(Boolean isexportedtosugarcrm) {
        this.isexportedtosugarcrm = isexportedtosugarcrm;
    }

    public Boolean getIsdownloadedtoprivate() {
        return this.isdownloadedtoprivate;
    }

    public void setIsdownloadedtoprivate(Boolean isdownloadedtoprivate) {
        this.isdownloadedtoprivate = isdownloadedtoprivate;
    }
}

