/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ContactInfoForEs {
    private String guid;
    private List<String> fullname;
    private String fullnameeastfirstwestfirst;
    private String fullnameeastfirstwestlast;
    private String fullnameeastlastwestfirst;
    private String fullnameeastlastwestlast;
    private List<String> autocompleteField;
    private List<String> company;
    private List<String> department;
    private List<String> jobTitle;
    private List<String> phoneNumber;
    private List<String> fullAddress;
    private List<String> instantMessage;
    private List<String> socialNetwork;
    private List<String> email;
    private List<String> url;
    private String note;
    private String uniformNumber;
    private String ownerGuid;
    private String creatorGuid;
    private String editorGuid;
    private Long createTime;
    private Long modifyTime;
    private List<String> totalContent;
    private String joinfield;

    public ContactInfoForEs() {
    }

    public ContactInfoForEs(Contact contact) {
        Account owner;
        ArrayList<String> fullnameBuilder = new ArrayList<String>();
        ArrayList companyBuilder = new ArrayList();
        ArrayList departmentBuilder = new ArrayList();
        ArrayList jobTitleBuilder = new ArrayList();
        ArrayList phoneNumberBuilder = new ArrayList();
        ArrayList fullAddressBuilder = new ArrayList();
        ArrayList instantMessageBuilder = new ArrayList();
        ArrayList socialNetworkBuilder = new ArrayList();
        ArrayList emailBuilder = new ArrayList();
        ArrayList urlBuilder = new ArrayList();
        ArrayList<String> totalContentBuilder = new ArrayList<String>();
        this.guid = contact.getGuid();
        if (!CollectionUtils.isEmpty((Collection)contact.getContactnames())) {
            contact.getContactnames().stream().forEach(name -> {
                String lastName = name.getLastName();
                String firstName = name.getFirstName();
                if (StringUtils.isEmpty((String)lastName) && StringUtils.isNotEmpty((String)firstName)) {
                    fullnameBuilder.add(firstName);
                } else if (StringUtils.isNotEmpty((String)lastName) && StringUtils.isEmpty((String)firstName)) {
                    fullnameBuilder.add(lastName);
                } else if (StringUtils.isNotEmpty((String)lastName) && StringUtils.isNotEmpty((String)firstName)) {
                    fullnameBuilder.add(firstName + " " + lastName);
                    fullnameBuilder.add(lastName + " " + firstName);
                    fullnameBuilder.add(firstName + lastName);
                    fullnameBuilder.add(lastName + firstName);
                }
                fullnameBuilder.add(name.getFirstNamePronunce());
                fullnameBuilder.add(name.getLastNamePronunce());
                fullnameBuilder.add(name.getMiddleName());
                fullnameBuilder.add(name.getPrefix());
                fullnameBuilder.add(name.getSuffix());
                if (name.getFieldOrder().equals(0)) {
                    Map nameOrder = GlobalUtils.getNameOrderString((String)name.getFirstName(), (String)name.getLastName());
                    this.fullnameeastlastwestfirst = (String)nameOrder.get(NameDisplayOrderSettingType.EAST_LF_WEST_FL);
                    this.fullnameeastfirstwestlast = (String)nameOrder.get(NameDisplayOrderSettingType.EAST_FL_WEST_LF);
                    this.fullnameeastfirstwestfirst = (String)nameOrder.get(NameDisplayOrderSettingType.EAST_FL_WEST_FL);
                    this.fullnameeastlastwestlast = (String)nameOrder.get(NameDisplayOrderSettingType.EAST_LF_WEST_LF);
                    this.autocompleteField = Arrays.asList((String)nameOrder.get(NameDisplayOrderSettingType.EAST_FL_WEST_FL), (String)nameOrder.get(NameDisplayOrderSettingType.EAST_LF_WEST_LF));
                }
            });
        }
        if (contact.getNickname() != null) {
            fullnameBuilder.add(contact.getNickname());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
            contact.getContactjobinfos().stream().forEach(jobinfo -> {
                if (jobinfo.getCompanyName() != null) {
                    if (this.autocompleteField != null) {
                        ArrayList<String> newAutocompleteField = new ArrayList<String>();
                        newAutocompleteField.addAll(this.autocompleteField);
                        newAutocompleteField.add(jobinfo.getCompanyName());
                        this.autocompleteField = newAutocompleteField;
                    } else {
                        this.autocompleteField = Arrays.asList(jobinfo.getCompanyName());
                    }
                }
                companyBuilder.add(jobinfo.getCompanyName());
                companyBuilder.add(jobinfo.getConpanyPronunce());
                departmentBuilder.add(jobinfo.getDepartment());
                jobTitleBuilder.add(jobinfo.getJobTitle());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactphones())) {
            contact.getContactphones().stream().forEach(contactphone -> phoneNumberBuilder.add(contactphone.getPhoneValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactaddresses())) {
            contact.getContactaddresses().stream().forEach(contactaddress -> {
                fullAddressBuilder.add(contactaddress.getCountryName());
                fullAddressBuilder.add(contactaddress.getCountryCode());
                fullAddressBuilder.add(contactaddress.getCity());
                fullAddressBuilder.add(contactaddress.getStreet());
                fullAddressBuilder.add(contactaddress.getZip());
                fullAddressBuilder.add(contactaddress.getState());
                fullAddressBuilder.add(contactaddress.GetFullAddress());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactims())) {
            contact.getContactims().stream().forEach(contactim -> instantMessageBuilder.add(contactim.getImValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactsocials())) {
            contact.getContactsocials().stream().forEach(contactsocial -> socialNetworkBuilder.add(contactsocial.getSocialValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactemails())) {
            contact.getContactemails().stream().forEach(contactemail -> emailBuilder.add(contactemail.getEmailValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContacturls())) {
            contact.getContacturls().stream().forEach(contacturl -> urlBuilder.add(contacturl.getUrlValue()));
        }
        if (StringUtils.isNotEmpty((String)contact.getNote())) {
            this.note = contact.getNote();
            totalContentBuilder.add(contact.getNote());
        }
        if (StringUtils.isNotEmpty((String)contact.getUniformNumber())) {
            this.uniformNumber = contact.getUniformNumber();
            totalContentBuilder.add(contact.getUniformNumber());
        }
        if (contact.getBirthday() != null) {
            String birthDayFormatted = contact.getBirthday().toString("yyyy/MM/dd");
            totalContentBuilder.add(birthDayFormatted);
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactdates())) {
            contact.getContactdates().stream().forEach(contactdate -> {
                String dateFormatted = contactdate.getDateValue().toString("yyyy/MM/dd");
                totalContentBuilder.add(dateFormatted);
            });
        }
        if ((owner = contact.getOwnerAccount()) != null) {
            this.ownerGuid = owner.getGuid();
        }
        this.creatorGuid = contact.getCreatorGuid();
        this.editorGuid = contact.getEditorguid();
        this.createTime = contact.getCreateTime().getMillis();
        this.modifyTime = contact.getModifytimefordisplay().getMillis();
        this.joinfield = "contactinfo";
        if (!CollectionUtils.isEmpty(fullnameBuilder)) {
            this.fullname = fullnameBuilder;
            totalContentBuilder.addAll(fullnameBuilder);
        }
        if (!CollectionUtils.isEmpty(companyBuilder)) {
            this.company = companyBuilder;
            totalContentBuilder.addAll(companyBuilder);
        }
        if (!CollectionUtils.isEmpty(departmentBuilder)) {
            this.department = departmentBuilder;
            totalContentBuilder.addAll(departmentBuilder);
        }
        if (!CollectionUtils.isEmpty(jobTitleBuilder)) {
            this.jobTitle = jobTitleBuilder;
            totalContentBuilder.addAll(jobTitleBuilder);
        }
        if (!CollectionUtils.isEmpty(phoneNumberBuilder)) {
            this.phoneNumber = phoneNumberBuilder;
            totalContentBuilder.addAll(phoneNumberBuilder);
        }
        if (!CollectionUtils.isEmpty(fullAddressBuilder)) {
            this.fullAddress = fullAddressBuilder;
            totalContentBuilder.addAll(fullAddressBuilder);
        }
        if (!CollectionUtils.isEmpty(instantMessageBuilder)) {
            this.instantMessage = instantMessageBuilder;
            totalContentBuilder.addAll(instantMessageBuilder);
        }
        if (!CollectionUtils.isEmpty(socialNetworkBuilder)) {
            this.socialNetwork = socialNetworkBuilder;
            totalContentBuilder.addAll(socialNetworkBuilder);
        }
        if (!CollectionUtils.isEmpty(emailBuilder)) {
            this.email = emailBuilder;
            totalContentBuilder.addAll(emailBuilder);
        }
        if (!CollectionUtils.isEmpty(urlBuilder)) {
            this.url = urlBuilder;
            totalContentBuilder.addAll(urlBuilder);
        }
        if (!CollectionUtils.isEmpty(totalContentBuilder)) {
            this.totalContent = totalContentBuilder;
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public List<String> getFullname() {
        return this.fullname;
    }

    public void setFullname(List<String> fullname) {
        this.fullname = fullname;
    }

    public String getFullnameeastfirstwestfirst() {
        return this.fullnameeastfirstwestfirst;
    }

    public void setFullnameeastfirstwestfirst(String fullnameeastfirstwestfirst) {
        this.fullnameeastfirstwestfirst = fullnameeastfirstwestfirst;
    }

    public String getFullnameeastfirstwestlast() {
        return this.fullnameeastfirstwestlast;
    }

    public void setFullnameeastfirstwestlast(String fullnameeastfirstwestlast) {
        this.fullnameeastfirstwestlast = fullnameeastfirstwestlast;
    }

    public String getFullnameeastlastwestfirst() {
        return this.fullnameeastlastwestfirst;
    }

    public void setFullnameeastlastwestfirst(String fullnameeastlastwestfirst) {
        this.fullnameeastlastwestfirst = fullnameeastlastwestfirst;
    }

    public String getFullnameeastlastwestlast() {
        return this.fullnameeastlastwestlast;
    }

    public void setFullnameeastlastwestlast(String fullnameeastlastwestlast) {
        this.fullnameeastlastwestlast = fullnameeastlastwestlast;
    }

    public List<String> getAutocompleteField() {
        return this.autocompleteField;
    }

    public void setAutocompleteField(List<String> autocompleteField) {
        this.autocompleteField = autocompleteField;
    }

    public List<String> getCompany() {
        return this.company;
    }

    public void setCompany(List<String> company) {
        this.company = company;
    }

    public List<String> getDepartment() {
        return this.department;
    }

    public void setDepartment(List<String> department) {
        this.department = department;
    }

    public List<String> getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(List<String> jobTitle) {
        this.jobTitle = jobTitle;
    }

    public List<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(List<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public List<String> getFullAddress() {
        return this.fullAddress;
    }

    public void setFullAddress(List<String> fullAddress) {
        this.fullAddress = fullAddress;
    }

    public List<String> getInstantMessage() {
        return this.instantMessage;
    }

    public void setInstantMessage(List<String> instantMessage) {
        this.instantMessage = instantMessage;
    }

    public List<String> getSocialNetwork() {
        return this.socialNetwork;
    }

    public void setSocialNetwork(List<String> socialNetwork) {
        this.socialNetwork = socialNetwork;
    }

    public List<String> getEmail() {
        return this.email;
    }

    public void setEmail(List<String> email) {
        this.email = email;
    }

    public List<String> getUrl() {
        return this.url;
    }

    public void setUrl(List<String> url) {
        this.url = url;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getUniformNumber() {
        return this.uniformNumber;
    }

    public void setUniformNumber(String uniformNumber) {
        this.uniformNumber = uniformNumber;
    }

    public String getOwnerGuid() {
        return this.ownerGuid;
    }

    public void setOwnerGuid(String ownerGuid) {
        this.ownerGuid = ownerGuid;
    }

    public String getCreatorGuid() {
        return this.creatorGuid;
    }

    public void setCreatorGuid(String creatorGuid) {
        this.creatorGuid = creatorGuid;
    }

    public String getEditorGuid() {
        return this.editorGuid;
    }

    public void setEditorGuid(String editorGuid) {
        this.editorGuid = editorGuid;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public List<String> getTotalContent() {
        return this.totalContent;
    }

    public void setTotalContent(List<String> totalContent) {
        this.totalContent = totalContent;
    }

    public String getJoinfield() {
        return this.joinfield;
    }

    public void setJoinfield(String joinfield) {
        this.joinfield = joinfield;
    }
}

