/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dao;

import com.penpower.worldcard.team.entity.Notice;
import com.penpower.worldcard.team.enums.NotifyCategory;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface NoticeDao
extends JpaRepository<Notice, String> {
    @Query(value="SELECT t FROM Notice t WHERE t.account.guid = ?1")
    public List<Notice> findByAccountGuid(@Param(value="accountGuid") String var1);

    @Query(value="SELECT t FROM Notice t WHERE t.account.guid = ?1 AND t.isviewed = ?2")
    public List<Notice> findByAccountGuidAndIsviewed(@Param(value="accountGuid") String var1, @Param(value="isviewed") boolean var2);

    @Query(value="SELECT t FROM Notice t WHERE t.account.guid = ?1 and t.notifycategory = ?2")
    public List<Notice> findByAccountGuidAndNotifyCategory(@Param(value="accountGuid") String var1, @Param(value="notifyCategory") NotifyCategory var2);

    @Query(value="SELECT t FROM Notice t WHERE t.account.guid = ?1 and t.notifycategory = ?2 AND t.isviewed = ?3")
    public List<Notice> findByAccountGuidAndNotifyCategoryAndIsviewed(@Param(value="accountGuid") String var1, @Param(value="notifyCategory") NotifyCategory var2, @Param(value="isviewed") boolean var3);

    @Modifying
    @Query(value="update Notice t set t.companyguid = :companyGuid ")
    public void updateAllNoticeWithCompany(@Param(value="companyGuid") String var1);

    @Query(value="SELECT t FROM Notice t LEFT OUTER JOIN t.senderAccount b WHERE t.account.guid = ?1")
    public Page<Notice> findByAccountGuidPage(@Param(value="accountGuid") String var1, Pageable var2);

    @Query(value="SELECT t FROM Notice t LEFT OUTER JOIN t.senderAccount b WHERE t.account.guid = ?1 AND t.isviewed = ?2")
    public Page<Notice> findByAccountGuidAndIsviewedPage(@Param(value="accountGuid") String var1, @Param(value="isviewed") boolean var2, Pageable var3);

    @Query(value="SELECT t FROM Notice t LEFT OUTER JOIN t.senderAccount b WHERE t.account.guid = ?1 and t.notifycategory = ?2")
    public Page<Notice> findByAccountGuidAndNotifyCategoryPage(@Param(value="accountGuid") String var1, @Param(value="notifyCategory") NotifyCategory var2, Pageable var3);

    @Query(value="SELECT t FROM Notice t LEFT OUTER JOIN t.senderAccount b WHERE t.account.guid = ?1 and t.notifycategory = ?2 AND t.isviewed = ?3")
    public Page<Notice> findByAccountGuidAndNotifyCategoryAndIsviewedPage(@Param(value="accountGuid") String var1, @Param(value="notifyCategory") NotifyCategory var2, @Param(value="isviewed") boolean var3, Pageable var4);

    @Query(value="SELECT COUNT(t) FROM Notice t WHERE t.account.guid = ?1 and t.notifycategory = ?2 and t.isviewed = ?3 and notifytime > ?4")
    public Long countByNotifyCategoryAndReceiverGuidAndIsViewedAndNotifyTime(@Param(value="accountGuid") String var1, @Param(value="notifyCategory") NotifyCategory var2, @Param(value="isViewed") boolean var3, @Param(value="notifyTime") DateTime var4);

    @Query(value="SELECT COUNT(t) FROM Notice t WHERE t.account.guid = ?1 and t.isviewed = ?2 and notifytime > ?3")
    public Long countByReceiverGuidAndIsViewedAndNotifyTime(@Param(value="accountGuid") String var1, @Param(value="isViewed") boolean var2, @Param(value="notifyTime") DateTime var3);

    @Query(value="SELECT COUNT(t) FROM Notice t WHERE t.account.guid = ?1 ")
    public Long countByReceiverGuid(@Param(value="accountGuid") String var1);
}

