/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dao;

import com.penpower.worldcard.team.entity.Contactsimpleinfo;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ContactSimpleInfoDao
extends JpaRepository<Contactsimpleinfo, String> {
    public List<Contactsimpleinfo> findByGuidIn(List<String> var1);

    @Query(value="select cs from Contactsimpleinfo cs where cs.contact.guid  = ?1")
    public Contactsimpleinfo findByContactGuid(@Param(value="contactGuid") String var1);

    @Query(value="select cs from Contactsimpleinfo cs where cs.contact.guid in :contactGuids")
    public List<Contactsimpleinfo> findByContactGuids(@Param(value="contactGuids") List<String> var1);

    @Query(value="select cs from Contactsimpleinfo cs where cs.contact.guid in :contactGuids")
    public Page<Contactsimpleinfo> findPageByContactGuidList(@Param(value="contactGuids") List<String> var1, Pageable var2);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c where   c.companyguid = :companyGuid and c.guid = cs.contact.guid  and  cs.contact.guid in (select c.guid from Contact c where c.isdeleted=false and c.createtime >=:startTime and c.createtime <=:endTime)")
    public List<String> findGuidByAllUndeleted(Sort var1, @Param(value="startTime") DateTime var2, @Param(value="endTime") DateTime var3, @Param(value="companyGuid") String var4);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c where c.owneraccount.guid=:accountGuid and c.isdeleted=false and c.createtime >=:startTime and c.createtime <=:endTime)")
    public List<String> findGuidOwnedByAccount(@Param(value="accountGuid") String var1, Sort var2, @Param(value="startTime") DateTime var3, @Param(value="endTime") DateTime var4);

    @Query(value="select cs.guid from Contactsimpleinfo cs where cs.contact.guid in (select c.guid from Contact c join c.accountscanview a where c.owneraccount.guid = :XaccountGuid and a.guid in :YaccountGuids and c.isdeleted=false and c.createtime >=:startTime and c.createtime <=:endTime)")
    public List<String> findGuidOwnedByXandCanViewByYs(@Param(value="XaccountGuid") String var1, @Param(value="YaccountGuids") List<String> var2, Sort var3, @Param(value="startTime") DateTime var4, @Param(value="endTime") DateTime var5);

    @Query(value="select cs from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c join c.accountscanview a where a.guid in :accountGuids and c.isdeleted=false) or c.guid in (select c.guid from Contact c join c.owneraccount a where a.guid in :accountGuids and c.isdeleted=false)")
    public Page<Contactsimpleinfo> findPageAllCanViewByAccounts(@Param(value="accountGuids") List<String> var1, Pageable var2);

    @Query(value="select cs.guid from contactsimpleinfo cs, contact c where cs.contact_guid = c.guid and c.guid in (select distinct acv.contact_guid from account a, account_can_view_contact acv where a.guid in :accountGuids and a.guid = acv.account_guid union all select distinct c.guid from account a, contact c where a.guid in :accountGuids and a.guid = c.ownerguid) and c.isdeleted = 0 and c.createtime AT TIME ZONE 'UTC' >= to_timestamp(:strStartTime,'YYYY-MM-DD HH24:MI:SS.MS') and c.createtime AT TIME ZONE 'UTC' <= to_timestamp(:strEndTime,'YYYY-MM-DD HH24:MI:SS.MS') order by CASE WHEN :orderBy = 'fullnameeastfirstwestfirst ASC'  THEN cs.fullnameeastfirstwestfirst END ASC ,CASE WHEN :orderBy = 'fullnameeastfirstwestfirst DESC' THEN cs.fullnameeastfirstwestfirst END DESC ,CASE WHEN :orderBy = 'fullnameeastfirstwestlast ASC'  THEN cs.fullnameeastfirstwestlast END ASC ,CASE WHEN :orderBy = 'fullnameeastfirstwestlast DESC' THEN cs.fullnameeastfirstwestlast END DESC ,CASE WHEN :orderBy = 'fullnameeastlastwestfirst ASC'  THEN cs.fullnameeastlastwestfirst END ASC ,CASE WHEN :orderBy = 'fullnameeastlastwestfirst DESC' THEN cs.fullnameeastlastwestfirst END DESC ,CASE WHEN :orderBy = 'fullnameeastlastwestlast ASC'  THEN cs.fullnameeastlastwestlast END ASC ,CASE WHEN :orderBy = 'fullnameeastlastwestlast DESC' THEN cs.fullnameeastlastwestlast END DESC ,CASE WHEN :orderBy = 'company ASC'  THEN cs.company END ASC ,CASE WHEN :orderBy = 'company DESC' THEN cs.company END DESC ,CASE WHEN :orderBy = 'department ASC'  THEN cs.department END ASC ,CASE WHEN :orderBy = 'department DESC' THEN cs.department END DESC ,CASE WHEN :orderBy = 'jobtitle ASC'  THEN cs.jobtitle END ASC ,CASE WHEN :orderBy = 'jobtitle DESC' THEN cs.jobtitle END DESC ,CASE WHEN :orderBy = 'createtime ASC'  THEN cs.createtime END ASC ,CASE WHEN :orderBy = 'createtime DESC' THEN cs.createtime END DESC,cs.createtime DESC ,cs.guid ASC", nativeQuery=true)
    public List<String> findGuidAllCanViewByAccounts(@Param(value="accountGuids") List<String> var1, @Param(value="orderBy") String var2, @Param(value="strStartTime") String var3, @Param(value="strEndTime") String var4);

    @Query(value="select cs.guid from contactsimpleinfo cs, contact c where cs.contact_guid = c.guid and c.guid in (select distinct acv.contact_guid from account a, account_can_view_contact acv where a.guid in :accountGuids and a.guid = acv.account_guid union all select distinct c.guid from account a, contact c where a.guid in :accountGuids and a.guid = c.ownerguid) and c.isdeleted = 0 and switchoffset(c.createtime, '+00:00') >= convert(datetime, :strStartTime, 121) and switchoffset(c.createtime, '+00:00') <= convert(datetime, :strEndTime, 121) order by CASE WHEN :orderBy = 'fullnameeastfirstwestfirst ASC'  THEN cs.fullnameeastfirstwestfirst END ASC ,CASE WHEN :orderBy = 'fullnameeastfirstwestfirst DESC' THEN cs.fullnameeastfirstwestfirst END DESC ,CASE WHEN :orderBy = 'fullnameeastfirstwestlast ASC'  THEN cs.fullnameeastfirstwestlast END ASC ,CASE WHEN :orderBy = 'fullnameeastfirstwestlast DESC' THEN cs.fullnameeastfirstwestlast END DESC ,CASE WHEN :orderBy = 'fullnameeastlastwestfirst ASC'  THEN cs.fullnameeastlastwestfirst END ASC ,CASE WHEN :orderBy = 'fullnameeastlastwestfirst DESC' THEN cs.fullnameeastlastwestfirst END DESC ,CASE WHEN :orderBy = 'fullnameeastlastwestlast ASC'  THEN cs.fullnameeastlastwestlast END ASC ,CASE WHEN :orderBy = 'fullnameeastlastwestlast DESC' THEN cs.fullnameeastlastwestlast END DESC ,CASE WHEN :orderBy = 'company ASC'  THEN cs.company END ASC ,CASE WHEN :orderBy = 'company DESC' THEN cs.company END DESC ,CASE WHEN :orderBy = 'department ASC'  THEN cs.department END ASC ,CASE WHEN :orderBy = 'department DESC' THEN cs.department END DESC ,CASE WHEN :orderBy = 'jobtitle ASC'  THEN cs.jobtitle END ASC ,CASE WHEN :orderBy = 'jobtitle DESC' THEN cs.jobtitle END DESC ,CASE WHEN :orderBy = 'createtime ASC'  THEN cs.createtime END ASC ,CASE WHEN :orderBy = 'createtime DESC' THEN cs.createtime END DESC,cs.createtime DESC ,cs.guid ASC", nativeQuery=true)
    public List<String> findGuidAllCanViewByAccounts_MSSQL(@Param(value="accountGuids") List<String> var1, @Param(value="orderBy") String var2, @Param(value="strStartTime") String var3, @Param(value="strEndTime") String var4);

    @Query(value="select cs from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryGuid and c.isdeleted=false)")
    public Page<Contactsimpleinfo> findPageByCategory(@Param(value="categoryGuid") String var1, Pageable var2);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c where c.guid not in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryAllGuid) and c.owneraccount.guid = :contactOwnerGuid and c.createtime >=:startTime and c.createtime <=:endTime and c.isdeleted=false")
    public List<String> findGuidUncategoryByContactOwner(@Param(value="contactOwnerGuid") String var1, @Param(value="categoryAllGuid") String var2, Sort var3, @Param(value="startTime") DateTime var4, @Param(value="endTime") DateTime var5);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryGuid and c.owneraccount.guid = :contactOwnerGuid and c.createtime >=:startTime and c.createtime <=:endTime and c.isdeleted=false)")
    public List<String> findGuidByCategoryAndContactOwner(@Param(value="categoryGuid") String var1, @Param(value="contactOwnerGuid") String var2, Sort var3, @Param(value="startTime") DateTime var4, @Param(value="endTime") DateTime var5);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c join cs.contact.accountscanview a where c.guid not in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryAllGuid) and c.owneraccount.guid = :contactOwnerGuid and a.guid = :canViewAccountGuid and c.createtime >=:startTime and c.createtime <=:endTime and c.isdeleted=false")
    public List<String> findGuidUncategoryByContactOwnerAndAccountCanView(@Param(value="contactOwnerGuid") String var1, @Param(value="categoryAllGuid") String var2, @Param(value="canViewAccountGuid") String var3, Sort var4, @Param(value="startTime") DateTime var5, @Param(value="endTime") DateTime var6);

    @Query(value="select cs.guid from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c join c.categoriesownme ca join c.accountscanview a where ca.guid=:categoryGuid and c.owneraccount.guid = :contactOwnerGuid and a.guid = :canViewAccountGuid and c.createtime >=:startTime and c.createtime <=:endTime and c.isdeleted=false)")
    public List<String> findGuidByCategoryAndContactOwnerAndAccountCanView(@Param(value="categoryGuid") String var1, @Param(value="contactOwnerGuid") String var2, @Param(value="canViewAccountGuid") String var3, Sort var4, @Param(value="startTime") DateTime var5, @Param(value="endTime") DateTime var6);

    @Query(value="select cs from Contactsimpleinfo cs join cs.contact c where c.guid in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryGuid and c.iscorrected=false and c.isdeleted=false)")
    public Page<Contactsimpleinfo> findPageWithUncorrectedByCategory(@Param(value="categoryGuid") String var1, Pageable var2);
}

