/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dao;

import com.penpower.worldcard.team.dto.ContactGuidAndOwner;
import com.penpower.worldcard.team.dto.ContactObject;
import com.penpower.worldcard.team.dto.ContactSimpleInfoCustomerDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.enums.CategoryType;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ContactDao
extends JpaRepository<Contact, String> {
    @Query(value="select p.guid from Contact p where p.isdeleted=true order by p.modifytime asc")
    public List<String> findGuidDeletedAndOrderByModifyTimeAsc();

    @Query(value="select count(p) from Contact p where p.owneraccount.guid=:ownerGuid and p.isdeleted=:isDeleted and p.createtime >= :startTime and p.createtime <= :endTime")
    public Long countByOwneraccountAndIsdeleted(@Param(value="ownerGuid") String var1, @Param(value="isDeleted") Boolean var2, @Param(value="startTime") DateTime var3, @Param(value="endTime") DateTime var4);

    @Query(value="select count(p) from Contact p where p.companyguid =:companyGuid and p.isdeleted=:isDeleted ")
    public Long countByIsdeletedwithCompany(@Param(value="isDeleted") Boolean var1, @Param(value="companyGuid") String var2);

    public Long countByIsdeleted(Boolean var1);

    @Query(value="select p.guid from Contact p where p.modifytimeforsearch > p.modifytimeinsearch")
    public Page<String> findGuidsByModifyTimeForSearchNewerThanModifyTimeInSearch(Pageable var1);

    @Query(value="select p from Contact p where p.modifytimeforsearch > p.modifytimeinsearch")
    public Page<Contact> findByModifyTimeForSearchNewerThanModifyTimeInSearch(Pageable var1);

    @Query(value="select p.guid from Contact p where p.isdeleted=false")
    public Page<String> findGuidsByLimitCount(Pageable var1);

    @Query(value="select count(p) from Contact p where p.modifytimeforsearch > p.modifytimeinsearch")
    public long countByModifyTimeForSearchNewerThanModifyTimeInSearch();

    @Modifying
    @Query(value="update Contact p set p.modifytimeinsearch = :timelongvalue where p.modifytimeinsearch != :timelongvalue")
    public void setAllModifyTimeInSearch(@Param(value="timelongvalue") double var1);

    @Modifying
    @Query(value="update Contact p set p.modifytimeinsearch = :timelongvalue where p.guid in :contactGuids")
    public void setContactModifyTimeInSearch(@Param(value="contactGuids") List<String> var1, @Param(value="timelongvalue") double var2);

    @Modifying
    @Query(value="update Contact p set p.modifytimeinsearch = :modifytimeinsearch where p.guid=:contactGuid")
    public void updateContactModifyTimeInSearchByGuid(@Param(value="contactGuid") String var1, @Param(value="modifytimeinsearch") double var2);

    public List<Contact> findByGuidIn(List<String> var1);

    @Query(value="select count(p) from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false")
    public Long countByCategory(@Param(value="categoryGuid") String var1);

    @Query(value="select count(*) from category_has_contact where category_has_contact.category_guid=:categoryGuid", nativeQuery=true)
    public Long countByCategoryByNativeQuery(@Param(value="categoryGuid") String var1);

    @Query(value="select count(p) from Contact p join p.categoriesownme c where c.guid=:categoryGuid")
    public Long countByCategoryWithDeleted(@Param(value="categoryGuid") String var1);

    @Query(value="select count(p) from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.owneraccount.guid = :ownerGuid and p.isdeleted=false")
    public Long countByCategoryAndOwner(@Param(value="categoryGuid") String var1, @Param(value="ownerGuid") String var2);

    @Query(value="select count(p) from Contact p join p.categoriesownme c join p.accountscanview a where c.guid=:categoryGuid and p.owneraccount.guid = :ownerGuid and a.guid = :canViewAccountGuid and p.isdeleted=false")
    public Long countByCategoryAndOwnerAndAccountCanView(@Param(value="categoryGuid") String var1, @Param(value="ownerGuid") String var2, @Param(value="canViewAccountGuid") String var3);

    @Query(value="select count(p) from Contact p where p.owneraccount.guid=:ownerGuid and p.guid not in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryAllGuid) and p.isdeleted=false")
    public Long countUncategoryByOwner(@Param(value="ownerGuid") String var1, @Param(value="categoryAllGuid") String var2);

    @Query(value="select count(p) from Contact p join p.accountscanview a where p.owneraccount.guid=:ownerGuid and p.guid not in (select c.guid from Contact c join c.categoriesownme ca where ca.guid=:categoryAllGuid) and a.guid = :canViewAccountGuid and p.isdeleted=false")
    public Long countUncategoryByOwnerAndAccountCanView(@Param(value="ownerGuid") String var1, @Param(value="categoryAllGuid") String var2, @Param(value="canViewAccountGuid") String var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false")
    public List<Contact> findByCategory(@Param(value="categoryGuid") String var1);

    @Query(value="select p from Contact p where  p.isdeleted=false order by p.modifytime desc ")
    public Page<Contact> getLastContacts(Pageable var1);

    @Query(value="select p from Contact p where  p.isdeleted = false and p.companyguid = :CompanyGuid")
    public Page<Contact> getLastContactByCompanyGuid(@Param(value="CompanyGuid") String var1, Pageable var2);

    public Contact findFirstByIsdeletedAndOwneraccountGuid(boolean var1, String var2);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false   order by p.modifytime asc ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCount(@Param(value="categoryGuid") String var1, Pageable var2);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false  and  p.modifytime >= :seekTime and p.modifytime < :seprateTime   ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCountBeforeTime(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, @Param(value="seprateTime") DateTime var3, Pageable var4);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and  p.modifytime >= :seekTime and p.modifytime >=:seprateTime   order by p.modifytime asc ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCountAfterTime(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, @Param(value="seprateTime") DateTime var3, Pageable var4);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and  p.modifytime >= :seekTime     ")
    public Page<Contact> findSeekByCategorybyOrderModifyTimeLimitCount(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, Pageable var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false and  p.modifytime >= :seekTime ")
    public Page<Contact> findSeekByCategorybyOrderModifyTimeLimitCountWithoutDeleted(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, Pageable var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false and p.modifytime >=:seekTime   order by p.modifytime asc ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCountAfterSeekTime(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, Pageable var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid   order by p.modifytime asc ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCountWithDeleted(@Param(value="categoryGuid") String var1, Pageable var2);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.modifytime >=:seekTime   order by p.modifytime asc ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitCountAfterSeekTimeWithDeleted(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, Pageable var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.modifytime >:ModifyTime   order by p.modifytime asc ")
    public List<Contact> findByCategoryAfterSetTime(@Param(value="categoryGuid") String var1, @Param(value="ModifyTime") DateTime var2);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.modifytime >:ModifyTime   ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitAfterSetTime(@Param(value="categoryGuid") String var1, @Param(value="ModifyTime") DateTime var2, Pageable var3);

    @Query(value="select p from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.modifytime >=:seekTime  ")
    public Page<Contact> findByCategorybyOrderModifyTimeLimitAfterSeekTime(@Param(value="categoryGuid") String var1, @Param(value="seekTime") DateTime var2, Pageable var3);

    @Query(value="select p.guid from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.isdeleted=false")
    public List<String> findGuidByCategory(@Param(value="categoryGuid") String var1);

    @Query(value="select p.guid from Contact p join p.categoriesownme c where c.guid=:categoryGuid")
    public List<String> findGuidByCategory_IncludeDeleted(@Param(value="categoryGuid") String var1);

    @Query(value="select p from Contact p join p.categoriesownme c where c.owneraccount=:account and c.categorytype=:categorytype and p.isdeleted=false")
    public List<Contact> findByCategorytypeOfAccount(@Param(value="account") Account var1, @Param(value="categorytype") CategoryType var2);

    @Query(value="select p.guid from Contact p join p.categoriesownme c where c.owneraccount=:account and c.categorytype=:categorytype and p.isdeleted=false")
    public List<String> findGuidByCategorytypeOfAccount(@Param(value="account") Account var1, @Param(value="categorytype") CategoryType var2);

    @Query(value="select count(p) from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.iscorrected=false and p.isdeleted=false")
    public Long countUncorrectedByCategory(@Param(value="categoryGuid") String var1);

    @Query(value="select p.guid from Contact p join p.categoriesownme c where c.guid=:categoryGuid and p.iscorrected=false and p.isdeleted=false")
    public List<String> findGuidUncorrectedByCategory(@Param(value="categoryGuid") String var1);

    @Query(value="select p.guid from Contact p where p.owneraccount.guid = :accountGuid")
    public List<String> findGuidOwnedByAccount(@Param(value="accountGuid") String var1);

    @Query(value="select p.guid from Contact p join p.owneraccount a where a.guid in :accountGuids and p.isdeleted=false")
    public List<String> findGuidOwnedByAccounts(@Param(value="accountGuids") List<String> var1);

    @Query(value="select NEW com.penpower.worldcard.team.dto.ContactSimpleInfoCustomerDto(p.guid, p.textSha1) from Contact p where p.modifytime >= :startTime and p.isdeleted=false")
    public Page<ContactSimpleInfoCustomerDto> findSimpleInfoPageFromTime(@Param(value="startTime") DateTime var1, Pageable var2);

    @Query(value="select NEW com.penpower.worldcard.team.dto.ContactSimpleInfoCustomerDto(p.guid, p.textSha1) from Contact p where p.modifytime >= :startTime")
    public Page<ContactSimpleInfoCustomerDto> findSimpleInfoPageFromTimeWithDeleted(@Param(value="startTime") DateTime var1, Pageable var2);

    @Query(value="select p from Contact p where p.modifytime >= :startTime and p.isdeleted=false")
    public Page<Contact> findContactPageFromTime(@Param(value="startTime") DateTime var1, Pageable var2);

    @Query(value="select p from Contact p where p.modifytime >= :startTime")
    public Page<Contact> findContactPageFromTimeWithDeleted(@Param(value="startTime") DateTime var1, Pageable var2);

    @Query(value="select p from Contact p where p.modifytime >= :startTime and p.isdeleted = false and p.owneraccount.guid = :ownerGuid")
    public Page<Contact> findContactPageFromTimeByOwner(@Param(value="startTime") DateTime var1, @Param(value="ownerGuid") String var2, Pageable var3);

    @Query(value="select p from Contact p where p.modifytime >= :startTime and p.owneraccount.guid = :ownerGuid")
    public Page<Contact> findContactPageFromTimeByOwnerWithDeleted(@Param(value="startTime") DateTime var1, @Param(value="ownerGuid") String var2, Pageable var3);

    @Query(value="select c.guid from contact c, contactstatusforaccount cs where c.guid = cs.contact_guid and cs.account_guid = :accountGuid and c.modifytime  AT TIME ZONE 'UTC' >= to_timestamp(:strStartTime,'YYYY-MM-DD HH24:MI:SS.MS') and cs.isdeletedfromaccount = 0 order by c.modifytime asc limit :contactNumberGet", nativeQuery=true)
    public List<String> findGuidFromTimeByAccountPrivate(@Param(value="strStartTime") String var1, @Param(value="contactNumberGet") int var2, @Param(value="accountGuid") String var3);

    @Query(value="select c.guid from contact c, contactstatusforaccount cs where c.guid = cs.contact_guid and cs.account_guid = :accountGuid and switchoffset(c.modifytime, '+00:00') >= convert(datetime, :strStartTime, 121) and cs.isdeletedfromaccount = 0 order by c.modifytime asc limit :contactNumberGet", nativeQuery=true)
    public List<String> findGuidFromTimeByAccountPrivate_MSSQL(@Param(value="strStartTime") String var1, @Param(value="contactNumberGet") int var2, @Param(value="accountGuid") String var3);

    @Query(value="select c.guid from contact c, contactstatusforaccount cs where c.guid = cs.contact_guid and cs.account_guid = :accountGuid and c.modifytime  AT TIME ZONE 'UTC' >= to_timestamp(:strStartTime,'YYYY-MM-DD HH24:MI:SS.MS') order by c.modifytime asc limit :contactNumberGet", nativeQuery=true)
    public List<String> findGuidFromTimeByAccountPrivateWithDeleted(@Param(value="strStartTime") String var1, @Param(value="contactNumberGet") int var2, @Param(value="accountGuid") String var3);

    @Query(value="select c.guid from contact c, contactstatusforaccount cs where c.guid = cs.contact_guid and cs.account_guid = :accountGuid and switchoffset(c.modifytime, '+00:00') >= convert(datetime, :strStartTime, 121) order by c.modifytime asc limit :contactNumberGet", nativeQuery=true)
    public List<String> findGuidFromTimeByAccountPrivateWithDeleted_MSSQL(@Param(value="strStartTime") String var1, @Param(value="contactNumberGet") int var2, @Param(value="accountGuid") String var3);

    @Query(value="select NEW com.penpower.worldcard.team.dto.ContactGuidAndOwner(p.guid, p.owneraccount.guid) from Contact p join p.accountscanview a where a.guid in :accountGuids and p.isdeleted=false and p.createtime >= :startTime and p.createtime <= :endTime")
    public List<ContactGuidAndOwner> findCanViewByAccounts(@Param(value="accountGuids") List<String> var1, @Param(value="startTime") DateTime var2, @Param(value="endTime") DateTime var3);

    @Query(value="select p from Contact p join p.accountscanview a where a.guid in :accountGuids and p.isdeleted=false")
    public List<Contact> findCanViewByAccounts1(@Param(value="accountGuids") List<String> var1);

    @Query(value="select p.guid from Contact p join p.accountscanview a where a.guid = :accountGuid")
    public List<String> findGuidCanViewByAccount(@Param(value="accountGuid") String var1);

    @Query(value="select p.guid from Contact p join p.accountscanview a where a.guid in :accountGuids and p.isdeleted=false")
    public List<String> findGuidCanViewByAccounts(@Param(value="accountGuids") List<String> var1);

    @Query(value="select p from Contact p join p.accountscanview a where p.owneraccount = :Xaccount and a.guid = :YaccountGuid")
    public List<Contact> findOwnedByXandCanViewByY(@Param(value="Xaccount") Account var1, @Param(value="YaccountGuid") String var2);

    @Query(value="select p.guid from Contact p join p.accountscanview a where p.owneraccount = :Xaccount and a.guid = :YaccountGuid and p.isdeleted=false")
    public List<String> findGuidOwnedByXandCanViewByY(@Param(value="Xaccount") Account var1, @Param(value="YaccountGuid") String var2);

    @Query(value="select p.guid from Contact p join p.accountscanview a where p.owneraccount = :Xaccount and a.guid in :YaccountGuids and p.isdeleted=false")
    public List<String> findGuidOwnedByXandCanViewByYs(@Param(value="Xaccount") Account var1, @Param(value="YaccountGuids") List<String> var2);

    @Modifying
    @Query(value="update Contact p set p.companyguid = :companyGuid")
    public void updateContactWithCompanyGuid(@Param(value="companyGuid") String var1);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactObject(p.guid,p.creatorguid) from Contact p where p.guid=:contactGuid")
    public List<ContactObject> findSomeByGuid(@Param(value="contactGuid") String var1);
}

