/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dao;

import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AccountDao
extends JpaRepository<Account, String> {
    @Query(value="SELECT t FROM Account t WHERE t.company_guid = ?1")
    public List<Account> findAllbyCompany(@Param(value="companyGuid") String var1);

    public Account findOne(String var1);

    public Account findByEmailIgnoreCase(String var1);

    @Query(value="SELECT t FROM Account t WHERE t.displayname = ?1 and t.company_guid = ?2")
    public Account findByDisplayname(@Param(value="displayname") String var1, @Param(value="companyGuid") String var2);

    @Query(value="SELECT t FROM Account t WHERE t.accounttype = ?1 and t.company_guid = ?2")
    public List<Account> findByAccounttype(@Param(value="accounttype") AccountType var1, @Param(value="companyGuid") String var2);

    public List<Account> findByInheritancestatusIn(List<InheritanceStatus> var1);

    @Query(value="SELECT t FROM Account t WHERE t.status in ?1 and t.company_guid = ?2")
    public List<Account> findByStatusIn(@Param(value="statusList") List<UserStatus> var1, @Param(value="companyGuid") String var2);

    public List<Account> findByStatusIn(@Param(value="statusList") List<UserStatus> var1);

    @Query(value="SELECT t FROM Account t WHERE t.boss.guid = ?1 ")
    public List<Account> findByBossGuid(@Param(value="bossGuid") String var1);

    @Query(value="SELECT t.guid FROM Account t WHERE t.boss.guid = ?1 ")
    public List<String> findGuidsByBossGuid(@Param(value="bossGuid") String var1);

    @Query(value="select p from Account p where p.guid in :accountGuids")
    public List<Account> findByGuidList(@Param(value="accountGuids") List<String> var1);

    @Query(value="select p.guid from Account p join p.canviewcontacts a where a.guid = :contactGuid")
    public List<String> findGuidByCanViewContact(@Param(value="contactGuid") String var1);

    @Query(value="SELECT COUNT(t) FROM Account t WHERE t.role = ?1 and t.company_guid = ?2")
    public Long countByRole(@Param(value="role") UserRole var1, @Param(value="companyGuid") String var2);

    @Query(value="SELECT COUNT(t) FROM Account t WHERE t.status = ?1 and t.company_guid = ?2")
    public Long countByStatus(@Param(value="status") UserStatus var1, @Param(value="companyGuid") String var2);

    @Query(value="SELECT COUNT(t) FROM Account t WHERE t.inheritedaccount = ?1 and inheritancestatus =?2 ")
    public Long countByInheritor(@Param(value="inheritorGuid") String var1, @Param(value="inheritancestatus") InheritanceStatus var2);
}

