/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.crm.salesforce;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceAuthenticationManager;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceUserAgentOAuthToken;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.exception.CRMLoginException;
import com.penpower.worldcard.team.exception.CRMLogoutException;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SalesForceAuthenticationManager
implements CRMAuthenticationManager {
    private static final Logger LOG = LoggerFactory.getLogger(SalesForceAuthenticationManager.class);
    public static final String OAUTH_LOGIN_URL = "https://login.salesforce.com/services/oauth2/token";
    private static String LOGOUT_URL = "https://login.salesforce.com/services/oauth2/revoke";

    public BasicToken loginCRM(CRMSettingsDto CRMSettingsDto2) throws CRMLoginException, HttpConnectionException {
        Gson gson = new Gson();
        OkHttpClient client = new OkHttpClient();
        FormBody formBody = new FormBody.Builder().add("grant_type", "password").add("client_id", "3MVG9Km_cBLhsuPxAY85Hg9PpTkxrVU2SEZwbFfYVE.LXqUhtNgVcERtwl6w283nfwmBmUvUQmuNjoqQmFWAw").add("client_secret", "7799278545741941875").add("username", CRMSettingsDto2.getUserCRMAccount()).add("password", CRMSettingsDto2.getUserCRMPassword() + CRMSettingsDto2.getUserCRMSecretToken()).build();
        Request request = new Request.Builder().url(OAUTH_LOGIN_URL).post((RequestBody)formBody).build();
        SalesforceOAuthToken authResult = null;
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new CRMLoginException("Unexpected code " + OkHttpUtils.getResponseBodyString((Response)response));
            }
            String authString = OkHttpUtils.getResponseBodyString((Response)response);
            authResult = (SalesforceOAuthToken)gson.fromJson(authString, SalesforceOAuthToken.class);
            LOG.debug("authString : {} ", (Object)authString);
        }
        catch (IOException ex) {
            LOG.error("Failed to login CRM system.", (Throwable)ex);
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        return authResult;
    }

    public void logoutCRM(String accessToken) throws CRMLogoutException {
        OkHttpClient client = new OkHttpClient();
        FormBody revokeTokenFormBody = new FormBody.Builder().add("token", accessToken).build();
        Request revokeTokenRequest = new Request.Builder().url(LOGOUT_URL).post((RequestBody)revokeTokenFormBody).build();
        try (Response revokeResponse = client.newCall(revokeTokenRequest).execute();){
            if (!revokeResponse.isSuccessful()) {
                throw new CRMOperationException("CRM logout failed , Unexpected code " + OkHttpUtils.getResponseBodyString((Response)revokeResponse));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to logout CRM... ", (Throwable)e);
            throw new HttpConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean testAccessToken(BasicToken authToken, SalesForceOAuthTokenType tokenType) {
        if (authToken instanceof NullCRMToken) {
            return false;
        }
        return this.testAccessTokenInternal(authToken, tokenType);
    }

    public boolean testAccessTokenByJsonString(String accessTokenJson, SalesForceOAuthTokenType tokenType) {
        BasicToken authToken = this.getTokenByType(accessTokenJson, tokenType);
        if (authToken instanceof NullCRMToken) {
            return false;
        }
        return this.testAccessTokenInternal(authToken, tokenType);
    }

    private boolean testAccessTokenInternal(BasicToken authToken, SalesForceOAuthTokenType tokenType) {
        String instanceUrl = null;
        switch (1.$SwitchMap$com$penpower$worldcard$team$crm$salesforce$SalesForceOAuthTokenType[tokenType.ordinal()]) {
            case 1: {
                instanceUrl = ((SalesforceUserAgentOAuthToken)authToken).getInstance_url();
                break;
            }
            default: {
                instanceUrl = ((SalesforceOAuthToken)authToken).getInstance_url();
            }
        }
        String testGetSobjectUrl = instanceUrl + "/services/data/v39.0/sobjects";
        String accessToken = authToken.getAccess_token();
        try {
            OkHttpClient client = new OkHttpClient();
            Request testAccessTokenRequest = new Request.Builder().addHeader("Authorization", "Bearer " + accessToken).url(testGetSobjectUrl).build();
            try (Response testAccessTokenResponse = client.newCall(testAccessTokenRequest).execute();){
                if (!testAccessTokenResponse.isSuccessful()) {
                    String failureMessage = OkHttpUtils.getResponseBodyString((Response)testAccessTokenResponse);
                    LOG.warn("Test access_token failed : {} ", (Object)failureMessage);
                    throw new CRMOperationException(failureMessage);
                }
            }
        }
        catch (CRMOperationException ex) {
            LOG.warn("Test access_token failed,", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            LOG.warn("Test access_token failed,", (Throwable)e);
            return false;
        }
        return true;
    }

    private BasicToken getTokenByType(String userCRMloginTokenString, SalesForceOAuthTokenType tokenType) {
        BasicToken authResult = null;
        Gson gson = new Gson();
        switch (1.$SwitchMap$com$penpower$worldcard$team$crm$salesforce$SalesForceOAuthTokenType[tokenType.ordinal()]) {
            case 1: {
                try {
                    authResult = (BasicToken)gson.fromJson(userCRMloginTokenString, SalesforceUserAgentOAuthToken.class);
                }
                catch (Exception ex) {
                    authResult = new NullCRMToken();
                }
                break;
            }
            default: {
                try {
                    authResult = (BasicToken)gson.fromJson(userCRMloginTokenString, SalesforceOAuthToken.class);
                    break;
                }
                catch (Exception ex) {
                    authResult = new NullCRMToken();
                }
            }
        }
        return authResult;
    }

    public BasicToken getAccessToken(String CRMLoginJsonToken, SalesForceOAuthTokenType tokenType) {
        return this.getTokenByType(CRMLoginJsonToken, tokenType);
    }
}

