/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.websocket;

import com.penpower.worldcard.team.auth.AuthenticationWithToken;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.config.websocket.WebSocketSessionManager;
import com.penpower.worldcard.team.dto.AccountInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebsocketEndPoint
extends TextWebSocketHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketEndPoint.class);
    private WebSocketSessionManager webSocketSessionManager;

    public WebsocketEndPoint(WebSocketSessionManager webSocketSessionManager) {
        this.webSocketSessionManager = webSocketSessionManager;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        LOG.debug("websocket connection established.....");
        try {
            AuthenticationWithToken authenticationWithToken = (AuthenticationWithToken)session.getPrincipal();
            TokenInfo tokenInfo = (TokenInfo)authenticationWithToken.getDetails();
            String token = tokenInfo.getToken();
            AccountInfo accountInfo = (AccountInfo)authenticationWithToken.getPrincipal();
            this.webSocketSessionManager.addSession(accountInfo.getEmail(), token, session);
        }
        catch (Exception e) {
            LOG.error("Failed to add session .....", (Throwable)e);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        LOG.debug("websocket connection closed.....");
        try {
            AuthenticationWithToken authenticationWithToken = (AuthenticationWithToken)session.getPrincipal();
            TokenInfo tokenInfo = (TokenInfo)authenticationWithToken.getDetails();
            String token = tokenInfo.getToken();
            AccountInfo accountInfo = (AccountInfo)authenticationWithToken.getPrincipal();
            this.webSocketSessionManager.removeSession(accountInfo.getEmail(), token, session);
        }
        catch (Exception e) {
            LOG.error("Failed to add session .....", (Throwable)e);
        }
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        LOG.debug("message from clinet ..... skip process, message : {} ", message.getPayload());
    }
}

