/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.websocket;

import com.penpower.worldcard.team.config.websocket.HandshakeInterceptor;
import com.penpower.worldcard.team.config.websocket.WebSocketSessionManager;
import com.penpower.worldcard.team.config.websocket.WebsocketEndPoint;
import com.penpower.worldcard.team.websokcet.NoticeMessageSender;
import com.penpower.worldcard.team.websokcet.SimpleTextMessageSender;
import com.penpower.worldcard.team.websokcet.WebSocketMessageSender;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@Configuration
@EnableWebSocket
public class BasicWebSocketConfig
implements WebSocketConfigurer {
    public static final String WEB_SOCKET_END_POINT_PATH = "/webSocket";
    private WebSocketSessionManager webSocketSessionManager = new WebSocketSessionManager();
    private static final long MAX_SESSION_IDLE_TIMEOUT = 600000L;

    @Bean
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(8192);
        container.setMaxBinaryMessageBufferSize(8192);
        container.setMaxSessionIdleTimeout(30000L);
        return container;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)new WebsocketEndPoint(this.webSocketSessionManager), new String[]{WEB_SOCKET_END_POINT_PATH}).addInterceptors(new org.springframework.web.socket.server.HandshakeInterceptor[]{new HandshakeInterceptor()}).setAllowedOrigins(new String[]{"*"});
    }

    @Bean
    public SimpleTextMessageSender createSimpleTextMessageSender() {
        return new SimpleTextMessageSender(this.webSocketSessionManager);
    }

    @Bean
    public NoticeMessageSender createNoticeMessageSender(SimpleTextMessageSender simpleTextMessageSender) {
        return new NoticeMessageSender((WebSocketMessageSender)simpleTextMessageSender);
    }
}

